/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.services.document.impl;

import java.io.IOException;
import java.io.InputStream;
import java.io.StringWriter;
import java.io.UnsupportedEncodingException;
import java.io.Writer;
import java.util.Calendar;
import java.util.List;
import java.util.Properties;
import org.apache.jempbox.xmp.XMPMetadata;
import org.apache.jempbox.xmp.XMPSchemaBasic;
import org.apache.jempbox.xmp.XMPSchemaDublinCore;
import org.apache.pdfbox.exceptions.CryptographyException;
import org.apache.pdfbox.exceptions.InvalidPasswordException;
import org.apache.pdfbox.pdmodel.PDDocument;
import org.apache.pdfbox.pdmodel.PDDocumentCatalog;
import org.apache.pdfbox.pdmodel.PDDocumentInformation;
import org.apache.pdfbox.pdmodel.common.PDMetadata;
import org.apache.pdfbox.util.PDFTextStripper;
import org.exoplatform.services.document.DCMetaData;
import org.exoplatform.services.document.DocumentReadException;
import org.exoplatform.services.document.impl.BaseDocumentReader;
import org.exoplatform.services.log.ExoLogger;
import org.exoplatform.services.log.Log;

public class PDFDocumentReader
extends BaseDocumentReader {
    protected static Log log = ExoLogger.getLogger((String)"exo.core.component.document.PDFDocumentReader");

    public String[] getMimeTypes() {
        return new String[]{"application/pdf"};
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String getContentAsText(InputStream is) throws IOException, DocumentReadException {
        if (is == null) {
            throw new NullPointerException("InputStream is null.");
        }
        PDDocument pdDocument = null;
        StringWriter sw = new StringWriter();
        try {
            if (is.available() == 0) {
                String string = "";
                return string;
            }
            try {
                pdDocument = PDDocument.load((InputStream)is);
            }
            catch (IOException e) {
                throw new DocumentReadException("Can not load PDF document.", e);
            }
            PDFTextStripper stripper = new PDFTextStripper();
            stripper.setStartPage(1);
            stripper.setEndPage(Integer.MAX_VALUE);
            stripper.writeText(pdDocument, (Writer)sw);
        }
        finally {
            if (pdDocument != null) {
                try {
                    pdDocument.close();
                }
                catch (IOException e) {}
            }
            if (is != null) {
                try {
                    is.close();
                }
                catch (IOException e) {}
            }
        }
        return sw.toString();
    }

    public String getContentAsText(InputStream is, String encoding) throws IOException, DocumentReadException {
        return this.getContentAsText(is);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Properties getProperties(InputStream is) throws IOException, DocumentReadException {
        Properties props;
        block49: {
            PDDocument pdDocument = PDDocument.load((InputStream)is);
            props = new Properties();
            try {
                PDDocumentInformation docInfo;
                PDDocumentCatalog catalog;
                PDMetadata meta;
                if (pdDocument.isEncrypted()) {
                    try {
                        pdDocument.decrypt("");
                    }
                    catch (InvalidPasswordException e) {
                        throw new DocumentReadException("The pdf document is encrypted.", e);
                    }
                    catch (CryptographyException e) {
                        throw new DocumentReadException(e.getMessage(), e);
                    }
                }
                if ((meta = (catalog = pdDocument.getDocumentCatalog()).getMetadata()) != null) {
                    XMPSchemaBasic basic;
                    XMPMetadata metadata = meta.exportXMPMetadata();
                    XMPSchemaDublinCore dc = metadata.getDublinCoreSchema();
                    if (dc != null) {
                        List list;
                        try {
                            if (dc.getTitle() != null) {
                                props.put(DCMetaData.TITLE, this.fixEncoding(dc.getTitle()));
                            }
                        }
                        catch (Exception e) {
                            log.warn((Object)("getTitle failed: " + e));
                        }
                        try {
                            if (dc.getDescription() != null) {
                                props.put(DCMetaData.SUBJECT, this.fixEncoding(dc.getDescription()));
                            }
                        }
                        catch (Exception e) {
                            log.warn((Object)("getSubject failed: " + e));
                        }
                        try {
                            if (dc.getCreators() != null) {
                                list = dc.getCreators();
                                for (String creator : list) {
                                    props.put(DCMetaData.CREATOR, this.fixEncoding(creator));
                                }
                            }
                        }
                        catch (Exception e) {
                            log.warn((Object)("getCreator failed: " + e));
                        }
                        try {
                            if (dc.getDates() != null) {
                                list = dc.getDates();
                                for (Calendar date : list) {
                                    props.put(DCMetaData.DATE, date);
                                }
                            }
                        }
                        catch (Exception e) {
                            log.warn((Object)("getDate failed: " + e));
                        }
                    }
                    if ((basic = metadata.getBasicSchema()) != null) {
                        try {
                            if (basic.getCreateDate() != null) {
                                props.put(DCMetaData.DATE, basic.getCreateDate());
                            }
                        }
                        catch (Exception e) {
                            log.warn((Object)("getCreationDate failed: " + e));
                        }
                        try {
                            if (basic.getModifyDate() != null) {
                                props.put(DCMetaData.DATE, basic.getModifyDate());
                            }
                        }
                        catch (Exception e) {
                            log.warn((Object)("getModificationDate failed: " + e));
                        }
                    }
                }
                if (!props.isEmpty() || (docInfo = pdDocument.getDocumentInformation()) == null) break block49;
                try {
                    if (docInfo.getCreationDate() != null) {
                        props.put(DCMetaData.DATE, docInfo.getCreationDate());
                    }
                }
                catch (Exception e) {
                    log.warn((Object)("getCreationDate failed: " + e));
                }
                try {
                    if (docInfo.getCreator() != null) {
                        props.put(DCMetaData.CREATOR, docInfo.getCreator());
                    }
                }
                catch (Exception e) {
                    log.warn((Object)("getCreator failed: " + e));
                }
                try {
                    if (docInfo.getKeywords() != null) {
                        props.put(DCMetaData.SUBJECT, docInfo.getKeywords());
                    }
                }
                catch (Exception e) {
                    log.warn((Object)("getKeywords failed: " + e));
                }
                try {
                    if (docInfo.getModificationDate() != null) {
                        props.put(DCMetaData.DATE, docInfo.getModificationDate());
                    }
                }
                catch (Exception e) {
                    log.warn((Object)("getModificationDate failed: " + e));
                }
                try {
                    if (docInfo.getSubject() != null) {
                        props.put(DCMetaData.DESCRIPTION, docInfo.getSubject());
                    }
                }
                catch (Exception e) {
                    log.warn((Object)("getSubject failed: " + e));
                }
                try {
                    if (docInfo.getTitle() != null) {
                        props.put(DCMetaData.TITLE, docInfo.getTitle());
                    }
                }
                catch (Exception e) {
                    log.warn((Object)("getTitle failed: " + e));
                }
            }
            finally {
                if (pdDocument != null) {
                    pdDocument.close();
                }
            }
        }
        return props;
    }

    private String fixEncoding(String str) throws DocumentReadException {
        try {
            String encoding = null;
            int orderMaskOffset = 0;
            if (str.startsWith("\\000\\000\\376\\377")) {
                encoding = "UTF-32BE";
                orderMaskOffset = 16;
            } else if (str.startsWith("\\377\\376\\000\\000")) {
                encoding = "UTF-32LE";
                orderMaskOffset = 16;
            } else if (str.startsWith("\\376\\377")) {
                encoding = "UTF-16BE";
                orderMaskOffset = 8;
            } else if (str.startsWith("\\377\\376")) {
                encoding = "UTF-16LE";
                orderMaskOffset = 8;
            }
            if (encoding == null) {
                return str;
            }
            int i = orderMaskOffset;
            int len = str.length();
            StringBuilder sb = new StringBuilder(len);
            while (i < len) {
                char c;
                if ((c = str.charAt(i++)) == '\\') {
                    if (i + 3 <= len) {
                        try {
                            c = (char)Integer.parseInt(str.substring(i, i + 3), 8);
                            i += 3;
                        }
                        catch (NumberFormatException e) {
                            if (log.isDebugEnabled()) {
                                log.debug((Object)("PDF metadata exctraction warning: can not decode octal code - " + str.substring(i - 1, i + 3) + "."), (Throwable)e);
                            }
                        }
                    } else if (log.isDebugEnabled()) {
                        log.debug((Object)("PDF metadata exctraction warning: octal code is not complete - " + str.substring(i - 1, len)));
                    }
                }
                sb.append(c);
            }
            byte[] bytes = sb.toString().getBytes();
            return new String(bytes, encoding);
        }
        catch (UnsupportedEncodingException e) {
            throw new DocumentReadException(e.getMessage(), e);
        }
    }
}

