/*
 * Decompiled with CFR 0.152.
 */
package org.gatein.common.util;

import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;

public class CopyOnWriteRegistry {
    private volatile Map content = new HashMap();

    public synchronized boolean register(Object key, Object object) throws IllegalArgumentException {
        if (key == null) {
            throw new IllegalArgumentException("No null key accepted");
        }
        if (object == null) {
            throw new IllegalArgumentException("No null value accepted");
        }
        if (this.content.containsKey(key)) {
            return false;
        }
        HashMap<Object, Object> tmp = new HashMap<Object, Object>(this.content);
        tmp.put(key, object);
        this.content = tmp;
        return true;
    }

    public synchronized Object unregister(Object key) throws IllegalArgumentException {
        if (key == null) {
            throw new IllegalArgumentException("No null key accepted");
        }
        if (this.content.containsKey(key)) {
            HashMap tmp = new HashMap(this.content);
            Object registration = tmp.remove(key);
            this.content = tmp;
            return registration;
        }
        return null;
    }

    public Set getKeys() {
        return Collections.unmodifiableSet(this.content.keySet());
    }

    public Collection getRegistrations() {
        return Collections.unmodifiableCollection(this.content.values());
    }

    public Object getRegistration(Object key) throws IllegalArgumentException {
        if (key == null) {
            throw new IllegalArgumentException("No null key accepted");
        }
        return this.content.get(key);
    }
}

