/*
 * Decompiled with CFR 0.152.
 */
package org.reflext.api;

import java.util.ArrayList;
import java.util.List;
import org.reflext.api.ArrayTypeInfo;
import org.reflext.api.ClassTypeInfo;
import org.reflext.api.ParameterizedTypeInfo;
import org.reflext.api.TypeInfo;
import org.reflext.api.TypeVariableInfo;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class MethodSignature {
    private final String name;
    private final List<String> parameterRawNames;

    public MethodSignature(String name, List<TypeInfo> parameterTypes) {
        ArrayList<String> parameterRawNames = new ArrayList<String>();
        for (TypeInfo parameterType : parameterTypes) {
            String rawName = this.computeRawName(parameterType);
            parameterRawNames.add(rawName);
        }
        this.name = name;
        this.parameterRawNames = parameterRawNames;
    }

    public String getName() {
        return this.name;
    }

    private String computeRawName(TypeInfo type) {
        if (type instanceof ClassTypeInfo) {
            return ((ClassTypeInfo)type).getName();
        }
        if (type instanceof ParameterizedTypeInfo) {
            return this.computeRawName(((ParameterizedTypeInfo)type).getRawType());
        }
        if (type instanceof TypeVariableInfo) {
            return this.computeRawName(((TypeVariableInfo)type).getBounds().get(0));
        }
        if (type instanceof ArrayTypeInfo) {
            return "[L" + this.computeRawName(((ArrayTypeInfo)type).getComponentType()) + ";";
        }
        throw new AssertionError();
    }

    public int hashCode() {
        return this.name.hashCode() ^ ((Object)this.parameterRawNames).hashCode();
    }

    public boolean equals(Object obj) {
        if (obj == this) {
            return true;
        }
        if (obj instanceof MethodSignature) {
            MethodSignature that = (MethodSignature)obj;
            return this.name.equals(that.name) && ((Object)this.parameterRawNames).equals(that.parameterRawNames);
        }
        return false;
    }

    public String toString() {
        return "MethodSignature[name=" + this.name + ",parameterRawNames=" + this.parameterRawNames + "]";
    }
}

