/*
 * Decompiled with CFR 0.152.
 */
package org.chromattic.core.api;

import javax.jcr.Node;
import javax.jcr.Session;
import org.chromattic.api.ChromatticException;
import org.chromattic.api.ChromatticSession;
import org.chromattic.api.Status;
import org.chromattic.api.UndeclaredRepositoryException;
import org.chromattic.api.event.EventListener;
import org.chromattic.api.query.QueryBuilder;
import org.chromattic.core.Domain;
import org.chromattic.core.DomainSession;
import org.chromattic.core.EmbeddedContext;
import org.chromattic.core.EntityContext;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class ChromatticSessionImpl
implements ChromatticSession {
    final DomainSession domainSession;

    public ChromatticSessionImpl(DomainSession domainSession) {
        this.domainSession = domainSession;
    }

    public final Domain getDomain() {
        return this.domainSession.getDomain();
    }

    public Session getJCRSession() {
        return this.domainSession.getJCRSession();
    }

    public String getId(Object o) throws UndeclaredRepositoryException {
        if (o == null) {
            throw new NullPointerException("Cannot obtain id from null parameter");
        }
        EntityContext ctx = this.domainSession.unwrapEntity(o);
        return ctx.getId();
    }

    public String getName(Object o) throws UndeclaredRepositoryException {
        if (o == null) {
            throw new NullPointerException();
        }
        EntityContext ctx = this.domainSession.unwrapEntity(o);
        return this.domainSession.getLocalName(ctx);
    }

    public void setName(Object o, String name) throws NullPointerException, IllegalArgumentException, ChromatticException {
        if (o == null) {
            throw new NullPointerException();
        }
        EntityContext ctx = this.domainSession.unwrapEntity(o);
        this.domainSession.setLocalName(ctx, name);
    }

    public String getPath(Object o) throws UndeclaredRepositoryException {
        if (o == null) {
            throw new NullPointerException();
        }
        EntityContext ctx = this.domainSession.unwrapEntity(o);
        return ctx.getPath();
    }

    public <O> O create(Class<O> clazz) throws NullPointerException, IllegalArgumentException {
        return this.create(clazz, null);
    }

    public <O> O create(Class<O> clazz, String name) throws NullPointerException, IllegalArgumentException {
        return this.domainSession.create(clazz, name);
    }

    public <O> O insert(Object parent, Class<O> clazz, String name) throws NullPointerException, IllegalArgumentException, ChromatticException {
        O child = this.create(clazz);
        this.persist(parent, child, name);
        return child;
    }

    public <O> O insert(Object parent, Class<O> clazz, String prefix, String localName) throws NullPointerException, IllegalArgumentException, ChromatticException {
        O child = this.create(clazz);
        this.persist(parent, child, prefix, localName);
        return child;
    }

    public <O> O insert(Class<O> clazz, String name) throws NullPointerException, IllegalArgumentException, UndeclaredRepositoryException {
        return this.insert(null, clazz, name);
    }

    public <O> O insert(Class<O> clazz, String prefix, String localName) throws NullPointerException, IllegalArgumentException, ChromatticException {
        return this.insert(null, clazz, prefix, localName);
    }

    public String persist(Object parent, Object o, String name) throws NullPointerException, IllegalArgumentException, ChromatticException {
        String localName;
        String prefix;
        if (name == null) {
            throw new NullPointerException("No null name accepted");
        }
        int index = name.indexOf(58);
        if (index != -1) {
            prefix = name.substring(0, index);
            localName = name.substring(index + 1);
        } else {
            prefix = null;
            localName = name;
        }
        return this.persist(parent, o, prefix, localName);
    }

    public String persist(Object parent, Object o, String prefix, String localName) throws NullPointerException, IllegalArgumentException, ChromatticException {
        EntityContext childCtx = this.domainSession.unwrapEntity(o);
        if (parent != null) {
            EntityContext parentCtx = this.domainSession.unwrapEntity(parent);
            this.domainSession.persist(parentCtx, childCtx, prefix, localName);
        } else {
            this.domainSession.persist(childCtx, prefix, localName);
        }
        return childCtx.getId();
    }

    public String persist(Object parent, Object child) throws NullPointerException, IllegalArgumentException, ChromatticException {
        EntityContext childCtx = this.domainSession.unwrapEntity(child);
        String name = childCtx.getLocalName();
        if (name == null) {
            String msg = "Attempt to persist non named object " + childCtx;
            throw new IllegalArgumentException(msg);
        }
        if (parent != null) {
            EntityContext parentCtx = this.domainSession.unwrapEntity(parent);
            this.domainSession.persist(parentCtx, childCtx, null, name);
        } else {
            this.domainSession.persist(childCtx, null, name);
        }
        return childCtx.getId();
    }

    public String persist(Object o) throws NullPointerException, IllegalArgumentException, ChromatticException {
        return this.persist(null, o);
    }

    public String persist(Object o, String name) throws NullPointerException, IllegalArgumentException, ChromatticException {
        return this.persist(null, o, name);
    }

    public String persist(Object o, String prefix, String localName) throws NullPointerException, IllegalArgumentException, ChromatticException {
        return this.persist(null, o, prefix, localName);
    }

    public <O> O copy(O o, String name) throws NullPointerException, IllegalArgumentException, ChromatticException {
        EntityContext srcCtx = this.domainSession.unwrapEntity(o);
        EntityContext dstCtx = this.domainSession.copy(srcCtx, null, name);
        Object dst = dstCtx.getObject();
        return (O)dst;
    }

    public <O> O copy(Object parent, O o, String name) throws NullPointerException, IllegalArgumentException, ChromatticException {
        EntityContext srcCtx = this.domainSession.unwrapEntity(o);
        EntityContext parentCtx = this.domainSession.unwrapEntity(parent);
        EntityContext dstCtx = this.domainSession.copy(parentCtx, srcCtx, null, name);
        Object dst = dstCtx.getObject();
        return (O)dst;
    }

    public <O> O findByNode(Class<O> clazz, Node node) throws UndeclaredRepositoryException {
        return this.domainSession.findByNode(clazz, node);
    }

    public <O> O findById(Class<O> clazz, String id) throws UndeclaredRepositoryException {
        return this.domainSession.findById(clazz, id);
    }

    public <O> O findByPath(Object origin, Class<O> clazz, String relPath) throws ChromatticException {
        if (clazz == null) {
            throw new NullPointerException();
        }
        if (relPath == null) {
            throw new NullPointerException();
        }
        EntityContext ctx = null;
        if (origin != null) {
            ctx = this.domainSession.unwrapEntity(origin);
        }
        return this.domainSession.findByPath(ctx, clazz, relPath);
    }

    public <O> O findByPath(Class<O> clazz, String relPath) throws ChromatticException {
        if (clazz == null) {
            throw new NullPointerException();
        }
        if (relPath == null) {
            throw new NullPointerException();
        }
        return this.domainSession.findByPath(null, clazz, relPath);
    }

    public <O> O findByPath(Class<O> clazz, String path, boolean absolute) throws NullPointerException, ClassCastException, ChromatticException {
        if (clazz == null) {
            throw new NullPointerException();
        }
        if (path == null) {
            throw new NullPointerException();
        }
        if (absolute) {
            return this.domainSession.findByPath(clazz, path);
        }
        return this.domainSession.findByPath(null, clazz, path);
    }

    public void save() throws UndeclaredRepositoryException {
        this.domainSession.save();
    }

    public Status getStatus(Object o) throws UndeclaredRepositoryException {
        if (o == null) {
            throw new NullPointerException();
        }
        EntityContext ctx = this.domainSession.unwrapEntity(o);
        return ctx.getStatus();
    }

    public void remove(Object o) throws UndeclaredRepositoryException {
        if (o == null) {
            throw new NullPointerException();
        }
        EntityContext context = this.domainSession.unwrapEntity(o);
        this.domainSession.remove(context);
    }

    public <E> E getEmbedded(Object o, Class<E> embeddedType) throws NullPointerException, IllegalArgumentException, ChromatticException {
        if (o == null) {
            throw new NullPointerException();
        }
        EntityContext ctx = this.domainSession.unwrapEntity(o);
        EmbeddedContext embeddedCtx = ctx.getEmbedded(embeddedType);
        if (embeddedCtx != null) {
            return embeddedType.cast(embeddedCtx.getObject());
        }
        return null;
    }

    public <E> void setEmbedded(Object o, Class<E> embeddedType, E embedded) {
        if (o == null) {
            throw new NullPointerException();
        }
        if (embeddedType == null) {
            throw new NullPointerException();
        }
        if (embedded == null) {
            throw new NullPointerException();
        }
        EntityContext ctx = this.domainSession.unwrapEntity(o);
        EmbeddedContext embeddedCtx = this.domainSession.unwrapMixin(embedded);
        ctx.addMixin(embeddedCtx);
    }

    public void close() {
        this.domainSession.close();
    }

    public boolean isClosed() {
        return this.domainSession.isClosed();
    }

    public <O> QueryBuilder<O> createQueryBuilder(Class<O> fromClass) throws NullPointerException, IllegalArgumentException, ChromatticException {
        return this.domainSession.createQueryBuilder(fromClass);
    }

    public void addEventListener(EventListener listener) {
        this.domainSession.addEventListener(listener);
    }

    public Node getRoot() {
        return this.domainSession.getRoot();
    }

    public Node getNode(Object o) {
        if (o == null) {
            throw new NullPointerException();
        }
        EntityContext ctx = this.domainSession.unwrapEntity(o);
        return ctx.getNode();
    }
}

