/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.portal.webui.workspace;

import java.lang.reflect.Method;
import org.exoplatform.portal.application.PortalRequestContext;
import org.exoplatform.portal.config.UserACL;
import org.exoplatform.portal.config.UserPortalConfig;
import org.exoplatform.portal.config.UserPortalConfigService;
import org.exoplatform.portal.config.model.Page;
import org.exoplatform.portal.config.model.PageNavigation;
import org.exoplatform.portal.webui.page.UIPage;
import org.exoplatform.portal.webui.page.UIPageBody;
import org.exoplatform.portal.webui.page.UIPageCreationWizard;
import org.exoplatform.portal.webui.page.UIPageFactory;
import org.exoplatform.portal.webui.page.UISiteBody;
import org.exoplatform.portal.webui.page.UIWizardPageSetInfo;
import org.exoplatform.portal.webui.portal.UIPortal;
import org.exoplatform.portal.webui.portal.UIPortalComposer;
import org.exoplatform.portal.webui.portal.UIPortalForm;
import org.exoplatform.portal.webui.util.PortalDataMapper;
import org.exoplatform.portal.webui.util.Util;
import org.exoplatform.portal.webui.workspace.UIEditInlineWorkspace;
import org.exoplatform.portal.webui.workspace.UIMaskWorkspace;
import org.exoplatform.portal.webui.workspace.UIPortalApplication;
import org.exoplatform.portal.webui.workspace.UIPortalToolPanel;
import org.exoplatform.portal.webui.workspace.UIWorkingWorkspace;
import org.exoplatform.services.log.ExoLogger;
import org.exoplatform.services.log.Log;
import org.exoplatform.web.application.ApplicationMessage;
import org.exoplatform.webui.application.WebuiRequestContext;
import org.exoplatform.webui.core.UIComponent;
import org.exoplatform.webui.event.Event;
import org.exoplatform.webui.event.EventListener;

public class UIMainActionListener {

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class EditBackgroundActionListener
    extends EventListener<UIWorkingWorkspace> {
        private Log log = ExoLogger.getExoLogger(((Object)((Object)this)).getClass());

        public void execute(Event<UIWorkingWorkspace> event) throws Exception {
            UIWorkingWorkspace workingWorkspace = (UIWorkingWorkspace)((Object)event.getSource());
            UIPage uiPage = (UIPage)workingWorkspace.findFirstComponentOfType(UIPage.class);
            Method showEditBackgroundPopupMethod = null;
            try {
                if (uiPage == null) {
                    return;
                }
                showEditBackgroundPopupMethod = ((Object)((Object)uiPage)).getClass().getDeclaredMethod("showEditBackgroundPopup", WebuiRequestContext.class);
            }
            catch (NoSuchMethodException ex) {
                this.log.warn((Object)ex.getMessage(), (Throwable)ex);
            }
            if (showEditBackgroundPopupMethod != null) {
                showEditBackgroundPopupMethod.invoke((Object)uiPage, event.getRequestContext());
            }
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class CreatePortalActionListener
    extends EventListener<UIWorkingWorkspace> {
        public void execute(Event<UIWorkingWorkspace> event) throws Exception {
            PortalRequestContext prContext = Util.getPortalRequestContext();
            UIPortalApplication uiApp = (UIPortalApplication)((UIWorkingWorkspace)((Object)event.getSource())).getAncestorOfType(UIPortalApplication.class);
            UserACL userACL = (UserACL)uiApp.getApplicationComponent(UserACL.class);
            if (!userACL.hasCreatePortalPermission()) {
                uiApp.addMessage(new ApplicationMessage("UIPortalBrowser.msg.Invalid-createPermission", null));
                return;
            }
            UIMaskWorkspace uiMaskWS = (UIMaskWorkspace)uiApp.getChildById("UIMaskWorkspace");
            UIPortalForm uiNewPortal = uiMaskWS.createUIComponent(UIPortalForm.class, "CreatePortal", "UIPortalForm");
            uiMaskWS.setUIComponent((UIComponent)uiNewPortal);
            uiMaskWS.setShow(true);
            prContext.addUIComponentToUpdateByAjax((UIComponent)uiMaskWS);
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class EditInlineActionListener
    extends EventListener<UIWorkingWorkspace> {
        public void execute(Event<UIWorkingWorkspace> event) throws Exception {
            UIPortalApplication uiApp = Util.getUIPortalApplication();
            UIPortal uiPortal = uiApp.getShowedUIPortal();
            UserPortalConfigService service = (UserPortalConfigService)uiApp.getApplicationComponent(UserPortalConfigService.class);
            UserPortalConfig userConfig = service.getUserPortalConfig(uiPortal.getName(), event.getRequestContext().getRemoteUser());
            if (userConfig == null) {
                userConfig = uiApp.getUserPortalConfig();
            }
            UIPortalApplication portalApp = Util.getUIPortalApplication();
            UIPortal currentUIPortal = (UIPortal)((UIWorkingWorkspace)portalApp.findComponentById("UIWorkingWorkspace")).findFirstComponentOfType(UIPortal.class);
            UserACL userACL = (UserACL)portalApp.getApplicationComponent(UserACL.class);
            if (!userACL.hasEditPermissionOnPortal(currentUIPortal.getOwnerType(), currentUIPortal.getOwner(), currentUIPortal.getEditPermission())) {
                uiApp.addMessage(new ApplicationMessage("UIPortalManagement.msg.Invalid-EditLayout-Permission", (Object[])new String[]{uiPortal.getName()}));
                return;
            }
            PortalRequestContext pcontext = (PortalRequestContext)event.getRequestContext();
            UIWorkingWorkspace uiWorkingWS = (UIWorkingWorkspace)uiApp.getChildById("UIWorkingWorkspace");
            uiWorkingWS.setBackupUIPortal(uiPortal);
            uiApp.setModeState(1);
            UIPortal newPortal = (UIPortal)uiWorkingWS.createUIComponent(UIPortal.class, null, null);
            PortalDataMapper.toUIPortal(newPortal, userConfig);
            newPortal.setSelectedNode(uiPortal.getSelectedNode());
            newPortal.setSelectedNavigation(uiPortal.getSelectedNavigation());
            newPortal.setSelectedPath(uiPortal.getSelectedPath());
            newPortal.refreshUIPage();
            UIEditInlineWorkspace uiEditWS = (UIEditInlineWorkspace)uiWorkingWS.getChild(UIEditInlineWorkspace.class);
            uiEditWS.setUIComponent((UIComponent)newPortal);
            UISiteBody siteBody = (UISiteBody)uiWorkingWS.findFirstComponentOfType(UISiteBody.class);
            siteBody.setUIComponent(null);
            UIPortalComposer uiComposer = (UIPortalComposer)uiEditWS.getComposer().setRendered(true);
            uiComposer.setComponentConfig(UIPortalComposer.class, null);
            uiComposer.setShowControl(true);
            uiComposer.setEditted(false);
            uiComposer.setCollapse(false);
            uiComposer.setId("UIPortalComposer");
            uiWorkingWS.setRenderedChild(UIEditInlineWorkspace.class);
            pcontext.addUIComponentToUpdateByAjax((UIComponent)uiWorkingWS);
            pcontext.setFullRender(true);
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class PageCreationWizardActionListener
    extends EventListener<UIWorkingWorkspace> {
        public void execute(Event<UIWorkingWorkspace> event) throws Exception {
            UIPortalApplication uiApp = Util.getUIPortalApplication();
            uiApp.setModeState(1);
            UIWorkingWorkspace uiWorkingWS = (UIWorkingWorkspace)uiApp.getChildById("UIWorkingWorkspace");
            if (!this.hasPageCreationPermission()) {
                uiApp.addMessage(new ApplicationMessage("UIPortalManagement.msg.Invalid-CreatePage-Permission", null));
                return;
            }
            uiWorkingWS.setRenderedChild(UIEditInlineWorkspace.class);
            UIPortalComposer portalComposer = (UIPortalComposer)uiWorkingWS.findFirstComponentOfType(UIPortalComposer.class);
            portalComposer.setRendered(false);
            portalComposer.setComponentConfig(UIPortalComposer.class, "UIPageEditor");
            portalComposer.setId("UIPageEditor");
            portalComposer.setShowControl(true);
            portalComposer.setEditted(true);
            portalComposer.setCollapse(false);
            UIPortalToolPanel uiToolPanel = (UIPortalToolPanel)uiWorkingWS.findFirstComponentOfType(UIPortalToolPanel.class);
            uiToolPanel.setShowMaskLayer(false);
            uiToolPanel.setWorkingComponent(UIPageCreationWizard.class, null);
            UIPageCreationWizard uiWizard = (UIPageCreationWizard)uiToolPanel.getUIComponent();
            UIWizardPageSetInfo uiPageSetInfo = (UIWizardPageSetInfo)uiWizard.getChild(UIWizardPageSetInfo.class);
            uiPageSetInfo.setShowPublicationDate(false);
            event.getRequestContext().addUIComponentToUpdateByAjax((UIComponent)uiWorkingWS);
        }

        private boolean hasPageCreationPermission() throws Exception {
            UIPortal currentPortal = Util.getUIPortal();
            UserACL userACL = (UserACL)Util.getUIPortalApplication().getApplicationComponent(UserACL.class);
            PageNavigation selectedNavigation = currentPortal.getSelectedNavigation();
            if ("portal".equals(selectedNavigation.getOwnerType())) {
                return userACL.hasEditPermissionOnPortal(currentPortal.getOwnerType(), currentPortal.getOwner(), currentPortal.getEditPermission());
            }
            return userACL.hasEditPermission(selectedNavigation);
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class EditCurrentPageActionListener
    extends EventListener<UIWorkingWorkspace> {
        public void execute(Event<UIWorkingWorkspace> event) throws Exception {
            UIPortalApplication uiApp = Util.getUIPortalApplication();
            UIWorkingWorkspace uiWorkingWS = (UIWorkingWorkspace)uiApp.getChildById("UIWorkingWorkspace");
            UIPageBody pageBody = (UIPageBody)uiWorkingWS.findFirstComponentOfType(UIPageBody.class);
            UIPage uiPage = (UIPage)pageBody.getUIComponent();
            if (uiPage == null) {
                uiApp.addMessage(new ApplicationMessage("UIPageBrowser.msg.PageNotExist", null));
                return;
            }
            Page page = PortalDataMapper.toPageModel(uiPage);
            UserACL userACL = (UserACL)uiApp.getApplicationComponent(UserACL.class);
            if (!userACL.hasEditPermission(page)) {
                uiApp.addMessage(new ApplicationMessage("UIPortalManagement.msg.Invalid-EditPage-Permission", null));
                return;
            }
            uiWorkingWS.setRenderedChild(UIEditInlineWorkspace.class);
            UIPortalComposer portalComposer = (UIPortalComposer)((UIPortalComposer)uiWorkingWS.findFirstComponentOfType(UIPortalComposer.class)).setRendered(true);
            portalComposer.setComponentConfig(UIPortalComposer.class, "UIPageEditor");
            portalComposer.setId("UIPageEditor");
            portalComposer.setShowControl(true);
            portalComposer.setEditted(false);
            portalComposer.setCollapse(false);
            UIPortalToolPanel uiToolPanel = (UIPortalToolPanel)uiWorkingWS.findFirstComponentOfType(UIPortalToolPanel.class);
            uiToolPanel.setShowMaskLayer(false);
            uiApp.setModeState(1);
            UIPageFactory clazz = UIPageFactory.getInstance(page.getFactoryId());
            UIPage newUIPage = clazz.createUIPage(null);
            PortalDataMapper.toUIPage(newUIPage, page);
            uiToolPanel.setWorkingComponent((UIComponent)newUIPage);
            pageBody.setUIComponent(null);
            event.getRequestContext().addUIComponentToUpdateByAjax((UIComponent)uiWorkingWS);
            Util.getPortalRequestContext().setFullRender(true);
        }
    }
}

