/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.services.rest.ext.groovy;

import groovy.lang.GroovyResourceLoader;
import java.io.IOException;
import java.net.MalformedURLException;
import java.net.URL;
import java.security.AccessController;
import java.security.PrivilegedActionException;
import java.security.PrivilegedExceptionAction;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.Map;

public class DefaultGroovyResourceLoader
implements GroovyResourceLoader {
    private static final String DEFAULT_SOURCE_FILE_EXTENSION = ".groovy";
    private int maxEntries = 512;
    protected final Map<String, URL> resources;
    protected final URL[] roots;

    public DefaultGroovyResourceLoader(URL[] roots) throws MalformedURLException {
        this.roots = new URL[roots.length];
        for (int i = 0; i < roots.length; ++i) {
            String str = roots[i].toString();
            this.roots[i] = str.charAt(str.length() - 1) != '/' ? new URL(str + '/') : roots[i];
        }
        this.resources = Collections.synchronizedMap(new LinkedHashMap<String, URL>(){

            @Override
            protected boolean removeEldestEntry(Map.Entry<String, URL> eldest) {
                return this.size() > DefaultGroovyResourceLoader.this.maxEntries;
            }
        });
    }

    public DefaultGroovyResourceLoader(URL root) throws MalformedURLException {
        this(new URL[]{root});
    }

    public final URL loadGroovySource(String filename) throws MalformedURLException {
        URL resource = null;
        final String ffilename = filename.replace('.', '/') + this.getSourceFileExtension();
        try {
            resource = AccessController.doPrivileged(new PrivilegedExceptionAction<URL>(){

                @Override
                public URL run() throws MalformedURLException {
                    return DefaultGroovyResourceLoader.this.getResource(ffilename);
                }
            });
        }
        catch (PrivilegedActionException e) {
            Throwable cause = e.getCause();
            throw (MalformedURLException)cause;
        }
        return resource;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected URL getResource(String filename) throws MalformedURLException {
        URL resource = null;
        String string = filename = filename.intern();
        synchronized (string) {
            boolean inCache;
            resource = this.resources.get(filename);
            boolean bl = inCache = resource != null;
            if (inCache && !this.checkResource(resource)) {
                resource = null;
            }
            for (int i = 0; i < this.roots.length && resource == null; ++i) {
                URL tmp = new URL(this.roots[i], filename);
                if (!this.checkResource(tmp)) continue;
                resource = tmp;
            }
            if (resource != null) {
                this.resources.put(filename, resource);
            } else if (inCache) {
                this.resources.remove(filename);
            }
        }
        return resource;
    }

    protected String getSourceFileExtension() {
        return DEFAULT_SOURCE_FILE_EXTENSION;
    }

    protected boolean checkResource(URL resource) {
        try {
            resource.openStream().close();
            return true;
        }
        catch (IOException e) {
            return false;
        }
    }
}

