/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.frameworks.jcr.cli;

import javax.jcr.Node;
import javax.jcr.NodeIterator;
import javax.jcr.Property;
import javax.jcr.PropertyIterator;
import org.exoplatform.frameworks.jcr.cli.AbstractCliCommand;
import org.exoplatform.frameworks.jcr.cli.CliAppContext;

public class GetNodesCommand
extends AbstractCliCommand {
    public boolean perform(CliAppContext ctx) {
        String output = "";
        try {
            if (ctx.getCurrentItem().isNode()) {
                Node currentNode = (Node)ctx.getCurrentItem();
                PropertyIterator propertyIterator = currentNode.getProperties();
                output = output + "Properties list for " + currentNode.getPath() + ":\n";
                while (propertyIterator.hasNext()) {
                    Property property = propertyIterator.nextProperty();
                    output = output + property.getName() + "\n";
                }
                NodeIterator nodeIterator = currentNode.getNodes();
                output = output + "Nodes list for " + currentNode.getPath() + ":\n";
                while (nodeIterator.hasNext()) {
                    Node node = nodeIterator.nextNode();
                    output = output + node.getPath() + "\n";
                }
            } else {
                output = output + "Current item is property: " + ((Property)ctx.getCurrentItem()).getName() + "\n";
            }
        }
        catch (Exception e) {
            output = "Can't execute command - " + e.getMessage() + "\n";
        }
        ctx.setOutput(output);
        return false;
    }
}

