/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.services.ldap.impl;

import java.io.File;
import java.util.HashMap;
import java.util.Hashtable;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.naming.CommunicationException;
import javax.naming.Context;
import javax.naming.InitialContext;
import javax.naming.NamingEnumeration;
import javax.naming.NamingException;
import javax.naming.ServiceUnavailableException;
import javax.naming.directory.Attributes;
import javax.naming.directory.SearchControls;
import javax.naming.directory.SearchResult;
import javax.naming.ldap.InitialLdapContext;
import javax.naming.ldap.LdapContext;
import org.exoplatform.commons.utils.PrivilegedSystemHelper;
import org.exoplatform.container.ExoContainer;
import org.exoplatform.container.component.ComponentPlugin;
import org.exoplatform.container.component.ComponentRequestLifecycle;
import org.exoplatform.container.xml.InitParams;
import org.exoplatform.services.ldap.CreateObjectCommand;
import org.exoplatform.services.ldap.LDAPService;
import org.exoplatform.services.ldap.impl.LDAPConnectionConfig;
import org.exoplatform.services.log.ExoLogger;
import org.exoplatform.services.log.Log;

public class LDAPServiceImpl
implements LDAPService,
ComponentRequestLifecycle {
    private static final Log LOG = ExoLogger.getLogger((String)"exo.core.component.ldap.LDAPServiceImpl");
    private Map<String, String> env = new HashMap<String, String>();
    private int serverType = 0;

    public LDAPServiceImpl(InitParams params) {
        LDAPConnectionConfig config = (LDAPConnectionConfig)params.getObjectParam("ldap.config").getObject();
        String url = config.getProviderURL();
        this.serverType = this.toServerType(config.getServerName());
        boolean ssl = url.toLowerCase().startsWith("ldaps");
        if (this.serverType == 1 && ssl) {
            String keystore = System.getProperty("java.home");
            keystore = keystore + File.separator + "lib" + File.separator + "security" + File.separator + "cacerts";
            PrivilegedSystemHelper.setProperty((String)"javax.net.ssl.trustStore", (String)keystore);
        }
        this.env.put("java.naming.factory.initial", "com.sun.jndi.ldap.LdapCtxFactory");
        this.env.put("java.naming.security.authentication", config.getAuthenticationType());
        this.env.put("java.naming.security.principal", config.getRootDN());
        this.env.put("java.naming.security.credentials", config.getPassword());
        this.env.put("com.sun.jndi.ldap.connect.timeout", "60000");
        this.env.put("com.sun.jndi.ldap.connect.pool", "true");
        this.env.put("java.naming.ldap.version", config.getVerion());
        this.env.put("java.naming.ldap.attributes.binary", "tokenGroups");
        this.env.put("java.naming.referral", config.getReferralMode());
        Pattern pattern = Pattern.compile("\\p{Space}*,\\p{Space}*", 2);
        Matcher matcher = pattern.matcher(url);
        url = ssl ? matcher.replaceAll("/ ldaps://") : matcher.replaceAll("/ ldap://");
        url = url + "/";
        this.env.put("java.naming.provider.url", url);
        if (this.serverType == 1 && ssl) {
            this.env.put("java.naming.security.protocol", "ssl");
        }
    }

    public LdapContext getLdapContext() throws NamingException {
        return this.getLdapContext(true);
    }

    public LdapContext getLdapContext(boolean renew) throws NamingException {
        return new InitialLdapContext(new Hashtable<String, String>(this.env), null);
    }

    public void release(LdapContext ctx) {
        this.closeContext(ctx);
    }

    public InitialContext getInitialContext() throws NamingException {
        Hashtable<String, String> props = new Hashtable<String, String>(this.env);
        props.put("java.naming.factory.object", "com.sun.jndi.ldap.obj.LdapGroupFactory");
        props.put("java.naming.factory.state", "com.sun.jndi.ldap.obj.LdapGroupFactory");
        return new InitialLdapContext(props, null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean authenticate(String userDN, String password) throws NamingException {
        Hashtable<String, String> props = new Hashtable<String, String>(this.env);
        props.put("java.naming.security.authentication", "simple");
        props.put("java.naming.security.principal", userDN);
        props.put("java.naming.security.credentials", password);
        props.put("com.sun.jndi.ldap.connect.pool", "false");
        InitialLdapContext ctx = null;
        try {
            ctx = new InitialLdapContext(props, null);
            boolean bl = true;
            this.closeContext(ctx);
            return bl;
        }
        catch (NamingException e) {
            try {
                LOG.debug((Object)"Error during initialization LDAP Context", (Throwable)e);
                boolean bl = false;
                this.closeContext(ctx);
                return bl;
            }
            catch (Throwable throwable) {
                this.closeContext(ctx);
                throw throwable;
            }
        }
    }

    public int getServerType() {
        return this.serverType;
    }

    public void addDeleteObject(ComponentPlugin plugin) throws NamingException {
    }

    private void unbind(LdapContext ctx, String name) throws NamingException {
        SearchControls constraints = new SearchControls();
        constraints.setSearchScope(1);
        NamingEnumeration<SearchResult> results = ctx.search(name, "(objectclass=*)", constraints);
        while (results.hasMore()) {
            SearchResult sr = results.next();
            this.unbind(ctx, sr.getNameInNamespace());
        }
        results.close();
        ctx.unbind(name);
    }

    public void addCreateObject(ComponentPlugin plugin) throws NamingException {
        if (plugin instanceof CreateObjectCommand) {
            CreateObjectCommand command = (CreateObjectCommand)plugin;
            Map<String, Attributes> objectsToCreate = command.getObjectsToCreate();
            if (objectsToCreate == null || objectsToCreate.size() == 0) {
                return;
            }
            LdapContext ctx = this.getLdapContext();
            for (Map.Entry<String, Attributes> e : objectsToCreate.entrySet()) {
                String name = e.getKey();
                Attributes attrs = e.getValue();
                try {
                    try {
                        ctx.createSubcontext(name, attrs);
                    }
                    catch (CommunicationException e1) {
                        ctx = this.getLdapContext(true);
                        ctx.createSubcontext(name, attrs);
                    }
                    catch (ServiceUnavailableException e2) {
                        ctx = this.getLdapContext(true);
                        ctx.createSubcontext(name, attrs);
                    }
                }
                catch (Exception e3) {
                    LOG.error((Object)("Create object (" + name + ") failed. "), (Throwable)e3);
                }
            }
            this.release(ctx);
        }
    }

    public void startRequest(ExoContainer container) {
    }

    public void endRequest(ExoContainer container) {
    }

    private int toServerType(String name) {
        if ((name = name.trim()) == null || name.length() < 1) {
            return 0;
        }
        if (name.equalsIgnoreCase("ACTIVE.DIRECTORY")) {
            return 1;
        }
        return 0;
    }

    private void closeContext(Context ctx) {
        try {
            if (ctx != null) {
                ctx.close();
            }
        }
        catch (NamingException e) {
            LOG.warn((Object)"Exception occurred when tried to close context", (Throwable)e);
        }
    }
}

