/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.services.cms.views.impl;

import java.io.ByteArrayInputStream;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.jcr.Node;
import javax.jcr.NodeIterator;
import javax.jcr.RepositoryException;
import javax.jcr.Session;
import org.exoplatform.container.xml.InitParams;
import org.exoplatform.container.xml.PropertiesParam;
import org.exoplatform.services.cms.impl.DMSConfiguration;
import org.exoplatform.services.cms.impl.DMSRepositoryConfiguration;
import org.exoplatform.services.cms.templates.TemplateService;
import org.exoplatform.services.cms.views.ApplicationTemplateManagerService;
import org.exoplatform.services.cms.views.PortletTemplatePlugin;
import org.exoplatform.services.jcr.RepositoryService;
import org.exoplatform.services.jcr.config.RepositoryEntry;
import org.exoplatform.services.jcr.core.ManageableRepository;
import org.exoplatform.services.jcr.ext.common.SessionProvider;
import org.exoplatform.services.jcr.ext.hierarchy.NodeHierarchyCreator;
import org.exoplatform.services.log.ExoLogger;
import org.exoplatform.services.log.Log;
import org.exoplatform.services.wcm.utils.WCMCoreUtils;
import org.picocontainer.Startable;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ApplicationTemplateManagerServiceImpl
implements ApplicationTemplateManagerService,
Startable {
    private static Log log = ExoLogger.getLogger(ApplicationTemplateManagerService.class);
    private RepositoryService repositoryService;
    private List<PortletTemplatePlugin> portletTemplatePlugins = new ArrayList<PortletTemplatePlugin>();
    Map<String, List<String>> managedApplicationNames = new HashMap<String, List<String>>();
    private Map<String, String> storedWorkspaces = new HashMap<String, String>();
    private String basedApplicationTemplatesPath;
    private DMSConfiguration dmsConfiguration_;
    private NodeHierarchyCreator hierarchyCreator;
    private InitParams params;
    private TemplateService templateService;

    public ApplicationTemplateManagerServiceImpl(RepositoryService repositoryService, NodeHierarchyCreator hierarchyCreator, InitParams params, DMSConfiguration dmsConfiguration) throws Exception {
        this.repositoryService = repositoryService;
        this.dmsConfiguration_ = dmsConfiguration;
        this.params = params;
        this.hierarchyCreator = hierarchyCreator;
        this.templateService = WCMCoreUtils.getService(TemplateService.class);
    }

    @Override
    public void addPlugin(PortletTemplatePlugin portletTemplatePlugin) throws Exception {
        this.portletTemplatePlugins.add(portletTemplatePlugin);
    }

    @Override
    public List<Node> getTemplatesByApplication(String repository, String portletName, SessionProvider provider) throws Exception {
        return null;
    }

    @Override
    public void addTemplate(Node portletTemplateHome, PortletTemplatePlugin.PortletTemplateConfig config) throws Exception {
        Node category = null;
        try {
            category = portletTemplateHome.getNode(config.getCategory());
        }
        catch (Exception e) {
            category = portletTemplateHome.addNode(config.getCategory(), "nt:unstructured");
            portletTemplateHome.save();
        }
        this.templateService.createTemplate(category, config.getTemplateName(), new ByteArrayInputStream(config.getTemplateData().getBytes()), new String[]{"*"});
    }

    public Node getApplicationTemplateHome(String repository, String portletName, SessionProvider provider) throws Exception {
        Node basedApplicationTemplateHome = this.getBasedApplicationTemplatesHome(provider, repository);
        return basedApplicationTemplateHome.getNode(portletName);
    }

    @Override
    public List<String> getAllManagedPortletName(String repository) throws Exception {
        return this.managedApplicationNames.get(repository);
    }

    @Override
    public Node getTemplateByName(String repository, String portletName, String category, String templateName, SessionProvider sessionProvider) throws Exception {
        Node basedApplicationTemplateHome = this.getBasedApplicationTemplatesHome(sessionProvider, repository);
        return basedApplicationTemplateHome.getNode(portletName + "/" + category + "/" + templateName);
    }

    @Override
    public List<Node> getTemplatesByCategory(String repository, String portletName, String category, SessionProvider sessionProvider) throws Exception {
        Node basedApplicationTemplateHome = this.getBasedApplicationTemplatesHome(sessionProvider, repository);
        Node applicationHome = basedApplicationTemplateHome.getNode(portletName);
        Node categoryNode = applicationHome.getNode(category);
        ArrayList<Node> templateNodes = new ArrayList<Node>();
        NodeIterator iterator = categoryNode.getNodes();
        while (iterator.hasNext()) {
            templateNodes.add(iterator.nextNode());
        }
        return templateNodes;
    }

    @Override
    public Node getTemplateByPath(String repository, String templatePath, SessionProvider sessionProvider) throws Exception {
        Node basedTemplateNode = this.getBasedApplicationTemplatesHome(sessionProvider, repository);
        return (Node)basedTemplateNode.getSession().getItem(templatePath);
    }

    @Override
    public void removeTemplate(String repository, String portletName, String catgory, String templateName, SessionProvider sessionProvider) throws Exception {
        Node templateNode = this.getTemplateByName(repository, portletName, catgory, templateName, sessionProvider);
        Session session = templateNode.getSession();
        templateNode.remove();
        session.save();
        session.logout();
    }

    private Node getBasedApplicationTemplatesHome(SessionProvider sessionProvider, String repository) throws Exception {
        DMSRepositoryConfiguration dmsRepoConfig = this.dmsConfiguration_.getConfig();
        ManageableRepository manageableRepository = this.repositoryService.getRepository(repository);
        Session session = sessionProvider.getSession(dmsRepoConfig.getSystemWorkspace(), manageableRepository);
        Node basedTemplateHome = (Node)session.getItem(this.basedApplicationTemplatesPath);
        session.logout();
        return basedTemplateHome;
    }

    private void importPredefinedTemplateToDB(Node storedTemplateHomeNode) throws Exception {
        HashMap<String, ArrayList<PortletTemplatePlugin.PortletTemplateConfig>> map = new HashMap<String, ArrayList<PortletTemplatePlugin.PortletTemplateConfig>>();
        String repository = ((ManageableRepository)storedTemplateHomeNode.getSession().getRepository()).getConfiguration().getName();
        List<String> managedApplicationsPerRepo = this.managedApplicationNames.get(repository);
        if (managedApplicationsPerRepo == null) {
            managedApplicationsPerRepo = new ArrayList<String>();
        }
        for (PortletTemplatePlugin plugin : this.portletTemplatePlugins) {
            ArrayList<PortletTemplatePlugin.PortletTemplateConfig> list;
            String portletName = plugin.getPortletName();
            if (!managedApplicationsPerRepo.contains(portletName)) {
                managedApplicationsPerRepo.add(portletName);
            }
            if ((list = (ArrayList<PortletTemplatePlugin.PortletTemplateConfig>)map.get(portletName)) == null) {
                list = new ArrayList<PortletTemplatePlugin.PortletTemplateConfig>();
            }
            list.addAll(plugin.getPortletTemplateConfigs());
            map.put(portletName, list);
        }
        for (String portletName : managedApplicationsPerRepo) {
            if (storedTemplateHomeNode.hasNode(portletName)) continue;
            Node templateNode = storedTemplateHomeNode.addNode(portletName, "nt:unstructured");
            storedTemplateHomeNode.save();
            for (PortletTemplatePlugin.PortletTemplateConfig config : (List)map.get(portletName)) {
                this.addTemplate(templateNode, config);
            }
        }
        this.managedApplicationNames.put(repository, managedApplicationsPerRepo);
        storedTemplateHomeNode.getSession().save();
    }

    public void start() {
        PropertiesParam propertiesParam = this.params.getPropertiesParam("storedLocations");
        RepositoryEntry repositoryEntry = null;
        try {
            repositoryEntry = this.repositoryService.getCurrentRepository().getConfiguration();
        }
        catch (RepositoryException e) {
            log.error((Object)e.getMessage(), (Throwable)e);
        }
        String repoName = repositoryEntry.getName();
        String workspaceName = propertiesParam.getProperty(repoName);
        if (workspaceName != null) {
            workspaceName = repositoryEntry.getSystemWorkspaceName();
        }
        this.storedWorkspaces.put(repoName, workspaceName);
        this.basedApplicationTemplatesPath = this.hierarchyCreator.getJcrPath("viewTemplatesPath");
        SessionProvider sessionProvider = SessionProvider.createSystemProvider();
        for (String repository : this.storedWorkspaces.keySet()) {
            try {
                Node storedTemplateHome = this.getBasedApplicationTemplatesHome(sessionProvider, repository);
                this.importPredefinedTemplateToDB(storedTemplateHome);
            }
            catch (Exception e) {
                log.error((Object)("Exception when import predefine application template into repository: " + repository), (Throwable)e);
            }
        }
        sessionProvider.close();
        this.portletTemplatePlugins.clear();
        this.portletTemplatePlugins = null;
    }

    public void stop() {
    }
}

