/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.services.jcr.impl.core;

import java.io.InputStream;
import java.util.Calendar;
import javax.jcr.ItemVisitor;
import javax.jcr.Node;
import javax.jcr.Property;
import javax.jcr.PropertyType;
import javax.jcr.RepositoryException;
import javax.jcr.Value;
import javax.jcr.ValueFactory;
import javax.jcr.ValueFormatException;
import javax.jcr.lock.LockException;
import javax.jcr.nodetype.ConstraintViolationException;
import javax.jcr.nodetype.PropertyDefinition;
import javax.jcr.version.VersionException;
import org.exoplatform.services.jcr.core.nodetype.ExtendedNodeTypeManager;
import org.exoplatform.services.jcr.core.nodetype.ItemDefinitionData;
import org.exoplatform.services.jcr.core.nodetype.PropertyDefinitionData;
import org.exoplatform.services.jcr.core.nodetype.PropertyDefinitionDatas;
import org.exoplatform.services.jcr.dataflow.ItemDataConsumer;
import org.exoplatform.services.jcr.datamodel.InternalQName;
import org.exoplatform.services.jcr.datamodel.ItemData;
import org.exoplatform.services.jcr.datamodel.NodeData;
import org.exoplatform.services.jcr.datamodel.PropertyData;
import org.exoplatform.services.jcr.impl.core.ItemImpl;
import org.exoplatform.services.jcr.impl.core.SessionImpl;
import org.exoplatform.services.jcr.impl.core.nodetype.PropertyDefinitionImpl;
import org.exoplatform.services.jcr.impl.core.value.BaseValue;

public class PropertyImpl
extends ItemImpl
implements Property {
    protected int type;
    private PropertyDefinitionData propertyDef;
    private PropertyData propertyData;

    PropertyImpl(ItemData data, SessionImpl session) throws RepositoryException, ConstraintViolationException {
        super(data, session);
        this.loadData(data);
    }

    PropertyImpl(ItemData data, NodeData parent, SessionImpl session) throws RepositoryException, ConstraintViolationException {
        super(data, session);
        this.loadData(data, parent);
    }

    void loadData(ItemData data) throws RepositoryException, ConstraintViolationException {
        this.loadData(data, null);
    }

    void loadData(ItemData data, NodeData parent) throws RepositoryException, ConstraintViolationException {
        if (data.isNode()) {
            throw new RepositoryException("Load data failed: Property expected");
        }
        this.data = data;
        this.propertyData = (PropertyData)data;
        this.type = this.propertyData.getType();
        this.qpath = data.getQPath();
        this.location = null;
        this.initDefinitions(this.propertyData.isMultiValued(), parent);
    }

    public ItemDefinitionData getItemDefinitionData() {
        return this.propertyDef;
    }

    public Value getValue() throws ValueFormatException, RepositoryException {
        this.checkValid();
        if (this.isMultiValued()) {
            throw new ValueFormatException("The property " + this.getPath() + " is multi-valued (6.2.4)");
        }
        if (this.propertyData.getValues() != null && this.propertyData.getValues().size() == 0) {
            throw new ValueFormatException("The single valued property " + this.getPath() + " is empty");
        }
        return this.valueFactory.loadValue(this.propertyData.getValues().get(0), this.propertyData.getType());
    }

    public Value[] getValues() throws ValueFormatException, RepositoryException {
        this.checkValid();
        if (!this.isMultiValued()) {
            throw new ValueFormatException("The property " + this.getPath() + " is single-valued (6.2.4)");
        }
        return this.getValueArray();
    }

    public String getString() throws ValueFormatException, RepositoryException {
        try {
            return this.getValue().getString();
        }
        catch (ValueFormatException e) {
            throw new ValueFormatException("PropertyImpl.getString() for " + this.getPath() + " failed: " + (Object)((Object)e));
        }
        catch (IllegalStateException e) {
            throw new ValueFormatException("PropertyImpl.getString() for " + this.getPath() + " failed: " + e);
        }
    }

    public double getDouble() throws ValueFormatException, RepositoryException {
        try {
            return this.getValue().getDouble();
        }
        catch (IllegalStateException e) {
            throw new ValueFormatException("PropertyImpl.getDouble() failed: " + e);
        }
    }

    public long getLong() throws ValueFormatException, RepositoryException {
        try {
            return this.getValue().getLong();
        }
        catch (IllegalStateException e) {
            throw new ValueFormatException("PropertyImpl.getLong() failed: " + e);
        }
    }

    public InputStream getStream() throws ValueFormatException, RepositoryException {
        try {
            return this.getValue().getStream();
        }
        catch (IllegalStateException e) {
            throw new ValueFormatException("PropertyImpl.getStream() failed: " + e);
        }
    }

    public Calendar getDate() throws ValueFormatException, RepositoryException {
        try {
            return this.getValue().getDate();
        }
        catch (IllegalStateException e) {
            throw new ValueFormatException("PropertyImpl.getDate() failed: " + e);
        }
    }

    public boolean getBoolean() throws ValueFormatException, RepositoryException {
        try {
            return this.getValue().getBoolean();
        }
        catch (IllegalStateException e) {
            throw new ValueFormatException("PropertyImpl.getBoolean() failed: " + e);
        }
    }

    public Node getNode() throws ValueFormatException, RepositoryException {
        try {
            String identifier = ((BaseValue)this.getValue()).getReference();
            return this.session.getNodeByUUID(identifier);
        }
        catch (IllegalStateException e) {
            throw new ValueFormatException("PropertyImpl.getNode() failed: " + e);
        }
    }

    public long getLength() throws ValueFormatException, RepositoryException {
        return ((BaseValue)this.getValue()).getLength();
    }

    public long[] getLengths() throws ValueFormatException, RepositoryException {
        Value[] thisValues = this.getValues();
        long[] lengths = new long[thisValues.length];
        for (int i = 0; i < lengths.length; ++i) {
            lengths[i] = ((BaseValue)thisValues[i]).getLength();
        }
        return lengths;
    }

    public PropertyDefinition getDefinition() throws RepositoryException {
        this.checkValid();
        if (this.propertyDef == null) {
            throw new RepositoryException("FATAL: property definition is NULL " + this.getPath() + " " + this.propertyData.getValues());
        }
        Value[] defaultValues = new Value[this.propertyDef.getDefaultValues().length];
        String[] propVal = this.propertyDef.getDefaultValues();
        if (propVal != null) {
            for (int i = 0; i < propVal.length; ++i) {
                defaultValues[i] = this.propertyDef.getRequiredType() == 0 ? this.valueFactory.createValue(propVal[i]) : this.valueFactory.createValue(propVal[i], this.propertyDef.getRequiredType());
            }
        }
        return new PropertyDefinitionImpl(this.propertyDef, this.session.getWorkspace().getNodeTypesHolder(), (ExtendedNodeTypeManager)this.session.getWorkspace().getNodeTypeManager(), this.session.getSystemLocationFactory(), (ValueFactory)this.session.getValueFactory(), (ItemDataConsumer)this.session.getTransientNodesManager());
    }

    private void initDefinitions(boolean multiple, NodeData parent) throws RepositoryException, ConstraintViolationException {
        PropertyDefinitionDatas definitions;
        InternalQName pname = this.getData().getQPath().getName();
        if (parent == null) {
            parent = this.parentData();
        }
        if ((definitions = this.session.getWorkspace().getNodeTypesHolder().getPropertyDefinitions(pname, parent.getPrimaryTypeName(), parent.getMixinTypeNames())) == null) {
            throw new ConstraintViolationException("Definition for property " + this.getPath() + " not found.");
        }
        this.propertyDef = definitions.getDefinition(multiple);
    }

    public int getType() {
        return this.type;
    }

    public void setValue(Value value) throws ValueFormatException, VersionException, LockException, ConstraintViolationException, RepositoryException {
        this.checkValid();
        this.doUpdateProperty(this.parent(), this.getInternalName(), value, false, 0);
    }

    public void setValue(Value[] values) throws ValueFormatException, VersionException, LockException, ConstraintViolationException, RepositoryException {
        this.checkValid();
        this.doUpdateProperty(this.parent(), this.getInternalName(), values, true, 0);
    }

    public boolean isMultiValued() {
        return ((PropertyData)this.data).isMultiValued();
    }

    public void setValue(String value) throws ValueFormatException, VersionException, LockException, ConstraintViolationException, RepositoryException {
        this.setValue(this.valueFactory.createValue(value));
    }

    public void setValue(InputStream stream) throws ValueFormatException, VersionException, LockException, ConstraintViolationException, RepositoryException {
        this.setValue(this.valueFactory.createValue(stream));
    }

    public void setValue(double number) throws ValueFormatException, VersionException, LockException, ConstraintViolationException, RepositoryException {
        this.setValue(this.valueFactory.createValue(number));
    }

    public void setValue(long number) throws ValueFormatException, VersionException, LockException, ConstraintViolationException, RepositoryException {
        this.setValue(this.valueFactory.createValue(number));
    }

    public void setValue(Calendar date) throws ValueFormatException, VersionException, LockException, ConstraintViolationException, RepositoryException {
        this.setValue(this.valueFactory.createValue(date));
    }

    public void setValue(boolean b) throws ValueFormatException, VersionException, LockException, ConstraintViolationException, RepositoryException {
        this.setValue(this.valueFactory.createValue(b));
    }

    public void setValue(Node value) throws ValueFormatException, VersionException, LockException, ConstraintViolationException, RepositoryException {
        this.setValue(this.valueFactory.createValue(value));
    }

    public void setValue(String[] values) throws ValueFormatException, VersionException, LockException, ConstraintViolationException, RepositoryException {
        Value[] strValues = null;
        if (values != null) {
            strValues = new Value[values.length];
            for (int i = 0; i < values.length; ++i) {
                strValues[i] = this.valueFactory.createValue(values[i]);
            }
        }
        this.setValue(strValues);
    }

    public void accept(ItemVisitor visitor) throws RepositoryException {
        this.checkValid();
        visitor.visit((Property)this);
    }

    public boolean isNode() {
        return false;
    }

    public Value[] getValueArray() throws RepositoryException {
        Value[] values = new Value[this.propertyData.getValues().size()];
        for (int i = 0; i < values.length; ++i) {
            values[i] = this.valueFactory.loadValue(this.propertyData.getValues().get(i), this.propertyData.getType());
        }
        return values;
    }

    public String dump() {
        String vals = "Property ";
        try {
            vals = this.getPath() + " values: ";
            for (int i = 0; i < this.getValueArray().length; ++i) {
                vals = vals + new String(((BaseValue)this.getValueArray()[i]).getInternalData().getAsByteArray()) + ";";
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return vals;
    }

    public boolean equals(Object obj) {
        if (obj instanceof PropertyImpl) {
            try {
                return this.getLocation().equals(((PropertyImpl)obj).getLocation());
            }
            catch (Exception e) {
                return false;
            }
        }
        return false;
    }

    public String toString() {
        String typeName;
        try {
            typeName = PropertyType.nameFromValue((int)this.type);
        }
        catch (IllegalArgumentException e) {
            typeName = String.valueOf(this.type);
        }
        return String.format("Property {\n id: %s;\n path: %s;\n type: %s;\n multi-valued: %b\n}", this.data == null ? "not valid property" : this.data.getIdentifier(), this.qpath == null ? "undefined" : this.qpath.getAsString(), typeName, this.data == null ? false : this.isMultiValued());
    }
}

