/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.services.jcr.impl.core.lock.cacheable;

import javax.jcr.Node;
import javax.jcr.RepositoryException;
import javax.jcr.lock.LockException;
import org.exoplatform.services.jcr.impl.core.SessionImpl;
import org.exoplatform.services.jcr.impl.core.lock.LockImpl;
import org.exoplatform.services.jcr.impl.core.lock.cacheable.CacheableSessionLockManager;
import org.exoplatform.services.jcr.impl.core.lock.cacheable.LockData;

public class CacheLockImpl
extends LockImpl {
    private boolean live;
    private LockData lockData;
    private SessionImpl session;
    private CacheableSessionLockManager lockManager;

    public CacheLockImpl(SessionImpl session, LockData lockData, CacheableSessionLockManager lockManager) {
        this.lockData = lockData;
        this.session = session;
        this.lockManager = lockManager;
        this.live = true;
    }

    public String getLockOwner() {
        return this.lockData.getOwner();
    }

    public String getLockToken() {
        return this.lockManager.getLockToken(this.lockData.getTokenHash());
    }

    public boolean isLive() throws LockException {
        if (!this.live) {
            return false;
        }
        this.live = this.lockManager.isLockLive(this.lockData.getNodeIdentifier());
        return this.live;
    }

    public void refresh() throws LockException, RepositoryException {
        if (!this.isLive()) {
            throw new LockException("Lock is not live");
        }
        LockData newLockData = new LockData(this.lockData.getNodeIdentifier(), this.lockData.getTokenHash(), this.lockData.isDeep(), this.lockData.isSessionScoped(), this.lockData.getOwner(), this.lockData.getTimeOut());
        this.lockManager.refresh(newLockData);
        this.lockData = newLockData;
    }

    public Node getNode() {
        try {
            return (Node)this.session.getTransientNodesManager().getItemByIdentifier(this.lockData.getNodeIdentifier(), true);
        }
        catch (RepositoryException e) {
            e.printStackTrace();
            return null;
        }
    }

    public boolean isDeep() {
        return this.lockData.isDeep();
    }

    public boolean isSessionScoped() {
        return this.lockData.isSessionScoped();
    }

    public long getTimeToDeath() {
        return this.lockData.getTimeToDeath();
    }

    protected void setTimeOut(long timeOut) throws LockException {
        this.lockData.setTimeOut(timeOut);
        this.lockManager.refresh(this.lockData);
    }
}

