/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.services.jcr.impl.core.lock.jbosscache;

import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.security.AccessController;
import java.security.PrivilegedAction;
import java.security.PrivilegedActionException;
import java.security.PrivilegedExceptionAction;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.exoplatform.commons.utils.SecurityHelper;
import org.jboss.cache.CacheSPI;
import org.jboss.cache.CacheStatus;
import org.jboss.cache.Fqn;
import org.jboss.cache.Modification;
import org.jboss.cache.NodeSPI;
import org.jboss.cache.RegionManager;
import org.jboss.cache.config.CacheLoaderConfig;
import org.jboss.cache.loader.CacheLoader;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ControllerCacheLoader
implements CacheLoader {
    private final CacheLoader cl;
    private CacheSPI cache;
    private CacheLoaderConfig.IndividualCacheLoaderConfig config;

    public ControllerCacheLoader(CacheLoader cl) {
        this.cl = cl;
    }

    public void commit(final Object tx) throws Exception {
        PrivilegedExceptionAction<Object> action = new PrivilegedExceptionAction<Object>(){

            @Override
            public Object run() throws Exception {
                ControllerCacheLoader.this.cl.commit(tx);
                return null;
            }
        };
        try {
            AccessController.doPrivileged(action);
        }
        catch (PrivilegedActionException pae) {
            Throwable cause = pae.getCause();
            if (cause instanceof Exception) {
                throw (Exception)cause;
            }
            throw new RuntimeException(cause);
        }
    }

    public boolean exists(Fqn name) throws Exception {
        if (this.cache.getCacheStatus() == CacheStatus.STARTING) {
            NodeSPI node = this.cache.peek(name, false);
            if (node != null) {
                return true;
            }
            return this.cl.exists(name);
        }
        return false;
    }

    public Map<Object, Object> get(Fqn name) throws Exception {
        if (this.cache.getCacheStatus() == CacheStatus.STARTING) {
            NodeSPI node = this.cache.peek(name, false);
            if (node != null) {
                return node.getDataDirect();
            }
            return this.cl.get(name);
        }
        return null;
    }

    public Set<?> getChildrenNames(Fqn fqn) throws Exception {
        return this.cl.getChildrenNames(fqn);
    }

    public CacheLoaderConfig.IndividualCacheLoaderConfig getConfig() {
        return this.config;
    }

    public void loadEntireState(ObjectOutputStream os) throws Exception {
        this.cl.loadEntireState(os);
    }

    public void loadState(Fqn subtree, ObjectOutputStream os) throws Exception {
        this.cl.loadState(subtree, os);
    }

    public void prepare(final Object tx, final List<Modification> modifications, final boolean onePhase) throws Exception {
        PrivilegedExceptionAction<Object> action = new PrivilegedExceptionAction<Object>(){

            @Override
            public Object run() throws Exception {
                ControllerCacheLoader.this.cl.prepare(tx, modifications, onePhase);
                return null;
            }
        };
        try {
            AccessController.doPrivileged(action);
        }
        catch (PrivilegedActionException pae) {
            Throwable cause = pae.getCause();
            if (cause instanceof Exception) {
                throw (Exception)cause;
            }
            throw new RuntimeException(cause);
        }
    }

    public void put(final List<Modification> modifications) throws Exception {
        SecurityHelper.doPrivilegedIOExceptionAction((PrivilegedExceptionAction)new PrivilegedExceptionAction<Void>(){

            @Override
            public Void run() throws Exception {
                ControllerCacheLoader.this.cl.put(modifications);
                return null;
            }
        });
    }

    public void put(final Fqn name, final Map<Object, Object> attributes) throws Exception {
        SecurityHelper.doPrivilegedIOExceptionAction((PrivilegedExceptionAction)new PrivilegedExceptionAction<Void>(){

            @Override
            public Void run() throws Exception {
                ControllerCacheLoader.this.cl.put(name, attributes);
                return null;
            }
        });
    }

    public Object put(final Fqn name, final Object key, final Object value) throws Exception {
        return SecurityHelper.doPrivilegedIOExceptionAction((PrivilegedExceptionAction)new PrivilegedExceptionAction<Object>(){

            @Override
            public Object run() throws Exception {
                return ControllerCacheLoader.this.cl.put(name, key, value);
            }
        });
    }

    public void remove(final Fqn fqn) throws Exception {
        SecurityHelper.doPrivilegedIOExceptionAction((PrivilegedExceptionAction)new PrivilegedExceptionAction<Void>(){

            @Override
            public Void run() throws Exception {
                ControllerCacheLoader.this.cl.remove(fqn);
                return null;
            }
        });
    }

    public Object remove(final Fqn fqn, final Object key) throws Exception {
        return SecurityHelper.doPrivilegedIOExceptionAction((PrivilegedExceptionAction)new PrivilegedExceptionAction<Object>(){

            @Override
            public Object run() throws Exception {
                return ControllerCacheLoader.this.cl.remove(fqn, key);
            }
        });
    }

    public void removeData(final Fqn fqn) throws Exception {
        SecurityHelper.doPrivilegedIOExceptionAction((PrivilegedExceptionAction)new PrivilegedExceptionAction<Void>(){

            @Override
            public Void run() throws Exception {
                ControllerCacheLoader.this.cl.removeData(fqn);
                return null;
            }
        });
    }

    public void rollback(final Object tx) {
        PrivilegedAction<Object> action = new PrivilegedAction<Object>(){

            @Override
            public Object run() {
                ControllerCacheLoader.this.cl.rollback(tx);
                return null;
            }
        };
        AccessController.doPrivileged(action);
    }

    public void setCache(CacheSPI c) {
        this.cl.setCache(c);
        this.cache = c;
    }

    public void setConfig(CacheLoaderConfig.IndividualCacheLoaderConfig config) {
        this.config = config;
    }

    public void setRegionManager(RegionManager manager) {
        this.cl.setRegionManager(manager);
    }

    public void storeEntireState(ObjectInputStream is) throws Exception {
        this.cl.storeEntireState(is);
    }

    public void storeState(Fqn subtree, ObjectInputStream is) throws Exception {
        this.cl.storeState(subtree, is);
    }

    public void create() throws Exception {
        this.cl.create();
    }

    public void destroy() {
        this.cl.destroy();
    }

    public void start() throws Exception {
        this.cl.start();
    }

    public void stop() {
        this.cl.stop();
    }
}

