/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.services.jcr.impl.dataflow.persistent.jbosscache;

import java.util.Set;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.exoplatform.services.jcr.impl.dataflow.persistent.jbosscache.JBossCacheWorkspaceStorageCache;
import org.jboss.cache.Cache;
import org.jboss.cache.CacheSPI;
import org.jboss.cache.Fqn;
import org.jboss.cache.NodeSPI;
import org.jboss.cache.eviction.EvictionActionPolicy;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ParentNodeEvictionActionPolicy
implements EvictionActionPolicy {
    Cache<?, ?> cache;
    private static final Log log = LogFactory.getLog((String)"exo.jcr.component.core.DefaultEvictionActionPolicy");

    public void setCache(Cache<?, ?> cache) {
        this.cache = cache;
    }

    public boolean evict(Fqn fqn) {
        boolean result;
        block9: {
            try {
                if (log.isTraceEnabled()) {
                    log.trace((Object)("Evicting Fqn " + fqn));
                }
                this.cache.evict(fqn);
                result = true;
            }
            catch (Exception e) {
                if (log.isDebugEnabled()) {
                    log.debug((Object)("Unable to evict " + fqn), (Throwable)e);
                }
                result = false;
            }
            if (fqn.size() != 4) {
                return result;
            }
            try {
                Set names;
                NodeSPI node;
                Fqn parentFqn = fqn.getParent();
                if ((parentFqn.get(1).equals(JBossCacheWorkspaceStorageCache.CHILD_NODES) || parentFqn.get(1).equals(JBossCacheWorkspaceStorageCache.CHILD_PROPS)) && (node = ((CacheSPI)this.cache).peek(parentFqn, false)) != null && ((names = node.getChildrenNamesDirect()).isEmpty() || names.size() == 1 && names.contains(fqn.get(3)))) {
                    if (log.isTraceEnabled()) {
                        log.trace((Object)("Evicting Fqn " + fqn));
                    }
                    this.cache.evict(parentFqn);
                }
            }
            catch (Exception e) {
                if (!log.isDebugEnabled()) break block9;
                log.debug((Object)("Unable to evict " + fqn), (Throwable)e);
            }
        }
        return result;
    }
}

