/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.services.jcr.impl.storage.jdbc.backup.util;

import java.io.ByteArrayInputStream;
import java.io.EOFException;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.security.PrivilegedExceptionAction;
import java.sql.Connection;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import javax.naming.InitialContext;
import javax.naming.NameNotFoundException;
import javax.naming.NamingException;
import javax.sql.DataSource;
import org.exoplatform.commons.utils.PrivilegedFileHelper;
import org.exoplatform.commons.utils.SecurityHelper;
import org.exoplatform.services.jcr.dataflow.serialization.ObjectReader;
import org.exoplatform.services.jcr.impl.Constants;
import org.exoplatform.services.jcr.impl.dataflow.serialization.ObjectReaderImpl;
import org.exoplatform.services.jcr.impl.dataflow.serialization.ObjectZipReaderImpl;
import org.exoplatform.services.jcr.impl.storage.jdbc.DialectDetecter;
import org.exoplatform.services.jcr.impl.storage.jdbc.backup.Backupable;
import org.exoplatform.services.jcr.impl.storage.jdbc.backup.RestoreException;
import org.exoplatform.services.jcr.impl.storage.jdbc.backup.util.BackupTables;
import org.exoplatform.services.jcr.impl.storage.jdbc.backup.util.RestoreTableRule;
import org.exoplatform.services.jcr.impl.util.io.FileCleaner;
import org.exoplatform.services.log.ExoLogger;
import org.exoplatform.services.log.Log;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class RestoreTables {
    private final List<File> spoolFileList = new ArrayList<File>();
    private final FileCleaner fileCleaner;
    private final File tempDir;
    private final int maxBufferSize;
    protected static final Log LOG = ExoLogger.getLogger((String)"exo.jcr.component.core.JDBCWorkspaceDataContainer");

    public RestoreTables(FileCleaner fileCleaner, File tempDir, int maxBufferSize) {
        this.fileCleaner = fileCleaner;
        this.tempDir = tempDir;
        this.maxBufferSize = maxBufferSize;
    }

    /*
     * Loose catch block
     */
    public void restore(File storageDir, String dsName, Map<String, RestoreTableRule> tables) throws RestoreException {
        block35: {
            SQLException e22;
            RestoreException exc;
            Statement st;
            Connection jdbcConn;
            block33: {
                jdbcConn = null;
                Object jdbcConn1 = null;
                st = null;
                exc = null;
                final DataSource ds = (DataSource)new InitialContext().lookup(dsName);
                if (ds == null) {
                    throw new NameNotFoundException("Data source " + dsName + " not found");
                }
                jdbcConn = (Connection)SecurityHelper.doPrivilegedSQLExceptionAction((PrivilegedExceptionAction)new PrivilegedExceptionAction<Connection>(){

                    @Override
                    public Connection run() throws Exception {
                        return ds.getConnection();
                    }
                });
                jdbcConn.setAutoCommit(false);
                int dialect = DialectDetecter.detect(jdbcConn.getMetaData()).hashCode();
                for (Map.Entry<String, RestoreTableRule> entry : tables.entrySet()) {
                    String tableName = entry.getKey();
                    RestoreTableRule restoreRule = entry.getValue();
                    String constraint = null;
                    if ((tableName.equals("JCR_SITEM") || tableName.equals("JCR_MITEM")) && dialect != BackupTables.DB_DIALECT_MYSQL && dialect != BackupTables.DB_DIALECT_MYSQL_UTF8 && dialect != BackupTables.DB_DIALECT_SYBASE) {
                        String constraintName = dialect == BackupTables.DB_DIALECT_DB2 || dialect == BackupTables.DB_DIALECT_DB2V8 ? "JCR_FK_" + (restoreRule.getDstMultiDb() != false ? "M" : "S") + "ITEM_PAREN" : "JCR_FK_" + (restoreRule.getDstMultiDb() != false ? "M" : "S") + "ITEM_PARENT";
                        constraint = "CONSTRAINT " + constraintName + " FOREIGN KEY(PARENT_ID) REFERENCES " + tableName + "(ID)";
                        st = jdbcConn.createStatement();
                        st.execute("ALTER TABLE " + tableName + " DROP CONSTRAINT " + constraintName);
                    }
                    this.restore(storageDir, jdbcConn, tableName, restoreRule);
                    if (constraint == null) continue;
                    st.execute("ALTER TABLE " + tableName + " ADD " + constraint);
                }
                jdbcConn.commit();
                Object var17_23 = null;
                if (st == null) break block33;
                try {
                    st.close();
                }
                catch (SQLException e22) {
                    LOG.warn((Object)"Can't close statemnt", (Throwable)e22);
                }
            }
            if (jdbcConn != null) {
                jdbcConn.rollback();
                Object var20_27 = null;
                try {
                    jdbcConn.close();
                }
                catch (SQLException e3) {
                    if (exc != null) {
                        throw new RestoreException(e3);
                    }
                    throw new RestoreException("Can't close connection", exc);
                }
                {
                    catch (SQLException e22) {
                        if (exc != null) {
                            throw new RestoreException(e22);
                        }
                        throw new RestoreException("Can't rollback connection", exc);
                    }
                }
                catch (Throwable throwable) {
                    Object var20_28 = null;
                    try {
                        jdbcConn.close();
                    }
                    catch (SQLException e3) {
                        if (exc != null) {
                            throw new RestoreException(e3);
                        }
                        throw new RestoreException("Can't close connection", exc);
                    }
                    throw throwable;
                }
            }
            break block35;
            {
                catch (IOException e4) {
                    exc = new RestoreException(e4);
                    throw exc;
                }
                catch (SQLException e5) {
                    String errorTrace = "";
                    for (SQLException next = e5.getNextException(); next != null; next = next.getNextException()) {
                        errorTrace = errorTrace + next.getMessage() + "; ";
                    }
                    Throwable cause = e5.getCause();
                    String msg = "SQL Exception: " + errorTrace + (cause != null ? " (Cause: " + cause.getMessage() + ")" : "");
                    exc = new RestoreException(msg, e5);
                    throw exc;
                }
                catch (NamingException e6) {
                    exc = new RestoreException(e6);
                    throw exc;
                }
            }
            catch (Throwable throwable) {
                SQLException e22;
                Object var17_24 = null;
                if (st != null) {
                    try {
                        st.close();
                    }
                    catch (SQLException e22) {
                        LOG.warn((Object)"Can't close statemnt", (Throwable)e22);
                    }
                }
                if (jdbcConn != null) {
                    jdbcConn.rollback();
                    Object var20_29 = null;
                    try {
                        jdbcConn.close();
                    }
                    catch (SQLException e3) {
                        if (exc != null) {
                            throw new RestoreException(e3);
                        }
                        throw new RestoreException("Can't close connection", exc);
                    }
                    {
                        catch (SQLException e22) {
                            if (exc != null) {
                                throw new RestoreException(e22);
                            }
                            throw new RestoreException("Can't rollback connection", exc);
                        }
                    }
                    catch (Throwable throwable2) {
                        Object var20_30 = null;
                        try {
                            jdbcConn.close();
                        }
                        catch (SQLException e3) {
                            if (exc != null) {
                                throw new RestoreException(e3);
                            }
                            throw new RestoreException("Can't close connection", exc);
                        }
                        throw throwable2;
                    }
                }
                throw throwable;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void restore(File storageDir, Connection jdbcConn, String tableName, RestoreTableRule restoreRule) throws IOException, SQLException {
        ResultSet tableMetaData;
        Statement insertNode;
        ObjectReaderImpl contentLenReader;
        block51: {
            SecurityManager security = System.getSecurityManager();
            if (security != null) {
                security.checkPermission(Backupable.BACKUP_RESTORE_PERMISSION);
            }
            ObjectZipReaderImpl contentReader = null;
            contentLenReader = null;
            insertNode = null;
            tableMetaData = null;
            int dialect = DialectDetecter.detect(jdbcConn.getMetaData()).hashCode();
            if (dialect == BackupTables.DB_DIALECT_PGSQL) {
                tableName = tableName.toLowerCase();
            }
            try {
                int i;
                contentReader = new ObjectZipReaderImpl(PrivilegedFileHelper.zipInputStream((File)restoreRule.getContentFile()));
                contentReader.getNextEntry();
                contentLenReader = new ObjectZipReaderImpl(PrivilegedFileHelper.zipInputStream((File)restoreRule.getContentLenFile()));
                ((ObjectZipReaderImpl)contentLenReader).getNextEntry();
                int sourceColumnCount = contentReader.readInt();
                ArrayList<Integer> columnType = new ArrayList<Integer>();
                ArrayList<String> columnName = new ArrayList<String>();
                for (int i2 = 0; i2 < sourceColumnCount; ++i2) {
                    columnType.add(contentReader.readInt());
                    columnName.add(contentReader.readString());
                }
                int targetColumnCount = sourceColumnCount;
                if (restoreRule.getDeleteColumnIndex() != null) {
                    --targetColumnCount;
                } else if (restoreRule.getNewColumnIndex() != null) {
                    ++targetColumnCount;
                    columnType.add(restoreRule.getNewColumnIndex(), restoreRule.getNewColumnType());
                    String newColumnName = dialect == BackupTables.DB_DIALECT_PGSQL ? restoreRule.getNewColumnName().toLowerCase() : restoreRule.getNewColumnName();
                    columnName.add(restoreRule.getNewColumnIndex(), newColumnName);
                }
                String names = "";
                String parameters = "";
                for (i = 0; i < targetColumnCount; ++i) {
                    if (restoreRule.getSkipColumnIndex() != null && restoreRule.getSkipColumnIndex() == i) continue;
                    names = names + (String)columnName.get(i) + (i == targetColumnCount - 1 ? "" : ",");
                    parameters = parameters + "?" + (i == targetColumnCount - 1 ? "" : ",");
                }
                insertNode = jdbcConn.prepareStatement("INSERT INTO " + tableName + " (" + names + ") VALUES(" + parameters + ")");
                block8: while (true) {
                    i = 0;
                    int targetIndex = 0;
                    while (i < columnType.size()) {
                        long len;
                        ByteArrayInputStream stream;
                        if (restoreRule.getNewColumnIndex() != null && restoreRule.getNewColumnIndex() == i) {
                            stream = new ByteArrayInputStream(restoreRule.getDstContainerName().getBytes("UTF-8"));
                            len = stream.available();
                        } else {
                            try {
                                len = contentLenReader.readLong();
                            }
                            catch (EOFException e) {
                                if (i == 0) {
                                    try {
                                        contentReader.readByte();
                                    }
                                    catch (EOFException e1) {
                                        break block8;
                                    }
                                }
                                throw new IOException("Content length file is empty but content still present", e);
                            }
                            InputStream inputStream = stream = len == -1L ? null : this.spoolInputStream(contentReader, len);
                        }
                        if (restoreRule.getSkipColumnIndex() != null && restoreRule.getSkipColumnIndex() == i) {
                            --targetIndex;
                        } else if (restoreRule.getDeleteColumnIndex() != null && restoreRule.getDeleteColumnIndex() == i) {
                            --targetIndex;
                        } else if (stream != null) {
                            String value;
                            byte[] readBuffer;
                            ByteArrayInputStream ba;
                            if (restoreRule.getConvertColumnIndex() != null && restoreRule.getConvertColumnIndex().contains(i)) {
                                StringBuilder builder;
                                ba = stream;
                                readBuffer = new byte[ba.available()];
                                ba.read(readBuffer);
                                String currentValue = new String(readBuffer, "UTF-8");
                                if (currentValue.equals(Constants.ROOT_PARENT_UUID)) {
                                    stream = new ByteArrayInputStream(Constants.ROOT_PARENT_UUID.getBytes());
                                } else if (restoreRule.getDstMultiDb().booleanValue()) {
                                    if (!restoreRule.getSrcMultiDb().booleanValue()) {
                                        stream = new ByteArrayInputStream(new String(readBuffer, "UTF-8").substring(restoreRule.getSrcContainerName().length()).getBytes());
                                    }
                                } else if (restoreRule.getSrcMultiDb().booleanValue()) {
                                    builder = new StringBuilder();
                                    builder.append(restoreRule.getDstContainerName());
                                    builder.append(currentValue);
                                    stream = new ByteArrayInputStream(builder.toString().getBytes());
                                } else {
                                    builder = new StringBuilder();
                                    builder.append(restoreRule.getDstContainerName());
                                    builder.append(new String(readBuffer, "UTF-8").substring(restoreRule.getSrcContainerName().length()));
                                    stream = new ByteArrayInputStream(builder.toString().getBytes());
                                }
                                len = stream.available();
                            }
                            if ((Integer)columnType.get(i) == 4 || (Integer)columnType.get(i) == -5 || (Integer)columnType.get(i) == 5 || (Integer)columnType.get(i) == -6) {
                                ba = stream;
                                readBuffer = new byte[ba.available()];
                                ba.read(readBuffer);
                                value = new String(readBuffer, "UTF-8");
                                insertNode.setLong(targetIndex + 1, Integer.parseInt(value));
                            } else if ((Integer)columnType.get(i) == -7) {
                                ba = stream;
                                readBuffer = new byte[ba.available()];
                                ba.read(readBuffer);
                                value = new String(readBuffer);
                                if (dialect == BackupTables.DB_DIALECT_PGSQL) {
                                    insertNode.setBoolean(targetIndex + 1, value.equals("t"));
                                } else {
                                    insertNode.setBoolean(targetIndex + 1, value.equals("1"));
                                }
                            } else if ((Integer)columnType.get(i) == 16) {
                                ba = stream;
                                readBuffer = new byte[ba.available()];
                                ba.read(readBuffer);
                                value = new String(readBuffer);
                                insertNode.setBoolean(targetIndex + 1, value.equals("true"));
                            } else if ((Integer)columnType.get(i) == -3 || (Integer)columnType.get(i) == -4 || (Integer)columnType.get(i) == 2004 || (Integer)columnType.get(i) == -2) {
                                insertNode.setBinaryStream(targetIndex + 1, stream, (int)len);
                            } else {
                                byte[] readBuffer2 = new byte[(int)len];
                                stream.read(readBuffer2);
                                insertNode.setString(targetIndex + 1, new String(readBuffer2, "UTF-8"));
                            }
                        } else {
                            insertNode.setNull(targetIndex + 1, (Integer)columnType.get(i));
                        }
                        ++i;
                        ++targetIndex;
                    }
                    insertNode.addBatch();
                }
                insertNode.executeBatch();
                Object var27_27 = null;
                if (contentReader == null) break block51;
            }
            catch (Throwable throwable) {
                Object var27_28 = null;
                if (contentReader != null) {
                    contentReader.close();
                }
                if (contentLenReader != null) {
                    contentLenReader.close();
                }
                if (insertNode != null) {
                    insertNode.close();
                }
                for (File file : this.spoolFileList) {
                    if (PrivilegedFileHelper.delete((File)file)) continue;
                    this.fileCleaner.addFile(file);
                }
                if (tableMetaData != null) {
                    tableMetaData.close();
                }
                throw throwable;
            }
            contentReader.close();
        }
        if (contentLenReader != null) {
            contentLenReader.close();
        }
        if (insertNode != null) {
            insertNode.close();
        }
        for (File file : this.spoolFileList) {
            if (PrivilegedFileHelper.delete((File)file)) continue;
            this.fileCleaner.addFile(file);
        }
        if (tableMetaData != null) {
            tableMetaData.close();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private InputStream spoolInputStream(ObjectReader in, long contentLen) throws IOException {
        FileInputStream fileInputStream;
        File sf;
        block13: {
            OutputStream sfout;
            block11: {
                ByteArrayInputStream byteArrayInputStream;
                block12: {
                    byte[] buffer = new byte[]{};
                    long readLen = 0L;
                    sf = null;
                    sfout = null;
                    try {
                        while (true) {
                            int needToRead = contentLen - readLen > 2048L ? 2048 : (int)(contentLen - readLen);
                            byte[] tmpBuff = new byte[needToRead];
                            if (needToRead == 0) break;
                            in.readFully(tmpBuff);
                            if (sfout != null) {
                                sfout.write(tmpBuff);
                            } else if (readLen + (long)needToRead > (long)this.maxBufferSize && this.fileCleaner != null) {
                                sf = PrivilegedFileHelper.createTempFile((String)"jcrvd", null, (File)this.tempDir);
                                sfout = PrivilegedFileHelper.fileOutputStream((File)sf);
                                sfout.write(buffer);
                                sfout.write(tmpBuff);
                                buffer = null;
                            } else {
                                byte[] newBuffer = new byte[(int)(readLen + (long)needToRead)];
                                System.arraycopy(buffer, 0, newBuffer, 0, (int)readLen);
                                System.arraycopy(tmpBuff, 0, newBuffer, (int)readLen, needToRead);
                                buffer = newBuffer;
                            }
                            readLen += (long)needToRead;
                        }
                        if (buffer == null) break block11;
                        byteArrayInputStream = new ByteArrayInputStream(buffer);
                        Object var13_12 = null;
                        if (sfout == null) break block12;
                    }
                    catch (Throwable throwable) {
                        block14: {
                            Object var13_14 = null;
                            if (sfout != null) {
                                sfout.close();
                            }
                            if (sf == null) break block14;
                            this.spoolFileList.add(sf);
                        }
                        throw throwable;
                    }
                    sfout.close();
                }
                if (sf != null) {
                    this.spoolFileList.add(sf);
                }
                return byteArrayInputStream;
            }
            fileInputStream = PrivilegedFileHelper.fileInputStream(sf);
            Object var13_13 = null;
            if (sfout == null) break block13;
            sfout.close();
        }
        if (sf != null) {
            this.spoolFileList.add(sf);
        }
        return fileInputStream;
    }
}

