/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.ecm.webui.component.admin.nodetype;

import java.util.ArrayList;
import java.util.List;
import javax.jcr.nodetype.NodeType;
import javax.jcr.nodetype.PropertyDefinition;
import org.exoplatform.ecm.webui.component.admin.nodetype.UINodeTypeForm;
import org.exoplatform.ecm.webui.component.admin.nodetype.UINodeTypeOptionList;
import org.exoplatform.ecm.webui.form.UIFormInputSetWithAction;
import org.exoplatform.services.jcr.RepositoryService;
import org.exoplatform.services.jcr.core.nodetype.PropertyDefinitionValue;
import org.exoplatform.web.application.ApplicationMessage;
import org.exoplatform.webui.application.WebuiRequestContext;
import org.exoplatform.webui.config.annotation.ComponentConfig;
import org.exoplatform.webui.core.UIApplication;
import org.exoplatform.webui.core.UIComponent;
import org.exoplatform.webui.core.model.SelectItemOption;
import org.exoplatform.webui.event.Event;
import org.exoplatform.webui.event.EventListener;
import org.exoplatform.webui.form.UIFormCheckBoxInput;
import org.exoplatform.webui.form.UIFormInput;
import org.exoplatform.webui.form.UIFormMultiValueInputSet;
import org.exoplatform.webui.form.UIFormSelectBox;
import org.exoplatform.webui.form.UIFormStringInput;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@ComponentConfig(template="classpath:groovy/ecm/webui/form/UIFormInputSetWithAction.gtmpl")
public class UIPropertyDefinitionForm
extends UIFormInputSetWithAction {
    public static final String NAMESPACE = "propertyNamespace";
    public static final String DEFINITION_NAME = "propertyname";
    public static final String REQUIRED_TYPE = "requiredType";
    public static final String MULTIPLE = "multiple";
    public static final String MANDATORY = "mandatory";
    public static final String AUTOCREATED = "autoCreated";
    public static final String PROTECTED = "protected";
    public static final String PARENTVERSION = "parentversion";
    public static final String CONSTRAINTS = "constraints";
    public static final String VALUE_CONSTRAINTS = "valueconstraints";
    public static final String TRUE = "true";
    public static final String FALSE = "false";
    public static final String ACTION_UPDATE_PROPERTY = "UpdateProperty";
    public static final String ACTION_CANCEL_PROPERTY = "CancelProperty";
    private String requiredValue_;

    public UIPropertyDefinitionForm(String name) throws Exception {
        super(name);
        this.setComponentConfig(((Object)((Object)this)).getClass(), null);
        ArrayList<SelectItemOption> autoListItem = new ArrayList<SelectItemOption>();
        autoListItem.add(new SelectItemOption(FALSE, (Object)FALSE));
        autoListItem.add(new SelectItemOption(TRUE, (Object)TRUE));
        ArrayList<SelectItemOption> mandoListItem = new ArrayList<SelectItemOption>();
        mandoListItem.add(new SelectItemOption(FALSE, (Object)FALSE));
        mandoListItem.add(new SelectItemOption(TRUE, (Object)TRUE));
        ArrayList<SelectItemOption> multiListItem = new ArrayList<SelectItemOption>();
        multiListItem.add(new SelectItemOption(FALSE, (Object)FALSE));
        multiListItem.add(new SelectItemOption(TRUE, (Object)TRUE));
        ArrayList<SelectItemOption> protectedItem = new ArrayList<SelectItemOption>();
        protectedItem.add(new SelectItemOption(FALSE, (Object)FALSE));
        protectedItem.add(new SelectItemOption(TRUE, (Object)TRUE));
        this.addUIFormInput((UIFormInput)new UIFormSelectBox(NAMESPACE, NAMESPACE, this.getNamespaces()));
        this.addUIFormInput((UIFormInput)new UIFormStringInput(DEFINITION_NAME, DEFINITION_NAME, null));
        UIFormSelectBox uiRequired = new UIFormSelectBox(REQUIRED_TYPE, REQUIRED_TYPE, this.getRequiredTypes());
        uiRequired.setOnChange("ChangeRequiredType");
        this.addUIFormInput((UIFormInput)uiRequired);
        this.addUIFormInput((UIFormInput)new UIFormSelectBox(AUTOCREATED, AUTOCREATED, autoListItem));
        this.addUIFormInput((UIFormInput)new UIFormSelectBox(MANDATORY, MANDATORY, mandoListItem));
        this.addUIFormInput((UIFormInput)new UIFormSelectBox(PARENTVERSION, PARENTVERSION, this.getParentVersions()));
        this.addUIFormInput((UIFormInput)new UIFormSelectBox(PROTECTED, PROTECTED, protectedItem));
        this.addUIFormInput((UIFormInput)new UIFormSelectBox(MULTIPLE, MULTIPLE, multiListItem));
        this.addUIFormInput((UIFormInput)new UIFormStringInput(VALUE_CONSTRAINTS, VALUE_CONSTRAINTS, null));
    }

    public void processRender(WebuiRequestContext context) throws Exception {
        super.processRender(context);
    }

    private List<SelectItemOption<String>> getParentVersions() {
        ArrayList<SelectItemOption<String>> versionItem = new ArrayList<SelectItemOption<String>>();
        versionItem.add(new SelectItemOption("COPY", (Object)"1"));
        versionItem.add(new SelectItemOption("VERSION", (Object)"2"));
        versionItem.add(new SelectItemOption("INITIALIZE", (Object)"3"));
        versionItem.add(new SelectItemOption("COMPUTE", (Object)"4"));
        versionItem.add(new SelectItemOption("IGNORE", (Object)"5"));
        versionItem.add(new SelectItemOption("ABORT", (Object)"6"));
        return versionItem;
    }

    private List<SelectItemOption<String>> getRequiredTypes() {
        ArrayList<SelectItemOption<String>> requireType = new ArrayList<SelectItemOption<String>>();
        requireType.add(new SelectItemOption("STRING", (Object)"1"));
        requireType.add(new SelectItemOption("BINARY", (Object)"2"));
        requireType.add(new SelectItemOption("LONG", (Object)"3"));
        requireType.add(new SelectItemOption("DOUBLE", (Object)"4"));
        requireType.add(new SelectItemOption("DATE", (Object)"5"));
        requireType.add(new SelectItemOption("BOOLEAN", (Object)"6"));
        requireType.add(new SelectItemOption("NAME", (Object)"7"));
        requireType.add(new SelectItemOption("PATH", (Object)"8"));
        requireType.add(new SelectItemOption("REFERENCE", (Object)"9"));
        requireType.add(new SelectItemOption("UNDEFINED", (Object)"0"));
        return requireType;
    }

    public List<SelectItemOption<String>> getNamespaces() throws Exception {
        ArrayList<SelectItemOption<String>> namespacesOptions = new ArrayList<SelectItemOption<String>>();
        String[] namespaces = ((RepositoryService)this.getApplicationComponent(RepositoryService.class)).getCurrentRepository().getNamespaceRegistry().getPrefixes();
        for (int i = 0; i < namespaces.length; ++i) {
            namespacesOptions.add((SelectItemOption<String>)new SelectItemOption(namespaces[i], (Object)namespaces[i]));
        }
        return namespacesOptions;
    }

    public void refresh() throws Exception {
        ArrayList<SelectItemOption> autoListItem = new ArrayList<SelectItemOption>();
        autoListItem.add(new SelectItemOption(FALSE, (Object)FALSE));
        autoListItem.add(new SelectItemOption(TRUE, (Object)TRUE));
        ArrayList<SelectItemOption> mandoListItem = new ArrayList<SelectItemOption>();
        mandoListItem.add(new SelectItemOption(FALSE, (Object)FALSE));
        mandoListItem.add(new SelectItemOption(TRUE, (Object)TRUE));
        ArrayList<SelectItemOption> multiListItem = new ArrayList<SelectItemOption>();
        multiListItem.add(new SelectItemOption(FALSE, (Object)FALSE));
        multiListItem.add(new SelectItemOption(TRUE, (Object)TRUE));
        ArrayList<SelectItemOption> protectedItem = new ArrayList<SelectItemOption>();
        protectedItem.add(new SelectItemOption(FALSE, (Object)FALSE));
        protectedItem.add(new SelectItemOption(TRUE, (Object)TRUE));
        this.getUIFormSelectBox(NAMESPACE).setOptions(this.getNamespaces()).setDisabled(false);
        this.getUIStringInput(DEFINITION_NAME).setEditable(true).setValue(null);
        this.getUIFormSelectBox(REQUIRED_TYPE).setOptions(this.getRequiredTypes()).setDisabled(false);
        this.getUIFormSelectBox(AUTOCREATED).setOptions(autoListItem).setDisabled(false);
        this.getUIFormSelectBox(MANDATORY).setOptions(mandoListItem).setDisabled(false);
        this.getUIFormSelectBox(PARENTVERSION).setOptions(this.getParentVersions()).setDisabled(false);
        this.getUIFormSelectBox(PROTECTED).setOptions(protectedItem).setDisabled(false);
        this.getUIFormSelectBox(MULTIPLE).setOptions(multiListItem).setDisabled(false);
        this.getUIStringInput(VALUE_CONSTRAINTS).setEditable(true).setValue(null);
        UINodeTypeForm uiForm = (UINodeTypeForm)this.getParent();
        UIFormInputSetWithAction uiPropertyTab = (UIFormInputSetWithAction)uiForm.getChildById("propertyDefinition");
        uiForm.setActionInTab(uiPropertyTab);
    }

    private void setRequiredValue(String requiredValue) {
        this.requiredValue_ = requiredValue;
    }

    private String getRequiredValue() {
        return this.requiredValue_ == null ? "1" : this.requiredValue_;
    }

    public void update(NodeType nodeType, String propertyName) throws Exception {
        if (propertyName != null) {
            PropertyDefinition[] propertyDefinitions = nodeType.getPropertyDefinitions();
            for (int i = 0; i < propertyDefinitions.length; ++i) {
                String name = propertyDefinitions[i].getName();
                if (!name.equals(propertyName)) continue;
                if (propertyName.indexOf(":") > -1) {
                    this.getUIStringInput(DEFINITION_NAME).setValue((Object)propertyName.substring(propertyName.indexOf(":") + 1));
                    this.getUIFormSelectBox(NAMESPACE).setValue(propertyName.substring(0, propertyName.indexOf(":")));
                } else {
                    this.getUIStringInput(DEFINITION_NAME).setValue((Object)propertyName);
                    this.getUIFormSelectBox(NAMESPACE).setValue("");
                }
                String requiredType = Integer.toString(propertyDefinitions[i].getRequiredType());
                this.getUIFormSelectBox(REQUIRED_TYPE).setValue(requiredType);
                this.getUIFormSelectBox(MULTIPLE).setValue(String.valueOf(propertyDefinitions[i].isMultiple()));
                this.getUIFormSelectBox(MANDATORY).setValue(String.valueOf(propertyDefinitions[i].isMandatory()));
                this.getUIFormSelectBox(AUTOCREATED).setValue(String.valueOf(propertyDefinitions[i].isAutoCreated()));
                this.getUIFormSelectBox(PROTECTED).setValue(String.valueOf(propertyDefinitions[i].isProtected()));
                String[] cons = propertyDefinitions[i].getValueConstraints();
                StringBuilder conValues = new StringBuilder();
                if (cons != null && cons.length > 0) {
                    for (int j = 0; j < cons.length; ++j) {
                        if (conValues.length() > 0) {
                            conValues.append(", ");
                        }
                        conValues.append(cons[j]);
                    }
                }
                this.getUIStringInput(VALUE_CONSTRAINTS).setValue((Object)conValues.toString());
                String parentVersion = Integer.toString(propertyDefinitions[i].getOnParentVersion());
                this.getUIFormSelectBox(PARENTVERSION).setValue(parentVersion);
                break;
            }
        }
        this.getUIFormSelectBox(NAMESPACE).setDisabled(true);
        this.getUIStringInput(DEFINITION_NAME).setEditable(false);
        this.getUIFormSelectBox(REQUIRED_TYPE).setDisabled(true);
        this.getUIFormSelectBox(AUTOCREATED).setDisabled(true);
        this.getUIFormSelectBox(MANDATORY).setDisabled(true);
        this.getUIFormSelectBox(PARENTVERSION).setDisabled(true);
        this.getUIFormSelectBox(PROTECTED).setDisabled(true);
        this.getUIFormSelectBox(MULTIPLE).setDisabled(true);
        this.getUIStringInput(VALUE_CONSTRAINTS).setEditable(false);
    }

    private PropertyDefinitionValue getPropertyByName(String propertyName, List<PropertyDefinitionValue> listProperty) {
        for (PropertyDefinitionValue property : listProperty) {
            if (!property.getName().equals(propertyName)) continue;
            return property;
        }
        return null;
    }

    private void setValues(PropertyDefinitionValue property) throws Exception {
        String propertyName = property.getName();
        if (propertyName.indexOf(":") > -1) {
            this.getUIStringInput(DEFINITION_NAME).setValue((Object)propertyName.substring(propertyName.indexOf(":") + 1));
            this.getUIFormSelectBox(NAMESPACE).setValue(propertyName.substring(0, propertyName.indexOf(":")));
        } else {
            this.getUIStringInput(DEFINITION_NAME).setValue((Object)propertyName);
            this.getUIFormSelectBox(NAMESPACE).setValue("");
        }
        String requiredType = Integer.toString(property.getRequiredType());
        this.getUIFormSelectBox(REQUIRED_TYPE).setValue(requiredType);
        this.getUIFormSelectBox(MULTIPLE).setValue(String.valueOf(property.isMultiple()));
        this.getUIFormSelectBox(MANDATORY).setValue(String.valueOf(property.isMandatory()));
        this.getUIFormSelectBox(AUTOCREATED).setValue(String.valueOf(property.isAutoCreate()));
        this.getUIFormSelectBox(PROTECTED).setValue(String.valueOf(property.isReadOnly()));
        List cons = property.getValueConstraints();
        String valueConstraints = null;
        for (String value : cons) {
            if (valueConstraints == null) {
                valueConstraints = value;
                continue;
            }
            valueConstraints = valueConstraints + "," + value;
        }
        this.getUIStringInput(VALUE_CONSTRAINTS).setValue(valueConstraints);
        String parentVersion = Integer.toString(property.getOnVersion());
        this.getUIFormSelectBox(PARENTVERSION).setValue(parentVersion);
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class CancelConstraintsActionListener
    extends EventListener<UINodeTypeForm> {
        public void execute(Event<UINodeTypeForm> event) throws Exception {
            UINodeTypeForm uiForm = (UINodeTypeForm)((Object)event.getSource());
            uiForm.removeChildById("Contraints");
            uiForm.setTabRender("propertyDefinition");
            event.getRequestContext().addUIComponentToUpdateByAjax(uiForm.getParent());
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class AddValueActionListener
    extends EventListener<UINodeTypeForm> {
        public void execute(Event<UINodeTypeForm> event) throws Exception {
            UINodeTypeForm uiForm = (UINodeTypeForm)((Object)event.getSource());
            UIPropertyDefinitionForm uiPropertyForm = (UIPropertyDefinitionForm)uiForm.getChild(UIPropertyDefinitionForm.class);
            String strValues = null;
            if (uiPropertyForm.getRequiredValue().equals("9")) {
                int i;
                ArrayList<String> selectedNodes = new ArrayList<String>();
                ArrayList listCheckbox = new ArrayList();
                uiForm.findComponentOfType(listCheckbox, UIFormCheckBoxInput.class);
                int count = 0;
                for (i = 0; i < listCheckbox.size(); ++i) {
                    if (!((UIFormCheckBoxInput)listCheckbox.get(i)).isChecked()) continue;
                    selectedNodes.add(((UIFormCheckBoxInput)listCheckbox.get(i)).getName());
                    ++count;
                }
                for (i = 0; i < selectedNodes.size(); ++i) {
                    strValues = strValues == null ? (String)selectedNodes.get(i) : strValues + "," + (String)selectedNodes.get(i);
                }
            } else if (uiPropertyForm.getRequiredValue().equals("1")) {
                UIFormMultiValueInputSet uiMulti = (UIFormMultiValueInputSet)uiForm.getUIInput(UIPropertyDefinitionForm.CONSTRAINTS);
                ArrayList constraintValues = uiMulti.getValue();
                if (constraintValues == null) {
                    constraintValues = new ArrayList();
                }
                for (int i = 0; i < constraintValues.size(); ++i) {
                    strValues = strValues == null ? (String)constraintValues.get(i) : strValues + "," + (String)constraintValues.get(i);
                }
            }
            uiForm.getUIStringInput(UIPropertyDefinitionForm.VALUE_CONSTRAINTS).setValue(strValues);
            uiForm.removeChildById("Contraints");
            uiForm.setTabRender("propertyDefinition");
            event.getRequestContext().addUIComponentToUpdateByAjax(uiForm.getParent());
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class RemoveActionListener
    extends EventListener<UINodeTypeForm> {
        public void execute(Event<UINodeTypeForm> event) throws Exception {
            UINodeTypeForm uiForm = (UINodeTypeForm)((Object)event.getSource());
            uiForm.setSelectedTab("Contraints");
            event.getRequestContext().addUIComponentToUpdateByAjax(uiForm.getParent());
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class AddActionListener
    extends EventListener<UINodeTypeForm> {
        public void execute(Event<UINodeTypeForm> event) throws Exception {
            UINodeTypeForm uiForm = (UINodeTypeForm)((Object)event.getSource());
            uiForm.setSelectedTab("Contraints");
            event.getRequestContext().addUIComponentToUpdateByAjax((UIComponent)uiForm);
            event.getRequestContext().addUIComponentToUpdateByAjax(uiForm.getParent());
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class CancelPropertyActionListener
    extends EventListener<UINodeTypeForm> {
        public void execute(Event<UINodeTypeForm> event) throws Exception {
            UINodeTypeForm uiForm = (UINodeTypeForm)((Object)event.getSource());
            UIPropertyDefinitionForm uiPropertyForm = (UIPropertyDefinitionForm)uiForm.getChild(UIPropertyDefinitionForm.class);
            uiPropertyForm.refresh();
            UIFormInputSetWithAction childTab = (UIFormInputSetWithAction)uiForm.getChildById("propertyDefinition");
            childTab.setActions(new String[]{"AddProperty"}, null);
            uiForm.setTabRender("nodeTypeDefinition");
            event.getRequestContext().addUIComponentToUpdateByAjax(uiForm.getParent());
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class AddConstraintsActionListener
    extends EventListener<UINodeTypeForm> {
        public void execute(Event<UINodeTypeForm> event) throws Exception {
            UINodeTypeForm uiForm = (UINodeTypeForm)((Object)event.getSource());
            UIPropertyDefinitionForm uiPropertyForm = (UIPropertyDefinitionForm)uiForm.getChild(UIPropertyDefinitionForm.class);
            uiForm.removeChildById("Contraints");
            String values = (String)uiForm.getUIStringInput(UIPropertyDefinitionForm.VALUE_CONSTRAINTS).getValue();
            UINodeTypeOptionList constraintTab = null;
            if (uiPropertyForm.getRequiredValue().equals("9")) {
                constraintTab = new UINodeTypeOptionList("Contraints");
                uiForm.addUIComponentInput((UIComponent)constraintTab);
                uiForm.setSelectedTab(constraintTab.getId());
                UINodeTypeOptionList uiOptionList = (UINodeTypeOptionList)uiForm.getChild(UINodeTypeOptionList.class);
                uiOptionList.update(values);
            } else if (uiPropertyForm.getRequiredValue().equals("1")) {
                constraintTab = new UIFormInputSetWithAction("Contraints");
                UIFormMultiValueInputSet valuesConstraint = (UIFormMultiValueInputSet)uiPropertyForm.createUIComponent(UIFormMultiValueInputSet.class, null, UIPropertyDefinitionForm.CONSTRAINTS);
                valuesConstraint.setType(UIFormStringInput.class);
                constraintTab.addUIFormInput((UIFormInput)valuesConstraint);
                uiForm.addUIComponentInput((UIComponent)constraintTab);
                uiForm.setSelectedTab(constraintTab.getId());
            } else {
                UIApplication uiApp = (UIApplication)uiForm.getAncestorOfType(UIApplication.class);
                String message = "UIPropertyDefinitionForm.msg.not-supported-value-constraints";
                uiApp.addMessage(new ApplicationMessage(message, null));
                event.getRequestContext().addUIComponentToUpdateByAjax((UIComponent)uiApp.getUIPopupMessages());
                return;
            }
            uiForm.setSelectedTab("Contraints");
            String[] actionNames = new String[]{"AddValue", "CancelConstraints"};
            constraintTab.setActions(actionNames, null);
            event.getRequestContext().addUIComponentToUpdateByAjax(uiForm.getParent());
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class ChangeRequiredTypeActionListener
    extends EventListener<UINodeTypeForm> {
        public void execute(Event<UINodeTypeForm> event) throws Exception {
            UINodeTypeForm uiForm = (UINodeTypeForm)((Object)event.getSource());
            UIPropertyDefinitionForm uiPropertyForm = (UIPropertyDefinitionForm)uiForm.getChild(UIPropertyDefinitionForm.class);
            String value = (String)uiForm.getUIFormSelectBox(UIPropertyDefinitionForm.REQUIRED_TYPE).getValue();
            uiPropertyForm.setRequiredValue(value);
            if (value.equals("1") || value.equals("9")) {
                uiForm.getUIStringInput(UIPropertyDefinitionForm.VALUE_CONSTRAINTS).setEditable(true);
            } else {
                uiForm.getUIStringInput(UIPropertyDefinitionForm.VALUE_CONSTRAINTS).setEditable(false);
            }
            uiForm.getUIStringInput(UIPropertyDefinitionForm.VALUE_CONSTRAINTS).setValue(null);
            event.getRequestContext().addUIComponentToUpdateByAjax(uiForm.getParent());
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class AddPropertyActionListener
    extends EventListener<UINodeTypeForm> {
        public void execute(Event<UINodeTypeForm> event) throws Exception {
            UINodeTypeForm uiForm = (UINodeTypeForm)((Object)event.getSource());
            UIApplication uiApp = (UIApplication)uiForm.getAncestorOfType(UIApplication.class);
            String prefix = (String)uiForm.getUIFormSelectBox(UIPropertyDefinitionForm.NAMESPACE).getValue();
            String propertyName = (String)uiForm.getUIStringInput(UIPropertyDefinitionForm.DEFINITION_NAME).getValue();
            if (propertyName == null || propertyName.trim().length() == 0) {
                uiForm.setTabRender("propertyDefinition");
                uiApp.addMessage(new ApplicationMessage("UIPropertyDefinitionForm.msg.property-name", null));
                event.getRequestContext().addUIComponentToUpdateByAjax((UIComponent)uiApp.getUIPopupMessages());
                return;
            }
            for (int i = 0; i < propertyName.length(); ++i) {
                char c = propertyName.charAt(i);
                if (Character.isLetter(c) || Character.isDigit(c) || Character.isSpaceChar(c) || c == '_' || c == '-' || c == '.' || c == ':' || c == '@' || c == '^' || c == '[' || c == ']' || c == ',') continue;
                uiApp.addMessage(new ApplicationMessage("UIPropertyDefinitionForm.msg.property-name", null, 1));
                event.getRequestContext().addUIComponentToUpdateByAjax((UIComponent)uiApp.getUIPopupMessages());
                return;
            }
            if (prefix != null && prefix.length() > 0) {
                propertyName = prefix + ":" + propertyName;
            }
            UIPropertyDefinitionForm uiPropertyForm = (UIPropertyDefinitionForm)uiForm.getChild(UIPropertyDefinitionForm.class);
            PropertyDefinitionValue propertyInfo = new PropertyDefinitionValue();
            propertyInfo.setName(propertyName);
            String requiredType = (String)uiForm.getUIFormSelectBox(UIPropertyDefinitionForm.REQUIRED_TYPE).getValue();
            propertyInfo.setRequiredType(Integer.parseInt(requiredType));
            String multipleValue = (String)uiForm.getUIFormSelectBox(UIPropertyDefinitionForm.MULTIPLE).getValue();
            propertyInfo.setMultiple(Boolean.parseBoolean(multipleValue));
            String mandatory = (String)uiForm.getUIFormSelectBox(UIPropertyDefinitionForm.MANDATORY).getValue();
            propertyInfo.setMandatory(Boolean.parseBoolean(mandatory));
            String autoCreate = (String)uiForm.getUIFormSelectBox(UIPropertyDefinitionForm.AUTOCREATED).getValue();
            propertyInfo.setAutoCreate(Boolean.parseBoolean(autoCreate));
            String isProtected = (String)uiForm.getUIFormSelectBox(UIPropertyDefinitionForm.PROTECTED).getValue();
            propertyInfo.setReadOnly(Boolean.parseBoolean(isProtected));
            String onParent = (String)uiForm.getUIFormSelectBox(UIPropertyDefinitionForm.PARENTVERSION).getValue();
            propertyInfo.setOnVersion(Integer.parseInt(onParent));
            String valueConstraints = (String)uiForm.getUIStringInput(UIPropertyDefinitionForm.VALUE_CONSTRAINTS).getValue();
            ArrayList<String> constraintValues = new ArrayList<String>();
            if (valueConstraints != null) {
                if (valueConstraints.indexOf(",") > -1) {
                    String[] arrValues = valueConstraints.split(",");
                    for (int i = 0; i < arrValues.length; ++i) {
                        constraintValues.add(arrValues[i].toString());
                    }
                } else {
                    constraintValues.add(valueConstraints);
                }
            }
            propertyInfo.setValueConstraints(constraintValues);
            uiForm.addedPropertiesDef_.add(propertyInfo);
            uiForm.setPropertyValue(uiForm.addedPropertiesDef_);
            uiPropertyForm.refresh();
            uiForm.setTabRender("nodeTypeDefinition");
            UIFormInputSetWithAction nodeTypeTab = (UIFormInputSetWithAction)uiForm.getChildById("nodeTypeDefinition");
            nodeTypeTab.setIsView(false);
            event.getRequestContext().addUIComponentToUpdateByAjax(uiForm.getParent());
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class UpdatePropertyActionListener
    extends EventListener<UINodeTypeForm> {
        public void execute(Event<UINodeTypeForm> event) throws Exception {
            UINodeTypeForm uiForm = (UINodeTypeForm)((Object)event.getSource());
            UIPropertyDefinitionForm uiPropertyForm = (UIPropertyDefinitionForm)uiForm.getChild(UIPropertyDefinitionForm.class);
            String propertyName = event.getRequestContext().getRequestParameter("objectId");
            PropertyDefinitionValue propertyInfo = uiPropertyForm.getPropertyByName(propertyName, uiForm.addedPropertiesDef_);
            UIApplication uiApp = (UIApplication)uiForm.getAncestorOfType(UIApplication.class);
            String prefix = (String)uiForm.getUIFormSelectBox(UIPropertyDefinitionForm.NAMESPACE).getValue();
            String name = (String)uiPropertyForm.getUIStringInput(UIPropertyDefinitionForm.DEFINITION_NAME).getValue();
            if (name == null || name.trim().length() == 0) {
                uiForm.setTabRender("propertyDefinition");
                uiApp.addMessage(new ApplicationMessage("UIPropertyDefinitionForm.msg.property-name", null));
                event.getRequestContext().addUIComponentToUpdateByAjax((UIComponent)uiApp.getUIPopupMessages());
                return;
            }
            for (int i = 0; i < name.length(); ++i) {
                char c = name.charAt(i);
                if (Character.isLetter(c) || Character.isDigit(c) || Character.isSpaceChar(c) || c == '_' || c == '-' || c == '.' || c == ':' || c == '@' || c == '^' || c == '[' || c == ']' || c == ',') continue;
                uiApp.addMessage(new ApplicationMessage("UIPropertyDefinitionForm.msg.property-name", null, 1));
                event.getRequestContext().addUIComponentToUpdateByAjax((UIComponent)uiApp.getUIPopupMessages());
                return;
            }
            if (prefix != null && prefix.length() > 0) {
                name = prefix + ":" + name;
            }
            if (propertyInfo == null) {
                propertyInfo = new PropertyDefinitionValue();
            }
            propertyInfo.setName(name);
            String requiredType = (String)uiForm.getUIFormSelectBox(UIPropertyDefinitionForm.REQUIRED_TYPE).getValue();
            propertyInfo.setRequiredType(Integer.parseInt(requiredType));
            String isMultiple = (String)uiForm.getUIFormSelectBox(UIPropertyDefinitionForm.MULTIPLE).getValue();
            propertyInfo.setMultiple(Boolean.parseBoolean(isMultiple));
            String isMandatory = (String)uiForm.getUIFormSelectBox(UIPropertyDefinitionForm.MANDATORY).getValue();
            propertyInfo.setMandatory(Boolean.parseBoolean(isMandatory));
            String autoCreate = (String)uiForm.getUIFormSelectBox(UIPropertyDefinitionForm.AUTOCREATED).getValue();
            propertyInfo.setAutoCreate(Boolean.parseBoolean(autoCreate));
            String isProtected = (String)uiForm.getUIFormSelectBox(UIPropertyDefinitionForm.PROTECTED).getValue();
            propertyInfo.setReadOnly(Boolean.parseBoolean(isProtected));
            String onParent = (String)uiForm.getUIFormSelectBox(UIPropertyDefinitionForm.PARENTVERSION).getValue();
            propertyInfo.setOnVersion(Integer.parseInt(onParent));
            String valueConstraints = (String)uiForm.getUIStringInput(UIPropertyDefinitionForm.VALUE_CONSTRAINTS).getValue();
            ArrayList<String> constraintValues = new ArrayList<String>();
            if (valueConstraints != null) {
                if (valueConstraints.indexOf(",") > -1) {
                    String[] arrValues = valueConstraints.split(",");
                    for (int i = 0; i < arrValues.length; ++i) {
                        constraintValues.add(arrValues[i]);
                    }
                } else {
                    constraintValues.add(valueConstraints);
                }
            }
            propertyInfo.setValueConstraints(constraintValues);
            uiForm.setPropertyValue(uiForm.addedPropertiesDef_);
            uiPropertyForm.refresh();
            UIFormInputSetWithAction propertyTab = (UIFormInputSetWithAction)uiForm.getChildById("propertyDefinition");
            propertyTab.setActions(new String[]{"AddProperty"}, null);
            uiForm.setTabRender("nodeTypeDefinition");
            event.getRequestContext().addUIComponentToUpdateByAjax(uiForm.getParent());
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class EditPropertyActionListener
    extends EventListener<UINodeTypeForm> {
        public void execute(Event<UINodeTypeForm> event) throws Exception {
            UINodeTypeForm uiForm = (UINodeTypeForm)((Object)event.getSource());
            UIPropertyDefinitionForm uiPropertyForm = (UIPropertyDefinitionForm)uiForm.getChild(UIPropertyDefinitionForm.class);
            String propertyName = event.getRequestContext().getRequestParameter("objectId");
            if (propertyName == null || propertyName.trim().length() == 0) {
                uiForm.setTabRender("propertyDefinition");
                UIApplication uiApp = (UIApplication)uiForm.getAncestorOfType(UIApplication.class);
                uiApp.addMessage(new ApplicationMessage("UIPropertyDefinitionForm.msg.property-name", null));
                event.getRequestContext().addUIComponentToUpdateByAjax((UIComponent)uiApp.getUIPopupMessages());
                return;
            }
            PropertyDefinitionValue property = uiPropertyForm.getPropertyByName(propertyName, uiForm.addedPropertiesDef_);
            uiPropertyForm.setValues(property);
            uiPropertyForm.setRequiredValue(Integer.toString(property.getRequiredType()));
            UIFormInputSetWithAction propertyTab = (UIFormInputSetWithAction)uiForm.getChildById("propertyDefinition");
            String[] actionNames = new String[]{UIPropertyDefinitionForm.ACTION_UPDATE_PROPERTY, UIPropertyDefinitionForm.ACTION_CANCEL_PROPERTY};
            String[] fieldNames = new String[]{propertyName, null};
            propertyTab.setActions(actionNames, fieldNames);
            uiForm.setTabRender("propertyDefinition");
            event.getRequestContext().addUIComponentToUpdateByAjax(uiForm.getParent());
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class RemovePropertyActionListener
    extends EventListener<UINodeTypeForm> {
        public void execute(Event<UINodeTypeForm> event) throws Exception {
            UINodeTypeForm uiForm = (UINodeTypeForm)((Object)event.getSource());
            String propertyName = event.getRequestContext().getRequestParameter("objectId");
            if (propertyName == null || propertyName.trim().length() == 0) {
                uiForm.setTabRender("propertyDefinition");
                UIApplication uiApp = (UIApplication)uiForm.getAncestorOfType(UIApplication.class);
                uiApp.addMessage(new ApplicationMessage("UIPropertyDefinitionForm.msg.property-name", null));
                event.getRequestContext().addUIComponentToUpdateByAjax((UIComponent)uiApp.getUIPopupMessages());
                return;
            }
            for (PropertyDefinitionValue property : uiForm.addedPropertiesDef_) {
                if (!property.getName().equals(propertyName)) continue;
                uiForm.addedPropertiesDef_.remove(property);
                break;
            }
            uiForm.setPropertyValue(uiForm.addedPropertiesDef_);
            uiForm.setTabRender("nodeTypeDefinition");
            event.getRequestContext().addUIComponentToUpdateByAjax(uiForm.getParent());
        }
    }
}

