/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.web.handler;

import java.io.PrintWriter;
import java.io.Writer;
import java.net.URLEncoder;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.exoplatform.container.ExoContainer;
import org.exoplatform.container.ExoContainerContext;
import org.exoplatform.upload.UploadResource;
import org.exoplatform.upload.UploadService;
import org.exoplatform.web.WebAppController;
import org.exoplatform.web.WebRequestHandler;

public class UploadHandler
extends WebRequestHandler {
    public String[] getPath() {
        return new String[]{"/upload"};
    }

    public void execute(WebAppController controller, HttpServletRequest req, HttpServletResponse res) throws Exception {
        String action = req.getParameter("action");
        String[] uploadIds = req.getParameterValues("uploadId");
        res.setHeader("Cache-Control", "no-cache");
        ExoContainer container = ExoContainerContext.getCurrentContainer();
        UploadService service = (UploadService)container.getComponentInstanceOfType(UploadService.class);
        if (action == null || action.length() < 1) {
            return;
        }
        UploadServiceAction uploadActionService = UploadServiceAction.valueOf(action.toUpperCase());
        if (uploadActionService == UploadServiceAction.PROGRESS) {
            PrintWriter writer = res.getWriter();
            if (uploadIds == null) {
                return;
            }
            StringBuilder value = new StringBuilder();
            value.append("{\n  upload : {");
            for (int i = 0; i < uploadIds.length; ++i) {
                UploadResource upResource = service.getUploadResource(uploadIds[i]);
                if (upResource == null) continue;
                if (upResource.getStatus() == 2) {
                    int limitMB = service.getUploadLimitsMB().get(uploadIds[i]);
                    value.append("\n    \"").append(uploadIds[i]).append("\": {");
                    value.append("\n      \"status\":").append('\"').append("failed").append("\",");
                    value.append("\n      \"size\":").append('\"').append(limitMB).append("\"");
                    value.append("\n    }");
                    continue;
                }
                double percent = 100.0;
                if (upResource.getStatus() == 0) {
                    percent = upResource.getUploadedSize() * 100.0 / upResource.getEstimatedSize();
                }
                value.append("\n    \"").append(uploadIds[i]).append("\": {");
                value.append("\n      \"percent\":").append('\"').append((int)percent).append("\",");
                value.append("\n      \"fileName\":").append('\"').append(this.encodeName(upResource.getFileName())).append("\"");
                value.append("\n    }");
                if (i >= uploadIds.length - 1) continue;
                value.append(',');
            }
            value.append("\n  }\n}");
            ((Writer)writer).append(value);
        } else if (uploadActionService == UploadServiceAction.UPLOAD) {
            service.createUploadResource(req);
        } else if (uploadActionService == UploadServiceAction.DELETE) {
            service.removeUploadResource(uploadIds[0]);
        } else if (uploadActionService == UploadServiceAction.ABORT) {
            service.removeUploadResource(uploadIds[0]);
        }
    }

    public String encodeName(String name) throws Exception {
        String[] arr = name.split(" ");
        String str = "";
        for (int i = 0; i < arr.length; ++i) {
            str = str + " " + URLEncoder.encode(arr[i], "UTF-8");
        }
        return str;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    static enum UploadServiceAction {
        PROGRESS,
        UPLOAD,
        DELETE,
        ABORT;

    }
}

