/*
 * Decompiled with CFR 0.152.
 */
package org.jbpm.command;

import java.util.ArrayList;
import java.util.Iterator;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.hibernate.Query;
import org.jbpm.JbpmContext;
import org.jbpm.command.Command;
import org.jbpm.graph.exe.Token;
import org.jbpm.util.ArrayUtil;

public abstract class AbstractTokenBaseCommand
implements Command {
    protected Log log = LogFactory.getLog(this.getClass());
    private long[] tokenIds = null;
    private String processName = null;
    private String stateName = null;
    private int processVersion = 0;
    private boolean operateOnSingleObject;
    private transient JbpmContext jbpmContext;
    private static final long serialVersionUID = 1L;

    protected JbpmContext getJbpmContext() {
        return this.jbpmContext;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Object execute(JbpmContext jbpmContext) throws Exception {
        this.jbpmContext = jbpmContext;
        try {
            ArrayList<Object> result = new ArrayList<Object>();
            this.log.debug((Object)("executing " + this));
            if (this.tokenIds != null && this.tokenIds.length > 0) {
                for (int i = 0; i < this.tokenIds.length; ++i) {
                    Token token = jbpmContext.loadTokenForUpdate(this.tokenIds[i]);
                    result.add(this.execute(token));
                }
            }
            if (this.processName != null && this.stateName != null) {
                this.operateOnSingleObject = false;
                Query query = null;
                if (this.processVersion > 0) {
                    query = jbpmContext.getSession().getNamedQuery("GraphSession.findTokensForProcessVersionInNode");
                    query.setInteger("processDefinitionVersion", this.processVersion);
                } else {
                    query = jbpmContext.getSession().getNamedQuery("GraphSession.findTokensForProcessInNode");
                }
                query.setString("processDefinitionName", this.processName);
                query.setString("nodeName", this.stateName);
                Iterator iter = query.list().iterator();
                while (iter.hasNext()) {
                    Token token = (Token)iter.next();
                    result.add(this.execute(token));
                }
            }
            if (this.operateOnSingleObject) {
                if (result.size() < 1) {
                    Object var3_5 = null;
                    return var3_5;
                }
                Object e = result.get(0);
                return e;
            }
            ArrayList<Object> arrayList = result;
            return arrayList;
        }
        finally {
            this.jbpmContext = null;
        }
    }

    public abstract Object execute(Token var1);

    public void setTokenIds(long[] tokenIds) {
        this.operateOnSingleObject = false;
        this.tokenIds = tokenIds;
    }

    public void setTokenId(long tokenId) {
        this.operateOnSingleObject = true;
        this.tokenIds = new long[1];
        this.tokenIds[0] = tokenId;
    }

    public String getAdditionalToStringInformation() {
        return "";
    }

    public String getProcessName() {
        return this.processName;
    }

    public void setProcessName(String processName) {
        this.processName = processName;
    }

    public int getProcessVersion() {
        return this.processVersion;
    }

    public void setProcessVersion(int processVersion) {
        this.processVersion = processVersion;
    }

    public String getStateName() {
        return this.stateName;
    }

    public void setStateName(String stateName) {
        this.stateName = stateName;
    }

    public long[] getTokenIds() {
        return this.tokenIds;
    }

    public long getTokenId() {
        if (this.tokenIds == null || this.tokenIds.length != 1) {
            throw new IllegalStateException("multiple token ids set: " + ArrayUtil.toString(this.tokenIds));
        }
        return this.tokenIds[0];
    }

    public String toString() {
        if (this.processName != null && this.stateName != null) {
            return this.getClass().getName() + " [tokenIds=" + ArrayUtil.toString(this.tokenIds) + ";processName=" + this.processName + ";processVersion=" + (this.processVersion > 0 ? Integer.toString(this.processVersion) : "NA") + ";stateName=" + this.stateName + this.getAdditionalToStringInformation() + "]";
        }
        return this.getClass().getName() + " [tokenIds=" + ArrayUtil.toString(this.tokenIds) + ";operateOnSingleObject=" + this.operateOnSingleObject + this.getAdditionalToStringInformation() + "]";
    }

    public AbstractTokenBaseCommand tokenIds(long[] tokenIds) {
        this.setTokenIds(tokenIds);
        return this;
    }

    public AbstractTokenBaseCommand tokenId(long tokenId) {
        this.setTokenId(tokenId);
        return this;
    }

    public AbstractTokenBaseCommand processName(String processName) {
        this.setProcessName(processName);
        return this;
    }

    public AbstractTokenBaseCommand processVersion(int processVersion) {
        this.setProcessVersion(processVersion);
        return this;
    }

    public AbstractTokenBaseCommand stateName(String stateName) {
        this.setStateName(stateName);
        return this;
    }
}

