/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.portal.resource;

class SkinKey {
    private final String module;
    private final String name;
    private final int hashCode;

    public SkinKey(String module, String name) throws IllegalArgumentException {
        if (module == null) {
            throw new IllegalArgumentException("No null base accepted");
        }
        if (name == null) {
            throw new IllegalArgumentException("No null skin name accepted");
        }
        this.module = module;
        this.name = name;
        this.hashCode = module.hashCode() * 41 + name.hashCode();
    }

    public String getModule() {
        return this.module;
    }

    public String getName() {
        return this.name;
    }

    public int hashCode() {
        return this.hashCode;
    }

    public boolean equals(Object obj) {
        if (obj == null) {
            return false;
        }
        if (obj == this) {
            return true;
        }
        if (obj instanceof SkinKey) {
            SkinKey that = (SkinKey)obj;
            return that.module.equals(this.module) && that.name.equals(this.name);
        }
        return false;
    }

    public String toString() {
        return "SkinKey[base=" + this.module + ",name=" + this.name + "]";
    }
}

