/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.services.cache.impl.jboss.util;

import java.io.InputStream;
import java.security.AccessController;
import java.security.PrivilegedAction;
import java.security.PrivilegedActionException;
import java.security.PrivilegedExceptionAction;
import org.jboss.cache.Cache;
import org.jboss.cache.CacheException;
import org.jboss.cache.CacheFactory;
import org.jboss.cache.DefaultCacheFactory;
import org.jboss.cache.Fqn;
import org.jboss.cache.config.ConfigurationException;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class PrivilegedCacheHelper {
    public static <K, V> void start(final Cache<K, V> cache) {
        PrivilegedAction<Void> action = new PrivilegedAction<Void>(){

            @Override
            public Void run() {
                cache.start();
                return null;
            }
        };
        AccessController.doPrivileged(action);
    }

    public static <K, V> void stop(final Cache<K, V> cache) {
        PrivilegedAction<Void> action = new PrivilegedAction<Void>(){

            @Override
            public Void run() {
                cache.stop();
                return null;
            }
        };
        AccessController.doPrivileged(action);
    }

    public static <K, V> void create(final Cache<K, V> cache) {
        PrivilegedAction<Void> action = new PrivilegedAction<Void>(){

            @Override
            public Void run() {
                cache.create();
                return null;
            }
        };
        AccessController.doPrivileged(action);
    }

    public static <K, V> void endBatch(final Cache<K, V> cache, final boolean successful) {
        PrivilegedAction<Void> action = new PrivilegedAction<Void>(){

            @Override
            public Void run() {
                cache.endBatch(successful);
                return null;
            }
        };
        AccessController.doPrivileged(action);
    }

    public static <K, V> Cache<K, V> createCache(final CacheFactory<K, V> factory, final InputStream is, final boolean start) {
        PrivilegedExceptionAction action = new PrivilegedExceptionAction<Cache<K, V>>(){

            @Override
            public Cache<K, V> run() throws Exception {
                return factory.createCache(is, start);
            }
        };
        try {
            return (Cache)AccessController.doPrivileged(action);
        }
        catch (PrivilegedActionException pae) {
            Throwable cause = pae.getCause();
            if (cause instanceof ConfigurationException) {
                throw (ConfigurationException)cause;
            }
            if (cause instanceof RuntimeException) {
                throw (RuntimeException)cause;
            }
            throw new RuntimeException(cause);
        }
    }

    public static <K, V> V put(final Cache<K, V> cache, final String fqn, final K key, final V value) throws CacheException {
        PrivilegedExceptionAction action = new PrivilegedExceptionAction<V>(){

            @Override
            public V run() throws Exception {
                return cache.put(fqn, key, value);
            }
        };
        try {
            return (V)AccessController.doPrivileged(action);
        }
        catch (PrivilegedActionException pae) {
            Throwable cause = pae.getCause();
            if (cause instanceof IllegalStateException) {
                throw (IllegalStateException)cause;
            }
            if (cause instanceof RuntimeException) {
                throw (RuntimeException)cause;
            }
            throw new RuntimeException(cause);
        }
    }

    public static <K, V> boolean removeNode(final Cache<K, V> cache, final Fqn fqn) throws CacheException {
        PrivilegedExceptionAction<Boolean> action = new PrivilegedExceptionAction<Boolean>(){

            @Override
            public Boolean run() throws Exception {
                return cache.removeNode(fqn);
            }
        };
        try {
            return AccessController.doPrivileged(action);
        }
        catch (PrivilegedActionException pae) {
            Throwable cause = pae.getCause();
            if (cause instanceof IllegalStateException) {
                throw (IllegalStateException)cause;
            }
            if (cause instanceof RuntimeException) {
                throw (RuntimeException)cause;
            }
            throw new RuntimeException(cause);
        }
    }

    public static <K, V> V put(final Cache<K, V> cache, final Fqn fqn, final K key, final V value) throws CacheException {
        PrivilegedExceptionAction action = new PrivilegedExceptionAction<V>(){

            @Override
            public V run() throws Exception {
                return cache.put(fqn, key, value);
            }
        };
        try {
            return (V)AccessController.doPrivileged(action);
        }
        catch (PrivilegedActionException pae) {
            Throwable cause = pae.getCause();
            if (cause instanceof IllegalStateException) {
                throw (IllegalStateException)cause;
            }
            if (cause instanceof RuntimeException) {
                throw (RuntimeException)cause;
            }
            throw new RuntimeException(cause);
        }
    }

    public static <K, V> DefaultCacheFactory<K, V> createCacheFactory() throws CacheException {
        PrivilegedAction action = new PrivilegedAction<DefaultCacheFactory<K, V>>(){

            @Override
            public DefaultCacheFactory<K, V> run() {
                return new DefaultCacheFactory();
            }
        };
        return (DefaultCacheFactory)AccessController.doPrivileged(action);
    }
}

