/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.ecm.webui.component.explorer.popup.admin;

import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import javax.jcr.Node;
import javax.jcr.PathNotFoundException;
import javax.jcr.nodetype.NodeType;
import org.exoplatform.ecm.webui.component.explorer.UIJCRExplorer;
import org.exoplatform.ecm.webui.component.explorer.popup.admin.UIActionContainer;
import org.exoplatform.ecm.webui.component.explorer.popup.admin.UIActionForm;
import org.exoplatform.portal.webui.util.Util;
import org.exoplatform.services.cms.actions.ActionServiceContainer;
import org.exoplatform.services.cms.templates.TemplateService;
import org.exoplatform.web.application.ApplicationMessage;
import org.exoplatform.webui.config.annotation.ComponentConfig;
import org.exoplatform.webui.config.annotation.EventConfig;
import org.exoplatform.webui.core.UIApplication;
import org.exoplatform.webui.core.UIComponent;
import org.exoplatform.webui.core.lifecycle.UIFormLifecycle;
import org.exoplatform.webui.core.model.SelectItemOption;
import org.exoplatform.webui.event.Event;
import org.exoplatform.webui.event.EventListener;
import org.exoplatform.webui.form.UIForm;
import org.exoplatform.webui.form.UIFormInput;
import org.exoplatform.webui.form.UIFormSelectBox;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@ComponentConfig(lifecycle=UIFormLifecycle.class, template="app:/groovy/webui/component/explorer/UIFormWithoutAction.gtmpl", events={@EventConfig(listeners={ChangeActionTypeActionListener.class})})
public class UIActionTypeForm
extends UIForm {
    public static final String ACTION_TYPE = "actionType";
    public static final String CHANGE_ACTION = "ChangeActionType";
    private List<SelectItemOption<String>> typeList_ = new ArrayList<SelectItemOption<String>>();
    public String defaultActionType_;

    public UIActionTypeForm() throws Exception {
        UIFormSelectBox uiSelectBox = new UIFormSelectBox(ACTION_TYPE, ACTION_TYPE, new ArrayList());
        uiSelectBox.setOnChange(CHANGE_ACTION);
        this.addUIFormInput((UIFormInput)uiSelectBox);
    }

    private Iterator<NodeType> getCreatedActionTypes() throws Exception {
        ActionServiceContainer actionService = (ActionServiceContainer)this.getApplicationComponent(ActionServiceContainer.class);
        String repository = ((UIJCRExplorer)this.getAncestorOfType(UIJCRExplorer.class)).getRepositoryName();
        return actionService.getCreatedActionTypes(repository).iterator();
    }

    public void setDefaultActionType() throws Exception {
        UIJCRExplorer uiExplorer = (UIJCRExplorer)this.getAncestorOfType(UIJCRExplorer.class);
        UIActionContainer uiActionContainer = (UIActionContainer)this.getParent();
        Node currentNode = uiExplorer.getCurrentNode();
        UIActionForm uiActionForm = (UIActionForm)uiActionContainer.getChild(UIActionForm.class);
        uiActionForm.createNewAction(currentNode, (String)this.typeList_.get(0).getValue(), true);
        uiActionForm.setWorkspace(currentNode.getSession().getWorkspace().getName());
        uiActionForm.setStoredPath(currentNode.getPath());
    }

    public void update() throws Exception {
        Iterator<NodeType> actions = this.getCreatedActionTypes();
        ArrayList<String> actionList = new ArrayList<String>();
        while (actions.hasNext()) {
            String action = actions.next().getName();
            actionList.add(action);
        }
        Collections.sort(actionList);
        TemplateService templateService = (TemplateService)this.getApplicationComponent(TemplateService.class);
        String userName = Util.getPortalRequestContext().getRemoteUser();
        for (String action : actionList) {
            try {
                templateService.getTemplatePathByUser(true, action, userName);
                this.typeList_.add((SelectItemOption<String>)new SelectItemOption(action, (Object)action));
            }
            catch (Exception e) {}
        }
        this.getUIFormSelectBox(ACTION_TYPE).setOptions(this.typeList_);
        this.defaultActionType_ = (String)this.typeList_.get(0).getValue();
        this.getUIFormSelectBox(ACTION_TYPE).setValue(this.defaultActionType_);
        this.setDefaultActionType();
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class ChangeActionTypeActionListener
    extends EventListener<UIActionTypeForm> {
        public void execute(Event<UIActionTypeForm> event) throws Exception {
            UIActionTypeForm uiActionType = (UIActionTypeForm)((Object)event.getSource());
            UIJCRExplorer uiExplorer = (UIJCRExplorer)uiActionType.getAncestorOfType(UIJCRExplorer.class);
            Node currentNode = uiExplorer.getCurrentNode();
            String actionType = (String)uiActionType.getUIFormSelectBox(UIActionTypeForm.ACTION_TYPE).getValue();
            TemplateService templateService = (TemplateService)uiActionType.getApplicationComponent(TemplateService.class);
            String userName = Util.getPortalRequestContext().getRemoteUser();
            UIApplication uiApp = (UIApplication)uiActionType.getAncestorOfType(UIApplication.class);
            try {
                String templatePath = templateService.getTemplatePathByUser(true, actionType, userName);
                if (templatePath == null) {
                    Object[] arg = new Object[]{actionType};
                    uiApp.addMessage(new ApplicationMessage("UIActionForm.msg.access-denied", arg, 1));
                    event.getRequestContext().addUIComponentToUpdateByAjax((UIComponent)uiApp.getUIPopupMessages());
                    uiActionType.getUIFormSelectBox(UIActionTypeForm.ACTION_TYPE).setValue(uiActionType.defaultActionType_);
                    UIActionContainer uiActionContainer = (UIActionContainer)uiActionType.getAncestorOfType(UIActionContainer.class);
                    UIActionForm uiActionForm = (UIActionForm)uiActionContainer.getChild(UIActionForm.class);
                    uiActionForm.createNewAction(currentNode, uiActionType.defaultActionType_, true);
                    uiActionContainer.setRenderSibling(UIActionContainer.class);
                    event.getRequestContext().addUIComponentToUpdateByAjax((UIComponent)uiActionContainer);
                    return;
                }
            }
            catch (PathNotFoundException path) {
                Object[] arg = new Object[]{actionType};
                uiApp.addMessage(new ApplicationMessage("UIActionForm.msg.not-support", arg, 1));
                event.getRequestContext().addUIComponentToUpdateByAjax((UIComponent)uiApp.getUIPopupMessages());
                uiActionType.getUIFormSelectBox(UIActionTypeForm.ACTION_TYPE).setValue(uiActionType.defaultActionType_);
                UIActionContainer uiActionContainer = (UIActionContainer)uiActionType.getAncestorOfType(UIActionContainer.class);
                UIActionForm uiActionForm = (UIActionForm)uiActionContainer.getChild(UIActionForm.class);
                uiActionForm.createNewAction(currentNode, uiActionType.defaultActionType_, true);
                uiActionContainer.setRenderSibling(UIActionContainer.class);
                event.getRequestContext().addUIComponentToUpdateByAjax((UIComponent)uiActionContainer);
            }
            UIActionContainer uiActionContainer = (UIActionContainer)uiActionType.getParent();
            UIActionForm uiActionForm = (UIActionForm)uiActionContainer.getChild(UIActionForm.class);
            uiActionForm.createNewAction(currentNode, actionType, true);
            uiActionContainer.setRenderSibling(UIActionContainer.class);
            event.getRequestContext().addUIComponentToUpdateByAjax((UIComponent)uiActionContainer);
        }
    }
}

