/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pdfbox.util.operator.pagedrawer;

import java.awt.geom.AffineTransform;
import java.awt.image.BufferedImage;
import java.io.IOException;
import java.util.List;
import java.util.Map;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.pdfbox.cos.COSBase;
import org.apache.pdfbox.cos.COSName;
import org.apache.pdfbox.cos.COSStream;
import org.apache.pdfbox.pdfviewer.PageDrawer;
import org.apache.pdfbox.pdmodel.PDPage;
import org.apache.pdfbox.pdmodel.PDResources;
import org.apache.pdfbox.pdmodel.graphics.xobject.PDXObject;
import org.apache.pdfbox.pdmodel.graphics.xobject.PDXObjectForm;
import org.apache.pdfbox.pdmodel.graphics.xobject.PDXObjectImage;
import org.apache.pdfbox.util.Matrix;
import org.apache.pdfbox.util.PDFOperator;
import org.apache.pdfbox.util.operator.OperatorProcessor;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Invoke
extends OperatorProcessor {
    private static final Log log = LogFactory.getLog(Invoke.class);

    @Override
    public void process(PDFOperator operator, List<COSBase> arguments) throws IOException {
        PageDrawer drawer = (PageDrawer)this.context;
        PDPage page = drawer.getPage();
        COSName objectName = (COSName)arguments.get(0);
        Map xobjects = drawer.getResources().getXObjects();
        PDXObject xobject = (PDXObject)xobjects.get(objectName.getName());
        if (xobject instanceof PDXObjectImage) {
            PDXObjectImage image = (PDXObjectImage)xobject;
            try {
                image.setGraphicsState(drawer.getGraphicsState());
                BufferedImage awtImage = image.getRGBImage();
                if (awtImage == null) {
                    log.warn((Object)"getRGBImage returned NULL");
                    return;
                }
                int imageWidth = awtImage.getWidth();
                int imageHeight = awtImage.getHeight();
                double pageHeight = drawer.getPageSize().getHeight();
                log.debug((Object)("imageWidth: " + imageWidth + "\t\timageHeight: " + imageHeight));
                Matrix ctm = drawer.getGraphicsState().getCurrentTransformationMatrix();
                int pageRotation = page.findRotation();
                AffineTransform ctmAT = ctm.createAffineTransform();
                ctmAT.scale(1.0f / (float)imageWidth, 1.0f / (float)imageHeight);
                Matrix rotationMatrix = new Matrix();
                rotationMatrix.setFromAffineTransform(ctmAT);
                double angle = Math.atan(ctmAT.getShearX() / ctmAT.getScaleX());
                Matrix translationMatrix = null;
                if (pageRotation == 0 || pageRotation == 180) {
                    translationMatrix = Matrix.getTranslatingInstance((float)(Math.sin(angle) * (double)ctm.getXScale()), (float)(pageHeight - (double)(2.0f * ctm.getYPosition()) - Math.cos(angle) * (double)ctm.getYScale()));
                } else if (pageRotation == 90 || pageRotation == 270) {
                    translationMatrix = Matrix.getTranslatingInstance((float)(Math.sin(angle) * (double)ctm.getYScale()), (float)(pageHeight - (double)(2.0f * ctm.getYPosition())));
                }
                rotationMatrix = rotationMatrix.multiply(translationMatrix);
                rotationMatrix.setValue(0, 1, -1.0f * rotationMatrix.getValue(0, 1));
                rotationMatrix.setValue(1, 0, -1.0f * rotationMatrix.getValue(1, 0));
                AffineTransform at = new AffineTransform(rotationMatrix.getValue(0, 0), rotationMatrix.getValue(0, 1), rotationMatrix.getValue(1, 0), rotationMatrix.getValue(1, 1), rotationMatrix.getValue(2, 0), rotationMatrix.getValue(2, 1));
                drawer.drawImage(awtImage, at);
            }
            catch (Exception e) {
                e.printStackTrace();
                log.error((Object)e, (Throwable)e);
            }
        } else if (xobject instanceof PDXObjectForm) {
            Matrix matrix;
            PDXObjectForm form = (PDXObjectForm)xobject;
            COSStream invoke = (COSStream)form.getCOSObject();
            PDResources pdResources = form.getResources();
            if (pdResources == null) {
                pdResources = page.findResources();
            }
            if ((matrix = form.getMatrix()) != null) {
                Matrix xobjectCTM = matrix.multiply(this.context.getGraphicsState().getCurrentTransformationMatrix());
                this.context.getGraphicsState().setCurrentTransformationMatrix(xobjectCTM);
            }
            this.getContext().processSubStream(page, pdResources, invoke);
        }
    }
}

