/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.webui.form.input;

import java.io.Writer;
import org.exoplatform.commons.serialization.api.annotations.Serialized;
import org.exoplatform.webui.application.WebuiRequestContext;
import org.exoplatform.webui.form.UIForm;
import org.exoplatform.webui.form.UIFormInput;
import org.exoplatform.webui.form.UIFormInputBase;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@Serialized
public class UIFormCheckBoxInput
extends UIFormInputBase<Boolean> {
    private String onchange_;
    private String componentEvent_ = null;

    public UIFormCheckBoxInput() {
        this(null, null, false);
    }

    public UIFormCheckBoxInput(String name, String bindingExpression, Boolean value) {
        super(name, bindingExpression, Boolean.class);
        this.setValue(value);
    }

    @Override
    public UIFormInput setValue(Boolean value) {
        if (value == null) {
            value = false;
        }
        return super.setValue(value);
    }

    public boolean isChecked() {
        return (Boolean)this.getValue();
    }

    public UIFormCheckBoxInput setChecked(boolean check) {
        return (UIFormCheckBoxInput)this.setValue(check);
    }

    public void setOnChange(String onchange) {
        this.onchange_ = onchange;
    }

    public void setComponentEvent(String com) {
        this.componentEvent_ = com;
    }

    public void setOnChange(String event, String com) {
        this.onchange_ = event;
        this.componentEvent_ = com;
    }

    public String renderOnChangeEvent(UIForm uiForm) throws Exception {
        if (this.componentEvent_ == null) {
            return uiForm.event(this.onchange_, null);
        }
        return uiForm.event(this.onchange_, this.componentEvent_, null);
    }

    @Override
    public void decode(Object input, WebuiRequestContext context) throws Exception {
        if (!this.isEnable()) {
            return;
        }
        if (input == null || "false".equals(input.toString())) {
            this.setValue(false);
        } else {
            this.setValue(true);
        }
    }

    public void processRender(WebuiRequestContext context) throws Exception {
        Writer w = context.getWriter();
        w.write("<input type='checkbox' name='");
        w.write(this.name);
        w.write("'");
        if (this.onchange_ != null) {
            UIForm uiForm = (UIForm)this.getAncestorOfType(UIForm.class);
            w.append(" onclick=\"").append(this.renderOnChangeEvent(uiForm)).append("\"");
        }
        if (this.isChecked()) {
            w.write(" checked");
        }
        if (!this.enable_) {
            w.write(" disabled");
        }
        w.write(" class='checkbox'/>");
        if (this.isMandatory()) {
            w.write(" *");
        }
    }
}

