/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.ecm.resolver;

import java.io.ByteArrayInputStream;
import java.io.InputStream;
import java.net.URL;
import java.util.ArrayList;
import java.util.List;
import javax.jcr.Node;
import javax.jcr.Session;
import org.exoplatform.portal.webui.util.SessionProviderFactory;
import org.exoplatform.resolver.ResourceKey;
import org.exoplatform.resolver.ResourceResolver;
import org.exoplatform.services.cms.templates.TemplateService;
import org.exoplatform.services.jcr.ext.common.SessionProvider;
import org.exoplatform.services.log.ExoLogger;
import org.exoplatform.services.log.Log;
import org.exoplatform.services.wcm.utils.WCMCoreUtils;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class JCRResourceResolver
extends ResourceResolver {
    protected String repository;
    protected String workspace;
    protected String propertyName;
    private static Log LOG = ExoLogger.getLogger((String)"ecm:JCRResourceResolver");
    private TemplateService templateService;

    @Deprecated
    public JCRResourceResolver(String repository, String workspace, String propertyName) {
        this(repository, workspace);
    }

    @Deprecated
    public JCRResourceResolver(String repository, String workspace) {
        this.repository = repository;
        this.workspace = workspace;
        this.templateService = (TemplateService)WCMCoreUtils.getService(TemplateService.class);
    }

    public JCRResourceResolver(String workspace) {
        this.workspace = workspace;
        this.templateService = (TemplateService)WCMCoreUtils.getService(TemplateService.class);
    }

    public URL getResource(String url) throws Exception {
        throw new Exception("This method is not  supported");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public InputStream getInputStream(String url) throws Exception {
        SessionProvider provider = SessionProviderFactory.createSystemProvider();
        Session session = provider.getSession(this.workspace, WCMCoreUtils.getRepository());
        ByteArrayInputStream inputStream = null;
        try {
            Node template = (Node)session.getItem(this.removeScheme(url));
            inputStream = new ByteArrayInputStream(this.templateService.getTemplate(template).getBytes());
        }
        catch (Exception e) {
            LOG.error((Object)"Unexpected problem happen when try to process with url");
        }
        finally {
            session.logout();
        }
        return inputStream;
    }

    public List<URL> getResources(String url) throws Exception {
        throw new Exception("This method is not  supported");
    }

    public List<InputStream> getInputStreams(String url) throws Exception {
        ArrayList<InputStream> inputStreams = new ArrayList<InputStream>(1);
        inputStreams.add(this.getInputStream(url));
        return inputStreams;
    }

    public boolean isModified(String url, long lastAccess) {
        return false;
    }

    public String createResourceId(String url) {
        return url;
    }

    public ResourceKey createResourceKey(String url) {
        return new ResourceKey(url.hashCode(), url);
    }

    public String getResourceScheme() {
        return "jcr:";
    }
}

