/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.ecm.webui.component.admin.taxonomy;

import java.util.ArrayList;
import java.util.List;
import javax.jcr.Node;
import javax.jcr.Session;
import org.exoplatform.ecm.webui.component.admin.taxonomy.UITaxonomyTreeBrowser;
import org.exoplatform.ecm.webui.component.admin.taxonomy.UITaxonomyTreeCreateChildForm;
import org.exoplatform.ecm.webui.component.admin.taxonomy.UITaxonomyTreeWorkingArea;
import org.exoplatform.portal.webui.util.SessionProviderFactory;
import org.exoplatform.services.jcr.RepositoryService;
import org.exoplatform.services.jcr.core.ManageableRepository;
import org.exoplatform.services.wcm.core.NodeLocation;
import org.exoplatform.webui.config.annotation.ComponentConfig;
import org.exoplatform.webui.config.annotation.ComponentConfigs;
import org.exoplatform.webui.config.annotation.EventConfig;
import org.exoplatform.webui.core.UIBreadcumbs;
import org.exoplatform.webui.core.UIComponent;
import org.exoplatform.webui.core.UIContainer;
import org.exoplatform.webui.core.UIPopupContainer;
import org.exoplatform.webui.core.UIPopupWindow;
import org.exoplatform.webui.core.lifecycle.UIContainerLifecycle;
import org.exoplatform.webui.event.Event;
import org.exoplatform.webui.event.EventListener;

@ComponentConfigs(value={@ComponentConfig(lifecycle=UIContainerLifecycle.class), @ComponentConfig(type=UIBreadcumbs.class, id="BreadcumbTaxonomyTreeECMAdmin", template="system:/groovy/webui/core/UIBreadcumbs.gtmpl", events={@EventConfig(listeners={SelectPathActionListener.class})})})
public class UITaxonomyTreeCreateChild
extends UIContainer {
    private String workspace;
    public static final String PERMISSION_ID_POPUP = "TaxonomyTreeViewPermissionPopup";
    private String selectedPath_ = null;
    private NodeLocation taxonomyTreeNode = null;

    public UITaxonomyTreeCreateChild() throws Exception {
        this.addChild(UIBreadcumbs.class, "BreadcumbTaxonomyTreeECMAdmin", "BreadcumbTaxonomyTreeECMAdmin");
        UITaxonomyTreeBrowser uiTaxonomyTreeBrowser = (UITaxonomyTreeBrowser)this.addChild(UITaxonomyTreeBrowser.class, null, null);
        uiTaxonomyTreeBrowser.setAcceptedNodeTypes(new String[]{"exo:taxonomy"});
        UITaxonomyTreeWorkingArea uiTaxonomyTreeWorkingArea = (UITaxonomyTreeWorkingArea)this.addChild(UITaxonomyTreeWorkingArea.class, null, null);
        uiTaxonomyTreeWorkingArea.setAcceptedNodeTypes(new String[]{"exo:taxonomy"});
    }

    public void update() throws Exception {
        UITaxonomyTreeBrowser uiTree = (UITaxonomyTreeBrowser)this.getChild(UITaxonomyTreeBrowser.class);
        uiTree.update();
        UITaxonomyTreeWorkingArea uiTaxonomyTreeWorkingArea = (UITaxonomyTreeWorkingArea)this.getChild(UITaxonomyTreeWorkingArea.class);
        uiTaxonomyTreeWorkingArea.update();
    }

    public void update(String path) throws Exception {
        UITaxonomyTreeBrowser uiTree = (UITaxonomyTreeBrowser)this.getChild(UITaxonomyTreeBrowser.class);
        uiTree.update();
        uiTree.setNodeSelect(path);
        UITaxonomyTreeWorkingArea uiTaxonomyTreeWorkingArea = (UITaxonomyTreeWorkingArea)this.getChild(UITaxonomyTreeWorkingArea.class);
        uiTaxonomyTreeWorkingArea.setSelectedPath(path);
        uiTaxonomyTreeWorkingArea.update();
        this.setSelectedPath(path);
    }

    public Node getRootNode() throws Exception {
        return this.getTaxonomyTreeNode().getParent();
    }

    public Node getTaxonomyTreeNode() {
        return NodeLocation.getNodeByLocation((NodeLocation)this.taxonomyTreeNode);
    }

    public void setSelectedPath(String selectedPath) {
        this.selectedPath_ = selectedPath;
    }

    public String getSelectedPath() {
        return this.selectedPath_;
    }

    public Node getNodeByPath(String path) throws Exception {
        return (Node)this.getSession().getItem(path);
    }

    Session getSession() throws Exception {
        return SessionProviderFactory.createSystemProvider().getSession(this.workspace, this.getRepository());
    }

    @Deprecated
    public ManageableRepository getRepository(String repositoryName) throws Exception {
        RepositoryService repositoryService = (RepositoryService)this.getApplicationComponent(RepositoryService.class);
        return repositoryService.getCurrentRepository();
    }

    public ManageableRepository getRepository() throws Exception {
        RepositoryService repositoryService = (RepositoryService)this.getApplicationComponent(RepositoryService.class);
        return repositoryService.getCurrentRepository();
    }

    public void initPopup(String path) throws Exception {
        this.removeChildById("TaxonomyPopupCreateChild");
        UIPopupWindow uiPopup = (UIPopupWindow)this.addChild(UIPopupWindow.class, null, "TaxonomyPopupCreateChild");
        uiPopup.setWindowSize(600, 250);
        UITaxonomyTreeCreateChildForm uiTaxoForm = (UITaxonomyTreeCreateChildForm)this.createUIComponent(UITaxonomyTreeCreateChildForm.class, null, null);
        uiTaxoForm.setParent(path);
        uiPopup.setUIComponent((UIComponent)uiTaxoForm);
        uiPopup.setRendered(true);
        uiPopup.setShow(true);
    }

    public UIPopupContainer initPopupPermission(String id) throws Exception {
        this.removeChildById(id);
        return (UIPopupContainer)this.addChild(UIPopupContainer.class, null, id);
    }

    public void onChange(Node currentNode) throws Exception {
        String subTaxonomy;
        String[] arrayPath;
        String taxonomyPath;
        UIBreadcumbs uiBreadcumbs = (UIBreadcumbs)this.getChild(UIBreadcumbs.class);
        ArrayList<UIBreadcumbs.LocalPath> listLocalPath = new ArrayList<UIBreadcumbs.LocalPath>();
        String path = currentNode.getPath().trim();
        if (path.startsWith(taxonomyPath = this.getTaxonomyTreeNode().getPath()) && (arrayPath = (subTaxonomy = path.substring(taxonomyPath.length(), path.length())).split("/")).length > 0) {
            for (int i = 0; i < arrayPath.length; ++i) {
                if (arrayPath[i].trim().equals("")) continue;
                UIBreadcumbs.LocalPath localPath1 = new UIBreadcumbs.LocalPath(arrayPath[i].trim(), arrayPath[i].trim());
                listLocalPath.add(localPath1);
            }
        }
        uiBreadcumbs.setPath(listLocalPath);
    }

    public void changeGroup(String groupId, Object context) throws Exception {
        List listLocalPath;
        String stringPath = this.getTaxonomyTreeNode().getPath() + "/";
        UIBreadcumbs uiBreadcumb = (UIBreadcumbs)this.getChild(UIBreadcumbs.class);
        if (groupId == null) {
            groupId = "";
        }
        if ((listLocalPath = uiBreadcumb.getPath()) == null || listLocalPath.size() == 0) {
            return;
        }
        ArrayList<String> listLocalPathString = new ArrayList<String>();
        for (UIBreadcumbs.LocalPath localPath : listLocalPath) {
            listLocalPathString.add(localPath.getId().trim());
        }
        if (listLocalPathString.contains(groupId)) {
            int i;
            int index = listLocalPathString.indexOf(groupId);
            if (index == listLocalPathString.size() - 1) {
                return;
            }
            for (i = listLocalPathString.size() - 1; i > index; --i) {
                listLocalPathString.remove(i);
                listLocalPath.remove(i);
            }
            uiBreadcumb.setPath(listLocalPath);
            for (i = 0; i < listLocalPathString.size(); ++i) {
                String pathName = (String)listLocalPathString.get(i);
                if (pathName == null && pathName.equals("")) continue;
                stringPath = stringPath + pathName.trim();
                if (i >= listLocalPathString.size() - 1) continue;
                stringPath = stringPath + "/";
            }
            UITaxonomyTreeBrowser uiTaxonomyTree = (UITaxonomyTreeBrowser)this.getChild(UITaxonomyTreeBrowser.class);
            uiTaxonomyTree.setNodeSelect(stringPath);
        }
    }

    public String getWorkspace() {
        return this.workspace;
    }

    public void setWorkspace(String workspace) {
        this.workspace = workspace;
    }

    public void setTaxonomyTreeNode(Node taxonomyTreeNode) {
        this.taxonomyTreeNode = NodeLocation.getNodeLocationByNode((Node)taxonomyTreeNode);
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class SelectPathActionListener
    extends EventListener<UIBreadcumbs> {
        public void execute(Event<UIBreadcumbs> event) throws Exception {
            UIBreadcumbs uiBreadcumbs = (UIBreadcumbs)event.getSource();
            UITaxonomyTreeCreateChild uiTaxonomyTreeCreateChild = (UITaxonomyTreeCreateChild)uiBreadcumbs.getParent();
            String objectId = event.getRequestContext().getRequestParameter("objectId");
            uiBreadcumbs.setSelectPath(objectId);
            String selectGroupId = uiBreadcumbs.getSelectLocalPath().getId();
            uiTaxonomyTreeCreateChild.changeGroup(selectGroupId, event.getRequestContext());
            event.getRequestContext().addUIComponentToUpdateByAjax((UIComponent)uiTaxonomyTreeCreateChild);
        }
    }
}

