/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.ecm.webui.component.admin.templates;

import java.util.ArrayList;
import java.util.List;
import javax.jcr.Node;
import javax.jcr.NodeIterator;
import javax.jcr.Value;
import javax.portlet.PortletPreferences;
import org.exoplatform.commons.utils.LazyPageList;
import org.exoplatform.commons.utils.ListAccess;
import org.exoplatform.commons.utils.ListAccessImpl;
import org.exoplatform.commons.utils.PageList;
import org.exoplatform.ecm.webui.component.admin.templates.UITemplateContent;
import org.exoplatform.ecm.webui.component.admin.templates.UITemplatesManager;
import org.exoplatform.ecm.webui.component.admin.templates.UIViewTemplate;
import org.exoplatform.ecm.webui.utils.Utils;
import org.exoplatform.portal.webui.util.SessionProviderFactory;
import org.exoplatform.services.cms.templates.TemplateService;
import org.exoplatform.web.application.ApplicationMessage;
import org.exoplatform.webui.application.WebuiRequestContext;
import org.exoplatform.webui.application.portlet.PortletRequestContext;
import org.exoplatform.webui.config.annotation.ComponentConfig;
import org.exoplatform.webui.config.annotation.EventConfig;
import org.exoplatform.webui.core.UIApplication;
import org.exoplatform.webui.core.UIComponent;
import org.exoplatform.webui.core.UIContainer;
import org.exoplatform.webui.core.UIGrid;
import org.exoplatform.webui.core.lifecycle.UIContainerLifecycle;
import org.exoplatform.webui.event.Event;
import org.exoplatform.webui.event.EventListener;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@ComponentConfig(lifecycle=UIContainerLifecycle.class, events={@EventConfig(listeners={EditActionListener.class}), @EventConfig(listeners={DeleteActionListener.class}, confirm="UIDialogTab.msg.confirm-delete")})
public class UISkinTab
extends UIContainer {
    private static final String[] BEAN_FIELD = new String[]{"name", "roles", "baseVersion"};
    private static final String[] ACTIONS = new String[]{"Edit", "Delete"};
    public static final String SKIN_LIST_NAME = "SkinList";
    public static final String SKIN_FORM_NAME = "SkinForm";
    private List<String> listSkin_ = new ArrayList<String>();

    public UISkinTab() throws Exception {
        UIGrid uiGrid = (UIGrid)this.addChild(UIGrid.class, null, SKIN_LIST_NAME);
        uiGrid.getUIPageIterator().setId("SkinListIterator");
        uiGrid.configure("name", BEAN_FIELD, ACTIONS);
        UITemplateContent uiForm = (UITemplateContent)this.addChild(UITemplateContent.class, null, SKIN_FORM_NAME);
        uiForm.setTemplateType(TemplateService.SKINS);
        uiForm.update(null);
    }

    public void setTabRendered() {
        UIViewTemplate uiViewTemplate = (UIViewTemplate)this.getAncestorOfType(UIViewTemplate.class);
        uiViewTemplate.setRenderedChild(UISkinTab.class);
    }

    public List<String> getListSkin() {
        return this.listSkin_;
    }

    public void updateGrid(String nodeName, String repository) throws Exception {
        TemplateService tempService = (TemplateService)this.getApplicationComponent(TemplateService.class);
        Node templateHome = tempService.getTemplatesHome(SessionProviderFactory.createSystemProvider()).getNode(nodeName);
        if (!templateHome.hasNode(TemplateService.SKINS)) {
            return;
        }
        NodeIterator iter = templateHome.getNode(TemplateService.SKINS).getNodes();
        ArrayList<SkinData> data = new ArrayList<SkinData>();
        Node node = null;
        while (iter.hasNext()) {
            node = (Node)iter.next();
            String version = "";
            StringBuilder rule = new StringBuilder();
            Value[] rules = node.getNode("jcr:content").getProperty("exo:roles").getValues();
            for (int i = 0; i < rules.length; ++i) {
                rule.append("[" + rules[i].getString() + "]");
            }
            if (node.isNodeType("mix:versionable") && !node.isNodeType(Utils.NT_FROZEN)) {
                version = node.getBaseVersion().getName();
            }
            this.listSkin_.add(node.getName());
            SkinData item = new SkinData(node.getName(), rule.toString(), version);
            data.add(item);
        }
        UIGrid uiGrid = (UIGrid)this.getChild(UIGrid.class);
        ListAccessImpl skinDataList = new ListAccessImpl(SkinData.class, data);
        LazyPageList dataPageList = new LazyPageList((ListAccess)skinDataList, 4);
        uiGrid.getUIPageIterator().setPageList((PageList)dataPageList);
    }

    public static class SkinData {
        private String name;
        private String roles;
        private String baseVersion;

        public SkinData(String name, String roles, String version) {
            this.name = name;
            this.roles = roles;
            this.baseVersion = version;
        }

        public String getName() {
            return this.name;
        }

        public String getRoles() {
            return this.roles;
        }

        public String getBaseVersion() {
            return this.baseVersion;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class DeleteActionListener
    extends EventListener<UISkinTab> {
        public void execute(Event<UISkinTab> event) throws Exception {
            UISkinTab skinTab = (UISkinTab)((Object)event.getSource());
            UIViewTemplate uiViewTemplate = (UIViewTemplate)((UISkinTab)((Object)event.getSource())).getAncestorOfType(UIViewTemplate.class);
            String nodeTypeName = uiViewTemplate.getNodeTypeName();
            String templateName = event.getRequestContext().getRequestParameter("objectId");
            TemplateService templateService = (TemplateService)skinTab.getApplicationComponent(TemplateService.class);
            UITemplateContent uiForm = (UITemplateContent)skinTab.findFirstComponentOfType(UITemplateContent.class);
            for (String template : TemplateService.UNDELETABLE_TEMPLATES) {
                if (!template.equals(templateName)) continue;
                UIApplication app = (UIApplication)skinTab.getAncestorOfType(UIApplication.class);
                Object[] args = new Object[]{template};
                app.addMessage(new ApplicationMessage("UIDialogTab.msg.undeletable", args));
                skinTab.setTabRendered();
                return;
            }
            PortletRequestContext pcontext = (PortletRequestContext)WebuiRequestContext.getCurrentInstance();
            PortletPreferences portletPref = pcontext.getRequest().getPreferences();
            String repository = portletPref.getValue(Utils.REPOSITORY, "");
            templateService.removeTemplate(TemplateService.SKINS, nodeTypeName, templateName);
            uiForm.update(null);
            uiForm.reset();
            skinTab.updateGrid(nodeTypeName, repository);
            skinTab.setTabRendered();
            UITemplatesManager uiManager = (UITemplatesManager)skinTab.getAncestorOfType(UITemplatesManager.class);
            event.getRequestContext().addUIComponentToUpdateByAjax((UIComponent)uiManager);
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class EditActionListener
    extends EventListener<UISkinTab> {
        public void execute(Event<UISkinTab> event) throws Exception {
            UISkinTab skinTab = (UISkinTab)((Object)event.getSource());
            String skinName = event.getRequestContext().getRequestParameter("objectId");
            UITemplateContent uiForm = (UITemplateContent)skinTab.getChild(UITemplateContent.class);
            uiForm.update(skinName);
            skinTab.setTabRendered();
            UITemplatesManager uiManager = (UITemplatesManager)skinTab.getAncestorOfType(UITemplatesManager.class);
            event.getRequestContext().addUIComponentToUpdateByAjax((UIComponent)uiManager);
        }
    }
}

