/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.services.cms.documents.impl;

import java.util.ArrayList;
import java.util.List;
import javax.jcr.Node;
import javax.jcr.NodeIterator;
import javax.jcr.Property;
import javax.jcr.RepositoryException;
import javax.jcr.Session;
import javax.jcr.Value;
import javax.jcr.ValueFactory;
import javax.jcr.ValueFormatException;
import javax.jcr.query.Query;
import javax.jcr.query.QueryManager;
import javax.jcr.query.QueryResult;
import org.exoplatform.services.cms.documents.FavouriteService;
import org.exoplatform.services.jcr.RepositoryService;
import org.exoplatform.services.jcr.core.ManageableRepository;
import org.exoplatform.services.jcr.ext.common.SessionProvider;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@Deprecated
public class FavouriteServiceImpl
implements FavouriteService {
    public static final String EXO_RESTORELOCATION = "exo:restoreLocation";
    private RepositoryService repositoryService;

    public FavouriteServiceImpl(RepositoryService repositoryService) {
        this.repositoryService = repositoryService;
    }

    @Override
    public boolean isFavouriter(String userName, Node node) {
        if (userName == null) {
            return false;
        }
        try {
            if (node.isNodeType("exo:favourite")) {
                Value[] favouriters;
                for (Value favouriter : favouriters = node.getProperty("exo:favouriter").getValues()) {
                    if (!userName.equals(favouriter.getString())) continue;
                    return true;
                }
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return false;
    }

    @Override
    public void addFavourite(Node node, String userName) throws Exception {
        node.getSession().save();
        if (!node.isNodeType("exo:favourite")) {
            node.addMixin("exo:favourite");
            node.setProperty("exo:favouriter", new String[]{userName});
            node.getSession().save();
        } else {
            Property favouriteProperty = node.getProperty("exo:favouriter");
            if (!this.foundValue(favouriteProperty, userName)) {
                Value[] values = favouriteProperty.getValues();
                Value[] newValues = new Value[values.length + 1];
                System.arraycopy(values, 0, newValues, 0, values.length);
                ValueFactory valueFactory = node.getSession().getValueFactory();
                newValues[values.length] = valueFactory.createValue(userName);
                node.setProperty("exo:favouriter", newValues);
                node.getSession().save();
            }
        }
    }

    @Override
    public void removeFavourite(Node node, String userName) throws Exception {
        Property favouriteProperty;
        node.getSession().save();
        if (node.isNodeType("exo:favourite") && this.foundValue(favouriteProperty = node.getProperty("exo:favouriter"), userName)) {
            Value[] values = favouriteProperty.getValues();
            if (values.length > 1) {
                Value[] newValues = new Value[values.length - 1];
                int count = 0;
                for (Value value : values) {
                    if (userName.equals(value.getString())) continue;
                    newValues[count++] = value;
                }
                node.setProperty("exo:favouriter", newValues);
            } else {
                node.removeMixin("exo:favourite");
            }
            node.getSession().save();
        }
    }

    @Override
    @Deprecated
    public List<Node> getAllFavouriteNodes(String workspace, String repository, SessionProvider sessionProvider) throws Exception {
        StringBuilder query = new StringBuilder("SELECT * FROM ").append("exo:favourite").append(" WHERE ").append("exo:favouriter").append(" IS NOT NULL");
        return this.selectNodesByQueryString(workspace, sessionProvider, query.toString(), "sql");
    }

    @Override
    public List<Node> getAllFavouriteNodes(String workspace, SessionProvider sessionProvider) throws Exception {
        StringBuilder query = new StringBuilder("SELECT * FROM ").append("exo:favourite").append(" WHERE ").append("exo:favouriter").append(" IS NOT NULL");
        return this.selectNodesByQueryString(workspace, sessionProvider, query.toString(), "sql");
    }

    @Override
    @Deprecated
    public List<Node> getAllFavouriteNodesByUser(String workspace, String repository, SessionProvider sessionProvider, String userName) throws Exception {
        StringBuilder query = new StringBuilder("SELECT * FROM ").append("exo:favourite").append(" WHERE ").append("exo:favouriter").append(" IS NOT NULL AND ").append(" CONTAINS (").append("exo:favouriter").append(", '").append(userName).append("')");
        return this.selectNodesByQueryString(workspace, sessionProvider, query.toString(), "sql");
    }

    @Override
    public List<Node> getAllFavouriteNodesByUser(String workspace, SessionProvider sessionProvider, String userName) throws Exception {
        StringBuilder query = new StringBuilder("SELECT * FROM ").append("exo:favourite").append(" WHERE ").append("exo:favouriter").append(" IS NOT NULL AND ").append(" CONTAINS (").append("exo:favouriter").append(", '").append(userName).append("')");
        return this.selectNodesByQueryString(workspace, sessionProvider, query.toString(), "sql");
    }

    private boolean foundValue(Property property, String value) throws RepositoryException {
        if (property == null) {
            return false;
        }
        try {
            Value[] values;
            for (Value v : values = property.getValues()) {
                if (!value.equals(v.getString())) continue;
                return true;
            }
            return false;
        }
        catch (ValueFormatException ex) {
            try {
                Value v = property.getValue();
                return value.equals(v.getString());
            }
            catch (ValueFormatException ex2) {
                return false;
            }
        }
    }

    private List<Node> selectNodesByQueryString(String workspace, SessionProvider sessionProvider, String queryString, String language) throws Exception {
        ArrayList<Node> ret = new ArrayList<Node>();
        ManageableRepository manageableRepository = this.repositoryService.getCurrentRepository();
        Session session = sessionProvider.getSession(workspace, manageableRepository);
        QueryManager queryManager = session.getWorkspace().getQueryManager();
        Query query = queryManager.createQuery(queryString, language);
        QueryResult queryResult = query.execute();
        NodeIterator nodeIter = queryResult.getNodes();
        while (nodeIter.hasNext()) {
            ret.add(nodeIter.nextNode());
        }
        return ret;
    }
}

