/*
 * Decompiled with CFR 0.152.
 */
package org.gatein.mop.core.api.workspace;

import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.ListIterator;
import java.util.Map;
import org.chromattic.api.annotations.Create;
import org.chromattic.api.annotations.OneToMany;
import org.chromattic.api.annotations.PrimaryType;
import org.gatein.mop.api.workspace.ObjectType;
import org.gatein.mop.api.workspace.ui.UIComponent;
import org.gatein.mop.api.workspace.ui.UIContainer;
import org.gatein.mop.core.api.workspace.UIBodyImpl;
import org.gatein.mop.core.api.workspace.UIComponentImpl;
import org.gatein.mop.core.api.workspace.UIWindowImpl;

@PrimaryType(name="mop:uicontainer")
public abstract class UIContainerImpl
extends UIComponentImpl
implements UIContainer {
    private final List<UIComponentImpl> components = new List<UIComponentImpl>(){

        @Override
        public int size() {
            return UIContainerImpl.this.getComponentList().size();
        }

        @Override
        public boolean isEmpty() {
            return UIContainerImpl.this.getComponentList().isEmpty();
        }

        @Override
        public boolean contains(Object o) {
            return UIContainerImpl.this.getComponentList().contains(o);
        }

        @Override
        public Iterator<UIComponentImpl> iterator() {
            return UIContainerImpl.this.getComponentList().iterator();
        }

        @Override
        public Object[] toArray() {
            return new Object[0];
        }

        @Override
        public <T> T[] toArray(T[] a) {
            return UIContainerImpl.this.getComponentList().toArray(a);
        }

        @Override
        public boolean add(UIComponentImpl uiComponent) {
            return UIContainerImpl.this.getComponentList().add(uiComponent);
        }

        @Override
        public boolean remove(Object o) {
            return UIContainerImpl.this.getComponentList().remove(o);
        }

        @Override
        public boolean containsAll(Collection<?> c) {
            return UIContainerImpl.this.getComponentList().containsAll(c);
        }

        @Override
        public boolean addAll(Collection<? extends UIComponentImpl> c) {
            return UIContainerImpl.this.getComponentList().addAll(c);
        }

        @Override
        public boolean addAll(int index, Collection<? extends UIComponentImpl> c) {
            return UIContainerImpl.this.getComponentList().addAll(index, c);
        }

        @Override
        public boolean removeAll(Collection<?> c) {
            return UIContainerImpl.this.getComponentList().removeAll(c);
        }

        @Override
        public boolean retainAll(Collection<?> c) {
            return UIContainerImpl.this.getComponentList().retainAll(c);
        }

        @Override
        public void clear() {
            UIContainerImpl.this.getComponentList().clear();
        }

        @Override
        public UIComponentImpl get(int index) {
            return UIContainerImpl.this.getComponentList().get(index);
        }

        @Override
        public UIComponentImpl set(int index, UIComponentImpl element) {
            return UIContainerImpl.this.getComponentList().set(index, element);
        }

        @Override
        public void add(int index, UIComponentImpl element) {
            UIContainerImpl.this.getComponentList().add(index, element);
        }

        @Override
        public UIComponentImpl remove(int index) {
            return UIContainerImpl.this.getComponentList().remove(index);
        }

        @Override
        public int indexOf(Object o) {
            return UIContainerImpl.this.getComponentList().indexOf(o);
        }

        @Override
        public int lastIndexOf(Object o) {
            return UIContainerImpl.this.getComponentList().lastIndexOf(o);
        }

        @Override
        public ListIterator<UIComponentImpl> listIterator() {
            return UIContainerImpl.this.getComponentList().listIterator();
        }

        @Override
        public ListIterator<UIComponentImpl> listIterator(int index) {
            return UIContainerImpl.this.getComponentList().listIterator(index);
        }

        @Override
        public List<UIComponentImpl> subList(int fromIndex, int toIndex) {
            return UIContainerImpl.this.getComponentList().subList(fromIndex, toIndex);
        }
    };

    @Create
    public abstract UIContainerImpl createContainer();

    @Create
    public abstract UIBodyImpl createInsertion();

    @Create
    public abstract UIWindowImpl createWindow();

    @OneToMany
    public abstract Map<String, UIComponentImpl> getComponentMap();

    @OneToMany
    public abstract List<UIComponentImpl> getComponentList();

    public ObjectType<? extends UIContainer> getObjectType() {
        return ObjectType.CONTAINER;
    }

    public UIComponent get(String componentName) {
        Map<String, UIComponentImpl> children = this.getComponentMap();
        return children.get(componentName);
    }

    public <T extends UIComponent> T add(ObjectType<T> componentType, String name) {
        UIComponentImpl child;
        if (componentType == ObjectType.WINDOW) {
            child = this.createWindow();
        } else if (componentType == ObjectType.CONTAINER) {
            child = this.createContainer();
        } else if (componentType == ObjectType.BODY) {
            child = this.createInsertion();
        } else {
            throw new UnsupportedOperationException();
        }
        Map<String, UIComponentImpl> children = this.getComponentMap();
        children.put(name, child);
        return (T)((UIComponent)componentType.cast((Object)child));
    }

    public <T extends UIComponent> T add(int index, ObjectType<T> componentType, String name) {
        UIComponentImpl child;
        if (componentType == ObjectType.WINDOW) {
            child = this.createWindow();
        } else if (componentType == ObjectType.CONTAINER) {
            child = this.createContainer();
        } else if (componentType == ObjectType.BODY) {
            child = this.createInsertion();
        } else {
            throw new UnsupportedOperationException();
        }
        child.setNodeName(name);
        List<UIComponentImpl> children = this.getComponentList();
        children.add(index, child);
        return (T)((UIComponent)componentType.cast((Object)child));
    }

    public List<UIComponent> getComponents() {
        return this.components;
    }
}

