/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.services.jcr.ext.script.groovy;

import groovy.lang.GroovyClassLoader;
import groovy.lang.GroovyCodeSource;
import groovy.lang.GroovyResourceLoader;
import java.io.IOException;
import java.io.InputStream;
import java.net.MalformedURLException;
import java.net.URL;
import java.security.PrivilegedAction;
import java.security.PrivilegedActionException;
import java.security.PrivilegedExceptionAction;
import java.util.HashSet;
import java.util.List;
import org.exoplatform.commons.utils.SecurityHelper;
import org.exoplatform.services.jcr.ext.resource.UnifiedNodeReference;
import org.exoplatform.services.jcr.ext.script.groovy.GroovyScriptAddRepoPlugin;
import org.exoplatform.services.jcr.ext.script.groovy.JcrGroovyClassLoaderProvider;
import org.exoplatform.services.jcr.ext.script.groovy.JcrGroovyResourceLoader;
import org.exoplatform.services.log.ExoLogger;
import org.exoplatform.services.log.Log;
import org.exoplatform.services.rest.ext.groovy.SourceFile;
import org.exoplatform.services.rest.ext.groovy.SourceFolder;
import org.picocontainer.Startable;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class JcrGroovyCompiler
implements Startable {
    private static final Log LOG = ExoLogger.getLogger(JcrGroovyCompiler.class);
    protected final JcrGroovyClassLoaderProvider classLoaderProvider;
    protected List<GroovyScriptAddRepoPlugin> addRepoPlugins;

    public JcrGroovyCompiler(JcrGroovyClassLoaderProvider classLoaderProvider) {
        this.classLoaderProvider = classLoaderProvider;
    }

    public JcrGroovyCompiler() {
        this(new JcrGroovyClassLoaderProvider());
    }

    public Class<?>[] compile(UnifiedNodeReference ... sourceReferences) throws IOException {
        return this.compile((SourceFolder[])null, sourceReferences);
    }

    public Class<?>[] compile(SourceFolder[] src, UnifiedNodeReference ... sourceReferences) throws IOException {
        SourceFile[] files = new SourceFile[sourceReferences.length];
        for (int i = 0; i < sourceReferences.length; ++i) {
            files[i] = new SourceFile(sourceReferences[i].getURL());
        }
        return this.doCompile((JcrGroovyClassLoaderProvider.JcrGroovyClassLoader)this.classLoaderProvider.getGroovyClassLoader(src), files);
    }

    public Class<?>[] compile(SourceFolder[] src, SourceFile[] files) throws IOException {
        return this.doCompile((JcrGroovyClassLoaderProvider.JcrGroovyClassLoader)this.classLoaderProvider.getGroovyClassLoader(src), files);
    }

    public Class<?>[] compile(SourceFile[] files) throws IOException {
        return this.doCompile((JcrGroovyClassLoaderProvider.JcrGroovyClassLoader)this.classLoaderProvider.getGroovyClassLoader(), files);
    }

    private Class<?>[] doCompile(final JcrGroovyClassLoaderProvider.JcrGroovyClassLoader cl, final SourceFile[] files) throws IOException {
        Class[] classes = SecurityHelper.doPrivilegedAction(new PrivilegedAction<Class[]>(){

            @Override
            public Class[] run() {
                return cl.parseClasses(files);
            }
        });
        return classes;
    }

    public URL[] getDependencies(final SourceFolder[] sources, final SourceFile[] files) throws IOException {
        try {
            return SecurityHelper.doPrivilegedExceptionAction(new PrivilegedExceptionAction<URL[]>(){

                @Override
                public URL[] run() throws IOException {
                    return ((JcrGroovyClassLoaderProvider.JcrGroovyClassLoader)JcrGroovyCompiler.this.classLoaderProvider.getGroovyClassLoader()).findDependencies(sources, files);
                }
            });
        }
        catch (PrivilegedActionException e) {
            Throwable cause = e.getCause();
            throw (IOException)cause;
        }
    }

    @Deprecated
    public GroovyClassLoader getGroovyClassLoader() {
        return this.classLoaderProvider.getGroovyClassLoader();
    }

    @Deprecated
    public void setGroovyClassLoader(GroovyClassLoader gcl) {
        LOG.warn("Method setGroovyClassLoader is deprecated.");
    }

    @Deprecated
    protected GroovyCodeSource createCodeSource(final InputStream in, final String name) {
        GroovyCodeSource gcs = SecurityHelper.doPrivilegedAction(new PrivilegedAction<GroovyCodeSource>(){

            @Override
            public GroovyCodeSource run() {
                return new GroovyCodeSource(in, name, "/groovy/script");
            }
        });
        gcs.setCachable(false);
        return gcs;
    }

    public void start() {
        if (this.addRepoPlugins != null && this.addRepoPlugins.size() > 0) {
            try {
                HashSet<URL> repos = new HashSet<URL>();
                for (GroovyScriptAddRepoPlugin pl : this.addRepoPlugins) {
                    repos.addAll(pl.getRepositories());
                }
                this.classLoaderProvider.getGroovyClassLoader().setResourceLoader((GroovyResourceLoader)new JcrGroovyResourceLoader(repos.toArray(new URL[repos.size()])));
            }
            catch (MalformedURLException e) {
                LOG.error("Unable add groovy script repository. ", e);
            }
        }
    }

    public void stop() {
    }
}

