/*
 * Decompiled with CFR 0.152.
 */
package org.gatein.common.concurrent;

import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.NoSuchElementException;
import org.gatein.common.concurrent.ObjectRef;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class BoundedBuffer<T>
implements Iterable<T> {
    private final int maxSize;
    private ObjectRef<T> last;
    private ObjectRef<T> first;
    private volatile int size;

    public BoundedBuffer(int maxSize) {
        if (maxSize < 1) {
            throw new IllegalArgumentException("Buffer size needs to be greater than zero");
        }
        this.maxSize = maxSize;
        this.size = 0;
    }

    public int getMaxSize() {
        return this.maxSize;
    }

    public int getSize() {
        return this.size;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void add(T t) {
        BoundedBuffer boundedBuffer = this;
        synchronized (boundedBuffer) {
            if (this.first == null) {
                this.first = new ObjectRef<T>(t);
                this.last = this.first;
                this.size = 1;
            } else {
                ObjectRef<T> tmp = this.first;
                this.first = new ObjectRef<T>(t);
                tmp.next.set(this.first);
                if (this.size < this.maxSize) {
                    ++this.size;
                } else {
                    this.last = this.last.next.get();
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Iterator<T> iterator() {
        int sizeSnapshot;
        ObjectRef<T> lastSnapshot;
        if (this.size == 0) {
            List empty = Collections.emptyList();
            return empty.iterator();
        }
        BoundedBuffer boundedBuffer = this;
        synchronized (boundedBuffer) {
            lastSnapshot = this.last;
            sizeSnapshot = this.size;
        }
        return new BoundedIterator(lastSnapshot, sizeSnapshot);
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static final class BoundedIterator<T>
    implements Iterator<T> {
        final int size;
        ObjectRef<T> current;
        int count = 0;

        private BoundedIterator(ObjectRef<T> current, int size) {
            this.current = current;
            this.size = size;
            this.count = 0;
        }

        @Override
        public boolean hasNext() {
            return this.count < this.size && this.current != null;
        }

        @Override
        public T next() {
            if (!this.hasNext()) {
                throw new NoSuchElementException();
            }
            Object next = this.current.object;
            this.current = this.current.next.get();
            ++this.count;
            return next;
        }

        @Override
        public void remove() {
            throw new UnsupportedOperationException();
        }
    }
}

