/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.ecm.webui.component.admin.namespace;

import javax.jcr.NamespaceRegistry;
import org.exoplatform.ecm.webui.component.admin.namespace.UINamespaceManager;
import org.exoplatform.ecm.webui.form.validator.ECMNameValidator;
import org.exoplatform.services.jcr.RepositoryService;
import org.exoplatform.web.application.ApplicationMessage;
import org.exoplatform.webui.config.annotation.ComponentConfig;
import org.exoplatform.webui.config.annotation.EventConfig;
import org.exoplatform.webui.core.UIApplication;
import org.exoplatform.webui.core.UIComponent;
import org.exoplatform.webui.core.UIPopupWindow;
import org.exoplatform.webui.core.lifecycle.UIFormLifecycle;
import org.exoplatform.webui.event.Event;
import org.exoplatform.webui.event.EventListener;
import org.exoplatform.webui.form.UIForm;
import org.exoplatform.webui.form.UIFormInput;
import org.exoplatform.webui.form.UIFormStringInput;
import org.exoplatform.webui.form.validator.MandatoryValidator;

@ComponentConfig(lifecycle=UIFormLifecycle.class, template="system:/groovy/webui/form/UIForm.gtmpl", events={@EventConfig(listeners={SaveActionListener.class}), @EventConfig(phase=Event.Phase.DECODE, listeners={CancelActionListener.class})})
public class UINamespaceForm
extends UIForm {
    public static final String FIELD_PREFIX = "namespace";
    public static final String FIELD_URI = "uri";

    public UINamespaceForm() throws Exception {
        this.addUIFormInput((UIFormInput)new UIFormStringInput(FIELD_PREFIX, FIELD_PREFIX, null).addValidator(MandatoryValidator.class, new Object[0]).addValidator(ECMNameValidator.class, new Object[0]));
        this.addUIFormInput((UIFormInput)new UIFormStringInput(FIELD_URI, FIELD_URI, null).addValidator(MandatoryValidator.class, new Object[0]));
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class CancelActionListener
    extends EventListener<UINamespaceForm> {
        public void execute(Event<UINamespaceForm> event) throws Exception {
            UINamespaceForm uiForm = (UINamespaceForm)((Object)event.getSource());
            UINamespaceManager uiManager = (UINamespaceManager)uiForm.getAncestorOfType(UINamespaceManager.class);
            uiManager.removeChild(UIPopupWindow.class);
            event.getRequestContext().addUIComponentToUpdateByAjax((UIComponent)uiManager);
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class SaveActionListener
    extends EventListener<UINamespaceForm> {
        public void execute(Event<UINamespaceForm> event) throws Exception {
            UINamespaceForm uiForm = (UINamespaceForm)((Object)event.getSource());
            String uri = (String)uiForm.getUIStringInput(UINamespaceForm.FIELD_URI).getValue();
            UIApplication uiApp = (UIApplication)uiForm.getAncestorOfType(UIApplication.class);
            NamespaceRegistry namespaceRegistry = ((RepositoryService)uiForm.getApplicationComponent(RepositoryService.class)).getCurrentRepository().getNamespaceRegistry();
            String prefix = (String)uiForm.getUIStringInput(UINamespaceForm.FIELD_PREFIX).getValue();
            if (prefix == null || prefix.trim().length() == 0) {
                uiApp.addMessage(new ApplicationMessage("UINamespaceForm.msg.prefix-null", null, 1));
                event.getRequestContext().addUIComponentToUpdateByAjax((UIComponent)uiApp.getUIPopupMessages());
                return;
            }
            if (uri == null || uri.trim().length() == 0) {
                uiApp.addMessage(new ApplicationMessage("UINamespaceForm.msg.uri-null", null, 1));
                event.getRequestContext().addUIComponentToUpdateByAjax((UIComponent)uiApp.getUIPopupMessages());
                return;
            }
            UINamespaceManager uiManager = (UINamespaceManager)uiForm.getAncestorOfType(UINamespaceManager.class);
            if (this.contains(namespaceRegistry.getPrefixes(), prefix) || this.contains(namespaceRegistry.getURIs(), uri)) {
                uiApp.addMessage(new ApplicationMessage("UINamespaceForm.msg.register-unsuccessfull", null, 1));
                event.getRequestContext().addUIComponentToUpdateByAjax((UIComponent)uiApp.getUIPopupMessages());
                return;
            }
            try {
                namespaceRegistry.registerNamespace(prefix, uri);
                uiManager.refresh();
                uiManager.removeChild(UIPopupWindow.class);
            }
            catch (Exception e) {
                uiApp.addMessage(new ApplicationMessage("UINamespaceForm.msg.register-unsuccessfull", null, 1));
                event.getRequestContext().addUIComponentToUpdateByAjax((UIComponent)uiApp.getUIPopupMessages());
                return;
            }
            event.getRequestContext().addUIComponentToUpdateByAjax((UIComponent)uiManager);
        }

        private boolean contains(String[] arr, String st) {
            if (st == null) {
                return false;
            }
            for (String value : arr) {
                if (!st.equals(value)) continue;
                return true;
            }
            return false;
        }
    }
}

