/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.ecm.webui.component.admin.taxonomy.tree.info;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import javax.jcr.AccessDeniedException;
import javax.jcr.Node;
import org.exoplatform.commons.utils.LazyPageList;
import org.exoplatform.commons.utils.ListAccess;
import org.exoplatform.commons.utils.ListAccessImpl;
import org.exoplatform.commons.utils.PageList;
import org.exoplatform.ecm.permission.PermissionBean;
import org.exoplatform.ecm.webui.component.admin.taxonomy.tree.info.UIPermissionTreeForm;
import org.exoplatform.ecm.webui.component.admin.taxonomy.tree.info.UIPermissionTreeManager;
import org.exoplatform.ecm.webui.utils.PermissionUtil;
import org.exoplatform.ecm.webui.utils.Utils;
import org.exoplatform.services.jcr.access.AccessControlEntry;
import org.exoplatform.services.jcr.access.PermissionType;
import org.exoplatform.services.jcr.core.ExtendedNode;
import org.exoplatform.services.security.IdentityConstants;
import org.exoplatform.services.wcm.core.NodeLocation;
import org.exoplatform.web.application.ApplicationMessage;
import org.exoplatform.webui.config.annotation.ComponentConfig;
import org.exoplatform.webui.config.annotation.EventConfig;
import org.exoplatform.webui.core.UIApplication;
import org.exoplatform.webui.core.UIComponent;
import org.exoplatform.webui.core.UIContainer;
import org.exoplatform.webui.core.UIGrid;
import org.exoplatform.webui.core.UIPopupContainer;
import org.exoplatform.webui.core.lifecycle.UIContainerLifecycle;
import org.exoplatform.webui.event.Event;
import org.exoplatform.webui.event.EventListener;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@ComponentConfig(lifecycle=UIContainerLifecycle.class, events={@EventConfig(listeners={DeleteActionListener.class}, confirm="UIPermissionTreeInfo.msg.confirm-delete-permission"), @EventConfig(listeners={EditActionListener.class})})
public class UIPermissionTreeInfo
extends UIContainer {
    public static String[] PERMISSION_BEAN_FIELD = new String[]{"usersOrGroups", "read", "addNode", "setProperty", "remove"};
    private static String[] PERMISSION_ACTION = new String[]{"Edit", "Delete"};
    private NodeLocation currentNode = null;
    private int sizeOfListPermission = 0;
    private List<PermissionBean> permBeans = new ArrayList<PermissionBean>();

    public UIPermissionTreeInfo() throws Exception {
        UIGrid uiGrid = (UIGrid)this.createUIComponent(UIGrid.class, null, "PermissionInfo");
        this.addChild((UIComponent)uiGrid);
        uiGrid.getUIPageIterator().setId("PermissionInfoIterator");
        uiGrid.configure("usersOrGroups", PERMISSION_BEAN_FIELD, PERMISSION_ACTION);
    }

    private String getExoOwner(Node node) throws Exception {
        return Utils.getNodeOwner((Node)node);
    }

    public void updateGrid() throws Exception {
        HashMap permsMap = new HashMap();
        int iSystemOwner = 0;
        if (this.currentNode != null) {
            this.permBeans = new ArrayList<PermissionBean>();
            ExtendedNode node = (ExtendedNode)this.getCurrentNode();
            List permsList = node.getACL().getPermissionEntries();
            for (AccessControlEntry accessControlEntry : permsList) {
                String currentIdentity = accessControlEntry.getIdentity();
                String currentPermission = accessControlEntry.getPermission();
                ArrayList<String> currentPermissionsList = (ArrayList<String>)permsMap.get(currentIdentity);
                if (!permsMap.containsKey(currentIdentity)) {
                    permsMap.put(currentIdentity, null);
                }
                if (currentPermissionsList == null) {
                    currentPermissionsList = new ArrayList<String>();
                }
                if (!currentPermissionsList.contains(currentPermission)) {
                    currentPermissionsList.add(currentPermission);
                }
                permsMap.put(currentIdentity, currentPermissionsList);
            }
            Set keys = permsMap.keySet();
            Iterator keysIter = keys.iterator();
            String owner = IdentityConstants.SYSTEM;
            if (this.getExoOwner((Node)node) != null) {
                owner = this.getExoOwner((Node)node);
            }
            if (owner.equals(IdentityConstants.SYSTEM)) {
                iSystemOwner = -1;
            }
            PermissionBean permOwnerBean = new PermissionBean();
            if (!permsMap.containsKey(owner)) {
                permOwnerBean.setUsersOrGroups(owner);
                permOwnerBean.setRead(true);
                permOwnerBean.setAddNode(true);
                permOwnerBean.setSetProperty(true);
                permOwnerBean.setRemove(true);
                this.permBeans.add(permOwnerBean);
            }
            while (keysIter.hasNext()) {
                String userOrGroup = (String)keysIter.next();
                List permissions = (List)permsMap.get(userOrGroup);
                PermissionBean permBean = new PermissionBean();
                permBean.setUsersOrGroups(userOrGroup);
                for (String perm : permissions) {
                    if ("read".equals(perm)) {
                        permBean.setRead(true);
                        continue;
                    }
                    if ("add_node".equals(perm)) {
                        permBean.setAddNode(true);
                        continue;
                    }
                    if ("set_property".equals(perm)) {
                        permBean.setSetProperty(true);
                        continue;
                    }
                    if (!"remove".equals(perm)) continue;
                    permBean.setRemove(true);
                }
                this.permBeans.add(permBean);
            }
        } else {
            UIPermissionTreeForm uiForm = (UIPermissionTreeForm)((UIContainer)this.getParent()).getChild(UIPermissionTreeForm.class);
            PermissionBean permBean = uiForm.getPermBean();
            if (permBean != null) {
                for (PermissionBean permBeanTemp : this.permBeans) {
                    if (!permBeanTemp.equals((Object)permBean)) continue;
                    permBeanTemp.setAddNode(permBean.isAddNode());
                    permBeanTemp.setRead(permBean.isRead());
                    permBeanTemp.setRemove(permBean.isRemove());
                    permBeanTemp.setSetProperty(permBean.isSetProperty());
                }
                if (!this.permBeans.contains(permBean)) {
                    this.permBeans.add(permBean);
                }
                uiForm.setPermBean(null);
            }
        }
        this.sizeOfListPermission = this.permBeans.size() + iSystemOwner;
        UIGrid uiGrid = (UIGrid)this.findFirstComponentOfType(UIGrid.class);
        ListAccessImpl permList = new ListAccessImpl(PermissionBean.class, this.permBeans);
        LazyPageList dataPageList = new LazyPageList((ListAccess)permList, 10);
        uiGrid.getUIPageIterator().setPageList((PageList)dataPageList);
    }

    public Node getCurrentNode() {
        return NodeLocation.getNodeByLocation((NodeLocation)this.currentNode);
    }

    public void setCurrentNode(Node currentNode) {
        this.currentNode = NodeLocation.getNodeLocationByNode((Node)currentNode);
    }

    public int getSizeOfListPermission() {
        return this.sizeOfListPermission;
    }

    public void setSizeOfListPermission(int sizeOfListPermission) {
        this.sizeOfListPermission = sizeOfListPermission;
    }

    public List<PermissionBean> getPermBeans() {
        return this.permBeans;
    }

    public void setPermBeans(List<PermissionBean> permBeans) {
        this.permBeans = permBeans;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class DeleteActionListener
    extends EventListener<UIPermissionTreeInfo> {
        public void execute(Event<UIPermissionTreeInfo> event) throws Exception {
            UIPermissionTreeInfo uicomp = (UIPermissionTreeInfo)((Object)event.getSource());
            UIPermissionTreeManager uiParent = (UIPermissionTreeManager)uicomp.getParent();
            Node currentNode = uicomp.getCurrentNode();
            ExtendedNode node = (ExtendedNode)currentNode;
            String owner = IdentityConstants.SYSTEM;
            int iSystemOwner = 0;
            if (uicomp.getExoOwner((Node)node) != null) {
                owner = uicomp.getExoOwner((Node)node);
            }
            if (owner.equals(IdentityConstants.SYSTEM)) {
                iSystemOwner = -1;
            }
            String name = event.getRequestContext().getRequestParameter("objectId");
            UIApplication uiApp = (UIApplication)uicomp.getAncestorOfType(UIApplication.class);
            UIPopupContainer uiPopup = (UIPopupContainer)uicomp.getAncestorOfType(UIPopupContainer.class);
            if (currentNode != null) {
                if (uicomp.getSizeOfListPermission() < 2 + iSystemOwner) {
                    uiApp.addMessage(new ApplicationMessage("UIPermissionTreeInfo.msg.no-permission-remove", null, 1));
                    event.getRequestContext().addUIComponentToUpdateByAjax((UIComponent)uiApp.getUIPopupMessages());
                    return;
                }
                if (!currentNode.isCheckedOut()) {
                    uiApp.addMessage(new ApplicationMessage("UIActionBar.msg.node-checkedin", null, 1));
                    event.getRequestContext().addUIComponentToUpdateByAjax((UIComponent)uiApp.getUIPopupMessages());
                    return;
                }
                String nodeOwner = Utils.getNodeOwner((Node)node);
                if (name.equals(nodeOwner)) {
                    uiApp.addMessage(new ApplicationMessage("UIPermissionInfo.msg.no-permission-remove", null, 1));
                    event.getRequestContext().addUIComponentToUpdateByAjax((UIComponent)uiApp.getUIPopupMessages());
                    return;
                }
                if (PermissionUtil.canChangePermission((Node)node)) {
                    if (node.canAddMixin("exo:privilegeable")) {
                        node.addMixin("exo:privilegeable");
                        node.setPermission(nodeOwner, PermissionType.ALL);
                        node.save();
                    }
                    try {
                        node.removePermission(name);
                        node.save();
                    }
                    catch (AccessDeniedException ace) {
                        node.getSession().refresh(false);
                        uiApp.addMessage(new ApplicationMessage("UIPermissionInfo.msg.access-denied", null, 1));
                        event.getRequestContext().addUIComponentToUpdateByAjax((UIComponent)uiApp.getUIPopupMessages());
                        return;
                    }
                } else {
                    uiApp.addMessage(new ApplicationMessage("UIPermissionInfo.msg.no-permission-tochange", null, 1));
                    event.getRequestContext().addUIComponentToUpdateByAjax((UIComponent)uiApp.getUIPopupMessages());
                    return;
                }
                node.getSession().save();
                node.getSession().refresh(false);
                if (!PermissionUtil.canRead((Node)node)) {
                    uiPopup.deActivate();
                } else {
                    uicomp.updateGrid();
                    event.getRequestContext().addUIComponentToUpdateByAjax((UIComponent)uiParent);
                }
            } else {
                PermissionBean permBean = new PermissionBean();
                permBean.setUsersOrGroups(name);
                if (uicomp.getPermBeans().contains(permBean)) {
                    uicomp.getPermBeans().remove(permBean);
                    uicomp.updateGrid();
                }
            }
            event.getRequestContext().addUIComponentToUpdateByAjax((UIComponent)uiParent);
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class EditActionListener
    extends EventListener<UIPermissionTreeInfo> {
        public void execute(Event<UIPermissionTreeInfo> event) throws Exception {
            UIPermissionTreeInfo uicomp = (UIPermissionTreeInfo)((Object)event.getSource());
            String name = event.getRequestContext().getRequestParameter("objectId");
            Node updateNode = uicomp.getCurrentNode();
            ExtendedNode node = (ExtendedNode)updateNode;
            UIPermissionTreeForm uiForm = (UIPermissionTreeForm)((UIPermissionTreeManager)uicomp.getAncestorOfType(UIPermissionTreeManager.class)).getChild(UIPermissionTreeForm.class);
            uiForm.fillForm(name, node);
            uiForm.lockForm(name.equals(uicomp.getExoOwner((Node)node)));
        }
    }
}

