/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.ecm.webui.component.admin.templates;

import javax.jcr.Node;
import org.exoplatform.ecm.webui.component.admin.templates.UITemplatesManager;
import org.exoplatform.services.cms.templates.TemplateService;
import org.exoplatform.services.wcm.utils.WCMCoreUtils;
import org.exoplatform.webui.config.annotation.ComponentConfig;
import org.exoplatform.webui.config.annotation.EventConfig;
import org.exoplatform.webui.core.UIComponent;
import org.exoplatform.webui.core.UIPopupWindow;
import org.exoplatform.webui.core.lifecycle.UIFormLifecycle;
import org.exoplatform.webui.event.Event;
import org.exoplatform.webui.event.EventListener;
import org.exoplatform.webui.form.UIForm;
import org.exoplatform.webui.form.UIFormCheckBoxInput;
import org.exoplatform.webui.form.UIFormStringInput;

@ComponentConfig(lifecycle=UIFormLifecycle.class, template="system:/groovy/webui/form/UIForm.gtmpl", events={@EventConfig(listeners={SaveActionListener.class}), @EventConfig(phase=Event.Phase.DECODE, listeners={CancelActionListener.class})})
public class UITemplateEditForm
extends UIForm {
    public static final String FIELD_NAME = "name";
    public static final String FIELD_LABEL = "label";
    public static final String FIELD_ISTEMPLATE = "isDocumentTemplate";
    private static String nodeType_;

    public UITemplateEditForm() {
        this.addChild((UIComponent)new UIFormStringInput(FIELD_NAME, null));
        this.addChild((UIComponent)new UIFormStringInput(FIELD_LABEL, null));
        this.addChild((UIComponent)new UIFormCheckBoxInput(FIELD_ISTEMPLATE, null, null));
    }

    private boolean isDocumentTemplate(String nodeType) throws Exception {
        TemplateService templateService = (TemplateService)this.getApplicationComponent(TemplateService.class);
        return templateService.getDocumentTemplates().contains(nodeType);
    }

    public void update(String nodeType) throws Exception {
        TemplateService tempService = (TemplateService)this.getApplicationComponent(TemplateService.class);
        Node node = tempService.getTemplatesHome(WCMCoreUtils.getUserSessionProvider()).getNode(nodeType);
        String label = null;
        if (node.hasProperty(TemplateService.TEMPLATE_LABEL)) {
            label = node.getProperty(TemplateService.TEMPLATE_LABEL).getString();
        }
        this.getUIFormCheckBoxInput(FIELD_ISTEMPLATE).setChecked(this.isDocumentTemplate(nodeType));
        this.getUIStringInput(FIELD_NAME).setValue((Object)nodeType);
        this.getUIStringInput(FIELD_LABEL).setValue((Object)label);
        this.getUIFormCheckBoxInput(FIELD_ISTEMPLATE).setEnable(false);
        this.getUIStringInput(FIELD_NAME).setEditable(false);
        nodeType_ = nodeType;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class CancelActionListener
    extends EventListener<UITemplateEditForm> {
        public void execute(Event<UITemplateEditForm> event) throws Exception {
            UITemplatesManager uiManager = (UITemplatesManager)((UITemplateEditForm)((Object)event.getSource())).getAncestorOfType(UITemplatesManager.class);
            UIPopupWindow uiPopupWindow = (UIPopupWindow)uiManager.getChildById("EditTemplatePopup");
            uiPopupWindow.setRendered(false);
            event.getRequestContext().addUIComponentToUpdateByAjax((UIComponent)uiManager);
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class SaveActionListener
    extends EventListener<UITemplateEditForm> {
        public void execute(Event<UITemplateEditForm> event) throws Exception {
            UITemplateEditForm uiForm = (UITemplateEditForm)((Object)event.getSource());
            TemplateService tempService = (TemplateService)uiForm.getApplicationComponent(TemplateService.class);
            Node node = tempService.getTemplatesHome(WCMCoreUtils.getUserSessionProvider()).getNode(nodeType_);
            node.setProperty(TemplateService.TEMPLATE_LABEL, (String)uiForm.getUIStringInput(UITemplateEditForm.FIELD_LABEL).getValue());
            node.save();
            uiForm.reset();
            UITemplatesManager uiManager = (UITemplatesManager)uiForm.getAncestorOfType(UITemplatesManager.class);
            UIPopupWindow uiPopupWindow = (UIPopupWindow)uiManager.getChildById("EditTemplatePopup");
            uiPopupWindow.setRendered(false);
            event.getRequestContext().addUIComponentToUpdateByAjax((UIComponent)uiManager);
        }
    }
}

