/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.services.common.util;

import java.util.Comparator;
import java.util.logging.Logger;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Arrays {
    private static Logger log = Logger.getLogger(Arrays.class.getName());

    public static <T> int search(T[] a, T key, Comparator<T> compare) {
        int low = 0;
        int high = a.length - 1;
        while (low <= high) {
            int mid = low + high >> 1;
            T t = a[mid];
            int cmp = compare.compare(t, key);
            if (cmp < 0) {
                low = mid + 1;
                continue;
            }
            if (cmp > 0) {
                high = mid - 1;
                continue;
            }
            return mid;
        }
        return -1;
    }

    private static <T> void sort(T[] array, int bot, int up, Comparator<T> compare) {
        int incre = bot;
        int decre = up;
        T mid = array[(incre + decre) / 2];
        while (true) {
            if (compare.compare(array[incre], mid) < 0) {
                ++incre;
                continue;
            }
            while (compare.compare(array[decre], mid) > 0) {
                --decre;
            }
            if (incre > decre) break;
            T v = array[incre];
            array[incre] = array[decre];
            array[decre] = v;
            ++incre;
            --decre;
        }
        if (bot < decre) {
            Arrays.sort(array, bot, decre, compare);
        }
        if (incre < up) {
            Arrays.sort(array, incre, up, compare);
        }
    }

    public static <T> void sort(T[] a, Comparator<T> compare) {
        Arrays.sort(a, 0, a.length - 1, compare);
    }

    public static void main(String[] args) {
        Integer[] a = new Integer[]{-8, 4, 8, 3, -2, 0, 1, -1, 7, 2, 2, 4, 6, 9, 1, 5, 3, 8, -9};
        long start = System.currentTimeMillis();
        int time = 100000;
        for (int i = 0; i < time; ++i) {
            Integer[] b = new Integer[a.length];
            System.arraycopy(a, 0, b, 0, b.length);
            Arrays.sort(b, new Comparator<Integer>(){

                @Override
                public int compare(Integer i1, Integer i2) {
                    return i1.compareTo(i2);
                }
            });
        }
        long end = System.currentTimeMillis();
        log.info(" het " + (end - start));
        start = System.currentTimeMillis();
        for (int i = 0; i < time; ++i) {
            Integer[] b = new Integer[a.length];
            System.arraycopy(a, 0, b, 0, b.length);
            java.util.Arrays.sort(b, new Comparator<Integer>(){

                @Override
                public int compare(Integer i1, Integer i2) {
                    return i1.compareTo(i2);
                }
            });
        }
        end = System.currentTimeMillis();
        log.info(" het " + (end - start));
    }
}

