/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.portal.application;

import java.io.IOException;
import java.io.OutputStream;
import java.io.StringWriter;
import java.io.UnsupportedEncodingException;
import java.io.Writer;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.ResourceBundle;
import java.util.Set;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.servlet.http.HttpSession;
import org.exoplatform.commons.utils.ExpressionUtil;
import org.exoplatform.commons.utils.PortalPrinter;
import org.exoplatform.commons.xml.DOMSerializer;
import org.exoplatform.container.ExoContainer;
import org.exoplatform.container.ExoContainerContext;
import org.exoplatform.container.PortalContainer;
import org.exoplatform.portal.application.PortalURLBuilder;
import org.exoplatform.portal.config.UserPortalConfig;
import org.exoplatform.portal.config.UserPortalConfigService;
import org.exoplatform.portal.config.model.Page;
import org.exoplatform.portal.mop.SiteKey;
import org.exoplatform.portal.mop.SiteType;
import org.exoplatform.portal.mop.user.UserNavigation;
import org.exoplatform.portal.mop.user.UserNode;
import org.exoplatform.portal.mop.user.UserPortalContext;
import org.exoplatform.portal.url.PortalURLContext;
import org.exoplatform.portal.webui.portal.UIPortal;
import org.exoplatform.portal.webui.util.Util;
import org.exoplatform.portal.webui.workspace.UIPortalApplication;
import org.exoplatform.services.log.ExoLogger;
import org.exoplatform.services.log.Log;
import org.exoplatform.services.resources.Orientation;
import org.exoplatform.services.resources.ResourceBundleManager;
import org.exoplatform.web.ControllerContext;
import org.exoplatform.web.application.Application;
import org.exoplatform.web.application.JavascriptManager;
import org.exoplatform.web.application.URLBuilder;
import org.exoplatform.web.url.PortalURL;
import org.exoplatform.web.url.ResourceType;
import org.exoplatform.web.url.URLContext;
import org.exoplatform.web.url.URLFactory;
import org.exoplatform.web.url.URLFactoryService;
import org.exoplatform.web.url.navigation.NavigationResource;
import org.exoplatform.web.url.navigation.NodeURL;
import org.exoplatform.webui.application.WebuiApplication;
import org.exoplatform.webui.application.WebuiRequestContext;
import org.exoplatform.webui.core.UIComponent;
import org.exoplatform.webui.url.ComponentURL;
import org.gatein.common.http.QueryStringParser;
import org.gatein.common.util.ParameterMap;
import org.w3c.dom.Element;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class PortalRequestContext
extends WebuiRequestContext {
    protected static Log log = ExoLogger.getLogger((String)"portal:PortalRequestContext");
    public static final int PUBLIC_ACCESS = 0;
    public static final int PRIVATE_ACCESS = 1;
    public static final String UI_COMPONENT_ACTION = "portal:action";
    public static final String UI_COMPONENT_ID = "portal:componentId";
    public static final String TARGET_NODE = "portal:targetNode";
    public static final String CACHE_LEVEL = "portal:cacheLevel";
    public static final String REQUEST_TITLE = "portal:requestTitle".intern();
    public static final String REQUEST_METADATA = "portal:requestMetadata".intern();
    private static final String LAST_PORTAL_NAME = "prc.lastPortalName";
    private final String nodePath_;
    private final String requestURI_;
    private final String portalURI;
    private final SiteKey siteKey;
    private final Locale requestLocale;
    private final HttpServletRequest request_;
    private final HttpServletResponse response_;
    private String cacheLevel_ = "cacheLevelPortlet";
    private boolean ajaxRequest_ = true;
    private boolean forceFullUpdate = false;
    private Writer writer_;
    protected JavascriptManager jsmanager_ = new JavascriptManager();
    private List<Element> extraMarkupHeaders;
    private final PortalURLBuilder urlBuilder;
    private Map<String, String[]> parameterMap;
    private Locale locale = Locale.ENGLISH;
    private final URLFactoryService urlFactory = (URLFactoryService)PortalContainer.getComponent(URLFactoryService.class);
    private final ControllerContext controllerContext;
    private UserPortalConfig userPortalConfig;
    public static final UserPortalContext USER_PORTAL_CONTEXT = new UserPortalContext(){

        public ResourceBundle getBundle(UserNavigation navigation) {
            ExoContainer container = ExoContainerContext.getCurrentContainer();
            ResourceBundleManager rbMgr = (ResourceBundleManager)container.getComponentInstanceOfType(ResourceBundleManager.class);
            Locale locale = Util.getPortalRequestContext().getLocale();
            return rbMgr.getNavigationResourceBundle(locale.getLanguage(), navigation.getKey().getTypeName(), navigation.getKey().getName());
        }

        public Locale getUserLocale() {
            return Util.getPortalRequestContext().getLocale();
        }
    };

    public JavascriptManager getJavascriptManager() {
        return this.jsmanager_;
    }

    public PortalRequestContext(WebuiApplication app, ControllerContext controllerContext, String requestSiteType, String requestSiteName, String requestPath, Locale requestLocale) throws Exception {
        super((Application)app);
        this.controllerContext = controllerContext;
        this.request_ = controllerContext.getRequest();
        this.response_ = controllerContext.getResponse();
        this.response_.setBufferSize(102400);
        this.setSessionId(this.request_.getSession().getId());
        this.response_.setContentType("text/html; charset=UTF-8");
        try {
            this.request_.setCharacterEncoding("UTF-8");
        }
        catch (UnsupportedEncodingException e) {
            log.error((Object)"Encoding not supported", (Throwable)e);
        }
        this.parameterMap = new HashMap<String, String[]>();
        this.parameterMap.putAll(this.request_.getParameterMap());
        String queryString = this.request_.getQueryString();
        if (queryString != null) {
            ParameterMap queryParams = QueryStringParser.getInstance().parseQueryString(queryString);
            this.parameterMap.putAll((Map<String, String[]>)queryParams);
        }
        this.ajaxRequest_ = "true".equals(this.request_.getParameter("ajaxRequest"));
        String cache = this.request_.getParameter(CACHE_LEVEL);
        if (cache != null) {
            this.cacheLevel_ = cache;
        }
        this.requestURI_ = this.request_.getRequestURI();
        this.siteKey = new SiteKey(SiteType.valueOf((String)requestSiteType.toUpperCase()), requestSiteName);
        this.nodePath_ = requestPath;
        this.requestLocale = requestLocale;
        NodeURL url = (NodeURL)this.createURL(NodeURL.TYPE);
        url.setResource(new NavigationResource(this.siteKey, ""));
        this.portalURI = url.toString();
        this.urlBuilder = new PortalURLBuilder(this, (ComponentURL)this.createURL(ComponentURL.TYPE));
    }

    public <R, U extends PortalURL<R, U>> U newURL(ResourceType<R, U> resourceType, URLFactory urlFactory) {
        PortalURLContext urlContext = new PortalURLContext(this.controllerContext, this.siteKey);
        PortalURL url = urlFactory.newURL(resourceType, (URLContext)urlContext);
        if (url != null) {
            url.setAjax(Boolean.valueOf(false));
            url.setLocale(this.requestLocale);
        }
        return (U)url;
    }

    public UserPortalConfig getUserPortalConfig() {
        if (this.userPortalConfig == null) {
            String portalName = null;
            String remoteUser = this.getRemoteUser();
            SiteType siteType = this.getSiteType();
            ExoContainer appContainer = this.getApplication().getApplicationServiceContainer();
            UserPortalConfigService service_ = (UserPortalConfigService)appContainer.getComponentInstanceOfType(UserPortalConfigService.class);
            if (SiteType.PORTAL == siteType) {
                portalName = this.getSiteName();
            }
            HttpSession session = this.request_.getSession();
            if (portalName == null && session != null) {
                portalName = (String)session.getAttribute(LAST_PORTAL_NAME);
            }
            if (portalName == null) {
                portalName = service_.getDefaultPortal();
            }
            try {
                this.userPortalConfig = service_.getUserPortalConfig(portalName, remoteUser, USER_PORTAL_CONTEXT);
                if (this.userPortalConfig != null) {
                    session.setAttribute(LAST_PORTAL_NAME, (Object)portalName);
                }
            }
            catch (Exception e) {
                return null;
            }
        }
        return this.userPortalConfig;
    }

    public void setUserPortalConfig(UserPortalConfig upc) {
        this.userPortalConfig = upc;
    }

    public String getInitialURI() {
        return this.request_.getRequestURI();
    }

    public ControllerContext getControllerContext() {
        return this.controllerContext;
    }

    public void refreshResourceBundle() throws Exception {
        this.appRes_ = this.getApplication().getResourceBundle(this.getLocale());
    }

    public String getTitle() throws Exception {
        UIPortal uiportal;
        UserNode node;
        String title = (String)this.request_.getAttribute(REQUEST_TITLE);
        if (title == null && (node = (uiportal = Util.getUIPortal()).getSelectedUserNode()) != null) {
            ExoContainer container = this.getApplication().getApplicationServiceContainer();
            container.getComponentInstanceOfType(UserPortalConfigService.class);
            UserPortalConfigService configService = (UserPortalConfigService)container.getComponentInstanceOfType(UserPortalConfigService.class);
            Page page = configService.getPage(node.getPageRef(), this.getRemoteUser());
            if (page != null) {
                title = page.getTitle();
                return ExpressionUtil.getExpressionValue((ResourceBundle)this.getApplicationResourceBundle(), (String)title);
            }
            title = node.getResolvedLabel();
        }
        return title;
    }

    public URLFactory getURLFactory() {
        return this.urlFactory;
    }

    public Orientation getOrientation() {
        return ((UIPortalApplication)this.uiApplication_).getOrientation();
    }

    public Locale getRequestLocale() {
        return this.requestLocale;
    }

    public void setLocale(Locale locale) {
        this.locale = locale;
    }

    public Locale getLocale() {
        return this.locale;
    }

    public Map<String, String> getMetaInformation() {
        return (Map)this.request_.getAttribute(REQUEST_METADATA);
    }

    public String getCacheLevel() {
        return this.cacheLevel_;
    }

    public String getRequestParameter(String name) {
        if (this.parameterMap.get(name) != null && this.parameterMap.get(name).length > 0) {
            return this.parameterMap.get(name)[0];
        }
        return null;
    }

    public String[] getRequestParameterValues(String name) {
        return this.parameterMap.get(name);
    }

    public Map<String, String[]> getPortletParameters() {
        Map<String, String[]> unsortedParams = this.parameterMap;
        HashMap<String, String[]> sortedParams = new HashMap<String, String[]>();
        Set<String> keys = unsortedParams.keySet();
        for (String key : keys) {
            if (key.startsWith("portal:")) continue;
            sortedParams.put(key, unsortedParams.get(key));
        }
        return sortedParams;
    }

    public final String getRequestContextPath() {
        return this.request_.getContextPath();
    }

    public String getPortalContextPath() {
        return this.getRequestContextPath();
    }

    public String getActionParameterName() {
        return UI_COMPONENT_ACTION;
    }

    public String getUIComponentIdParameterName() {
        return UI_COMPONENT_ID;
    }

    public SiteType getSiteType() {
        return this.siteKey.getType();
    }

    public String getSiteName() {
        return this.siteKey.getName();
    }

    public SiteKey getSiteKey() {
        return this.siteKey;
    }

    public String getPortalOwner() {
        UserPortalConfig userPortalConfig = this.getUserPortalConfig();
        if (userPortalConfig != null) {
            return userPortalConfig.getPortalName();
        }
        return null;
    }

    public String getNodePath() {
        return this.nodePath_;
    }

    public String getRequestURI() {
        return this.requestURI_;
    }

    public String getPortalURI() {
        return this.portalURI;
    }

    public URLBuilder<UIComponent> getURLBuilder() {
        return this.urlBuilder;
    }

    public int getAccessPath() {
        return this.request_.getRemoteUser() != null ? 1 : 0;
    }

    public final String getRemoteUser() {
        return this.request_.getRemoteUser();
    }

    public final boolean isUserInRole(String roleUser) {
        return this.request_.isUserInRole(roleUser);
    }

    public final Writer getWriter() throws Exception {
        if (this.writer_ == null) {
            this.writer_ = new PortalPrinter((OutputStream)this.response_.getOutputStream(), true, 30000);
        }
        return this.writer_;
    }

    public final void setWriter(Writer writer) {
        this.writer_ = writer;
    }

    public final boolean useAjax() {
        return this.ajaxRequest_;
    }

    public final HttpServletRequest getRequest() {
        return this.request_;
    }

    public final HttpServletResponse getResponse() {
        return this.response_;
    }

    public final boolean getFullRender() {
        return this.forceFullUpdate;
    }

    public final void setFullRender(boolean forceFullUpdate) {
        this.forceFullUpdate = forceFullUpdate;
    }

    public final void sendError(int sc) throws IOException {
        this.setResponseComplete(true);
        this.response_.sendError(sc);
    }

    public final void sendRedirect(String url) throws IOException {
        this.setResponseComplete(true);
        this.response_.sendRedirect(url);
    }

    public void setHeaders(Map<String, String> headers) {
        Set<String> keys = headers.keySet();
        for (String key : keys) {
            this.response_.setHeader(key, headers.get(key));
        }
    }

    public List<String> getExtraMarkupHeadersAsStrings() throws Exception {
        ArrayList<String> markupHeaders = new ArrayList<String>();
        if (this.extraMarkupHeaders != null && !this.extraMarkupHeaders.isEmpty()) {
            for (Element element : this.extraMarkupHeaders) {
                StringWriter sw = new StringWriter();
                DOMSerializer.serialize((Element)element, (Writer)sw);
                markupHeaders.add(sw.toString());
            }
        }
        return markupHeaders;
    }

    public List<Element> getExtraMarkupHeaders() {
        return this.extraMarkupHeaders;
    }

    public void addExtraMarkupHeader(Element element) {
        if (this.extraMarkupHeaders == null) {
            this.extraMarkupHeaders = new ArrayList<Element>();
        }
        this.extraMarkupHeaders.add(element);
    }
}

