/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.services.jcr.impl.dataflow;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import javax.jcr.RepositoryException;
import org.exoplatform.services.jcr.core.nodetype.NodeTypeDataManager;
import org.exoplatform.services.jcr.dataflow.ItemState;
import org.exoplatform.services.jcr.datamodel.InternalQName;
import org.exoplatform.services.jcr.datamodel.ItemData;
import org.exoplatform.services.jcr.datamodel.NodeData;
import org.exoplatform.services.jcr.datamodel.PropertyData;
import org.exoplatform.services.jcr.datamodel.QPath;
import org.exoplatform.services.jcr.impl.Constants;
import org.exoplatform.services.jcr.impl.core.ItemImpl;
import org.exoplatform.services.jcr.impl.core.SessionDataManager;
import org.exoplatform.services.jcr.impl.dataflow.DefaultItemDataCopyVisitor;
import org.exoplatform.services.jcr.impl.dataflow.session.SessionChangesLog;
import org.exoplatform.services.jcr.impl.storage.JCRItemExistsException;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ItemDataCloneVisitor
extends DefaultItemDataCopyVisitor {
    protected List<ItemState> itemDeletedExistingStates = new ArrayList<ItemState>();
    protected final SessionDataManager dstDataManager;
    private boolean removeExisting;
    private boolean deletedExistingPropery = false;
    private final SessionChangesLog changes;

    public ItemDataCloneVisitor(NodeData parent, InternalQName dstNodeName, NodeTypeDataManager nodeTypeManager, SessionDataManager srcDataManager, SessionDataManager dstDataManager, boolean removeExisting, SessionChangesLog changes) {
        super(parent, dstNodeName, nodeTypeManager, srcDataManager, false);
        this.dstDataManager = dstDataManager;
        this.removeExisting = removeExisting;
        this.changes = changes;
    }

    public List<ItemState> getItemDeletedExistingStates(boolean isInverse) {
        if (isInverse) {
            Collections.reverse(this.itemDeletedExistingStates);
        }
        return this.itemDeletedExistingStates;
    }

    @Override
    protected int calculateNewNodeOrderNumber() throws RepositoryException {
        NodeData parent = this.curParent();
        List<NodeData> existedChilds = this.getMargedChildNodesData(parent);
        int orderNum = 0;
        if (existedChilds.size() > 0) {
            orderNum = existedChilds.get(existedChilds.size() - 1).getOrderNumber() + 1;
        }
        return orderNum;
    }

    @Override
    protected QPath calculateNewNodePath(NodeData node, int level) throws RepositoryException {
        NodeData parent = this.curParent();
        InternalQName qname = null;
        List<NodeData> existedChilds = this.getMargedChildNodesData(parent);
        int newIndex = 1;
        if (level == 0) {
            qname = this.destNodeName;
            for (NodeData child : existedChilds) {
                if (!child.getQPath().getName().equals((Object)qname)) continue;
                ++newIndex;
            }
        } else {
            qname = node.getQPath().getName();
            newIndex = node.getQPath().getIndex();
        }
        return QPath.makeChildPath(parent.getQPath(), qname, newIndex);
    }

    @Override
    protected void entering(NodeData node, int level) throws RepositoryException {
        boolean isMixReferenceable = this.ntManager.isNodeType(Constants.MIX_REFERENCEABLE, node.getPrimaryTypeName(), node.getMixinTypeNames());
        this.deletedExistingPropery = false;
        if (isMixReferenceable) {
            String identifier = node.getIdentifier();
            ItemImpl relItem = this.dstDataManager.getItemByIdentifier(identifier, false);
            ItemState changesItemState = null;
            if (this.changes != null) {
                changesItemState = this.changes.getItemState(identifier);
            }
            if (!(relItem == null || changesItemState != null && changesItemState.isDeleted())) {
                if (this.removeExisting) {
                    this.deletedExistingPropery = true;
                    this.itemDeletedExistingStates.add(new ItemState(relItem.getData(), 4, true, this.dstDataManager.getItemByIdentifier(relItem.getParentIdentifier(), false).getInternalPath(), level != 0));
                } else {
                    throw new JCRItemExistsException("Item exists id = " + identifier + " name " + relItem.getName(), identifier);
                }
            }
            this.keepIdentifiers = true;
        }
        super.entering(node, level);
        this.keepIdentifiers = false;
    }

    @Override
    protected void entering(PropertyData property, int level) throws RepositoryException {
        if (this.deletedExistingPropery && this.removeExisting && this.itemInItemStateList(this.itemDeletedExistingStates, property.getParentIdentifier(), 4)) {
            ItemData dstParentNodeData = this.dstDataManager.getItemByIdentifier(property.getParentIdentifier(), false).getData();
            List<PropertyData> dstChildProperties = this.dstDataManager.getChildPropertiesData((NodeData)dstParentNodeData);
            ItemData dstProperty = null;
            for (PropertyData propertyData : dstChildProperties) {
                if (!propertyData.getQPath().getName().equals((Object)property.getQPath().getName())) continue;
                dstProperty = propertyData;
                break;
            }
            if (dstProperty != null) {
                this.itemDeletedExistingStates.add(new ItemState(dstProperty, 4, true, this.dstDataManager.getItemByIdentifier(dstProperty.getParentIdentifier(), false).getInternalPath(), level != 0));
            } else {
                throw new RepositoryException("Destination propery " + property.getQPath().getAsString() + " not found. ");
            }
        }
        super.entering(property, level);
    }

    private boolean itemInItemStateList(List<ItemState> list, String itemId, int state) {
        boolean retval = false;
        for (ItemState itemState : list) {
            if (itemState.getState() != state || !itemState.getData().getIdentifier().equals(itemId)) continue;
            retval = true;
            break;
        }
        return retval;
    }

    private boolean isItemDeleted(ItemData item) {
        if (this.itemInItemStateList(this.itemDeletedExistingStates, item.getIdentifier(), 4)) {
            return true;
        }
        ItemState changesItemState = null;
        return this.changes != null && (changesItemState = this.changes.getItemState(item.getIdentifier())) != null && changesItemState.isDeleted();
    }

    private List<NodeData> getMargedChildNodesData(NodeData parent) throws RepositoryException {
        ArrayList<NodeData> result = new ArrayList<NodeData>();
        List<NodeData> existedChilds = this.dstDataManager.getChildNodesData(parent);
        for (NodeData nodeData : existedChilds) {
            if (this.isItemDeleted(nodeData)) continue;
            result.add(nodeData);
        }
        return result;
    }
}

