/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.services.jcr.impl.xml.importing;

import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.jcr.NamespaceRegistry;
import javax.jcr.PathNotFoundException;
import javax.jcr.RepositoryException;
import javax.jcr.ValueFormatException;
import javax.jcr.nodetype.ConstraintViolationException;
import javax.jcr.nodetype.NoSuchNodeTypeException;
import org.exoplatform.services.jcr.access.AccessManager;
import org.exoplatform.services.jcr.core.ExtendedPropertyType;
import org.exoplatform.services.jcr.core.nodetype.NodeTypeDataManager;
import org.exoplatform.services.jcr.core.nodetype.PropertyDefinitionDatas;
import org.exoplatform.services.jcr.dataflow.ItemDataConsumer;
import org.exoplatform.services.jcr.dataflow.ItemState;
import org.exoplatform.services.jcr.datamodel.IllegalNameException;
import org.exoplatform.services.jcr.datamodel.IllegalPathException;
import org.exoplatform.services.jcr.datamodel.InternalQName;
import org.exoplatform.services.jcr.datamodel.ItemType;
import org.exoplatform.services.jcr.datamodel.NodeData;
import org.exoplatform.services.jcr.datamodel.QPath;
import org.exoplatform.services.jcr.datamodel.QPathEntry;
import org.exoplatform.services.jcr.datamodel.ValueData;
import org.exoplatform.services.jcr.impl.Constants;
import org.exoplatform.services.jcr.impl.core.JCRName;
import org.exoplatform.services.jcr.impl.core.LocationFactory;
import org.exoplatform.services.jcr.impl.core.RepositoryImpl;
import org.exoplatform.services.jcr.impl.core.value.BaseValue;
import org.exoplatform.services.jcr.impl.core.value.ValueFactoryImpl;
import org.exoplatform.services.jcr.impl.dataflow.ItemDataRemoveVisitor;
import org.exoplatform.services.jcr.impl.dataflow.TransientValueData;
import org.exoplatform.services.jcr.impl.dataflow.ValueDataConvertor;
import org.exoplatform.services.jcr.impl.xml.DecodedValue;
import org.exoplatform.services.jcr.impl.xml.importing.BaseXmlImporter;
import org.exoplatform.services.jcr.impl.xml.importing.NodePropertiesInfo;
import org.exoplatform.services.jcr.impl.xml.importing.dataflow.ImportNodeData;
import org.exoplatform.services.jcr.impl.xml.importing.dataflow.ImportPropertyData;
import org.exoplatform.services.jcr.impl.xml.importing.dataflow.PropertyInfo;
import org.exoplatform.services.jcr.util.IdGenerator;
import org.exoplatform.services.log.ExoLogger;
import org.exoplatform.services.log.Log;
import org.exoplatform.services.security.ConversationState;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class SystemViewImporter
extends BaseXmlImporter {
    private static Log log = ExoLogger.getLogger((String)"exo.jcr.component.core.SystemViewImporter");
    protected PropertyInfo propertyInfo = new PropertyInfo();
    protected Map<String, NodePropertiesInfo> mapNodePropertiesInfo = new HashMap<String, NodePropertiesInfo>();
    protected String ROOT_NODE_NAME = "jcr:root";

    public SystemViewImporter(NodeData parent, QPath ancestorToSave, int uuidBehavior, ItemDataConsumer dataConsumer, NodeTypeDataManager ntManager, LocationFactory locationFactory, ValueFactoryImpl valueFactory, NamespaceRegistry namespaceRegistry, AccessManager accessManager, ConversationState userState, Map<String, Object> context, RepositoryImpl repository, String currentWorkspaceName) {
        super(parent, ancestorToSave, uuidBehavior, dataConsumer, ntManager, locationFactory, valueFactory, namespaceRegistry, accessManager, userState, context, repository, currentWorkspaceName);
    }

    @Override
    public void characters(char[] ch, int start, int length) throws RepositoryException {
        if (this.propertyInfo.getValues().size() > 0) {
            DecodedValue curPropValue = this.propertyInfo.getValues().get(this.propertyInfo.getValues().size() - 1);
            if (curPropValue.isComplete()) {
                return;
            }
            if (this.propertyInfo.getType() == 2) {
                try {
                    curPropValue.getBinaryDecoder().write(ch, start, length);
                }
                catch (IOException e) {
                    throw new RepositoryException((Throwable)e);
                }
            } else {
                curPropValue.getStringBuffer().append(ch, start, length);
            }
        } else {
            log.debug((Object)("Wrong XML content. Element 'sv:value' expected, but SAX event 'characters' occured. characters:[" + new String(ch, start, length) + "]"));
        }
    }

    @Override
    public void endElement(String uri, String localName, String name) throws RepositoryException {
        InternalQName elementName = this.locationFactory.parseJCRName(name).getInternalName();
        if (Constants.SV_NODE_NAME.equals((Object)elementName)) {
            this.endNode();
        } else if (Constants.SV_PROPERTY_NAME.equals((Object)elementName)) {
            ImportPropertyData propertyData = this.endProperty();
            if (propertyData != null) {
                this.changesLog.add(new ItemState(propertyData, 1, true, this.getAncestorToSave()));
                ImportNodeData currentNodeInfo = (ImportNodeData)this.getParent();
                NodePropertiesInfo currentNodePropertiesInfo = this.mapNodePropertiesInfo.get(currentNodeInfo.getIdentifier());
                currentNodePropertiesInfo.addProperty(propertyData);
            }
        } else if (Constants.SV_VALUE_NAME.equals((Object)elementName)) {
            DecodedValue curPropValue = this.propertyInfo.getValues().get(this.propertyInfo.getValues().size() - 1);
            curPropValue.setComplete(true);
        } else if (Constants.SV_VERSION_HISTORY_NAME.equals((Object)elementName)) {
            this.tree.pop();
        } else {
            throw new RepositoryException("invalid element in system view xml document: " + localName);
        }
    }

    @Override
    public void startElement(String namespaceURI, String localName, String name, Map<String, String> atts) throws RepositoryException {
        InternalQName elementName = this.locationFactory.parseJCRName(name).getInternalName();
        if (Constants.SV_NODE_NAME.equals((Object)elementName)) {
            String svName = this.getAttribute(atts, Constants.SV_NAME_NAME);
            if (svName == null) {
                throw new RepositoryException("Missing mandatory sv:name attribute of element sv:node");
            }
            NodeData parentData = null;
            parentData = this.getParent();
            InternalQName currentNodeName = null;
            currentNodeName = this.ROOT_NODE_NAME.equals(svName) ? Constants.ROOT_PATH.getName() : this.locationFactory.parseJCRName(svName).getInternalName();
            int nodeIndex = this.getNodeIndex(parentData, currentNodeName, null);
            ImportNodeData newNodeData = new ImportNodeData(parentData, currentNodeName, nodeIndex);
            newNodeData.setACL(parentData.getACL());
            newNodeData.setOrderNumber(this.getNextChildOrderNum(parentData));
            newNodeData.setIdentifier(IdGenerator.generate());
            this.changesLog.add(new ItemState(newNodeData, 1, true, this.getAncestorToSave()));
            this.mapNodePropertiesInfo.put(newNodeData.getIdentifier(), new NodePropertiesInfo(newNodeData));
            this.tree.push(newNodeData);
        } else if (Constants.SV_PROPERTY_NAME.equals((Object)elementName)) {
            this.propertyInfo.setValues(new ArrayList<DecodedValue>());
            String svName = this.getAttribute(atts, Constants.SV_NAME_NAME);
            if (svName == null) {
                throw new RepositoryException("missing mandatory sv:name attribute of element sv:property");
            }
            this.propertyInfo.setName(this.locationFactory.parseJCRName(svName).getInternalName());
            this.propertyInfo.setIndentifer(IdGenerator.generate());
            String type = this.getAttribute(atts, Constants.SV_TYPE_NAME);
            if (type == null) {
                throw new RepositoryException("missing mandatory sv:type attribute of element sv:property");
            }
            try {
                this.propertyInfo.setType(ExtendedPropertyType.valueFromName(type));
            }
            catch (IllegalArgumentException e) {
                throw new RepositoryException("Unknown property type: " + type, (Throwable)e);
            }
        } else if (Constants.SV_VALUE_NAME.equals((Object)elementName)) {
            this.propertyInfo.getValues().add(new DecodedValue());
        } else if (Constants.SV_VERSION_HISTORY_NAME.equals((Object)elementName)) {
            String svName = this.getAttribute(atts, Constants.SV_NAME_NAME);
            if (svName == null) {
                throw new RepositoryException("Missing mandatory sv:name attribute of element sv:versionhistory");
            }
            NodeData versionStorage = (NodeData)this.dataConsumer.getItemData("00exo0jcr0version0storage0uuid00");
            NodeData versionHistory = (NodeData)this.dataConsumer.getItemData(versionStorage, new QPathEntry("", svName, 1), ItemType.NODE);
            if (versionHistory != null) {
                RemoveVisitor rv = new RemoveVisitor();
                rv.visit(versionHistory);
                this.changesLog.addAll(rv.getRemovedStates());
            }
            this.tree.push(versionStorage);
            ArrayList<String> list = (ArrayList<String>)this.context.get("importedSubversions");
            if (list == null) {
                list = new ArrayList<String>();
            }
            list.add(svName);
            this.context.put("importedSubversions", list);
        } else {
            throw new RepositoryException("Unknown element " + elementName.getAsString());
        }
    }

    private ImportPropertyData endMixinTypes() throws PathNotFoundException, RepositoryException, NoSuchNodeTypeException {
        InternalQName[] mixinNames = new InternalQName[this.propertyInfo.getValuesSize()];
        ArrayList<TransientValueData> values = new ArrayList<TransientValueData>(this.propertyInfo.getValuesSize());
        ImportNodeData currentNodeInfo = (ImportNodeData)this.getParent();
        for (int i = 0; i < this.propertyInfo.getValuesSize(); ++i) {
            String value = this.propertyInfo.getValues().get(i).toString();
            mixinNames[i] = this.locationFactory.parseJCRName(value).getInternalName();
            currentNodeInfo.addNodeType(this.nodeTypeDataManager.getNodeType(mixinNames[i]));
            values.add(new TransientValueData(value.toString()));
        }
        currentNodeInfo.setMixinTypeNames(mixinNames);
        ImportPropertyData propertyData = new ImportPropertyData(QPath.makeChildPath(currentNodeInfo.getQPath(), this.propertyInfo.getName()), this.propertyInfo.getIndentifer(), 0, this.propertyInfo.getType(), currentNodeInfo.getIdentifier(), true);
        propertyData.setValues(this.parseValues());
        return propertyData;
    }

    private void endNode() throws RepositoryException {
        ImportNodeData currentNodeInfo = (ImportNodeData)this.tree.pop();
        NodePropertiesInfo currentNodePropertiesInfo = this.mapNodePropertiesInfo.get(currentNodeInfo.getIdentifier());
        if (currentNodePropertiesInfo != null) {
            this.checkProperties(currentNodePropertiesInfo);
        }
        this.mapNodePropertiesInfo.remove(currentNodeInfo.getIdentifier());
        currentNodeInfo.setMixinTypeNames(currentNodeInfo.getMixinTypeNames());
        if (currentNodeInfo.isMixVersionable()) {
            this.createVersionHistory(currentNodeInfo);
        }
        currentNodeInfo.setACL(this.initAcl(currentNodeInfo.getACL(), currentNodeInfo.isExoOwneable(), currentNodeInfo.isExoPrivilegeable(), currentNodeInfo.getExoOwner(), currentNodeInfo.getExoPrivileges()));
    }

    private void checkProperties(NodePropertiesInfo currentNodePropertiesInfo) throws RepositoryException {
        if (currentNodePropertiesInfo.getNode().getQPath().isDescendantOf(Constants.JCR_VERSION_STORAGE_PATH) && currentNodePropertiesInfo.getNode().getPrimaryTypeName().equals((Object)Constants.NT_FROZENNODE)) {
            InternalQName fptName = null;
            ArrayList<InternalQName> fmtNames = new ArrayList<InternalQName>();
            try {
                for (ImportPropertyData propertyData : currentNodePropertiesInfo.getProperties()) {
                    if (propertyData.getQName().equals((Object)Constants.JCR_FROZENPRIMARYTYPE)) {
                        fptName = InternalQName.parse(new String(propertyData.getValues().get(0).getAsByteArray(), "UTF-8"));
                        continue;
                    }
                    if (!propertyData.getQName().equals((Object)Constants.JCR_FROZENMIXINTYPES)) continue;
                    for (ValueData valueData : propertyData.getValues()) {
                        fmtNames.add(InternalQName.parse(new String(valueData.getAsByteArray(), "UTF-8")));
                    }
                }
            }
            catch (IllegalStateException e) {
                throw new RepositoryException(e.getMessage(), (Throwable)e);
            }
            catch (IllegalNameException e) {
                throw new RepositoryException(e.getMessage(), (Throwable)e);
            }
            catch (IOException e) {
                throw new RepositoryException(e.getMessage(), (Throwable)e);
            }
            InternalQName nodePrimaryTypeName = currentNodePropertiesInfo.getNode().getPrimaryTypeName();
            InternalQName[] nodeMixinTypeName = currentNodePropertiesInfo.getNode().getMixinTypeNames();
            for (ImportPropertyData propertyData : currentNodePropertiesInfo.getProperties()) {
                PropertyDefinitionDatas vhdefs;
                PropertyDefinitionDatas defs = this.nodeTypeDataManager.getPropertyDefinitions(propertyData.getQName(), nodePrimaryTypeName, nodeMixinTypeName);
                if (defs != null && (defs == null || !defs.getAnyDefinition().isResidualSet()) || (vhdefs = this.nodeTypeDataManager.getPropertyDefinitions(propertyData.getQName(), fptName, fmtNames.toArray(new InternalQName[fmtNames.size()]))) == null) continue;
                boolean isMultivalue = vhdefs.getDefinition(true) != null;
                propertyData.setMultivalue(isMultivalue);
            }
        }
    }

    private ImportPropertyData endPrimaryType() throws PathNotFoundException, RepositoryException, NoSuchNodeTypeException {
        String sName = this.propertyInfo.getValues().get(0).toString();
        InternalQName primaryTypeName = this.locationFactory.parseJCRName(sName).getInternalName();
        ImportNodeData nodeData = (ImportNodeData)this.tree.pop();
        if (!"00exo0jcr0root0uuid0000000000000".equals(nodeData.getIdentifier())) {
            NodeData parentNodeData = this.getParent();
            if (!(nodeData.getQPath().getDepth() > 6 && primaryTypeName.equals((Object)Constants.NT_VERSIONEDCHILD) && nodeData.getQPath().getEntries()[5].equals((Object)Constants.JCR_FROZENNODE) || this.nodeTypeDataManager.isChildNodePrimaryTypeAllowed(primaryTypeName, parentNodeData.getPrimaryTypeName(), parentNodeData.getMixinTypeNames()))) {
                throw new ConstraintViolationException("Can't add node " + nodeData.getQName().getAsString() + " to " + parentNodeData.getQPath().getAsString() + " node type " + sName + " is not allowed as child's node type for parent node type " + parentNodeData.getPrimaryTypeName().getAsString());
            }
        }
        nodeData.addNodeType(this.nodeTypeDataManager.getNodeType(primaryTypeName));
        nodeData.setPrimaryTypeName(primaryTypeName);
        ImportPropertyData propertyData = new ImportPropertyData(QPath.makeChildPath(nodeData.getQPath(), this.propertyInfo.getName()), this.propertyInfo.getIndentifer(), 0, this.propertyInfo.getType(), nodeData.getIdentifier(), false);
        propertyData.setValues(this.parseValues());
        this.tree.push(nodeData);
        return propertyData;
    }

    private ImportPropertyData endProperty() throws PathNotFoundException, RepositoryException, NoSuchNodeTypeException, IllegalPathException, ValueFormatException {
        ImportPropertyData propertyData = null;
        if (Constants.JCR_PRIMARYTYPE.equals((Object)this.propertyInfo.getName())) {
            propertyData = this.endPrimaryType();
        } else if (Constants.JCR_MIXINTYPES.equals((Object)this.propertyInfo.getName())) {
            propertyData = this.endMixinTypes();
        } else if (Constants.JCR_UUID.equals((Object)this.propertyInfo.getName())) {
            propertyData = this.endUuid();
        } else if (!this.getParent().getQPath().isDescendantOf(Constants.JCR_VERSION_STORAGE_PATH) && (Constants.JCR_VERSIONHISTORY.equals((Object)this.propertyInfo.getName()) || Constants.JCR_BASEVERSION.equals((Object)this.propertyInfo.getName()) || Constants.JCR_PREDECESSORS.equals((Object)this.propertyInfo.getName()))) {
            propertyData = null;
            this.endVersionable((ImportNodeData)this.getParent(), this.parseValues());
        } else {
            ImportNodeData currentNodeInfo = (ImportNodeData)this.getParent();
            List<ValueData> values = this.parseValues();
            boolean isMultivalue = true;
            PropertyDefinitionDatas defs = this.nodeTypeDataManager.getPropertyDefinitions(this.propertyInfo.getName(), currentNodeInfo.getPrimaryTypeName(), currentNodeInfo.getMixinTypeNames());
            if (defs == null) {
                if (!((Boolean)this.context.get("respectPropertyDefinitionsConstraints")).booleanValue()) {
                    log.warn((Object)("Property definition not found for " + (Object)((Object)this.propertyInfo.getName())));
                    return null;
                }
                throw new RepositoryException("Property definition not found for " + (Object)((Object)this.propertyInfo.getName()));
            }
            if (values.size() == 1) {
                if (defs.getDefinition(false) != null) {
                    isMultivalue = false;
                }
            } else if (defs.getDefinition(true) == null && defs.getDefinition(false) != null) {
                throw new ValueFormatException("Can not assign multiple-values Value to a single-valued property " + this.propertyInfo.getName().getName());
            }
            log.debug((Object)("Import " + this.propertyInfo.getName().getName() + " size=" + this.propertyInfo.getValuesSize() + " isMultivalue=" + isMultivalue));
            propertyData = new ImportPropertyData(QPath.makeChildPath(currentNodeInfo.getQPath(), this.propertyInfo.getName()), this.propertyInfo.getIndentifer(), 0, this.propertyInfo.getType(), currentNodeInfo.getIdentifier(), isMultivalue);
            propertyData.setValues(values);
        }
        return propertyData;
    }

    private ImportPropertyData endUuid() throws RepositoryException, PathNotFoundException, IllegalPathException {
        ImportNodeData currentNodeInfo = (ImportNodeData)this.tree.pop();
        currentNodeInfo.setMixReferenceable(this.nodeTypeDataManager.isNodeType(Constants.MIX_REFERENCEABLE, currentNodeInfo.getPrimaryTypeName(), currentNodeInfo.getMixinTypeNames()));
        if (currentNodeInfo.isMixReferenceable()) {
            currentNodeInfo.setMixVersionable(this.nodeTypeDataManager.isNodeType(Constants.MIX_VERSIONABLE, currentNodeInfo.getPrimaryTypeName(), currentNodeInfo.getMixinTypeNames()));
            this.checkReferenceable(currentNodeInfo, this.propertyInfo.getValues().get(0).toString());
        }
        ImportPropertyData propertyData = new ImportPropertyData(QPath.makeChildPath(currentNodeInfo.getQPath(), this.propertyInfo.getName()), this.propertyInfo.getIndentifer(), 0, this.propertyInfo.getType(), currentNodeInfo.getIdentifier(), false);
        if (currentNodeInfo.getQPath().isDescendantOf(Constants.JCR_VERSION_STORAGE_PATH)) {
            propertyData.setValue(new TransientValueData(this.propertyInfo.getValues().get(0).toString()));
        } else {
            propertyData.setValue(new TransientValueData(currentNodeInfo.getIdentifier()));
        }
        this.tree.push(currentNodeInfo);
        this.mapNodePropertiesInfo.put(currentNodeInfo.getIdentifier(), new NodePropertiesInfo(currentNodeInfo));
        return propertyData;
    }

    private void endVersionable(ImportNodeData currentNodeInfo, List<ValueData> values) throws RepositoryException {
        try {
            if (this.propertyInfo.getName().equals((Object)Constants.JCR_VERSIONHISTORY)) {
                String versionHistoryIdentifier = null;
                versionHistoryIdentifier = ValueDataConvertor.readString(values.get(0));
                currentNodeInfo.setVersionHistoryIdentifier(versionHistoryIdentifier);
                currentNodeInfo.setContainsVersionhistory(this.dataConsumer.getItemData(versionHistoryIdentifier) != null);
            } else if (this.propertyInfo.getName().equals((Object)Constants.JCR_BASEVERSION)) {
                currentNodeInfo.setBaseVersionIdentifier(ValueDataConvertor.readString(values.get(0)));
            }
        }
        catch (IOException e) {
            throw new RepositoryException((Throwable)e);
        }
    }

    private List<ValueData> parseValues() throws RepositoryException {
        ArrayList<ValueData> values = new ArrayList<ValueData>(this.propertyInfo.getValuesSize());
        ArrayList<String> stringValues = new ArrayList<String>();
        for (int k = 0; k < this.propertyInfo.getValuesSize(); ++k) {
            if (this.propertyInfo.getType() == 2) {
                try {
                    InputStream vStream = this.propertyInfo.getValues().get(k).getInputStream();
                    TransientValueData binaryValue = new TransientValueData(k, null, vStream, null, this.valueFactory.getFileCleaner(), this.valueFactory.getMaxBufferSize(), null, true);
                    binaryValue.getAsStream().close();
                    vStream.close();
                    this.propertyInfo.getValues().get(k).remove();
                    values.add(binaryValue);
                    continue;
                }
                catch (IOException e) {
                    throw new RepositoryException((Throwable)e);
                }
            }
            String val = new String(this.propertyInfo.getValues().get(k).toString());
            stringValues.add(val);
            values.add(((BaseValue)this.valueFactory.createValue(val, this.propertyInfo.getType())).getInternalData());
        }
        if (this.propertyInfo.getType() == 100) {
            ImportNodeData currentNodeInfo = (ImportNodeData)this.getParent();
            currentNodeInfo.setExoPrivileges(stringValues);
        } else if (Constants.EXO_OWNER.equals((Object)this.propertyInfo.getName())) {
            ImportNodeData currentNodeInfo = (ImportNodeData)this.getParent();
            currentNodeInfo.setExoOwner((String)stringValues.get(0));
        }
        return values;
    }

    protected String getAttribute(Map<String, String> attributes, InternalQName name) throws RepositoryException {
        JCRName jname = this.locationFactory.createJCRName(name);
        return attributes.get(jname.getAsString());
    }

    protected class RemoveVisitor
    extends ItemDataRemoveVisitor {
        RemoveVisitor() throws RepositoryException {
            super(SystemViewImporter.this.dataConsumer, null, SystemViewImporter.this.nodeTypeDataManager, SystemViewImporter.this.accessManager, SystemViewImporter.this.userState);
        }

        protected void validateReferential(NodeData node) throws RepositoryException {
        }
    }
}

