/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.ecm.webui.component.explorer.popup.admin;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import javax.jcr.AccessDeniedException;
import javax.jcr.Node;
import javax.jcr.Property;
import javax.jcr.PropertyIterator;
import javax.jcr.Session;
import javax.jcr.Value;
import javax.jcr.ValueFormatException;
import javax.jcr.nodetype.NodeType;
import javax.jcr.nodetype.PropertyDefinition;
import org.exoplatform.ecm.webui.component.explorer.UIJCRExplorer;
import org.exoplatform.ecm.webui.component.explorer.popup.admin.UIPropertiesManager;
import org.exoplatform.ecm.webui.component.explorer.popup.admin.UIPropertyForm;
import org.exoplatform.ecm.webui.utils.PermissionUtil;
import org.exoplatform.services.log.ExoLogger;
import org.exoplatform.services.log.Log;
import org.exoplatform.web.application.ApplicationMessage;
import org.exoplatform.webui.config.annotation.ComponentConfig;
import org.exoplatform.webui.config.annotation.EventConfig;
import org.exoplatform.webui.core.UIApplication;
import org.exoplatform.webui.core.UIComponent;
import org.exoplatform.webui.core.UIContainer;
import org.exoplatform.webui.event.Event;
import org.exoplatform.webui.event.EventListener;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@ComponentConfig(template="app:/groovy/webui/component/explorer/popup/info/UIPropertyTab.gtmpl", events={@EventConfig(listeners={CloseActionListener.class}), @EventConfig(listeners={EditActionListener.class}), @EventConfig(listeners={DeleteActionListener.class}, confirm="UIPropertyTab.confirm.remove-property")})
public class UIPropertyTab
extends UIContainer {
    private static String[] PRO_BEAN_FIELD = new String[]{"icon", "name", "multiValue", "value", "action"};
    private static final String PRO_KEY_BINARYTYPE = "binary";
    private static final String PRO_KEY_CANNOTGET = "cannotget";
    private static final Log LOG = ExoLogger.getLogger((String)"explorer.UIPropertyTab");
    private List<String> propertiesName_ = new ArrayList<String>();

    public String[] getBeanFields() {
        return PRO_BEAN_FIELD;
    }

    public String[] getActions() {
        return new String[]{"Close"};
    }

    private Node getCurrentNode() throws Exception {
        UIPropertiesManager uiManager = (UIPropertiesManager)this.getParent();
        return uiManager.getCurrentNode();
    }

    public PropertyIterator getProperties() throws Exception {
        return this.getCurrentNode().getProperties();
    }

    private List<String> propertiesName() throws Exception {
        if (this.propertiesName_.size() == 0) {
            Node currentNode = this.getCurrentNode();
            NodeType nodetype = currentNode.getPrimaryNodeType();
            ArrayList<NodeType> types = new ArrayList<NodeType>();
            types.add(nodetype);
            NodeType[] mixins = currentNode.getMixinNodeTypes();
            if (mixins != null) {
                types.addAll(Arrays.asList(mixins));
            }
            for (NodeType nodeType : types) {
                for (PropertyDefinition property : nodeType.getPropertyDefinitions()) {
                    this.propertiesName_.add(property.getName());
                }
            }
        }
        return this.propertiesName_;
    }

    public boolean addedByUser(String propertyName) throws Exception {
        return !this.propertiesName().contains(propertyName);
    }

    public boolean isCanbeEdit(Property property) throws Exception {
        return !property.getDefinition().isAutoCreated() && !property.getDefinition().isProtected();
    }

    public String getPropertyValue(Property prop) throws Exception {
        if (prop.getType() == 2) {
            return PRO_KEY_BINARYTYPE;
        }
        boolean flag = true;
        try {
            if (prop.getDefinition() != null && prop.getDefinition().isMultiple()) {
                Value[] values = prop.getValues();
                StringBuilder sB = new StringBuilder();
                for (int i = 0; i < values.length; ++i) {
                    String uuid;
                    Node node;
                    if (prop.getType() == 9 && (node = this.getNodeByUUID(uuid = values[i].getString())) == null) {
                        if (i != 0) continue;
                        flag = false;
                        continue;
                    }
                    if (i > 0 && flag) {
                        sB.append("; ");
                    }
                    sB.append(values[i].getString());
                    flag = true;
                }
                return sB.toString();
            }
            return prop.getString();
        }
        catch (ValueFormatException ve) {
            return PRO_KEY_CANNOTGET;
        }
        catch (Exception e) {
            return PRO_KEY_CANNOTGET;
        }
    }

    public Node getNodeByUUID(String uuid) {
        Node node = null;
        try {
            UIJCRExplorer uiExplorer = (UIJCRExplorer)this.getAncestorOfType(UIJCRExplorer.class);
            Session session = uiExplorer.getSession();
            node = session.getNodeByUUID(uuid);
        }
        catch (Exception exception) {
            // empty catch block
        }
        return node;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class DeleteActionListener
    extends EventListener<UIPropertyTab> {
        public void execute(Event<UIPropertyTab> event) throws Exception {
            UIPropertyTab uiPropertyTab = (UIPropertyTab)((Object)event.getSource());
            String propertyName = event.getRequestContext().getRequestParameter("objectId");
            Node currentNode = uiPropertyTab.getCurrentNode();
            UIApplication uiApp = (UIApplication)uiPropertyTab.getAncestorOfType(UIApplication.class);
            try {
                if (currentNode.hasProperty(propertyName)) {
                    currentNode.getProperty(propertyName).remove();
                }
                currentNode.save();
                event.getRequestContext().addUIComponentToUpdateByAjax(uiPropertyTab.getParent());
                return;
            }
            catch (AccessDeniedException ace) {
                uiApp.addMessage(new ApplicationMessage("UIActionBar.msg.access-denied", null, 1));
                event.getRequestContext().addUIComponentToUpdateByAjax((UIComponent)uiApp.getUIPopupMessages());
                return;
            }
            catch (Exception e) {
                LOG.error((Object)"Unexpected error", (Throwable)e);
                return;
            }
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class EditActionListener
    extends EventListener<UIPropertyTab> {
        public void execute(Event<UIPropertyTab> event) throws Exception {
            UIPropertyTab uiPropertyTab = (UIPropertyTab)((Object)event.getSource());
            UIPropertiesManager uiManager = (UIPropertiesManager)uiPropertyTab.getParent();
            UIApplication uiApp = (UIApplication)uiManager.getAncestorOfType(UIApplication.class);
            UIJCRExplorer uiExplorer = (UIJCRExplorer)uiManager.getAncestorOfType(UIJCRExplorer.class);
            Node currentNode = uiExplorer.getCurrentNode();
            if (!PermissionUtil.canSetProperty((Node)currentNode)) {
                uiApp.addMessage(new ApplicationMessage("UIActionBar.msg.access-denied", null, 1));
                event.getRequestContext().addUIComponentToUpdateByAjax((UIComponent)uiApp.getUIPopupMessages());
                return;
            }
            if (uiExplorer.nodeIsLocked(currentNode)) {
                Object[] arg = new Object[]{currentNode.getPath()};
                uiApp.addMessage(new ApplicationMessage("UIPopupMenu.msg.node-locked", arg));
                event.getRequestContext().addUIComponentToUpdateByAjax((UIComponent)uiApp.getUIPopupMessages());
                return;
            }
            if (!currentNode.isCheckedOut()) {
                uiApp.addMessage(new ApplicationMessage("UIActionBar.msg.node-checkedin", null));
                event.getRequestContext().addUIComponentToUpdateByAjax((UIComponent)uiApp.getUIPopupMessages());
                return;
            }
            String propertyName = event.getRequestContext().getRequestParameter("objectId");
            UIPropertyForm uiForm = (UIPropertyForm)uiManager.getChild(UIPropertyForm.class);
            if (uiForm == null) {
                uiForm = (UIPropertyForm)uiManager.addChild(UIPropertyForm.class, null, null);
                uiForm.init(currentNode);
            }
            uiForm.loadForm(propertyName);
            uiManager.setIsEditProperty(true);
            uiManager.setRenderedChild(UIPropertyForm.class);
            uiPropertyTab.setRendered(false);
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class CloseActionListener
    extends EventListener<UIPropertyTab> {
        public void execute(Event<UIPropertyTab> event) throws Exception {
            ((UIJCRExplorer)((UIPropertyTab)((Object)event.getSource())).getAncestorOfType(UIJCRExplorer.class)).cancelAction();
        }
    }
}

