/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.ecm.webui.component.explorer.search;

import javax.jcr.AccessDeniedException;
import org.exoplatform.ecm.webui.component.explorer.search.UIECMSearch;
import org.exoplatform.ecm.webui.component.explorer.search.UISavedQuery;
import org.exoplatform.ecm.webui.component.explorer.search.UISearchContainer;
import org.exoplatform.ecm.webui.form.validator.ECMNameValidator;
import org.exoplatform.portal.webui.util.Util;
import org.exoplatform.services.cms.queries.QueryService;
import org.exoplatform.web.application.ApplicationMessage;
import org.exoplatform.webui.config.annotation.ComponentConfig;
import org.exoplatform.webui.config.annotation.EventConfig;
import org.exoplatform.webui.core.UIApplication;
import org.exoplatform.webui.core.UIComponent;
import org.exoplatform.webui.core.UIPopupComponent;
import org.exoplatform.webui.core.UIPopupContainer;
import org.exoplatform.webui.core.lifecycle.UIFormLifecycle;
import org.exoplatform.webui.event.Event;
import org.exoplatform.webui.event.EventListener;
import org.exoplatform.webui.form.UIForm;
import org.exoplatform.webui.form.UIFormInput;
import org.exoplatform.webui.form.UIFormStringInput;

@ComponentConfig(lifecycle=UIFormLifecycle.class, template="system:/groovy/webui/form/UIForm.gtmpl", events={@EventConfig(listeners={SaveActionListener.class}), @EventConfig(listeners={CancelActionListener.class}, phase=Event.Phase.DECODE)})
public class UISaveQueryForm
extends UIForm
implements UIPopupComponent {
    public static final String QUERY_NAME = "queryName";
    private String statement_;
    private boolean isSimpleSearch_ = false;
    private String queryType_;

    public UISaveQueryForm() throws Exception {
        this.addUIFormInput((UIFormInput)new UIFormStringInput(QUERY_NAME, QUERY_NAME, null).addValidator(ECMNameValidator.class, new Object[0]));
    }

    public void activate() throws Exception {
    }

    public void deActivate() throws Exception {
    }

    public void setSimpleSearch(boolean isSimpleSearch) {
        this.isSimpleSearch_ = isSimpleSearch;
    }

    public void setStatement(String statement) {
        this.statement_ = statement;
    }

    public void setQueryType(String queryType) {
        this.queryType_ = queryType;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class CancelActionListener
    extends EventListener<UISaveQueryForm> {
        public void execute(Event<UISaveQueryForm> event) throws Exception {
            UISearchContainer uiSearchContainer = (UISearchContainer)((UISaveQueryForm)((Object)event.getSource())).getAncestorOfType(UISearchContainer.class);
            UIPopupContainer uiPopup = (UIPopupContainer)uiSearchContainer.getChild(UIPopupContainer.class);
            uiPopup.deActivate();
            event.getRequestContext().addUIComponentToUpdateByAjax((UIComponent)uiPopup);
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class SaveActionListener
    extends EventListener<UISaveQueryForm> {
        public void execute(Event<UISaveQueryForm> event) throws Exception {
            UISaveQueryForm uiSaveQueryForm = (UISaveQueryForm)((Object)event.getSource());
            UIECMSearch uiECMSearch = (UIECMSearch)uiSaveQueryForm.getAncestorOfType(UIECMSearch.class);
            UIApplication uiApp = (UIApplication)uiSaveQueryForm.getAncestorOfType(UIApplication.class);
            String userName = Util.getPortalRequestContext().getRemoteUser();
            QueryService queryService = (QueryService)uiSaveQueryForm.getApplicationComponent(QueryService.class);
            String queryName = (String)uiSaveQueryForm.getUIStringInput(UISaveQueryForm.QUERY_NAME).getValue();
            if (queryName == null || queryName.trim().length() == 0) {
                uiApp.addMessage(new ApplicationMessage("UISaveQueryForm.msg.query-name-null", null));
                event.getRequestContext().addUIComponentToUpdateByAjax((UIComponent)uiApp.getUIPopupMessages());
                return;
            }
            try {
                queryService.addQuery(queryName, uiSaveQueryForm.statement_, uiSaveQueryForm.queryType_, userName);
            }
            catch (AccessDeniedException ace) {
                uiApp.addMessage(new ApplicationMessage("UISaveQueryForm.msg.access-denied", null, 1));
                event.getRequestContext().addUIComponentToUpdateByAjax((UIComponent)uiApp.getUIPopupMessages());
                return;
            }
            catch (Exception e) {
                uiApp.addMessage(new ApplicationMessage("UISaveQueryForm.msg.save-failed", null, 1));
                event.getRequestContext().addUIComponentToUpdateByAjax((UIComponent)uiApp.getUIPopupMessages());
                return;
            }
            ((UISavedQuery)uiECMSearch.getChild(UISavedQuery.class)).updateGrid(1);
            if (uiSaveQueryForm.isSimpleSearch_) {
                UISearchContainer uiSearchContainer = (UISearchContainer)uiSaveQueryForm.getAncestorOfType(UISearchContainer.class);
                UIPopupContainer uiPopup = (UIPopupContainer)uiSearchContainer.getChild(UIPopupContainer.class);
                uiPopup.deActivate();
            }
            uiECMSearch.setRenderedChild(UISavedQuery.class);
            event.getRequestContext().addUIComponentToUpdateByAjax((UIComponent)uiECMSearch);
        }
    }
}

