/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.ecm.webui.component.explorer.search;

import java.util.ArrayList;
import java.util.List;
import javax.jcr.AccessDeniedException;
import javax.jcr.Node;
import javax.jcr.RepositoryException;
import javax.jcr.query.Query;
import javax.jcr.query.QueryResult;
import org.exoplatform.commons.utils.LazyPageList;
import org.exoplatform.commons.utils.ListAccess;
import org.exoplatform.commons.utils.ListAccessImpl;
import org.exoplatform.commons.utils.PageList;
import org.exoplatform.ecm.webui.component.explorer.UIDocumentWorkspace;
import org.exoplatform.ecm.webui.component.explorer.UIJCRExplorer;
import org.exoplatform.ecm.webui.component.explorer.UIWorkingArea;
import org.exoplatform.ecm.webui.component.explorer.search.UIECMSearch;
import org.exoplatform.ecm.webui.component.explorer.search.UIJCRAdvancedSearch;
import org.exoplatform.ecm.webui.component.explorer.search.UISearchResult;
import org.exoplatform.portal.webui.util.Util;
import org.exoplatform.services.cms.queries.QueryService;
import org.exoplatform.services.wcm.core.NodeLocation;
import org.exoplatform.services.wcm.utils.WCMCoreUtils;
import org.exoplatform.web.application.ApplicationMessage;
import org.exoplatform.webui.application.WebuiRequestContext;
import org.exoplatform.webui.application.portlet.PortletRequestContext;
import org.exoplatform.webui.config.annotation.ComponentConfig;
import org.exoplatform.webui.config.annotation.EventConfig;
import org.exoplatform.webui.core.UIApplication;
import org.exoplatform.webui.core.UIComponent;
import org.exoplatform.webui.core.UIContainer;
import org.exoplatform.webui.core.UIPageIterator;
import org.exoplatform.webui.core.UIPopupComponent;
import org.exoplatform.webui.core.UIPopupContainer;
import org.exoplatform.webui.core.UIPopupWindow;
import org.exoplatform.webui.event.Event;
import org.exoplatform.webui.event.EventListener;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@ComponentConfig(template="app:/groovy/webui/component/explorer/search/UISavedQuery.gtmpl", events={@EventConfig(listeners={ExecuteActionListener.class}), @EventConfig(listeners={DeleteActionListener.class}, confirm="UISavedQuery.msg.confirm-delete-query"), @EventConfig(listeners={EditActionListener.class})})
public class UISavedQuery
extends UIContainer
implements UIPopupComponent {
    public static final String EDIT_FORM = "EditSavedQueryForm";
    private UIPageIterator uiPageIterator_ = (UIPageIterator)this.addChild(UIPageIterator.class, null, "SavedQueryIterator");
    private boolean isQuickSearch_ = false;

    public void updateGrid(int currentPage) throws Exception {
        ListAccessImpl queryList = new ListAccessImpl(Object.class, NodeLocation.getLocationsByNodeList(this.queryList()));
        LazyPageList pageList = new LazyPageList((ListAccess)queryList, 10);
        this.uiPageIterator_.setPageList((PageList)pageList);
        if (currentPage > this.uiPageIterator_.getAvailablePage()) {
            this.uiPageIterator_.setCurrentPage(this.uiPageIterator_.getAvailablePage());
        } else {
            this.uiPageIterator_.setCurrentPage(currentPage);
        }
    }

    public List<Object> queryList() throws Exception {
        List<Query> queries;
        ArrayList<Object> objectList = new ArrayList<Object>();
        List<Node> sharedQueries = this.getSharedQueries();
        if (!sharedQueries.isEmpty()) {
            for (Node node : sharedQueries) {
                objectList.add(node);
            }
        }
        if (!(queries = this.getQueries()).isEmpty()) {
            for (Query query : queries) {
                objectList.add(new QueryData(query));
            }
        }
        return objectList;
    }

    public UIPageIterator getUIPageIterator() {
        return this.uiPageIterator_;
    }

    public List getQueryList() throws Exception {
        return NodeLocation.getNodeListByLocationList((List)this.uiPageIterator_.getCurrentPageData());
    }

    public void initPopupEditForm(Query query) throws Exception {
        this.removeChildById(EDIT_FORM);
        UIPopupWindow uiPopup = (UIPopupWindow)this.addChild(UIPopupWindow.class, null, EDIT_FORM);
        uiPopup.setWindowSize(500, 0);
        UIJCRAdvancedSearch uiJAdvancedSearch = (UIJCRAdvancedSearch)this.createUIComponent(UIJCRAdvancedSearch.class, null, "EditQueryForm");
        uiJAdvancedSearch.setActions(new String[]{"Save", "Cancel"});
        uiPopup.setUIComponent((UIComponent)uiJAdvancedSearch);
        uiPopup.setRendered(true);
        uiJAdvancedSearch.setIsEdit(true);
        uiJAdvancedSearch.setQuery(query);
        uiJAdvancedSearch.update(query);
        uiPopup.setShow(true);
        uiPopup.setResizable(true);
    }

    public List<Query> getQueries() throws Exception {
        QueryService queryService = (QueryService)this.getApplicationComponent(QueryService.class);
        try {
            return queryService.getQueries(this.getCurrentUserId(), WCMCoreUtils.getUserSessionProvider());
        }
        catch (AccessDeniedException ace) {
            return new ArrayList<Query>();
        }
    }

    public String getCurrentUserId() {
        return Util.getPortalRequestContext().getRemoteUser();
    }

    public List<Node> getSharedQueries() throws Exception {
        PortletRequestContext pcontext = (PortletRequestContext)WebuiRequestContext.getCurrentInstance();
        QueryService queryService = (QueryService)this.getApplicationComponent(QueryService.class);
        String userId = pcontext.getRemoteUser();
        return queryService.getSharedQueries(userId, WCMCoreUtils.getSystemSessionProvider());
    }

    public void activate() throws Exception {
    }

    public void deActivate() throws Exception {
    }

    public void setIsQuickSearch(boolean isQuickSearch) {
        this.isQuickSearch_ = isQuickSearch;
    }

    public class QueryData {
        private String language_;
        private String statement_;
        private String storedQueryPath_;

        public QueryData(Query query) {
            this.language_ = query.getLanguage();
            this.statement_ = query.getStatement();
            try {
                this.storedQueryPath_ = query.getStoredQueryPath();
            }
            catch (RepositoryException e) {
                this.storedQueryPath_ = "";
            }
        }

        public String getLanguage() {
            return this.language_;
        }

        public void setLanguage(String language) {
            this.language_ = language;
        }

        public String getStatement() {
            return this.statement_;
        }

        public void setStatement(String statement) {
            this.statement_ = statement;
        }

        public String getStoredQueryPath() {
            return this.storedQueryPath_;
        }

        public void setStoredQueryPath(String storedQueryPath) {
            this.storedQueryPath_ = storedQueryPath;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class DeleteActionListener
    extends EventListener<UISavedQuery> {
        public void execute(Event<UISavedQuery> event) throws Exception {
            UISavedQuery uiQuery = (UISavedQuery)((Object)event.getSource());
            String userName = Util.getPortalRequestContext().getRemoteUser();
            QueryService queryService = (QueryService)uiQuery.getApplicationComponent(QueryService.class);
            String path = event.getRequestContext().getRequestParameter("objectId");
            queryService.removeQuery(path, userName);
            uiQuery.updateGrid(uiQuery.getUIPageIterator().getCurrentPage());
            event.getRequestContext().addUIComponentToUpdateByAjax((UIComponent)uiQuery);
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class EditActionListener
    extends EventListener<UISavedQuery> {
        public void execute(Event<UISavedQuery> event) throws Exception {
            UISavedQuery uiQuery = (UISavedQuery)((Object)event.getSource());
            String userName = Util.getPortalRequestContext().getRemoteUser();
            QueryService queryService = (QueryService)uiQuery.getApplicationComponent(QueryService.class);
            String queryPath = event.getRequestContext().getRequestParameter("objectId");
            Query query = queryService.getQueryByPath(queryPath, userName, WCMCoreUtils.getSystemSessionProvider());
            uiQuery.initPopupEditForm(query);
            if (!uiQuery.isQuickSearch_) {
                UIECMSearch uiECSearch = (UIECMSearch)uiQuery.getParent();
                uiECSearch.setRenderedChild(UISavedQuery.class);
                event.getRequestContext().addUIComponentToUpdateByAjax((UIComponent)uiECSearch);
            } else {
                event.getRequestContext().addUIComponentToUpdateByAjax(uiQuery.getParent());
            }
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class ExecuteActionListener
    extends EventListener<UISavedQuery> {
        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         * Enabled aggressive block sorting
         * Enabled unnecessary exception pruning
         * Enabled aggressive exception aggregation
         */
        public void execute(Event<UISavedQuery> event) throws Exception {
            Query query;
            UISearchResult uiSearchResult;
            UIComponent uiSearch;
            String wsName;
            UIJCRExplorer uiExplorer;
            UISavedQuery uiQuery;
            block17: {
                UIApplication uiApp;
                block16: {
                    uiQuery = (UISavedQuery)((Object)event.getSource());
                    uiExplorer = (UIJCRExplorer)uiQuery.getAncestorOfType(UIJCRExplorer.class);
                    wsName = ((UIJCRExplorer)uiQuery.getAncestorOfType(UIJCRExplorer.class)).getCurrentWorkspace();
                    uiApp = (UIApplication)uiQuery.getAncestorOfType(UIApplication.class);
                    QueryService queryService = (QueryService)uiQuery.getApplicationComponent(QueryService.class);
                    String queryPath = event.getRequestContext().getRequestParameter("objectId");
                    uiSearch = null;
                    uiSearchResult = null;
                    if (uiQuery.isQuickSearch_) {
                        uiSearch = ((UIWorkingArea)uiExplorer.getChild(UIWorkingArea.class)).getChild(UIDocumentWorkspace.class);
                        uiSearchResult = (UISearchResult)((UIDocumentWorkspace)uiSearch).getChild(UISearchResult.class);
                    } else {
                        uiSearch = uiQuery.getParent();
                        ((UIECMSearch)uiSearch).setRenderedChild(UISearchResult.class);
                        uiSearchResult = (UISearchResult)((UIECMSearch)uiSearch).getChild(UISearchResult.class);
                    }
                    query = null;
                    QueryResult queryResult = null;
                    try {
                        try {
                            query = queryService.getQuery(queryPath, wsName, WCMCoreUtils.getSystemSessionProvider(), uiQuery.getCurrentUserId());
                            queryResult = query.execute();
                        }
                        catch (Exception e) {
                            uiApp.addMessage(new ApplicationMessage("UISearchResult.msg.query-invalid", null, 1));
                            if (!uiQuery.isQuickSearch_) {
                                ((UIECMSearch)uiSearch).setRenderedChild(UISavedQuery.class);
                            }
                            Object var14_13 = null;
                            if (queryResult != null && queryResult.getNodes().getSize() != 0L) {
                                uiSearchResult.setQuery(query.getStatement(), wsName, query.getLanguage(), true, null);
                                uiSearchResult.updateGrid();
                                return;
                            }
                            uiApp.addMessage(new ApplicationMessage("UISavedQuery.msg.not-result-found", null));
                            event.getRequestContext().addUIComponentToUpdateByAjax((UIComponent)uiApp.getUIPopupMessages());
                            if (!uiQuery.isQuickSearch_) {
                                ((UIECMSearch)uiSearch).setRenderedChild(UISavedQuery.class);
                            }
                            return;
                        }
                        Object var14_12 = null;
                        if (queryResult == null) break block16;
                    }
                    catch (Throwable throwable) {
                        Object var14_14 = null;
                        if (queryResult != null && queryResult.getNodes().getSize() != 0L) {
                            uiSearchResult.setQuery(query.getStatement(), wsName, query.getLanguage(), true, null);
                            uiSearchResult.updateGrid();
                            throw throwable;
                        }
                        uiApp.addMessage(new ApplicationMessage("UISavedQuery.msg.not-result-found", null));
                        event.getRequestContext().addUIComponentToUpdateByAjax((UIComponent)uiApp.getUIPopupMessages());
                        if (!uiQuery.isQuickSearch_) {
                            ((UIECMSearch)uiSearch).setRenderedChild(UISavedQuery.class);
                        }
                        return;
                    }
                    if (queryResult.getNodes().getSize() != 0L) break block17;
                }
                uiApp.addMessage(new ApplicationMessage("UISavedQuery.msg.not-result-found", null));
                event.getRequestContext().addUIComponentToUpdateByAjax((UIComponent)uiApp.getUIPopupMessages());
                if (!uiQuery.isQuickSearch_) {
                    ((UIECMSearch)uiSearch).setRenderedChild(UISavedQuery.class);
                }
                return;
            }
            uiSearchResult.setQuery(query.getStatement(), wsName, query.getLanguage(), true, null);
            uiSearchResult.updateGrid();
            if (uiQuery.isQuickSearch_) {
                ((UIDocumentWorkspace)uiSearch).setRenderedChild(UISearchResult.class);
                UIPopupContainer uiPopup = (UIPopupContainer)uiExplorer.getChild(UIPopupContainer.class);
                uiPopup.deActivate();
            }
        }
    }
}

