/*
 * Decompiled with CFR 0.152.
 */
package com.google.caja.parser.html;

import com.google.caja.lexer.CharProducer;
import com.google.caja.lexer.FilePosition;
import com.google.caja.lexer.InputSource;
import com.google.caja.parser.html.DomParser;
import com.google.caja.parser.html.HtmlQuasiBuilder;
import com.google.caja.parser.html.Nodes;
import com.google.caja.util.Lists;
import com.google.caja.util.MoreAsserts;
import java.net.URI;
import java.util.Arrays;
import java.util.List;
import junit.framework.TestCase;
import org.w3c.dom.Attr;
import org.w3c.dom.Document;
import org.w3c.dom.DocumentFragment;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.Text;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class HtmlQuasiBuilderTest
extends TestCase {
    private HtmlQuasiBuilder hb;

    public void setUp() throws Exception {
        super.setUp();
        this.hb = HtmlQuasiBuilder.getBuilder(DomParser.makeDocument(null, null));
    }

    public final void testSubstV() {
        HtmlQuasiBuilderTest.assertEquals((String)"<b title=\"My title\">&lt;Hello&gt;</b>", (String)Nodes.render(this.hb.substV("<b title=@title>@text</b>", "title", "My title", "text", "<Hello>")));
        HtmlQuasiBuilderTest.assertEquals((String)"<b title=\"My title\">&lt;Hello&gt;</b>", (String)Nodes.render(this.hb.substV("<b title=\"@title\">@text</b>", "title", "My title", "text", "<Hello>")));
        HtmlQuasiBuilderTest.assertEquals((String)"<b title=\"My title\">&lt;Hello&gt;</b>", (String)Nodes.render(this.hb.substV("<b title='@title'>@text</b>", "title", "My title", "text", "<Hello>")));
        HtmlQuasiBuilderTest.assertEquals((String)"<b title=\"My title\">Hello <i>World</i></b>", (String)Nodes.render(this.hb.substV("<b title=@title>@a  @b</b>", "title", "My title", "a", "Hello", "b", this.hb.substV("<i>@t</i>", "t", "World"))));
        HtmlQuasiBuilderTest.assertEquals((String)"<b title=\"My title\"><i>Hello</i> World</b>", (String)Nodes.render(this.hb.substV("<b title=@title>@text</b>", "title", "My title", "text", this.hb.substV("<i>@w1</i>@w2", "w1", "Hello", "w2", " World"))));
        HtmlQuasiBuilderTest.assertEquals((String)"<select class=\"type-select\"></select>", (String)Nodes.render(this.hb.substV("<select class=type-select></select>", new Object[0])));
        HtmlQuasiBuilderTest.assertEquals((String)"<table summary=\"&#34;Quoted&#34;, a &lt; b &amp;&amp; c &gt; d\"><tbody><tr><td>&lt;&#34;Quoted&#34;, a &lt; b &amp;&amp; c &gt; d&gt;</td></tr></tbody></table>", (String)Nodes.render(this.hb.substV("<table summary=@s><tr><td>&lt;@s></table>", "s", "\"Quoted\", a < b && c > d")));
    }

    public final void testFramesetsAndBodies() throws Exception {
        HtmlQuasiBuilderTest.assertEquals((String)"<html><head></head><body>Hello</body></html>", (String)Nodes.render(this.hb.substV("<html><head></head><body>@text</body></html>", "text", "Hello")));
        HtmlQuasiBuilderTest.assertEquals((String)"<html><head></head><body><div>Hello</div></body></html>", (String)Nodes.render(this.hb.substV("<html><head></head><body>@div</body></html>", "div", this.hb.toFragment("<div>Hello</div>"))));
        HtmlQuasiBuilderTest.assertEquals((String)"<html><head></head><frameset><frame src=\"foo.html\"></frame></frameset></html>", (String)Nodes.render(this.hb.substV("<html><head></head><body>@fs</body></html>", "fs", this.hb.toFragment("<frameset><frame src=foo.html></frameset>"))));
        HtmlQuasiBuilderTest.assertEquals((String)"<html><head></head><frameset><frame src=\"foo.html\"></frame></frameset></html>", (String)Nodes.render(this.hb.substV("<html><head></head>@fs</html>", "fs", this.hb.toFragment("<frameset><frame src=foo.html></frameset>"))));
        HtmlQuasiBuilderTest.assertEquals((String)"<html><head></head>  <frameset><frame src=\"foo.html\"></frame></frameset></html>", (String)Nodes.render(this.hb.substV("<html><head></head>  @fs  </html>", "fs", this.hb.toFragment("<frameset><frame src=foo.html></frameset>"))));
    }

    public final void testAttributeValues() {
        HtmlQuasiBuilderTest.assertEquals((String)"<input checked=\"checked\" type=\"checkbox\" />", (String)Nodes.render(this.hb.substV("<input checked='@checked' type=@type>", "type", "checkbox", "checked", true)));
        HtmlQuasiBuilderTest.assertEquals((String)"<input type=\"radio\" />", (String)Nodes.render(this.hb.substV("<input checked=\"@checked\" type=@type />", "type", "radio", "checked", false)));
        HtmlQuasiBuilderTest.assertEquals((String)"<select><option selected=\"selected\">Foo</option></select>", (String)Nodes.render(this.hb.substV("<select><option SELECTED=\"@selected\">Foo</option></select>", "selected", true)));
    }

    public final void testMultiUse() throws Exception {
        HtmlQuasiBuilderTest.assertEquals((String)"<br /><br />@x<br />", (String)Nodes.render(this.hb.substV("@x@x&#64;x@x", "x", this.hb.toFragment("<br />"))));
    }

    public final void testToFragment() throws Exception {
        DocumentFragment f = this.hb.toFragment("&mdash;");
        HtmlQuasiBuilderTest.assertEquals((String)"\u2014", (String)((Text)f.getFirstChild()).getNodeValue());
        HtmlQuasiBuilderTest.assertEquals((String)"&#8212;", (String)Nodes.render(f));
    }

    public final void testFilePositions() throws Exception {
        Document inputDoc = DomParser.makeDocument(null, null);
        InputSource is = new InputSource(URI.create("p:///x"));
        String forty = "0123456789012345678901234567890123456789";
        CharProducer cp = CharProducer.Factory.fromString((CharSequence)("\n\n\n" + forty + "\n\n" + forty + "\n    \n" + forty), is);
        Attr title = inputDoc.createAttributeNS("http://www.w3.org/1999/xhtml", "description");
        title.setNodeValue("Hello, World!");
        Nodes.setFilePositionFor(title, cp.filePositionForOffsets(12, 42));
        Nodes.setFilePositionForValue(title, cp.filePositionForOffsets(22, 42));
        Text boldText = inputDoc.createTextNode("BOLD!");
        Text italicText = inputDoc.createTextNode("/74l1c");
        Element italicEl = inputDoc.createElementNS("http://www.w3.org/1999/xhtml", "SPAN");
        italicEl.appendChild(italicText);
        italicEl.setAttributeNS("http://www.w3.org/1999/xhtml", "id", "i");
        Nodes.setFilePositionFor(italicEl, cp.filePositionForOffsets(49, 79));
        Node n = this.hb.substV("<b title=@title>@boldText</b>@plainText<i>@italicEl</i>", "title", title, "boldText", boldText, "plainText", "Plain Text", "italicEl", italicEl);
        MoreAsserts.assertListsEqual(Arrays.asList("#document-fragment : ???", "  b : ???", "    title : /x@4+10 - 40", "      #text : /x@4+20 - 40", "    #text : ???", "  #text : ???", "  i : ???", "    SPAN : /x@6+5 - 35", "      id : ???", "        #text : ???", "      #text : ???"), HtmlQuasiBuilderTest.nodePositions(n));
        HtmlQuasiBuilder.usePosition(cp.filePositionForOffsets(0, 100), n);
        HtmlQuasiBuilderTest.assertEquals((String)"<b title=\"Hello, World!\">BOLD!</b>Plain Text<i><span id=\"i\">/74l1c</span></i>", (String)Nodes.render(n));
        MoreAsserts.assertListsEqual(Arrays.asList("#document-fragment : /x@1+1 - 8+10", "  b : /x@4+10 - 40", "    title : /x@4+10 - 40", "      #text : /x@4+20 - 40", "    #text : /x@4+40", "  #text : /x@4+40", "  i : /x@4+40 - 6+35", "    SPAN : /x@6+5 - 35", "      id : /x@6+5", "        #text : /x@6+5", "      #text : /x@6+5"), HtmlQuasiBuilderTest.nodePositions(n));
    }

    public final void testProblematicElements() {
        HtmlQuasiBuilderTest.assertEquals((String)"option", (String)HtmlQuasiBuilderTest.onlyElement(this.hb.substV("<option>Foo</option>", new Object[0])).getLocalName());
        HtmlQuasiBuilderTest.assertEquals((String)"option", (String)HtmlQuasiBuilderTest.onlyElement(this.hb.substV("<OPTION>Foo</OPTION>", new Object[0])).getLocalName());
        HtmlQuasiBuilderTest.assertEquals((String)"thead", (String)HtmlQuasiBuilderTest.onlyElement(this.hb.substV("<thead>Foo</thead>", new Object[0])).getLocalName());
        HtmlQuasiBuilderTest.assertEquals((String)"tbody", (String)HtmlQuasiBuilderTest.onlyElement(this.hb.substV("<tbody>Foo</tbody>", new Object[0])).getLocalName());
        HtmlQuasiBuilderTest.assertEquals((String)"tfoot", (String)HtmlQuasiBuilderTest.onlyElement(this.hb.substV("<tfoot></tfoot>", new Object[0])).getLocalName());
        HtmlQuasiBuilderTest.assertEquals((String)"caption", (String)HtmlQuasiBuilderTest.onlyElement(this.hb.substV("<caption>Foo</caption>", new Object[0])).getLocalName());
        HtmlQuasiBuilderTest.assertEquals((String)"tr", (String)HtmlQuasiBuilderTest.onlyElement(this.hb.substV("<tr><td>Foo</td></tr>", new Object[0])).getLocalName());
        HtmlQuasiBuilderTest.assertEquals((String)"td", (String)HtmlQuasiBuilderTest.onlyElement(this.hb.substV("<td>Foo</td>", new Object[0])).getLocalName());
        HtmlQuasiBuilderTest.assertEquals((String)"th", (String)HtmlQuasiBuilderTest.onlyElement(this.hb.substV("<th>Foo</th>", new Object[0])).getLocalName());
        HtmlQuasiBuilderTest.assertEquals((String)"p", (String)HtmlQuasiBuilderTest.onlyElement(this.hb.substV("<p>Not problematic", new Object[0])).getLocalName());
    }

    private static Element onlyElement(Node node) {
        HtmlQuasiBuilderTest.assertTrue((String)node.getNodeName(), (boolean)(node instanceof DocumentFragment));
        Element el = (Element)node.getFirstChild();
        HtmlQuasiBuilderTest.assertNotNull((Object)el);
        HtmlQuasiBuilderTest.assertNull((String)("" + el.getNextSibling()), (Object)el.getNextSibling());
        return el;
    }

    private static List<String> nodePositions(Node n) {
        List<String> out = Lists.newArrayList();
        HtmlQuasiBuilderTest.appendNodePositions(n, 0, out);
        return out;
    }

    private static void appendNodePositions(Node n, int depth, List<String> out) {
        StringBuilder sb = new StringBuilder();
        int i = depth;
        while (--i >= 0) {
            sb.append("  ");
        }
        sb.append(n.getNodeName()).append(" : ");
        FilePosition p = Nodes.getFilePositionFor(n);
        if (InputSource.UNKNOWN.equals(p.source())) {
            sb.append("???");
        } else {
            sb.append(p.source().getUri().getPath()).append('@').append(p.startLineNo()).append('+').append(p.startCharInLine());
            if (p.length() != 0) {
                sb.append(" - ");
                if (p.endLineNo() != p.startLineNo()) {
                    sb.append(p.endLineNo()).append('+');
                }
                sb.append(p.endCharInLine());
            }
        }
        out.add(sb.toString());
        if (n instanceof Element) {
            for (Attr attr : Nodes.attributesOf((Element)n)) {
                HtmlQuasiBuilderTest.appendNodePositions(attr, depth + 1, out);
            }
        }
        for (Node node : Nodes.childrenOf(n)) {
            HtmlQuasiBuilderTest.appendNodePositions(node, depth + 1, out);
        }
    }
}

