/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.services.jcr.impl.dataflow.persistent.infinispan;

import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.NoSuchElementException;
import java.util.Set;
import java.util.concurrent.CopyOnWriteArrayList;
import javax.jcr.RepositoryException;
import javax.transaction.TransactionManager;
import org.exoplatform.container.configuration.ConfigurationManager;
import org.exoplatform.management.annotations.Managed;
import org.exoplatform.management.annotations.ManagedDescription;
import org.exoplatform.services.jcr.access.AccessControlList;
import org.exoplatform.services.jcr.config.CacheEntry;
import org.exoplatform.services.jcr.config.RepositoryConfigurationException;
import org.exoplatform.services.jcr.config.WorkspaceEntry;
import org.exoplatform.services.jcr.dataflow.ItemState;
import org.exoplatform.services.jcr.dataflow.ItemStateChangesLog;
import org.exoplatform.services.jcr.dataflow.persistent.WorkspaceStorageCache;
import org.exoplatform.services.jcr.dataflow.persistent.WorkspaceStorageCacheListener;
import org.exoplatform.services.jcr.datamodel.IllegalPathException;
import org.exoplatform.services.jcr.datamodel.InternalQName;
import org.exoplatform.services.jcr.datamodel.ItemData;
import org.exoplatform.services.jcr.datamodel.ItemType;
import org.exoplatform.services.jcr.datamodel.NodeData;
import org.exoplatform.services.jcr.datamodel.NullItemData;
import org.exoplatform.services.jcr.datamodel.NullNodeData;
import org.exoplatform.services.jcr.datamodel.NullPropertyData;
import org.exoplatform.services.jcr.datamodel.PropertyData;
import org.exoplatform.services.jcr.datamodel.QPath;
import org.exoplatform.services.jcr.datamodel.QPathEntry;
import org.exoplatform.services.jcr.datamodel.ValueData;
import org.exoplatform.services.jcr.impl.Constants;
import org.exoplatform.services.jcr.impl.backup.BackupException;
import org.exoplatform.services.jcr.impl.backup.Backupable;
import org.exoplatform.services.jcr.impl.backup.DataRestore;
import org.exoplatform.services.jcr.impl.core.itemfilters.QPathEntryFilter;
import org.exoplatform.services.jcr.impl.dataflow.TransientNodeData;
import org.exoplatform.services.jcr.impl.dataflow.TransientPropertyData;
import org.exoplatform.services.jcr.impl.dataflow.persistent.infinispan.BufferedISPNCache;
import org.exoplatform.services.jcr.impl.dataflow.persistent.infinispan.CacheId;
import org.exoplatform.services.jcr.impl.dataflow.persistent.infinispan.CacheKey;
import org.exoplatform.services.jcr.impl.dataflow.persistent.infinispan.CacheNodesByPageId;
import org.exoplatform.services.jcr.impl.dataflow.persistent.infinispan.CacheNodesId;
import org.exoplatform.services.jcr.impl.dataflow.persistent.infinispan.CachePatternNodesId;
import org.exoplatform.services.jcr.impl.dataflow.persistent.infinispan.CachePatternPropsId;
import org.exoplatform.services.jcr.impl.dataflow.persistent.infinispan.CachePropsId;
import org.exoplatform.services.jcr.impl.dataflow.persistent.infinispan.CacheQPath;
import org.exoplatform.services.jcr.impl.dataflow.persistent.infinispan.CacheRefsId;
import org.exoplatform.services.jcr.infinispan.ISPNCacheFactory;
import org.exoplatform.services.log.ExoLogger;
import org.exoplatform.services.log.Log;
import org.exoplatform.services.transaction.ActionNonTxAware;
import org.infinispan.Cache;
import org.infinispan.lifecycle.ComponentStatus;
import org.infinispan.notifications.Listener;
import org.infinispan.notifications.cachelistener.annotation.CacheEntryModified;
import org.infinispan.notifications.cachelistener.event.CacheEntryModifiedEvent;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ISPNCacheWorkspaceStorageCache
implements WorkspaceStorageCache,
Backupable {
    private static final Log LOG = ExoLogger.getLogger((String)"exo.jcr.component.core.ISPNCacheWorkspaceStorageCache");
    private final boolean enabled;
    protected final BufferedISPNCache cache;
    private final List<WorkspaceStorageCacheListener> listeners = new CopyOnWriteArrayList<WorkspaceStorageCacheListener>();
    private final CacheActionNonTxAware<Void, Void> commitTransaction = new CacheActionNonTxAware<Void, Void>(){

        @Override
        protected Void execute(Void arg) throws RuntimeException {
            ISPNCacheWorkspaceStorageCache.this.cache.commitTransaction();
            return null;
        }
    };
    private final CacheActionNonTxAware<ItemData, String> getFromCacheById = new CacheActionNonTxAware<ItemData, String>(){

        @Override
        protected ItemData execute(String id) throws RuntimeException {
            return id == null ? null : (ItemData)ISPNCacheWorkspaceStorageCache.this.cache.get(new CacheId(id));
        }
    };
    private final CacheActionNonTxAware<List<NodeData>, NodeData> getChildNodes = new CacheActionNonTxAware<List<NodeData>, NodeData>(){

        @Override
        protected List<NodeData> execute(NodeData parent) throws RuntimeException {
            Set set = (Set)ISPNCacheWorkspaceStorageCache.this.cache.get(new CacheNodesId(parent.getIdentifier()));
            if (set != null) {
                ArrayList<NodeData> childs = new ArrayList<NodeData>();
                for (String childId : set) {
                    NodeData child = (NodeData)ISPNCacheWorkspaceStorageCache.this.cache.get(new CacheId(childId));
                    if (child == null) {
                        return null;
                    }
                    childs.add(child);
                }
                Collections.sort(childs, new NodesOrderComparator());
                return childs;
            }
            return null;
        }
    };
    private final CacheActionNonTxAware<ItemData, Object> getFromCacheByPath = new CacheActionNonTxAware<ItemData, Object>(){

        @Override
        protected ItemData execute(Object ... args) throws RuntimeException {
            String parentIdentifier = (String)args[0];
            QPathEntry name = (QPathEntry)args[1];
            ItemType itemType = (ItemType)((Object)args[2]);
            String itemId = null;
            if (itemType == ItemType.UNKNOWN) {
                String propId;
                itemId = (String)ISPNCacheWorkspaceStorageCache.this.cache.get(new CacheQPath(parentIdentifier, name, ItemType.NODE));
                if ((itemId == null || itemId.equals("_null_id")) && (propId = (String)ISPNCacheWorkspaceStorageCache.this.cache.get(new CacheQPath(parentIdentifier, name, ItemType.PROPERTY))) != null) {
                    itemId = propId;
                }
            } else {
                itemId = itemType == ItemType.NODE ? (String)ISPNCacheWorkspaceStorageCache.this.cache.get(new CacheQPath(parentIdentifier, name, ItemType.NODE)) : (String)ISPNCacheWorkspaceStorageCache.this.cache.get(new CacheQPath(parentIdentifier, name, ItemType.PROPERTY));
            }
            if (itemId != null) {
                if (itemId.equals("_null_id")) {
                    if (itemType == ItemType.UNKNOWN || itemType == ItemType.NODE) {
                        return new NullNodeData();
                    }
                    return new NullPropertyData();
                }
                return ISPNCacheWorkspaceStorageCache.this.get(itemId);
            }
            return null;
        }
    };
    private final CacheActionNonTxAware<Integer, NodeData> getChildNodesCount = new CacheActionNonTxAware<Integer, NodeData>(){

        @Override
        protected Integer execute(NodeData parent) throws RuntimeException {
            Set list = (Set)ISPNCacheWorkspaceStorageCache.this.cache.get(new CacheNodesId(parent.getIdentifier()));
            return list != null ? list.size() : -1;
        }
    };
    private final CacheActionNonTxAware<List<PropertyData>, Object> getChildProps = new CacheActionNonTxAware<List<PropertyData>, Object>(){

        @Override
        protected List<PropertyData> execute(Object ... args) throws RuntimeException {
            String parentId = (String)args[0];
            boolean withValue = (Boolean)args[1];
            Set set = (Set)ISPNCacheWorkspaceStorageCache.this.cache.get(new CachePropsId(parentId));
            if (set != null) {
                ArrayList<PropertyData> childs = new ArrayList<PropertyData>();
                for (String childId : set) {
                    PropertyData child = (PropertyData)ISPNCacheWorkspaceStorageCache.this.cache.get(new CacheId(childId));
                    if (child == null) {
                        return null;
                    }
                    if (withValue && child.getValues().size() <= 0) {
                        return null;
                    }
                    childs.add(child);
                }
                return childs;
            }
            return null;
        }
    };
    private final CacheActionNonTxAware<List<PropertyData>, String> getReferencedProperties = new CacheActionNonTxAware<List<PropertyData>, String>(){

        @Override
        protected List<PropertyData> execute(String identifier) throws RuntimeException {
            Set set = (Set)ISPNCacheWorkspaceStorageCache.this.cache.get(new CacheRefsId(identifier));
            if (set != null) {
                ArrayList<PropertyData> props = new ArrayList<PropertyData>();
                for (String childId : set) {
                    PropertyData prop = (PropertyData)ISPNCacheWorkspaceStorageCache.this.cache.get(new CacheId(childId));
                    if (prop == null || prop instanceof NullItemData) {
                        return null;
                    }
                    List<ValueData> lData = prop.getValues();
                    int length = lData.size();
                    for (int i = 0; i < length; ++i) {
                        ValueData vdata = lData.get(i);
                        try {
                            if (!new String(vdata.getAsByteArray(), "UTF-8").equals(identifier)) continue;
                            props.add(prop);
                            continue;
                        }
                        catch (IllegalStateException e) {
                            return null;
                        }
                        catch (IOException e) {
                            return null;
                        }
                    }
                }
                return props;
            }
            return null;
        }
    };
    private final CacheActionNonTxAware<Long, Void> getSize = new CacheActionNonTxAware<Long, Void>(){

        @Override
        protected Long execute(Void arg) throws RuntimeException {
            return ISPNCacheWorkspaceStorageCache.this.cache.size();
        }
    };

    public ISPNCacheWorkspaceStorageCache(WorkspaceEntry wsConfig, ConfigurationManager cfm) throws RepositoryException, RepositoryConfigurationException {
        if (wsConfig.getCache() == null) {
            throw new RepositoryConfigurationException("Cache configuration not found");
        }
        this.enabled = wsConfig.getCache().isEnabled();
        ISPNCacheFactory factory = new ISPNCacheFactory(cfm);
        CacheEntry cacheEntry = wsConfig.getCache();
        Cache parentCache = factory.createCache("Data_" + wsConfig.getUniqueName(), cacheEntry);
        Boolean allowLocalChanges = null;
        try {
            allowLocalChanges = cacheEntry.getParameterBoolean("allow-local-changes");
        }
        catch (RepositoryConfigurationException e) {
            // empty catch block
        }
        this.cache = new BufferedISPNCache(parentCache, allowLocalChanges);
        this.cache.addListener(new CacheEventListener());
    }

    public TransactionManager getTransactionManager() {
        return this.cache.getTransactionManager();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void put(ItemData item) {
        if (item instanceof NullItemData) {
            this.putNullItem((NullItemData)item);
            return;
        }
        boolean inTransaction = this.cache.isTransactionActive();
        try {
            if (!inTransaction) {
                this.cache.beginTransaction();
            }
            this.cache.setLocal(true);
            if (item.isNode()) {
                this.putNode((NodeData)item, ModifyChildOption.NOT_MODIFY);
            } else {
                this.putProperty((PropertyData)item, ModifyChildOption.NOT_MODIFY);
            }
            Object var4_3 = null;
            this.cache.setLocal(false);
            if (!inTransaction) {
                this.dedicatedTxCommit();
            }
        }
        catch (Throwable throwable) {
            Object var4_4 = null;
            this.cache.setLocal(false);
            if (!inTransaction) {
                this.dedicatedTxCommit();
            }
            throw throwable;
        }
    }

    @Override
    public void remove(ItemData item) {
        this.removeItem(item);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void onSaveItems(ItemStateChangesLog itemStates) {
        boolean rollback = true;
        try {
            this.cache.beginTransaction();
            for (ItemState state : itemStates.getAllStates()) {
                if (state.isAdded()) {
                    if (!state.isPersisted()) continue;
                    this.putItem(state.getData());
                    continue;
                }
                if (state.isUpdated()) {
                    ItemData prevItem;
                    if (!state.isPersisted() || (prevItem = this.putItemInBufferedCache(state.getData())) == null || !state.isNode()) continue;
                    this.updateInBuffer((NodeData)state.getData(), (NodeData)prevItem);
                    continue;
                }
                if (state.isDeleted()) {
                    this.removeItem(state.getData());
                    continue;
                }
                if (state.isRenamed()) {
                    this.putItem(state.getData());
                    continue;
                }
                if (state.isPathChanged()) {
                    this.updateTreePath(state.getOldPath(), state.getData().getQPath(), null);
                    continue;
                }
                if (!state.isMixinChanged() || !state.isPersisted()) continue;
                this.updateMixin((NodeData)state.getData());
            }
            this.cache.commitTransaction();
            rollback = false;
            Object var7_6 = null;
            if (rollback) {
                this.cache.rollbackTransaction();
            }
        }
        catch (Throwable throwable) {
            Object var7_7 = null;
            if (rollback) {
                this.cache.rollbackTransaction();
            }
            throw throwable;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void addChildNodesByPage(NodeData parent, List<NodeData> childs, int fromOrderNum) {
        boolean inTransaction = this.cache.isTransactionActive();
        try {
            if (!inTransaction) {
                this.cache.beginTransaction();
            }
            this.cache.setLocal(true);
            CacheNodesByPageId cacheId = new CacheNodesByPageId(parent.getIdentifier());
            HashMap pages = (HashMap)this.cache.get(cacheId);
            if (pages == null) {
                pages = new HashMap();
            }
            if (childs.size() > 0) {
                HashSet<String> set = new HashSet<String>();
                for (NodeData child : childs) {
                    this.putNode(child, ModifyChildOption.NOT_MODIFY);
                    set.add(child.getIdentifier());
                }
                pages.put(fromOrderNum, set);
                this.cache.put(cacheId, pages);
            } else {
                pages.put(fromOrderNum, new HashSet());
                this.cache.put(cacheId, pages);
            }
            Object var11_10 = null;
            this.cache.setLocal(false);
            if (!inTransaction) {
                this.dedicatedTxCommit();
            }
        }
        catch (Throwable throwable) {
            Object var11_11 = null;
            this.cache.setLocal(false);
            if (!inTransaction) {
                this.dedicatedTxCommit();
            }
            throw throwable;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void addChildNodes(NodeData parent, List<NodeData> childs) {
        boolean inTransaction = this.cache.isTransactionActive();
        try {
            if (!inTransaction) {
                this.cache.beginTransaction();
            }
            this.cache.setLocal(true);
            if (childs.size() > 0) {
                HashSet<String> set = new HashSet<String>();
                for (NodeData child : childs) {
                    this.putNode(child, ModifyChildOption.NOT_MODIFY);
                    set.add(child.getIdentifier());
                }
                this.cache.putIfAbsent(new CacheNodesId(parent.getIdentifier()), set);
            } else {
                this.cache.putIfAbsent(new CacheNodesId(parent.getIdentifier()), new HashSet());
            }
            Object var8_7 = null;
            this.cache.setLocal(false);
            if (!inTransaction) {
                this.dedicatedTxCommit();
            }
        }
        catch (Throwable throwable) {
            Object var8_8 = null;
            this.cache.setLocal(false);
            if (!inTransaction) {
                this.dedicatedTxCommit();
            }
            throw throwable;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void addChildNodes(NodeData parent, QPathEntryFilter pattern, List<NodeData> childs) {
        boolean inTransaction = this.cache.isTransactionActive();
        try {
            if (!inTransaction) {
                this.cache.beginTransaction();
            }
            this.cache.setLocal(true);
            HashSet<String> set = new HashSet<String>();
            for (NodeData child : childs) {
                this.putNode(child, ModifyChildOption.NOT_MODIFY);
                set.add(child.getIdentifier());
            }
            CachePatternNodesId cacheId = new CachePatternNodesId(parent.getIdentifier());
            HashMap patterns = (HashMap)this.cache.get(cacheId);
            if (patterns == null) {
                patterns = new HashMap();
            }
            patterns.put(pattern, set);
            this.cache.put(cacheId, patterns);
            Object var9_8 = null;
            this.cache.setLocal(false);
            if (!inTransaction) {
                this.dedicatedTxCommit();
            }
        }
        catch (Throwable throwable) {
            Object var9_9 = null;
            this.cache.setLocal(false);
            if (!inTransaction) {
                this.dedicatedTxCommit();
            }
            throw throwable;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void addChildProperties(NodeData parent, List<PropertyData> childs) {
        boolean inTransaction = this.cache.isTransactionActive();
        try {
            if (!inTransaction) {
                this.cache.beginTransaction();
            }
            this.cache.setLocal(true);
            if (childs.size() > 0) {
                HashSet<String> set = new HashSet<String>();
                for (PropertyData child : childs) {
                    this.putProperty(child, ModifyChildOption.NOT_MODIFY);
                    set.add(child.getIdentifier());
                }
                this.cache.putIfAbsent(new CachePropsId(parent.getIdentifier()), set);
            } else {
                LOG.warn((Object)("Empty properties list cached " + (parent != null ? parent.getQPath().getAsString() : parent)));
            }
            Object var8_7 = null;
            this.cache.setLocal(false);
            if (!inTransaction) {
                this.dedicatedTxCommit();
            }
        }
        catch (Throwable throwable) {
            Object var8_8 = null;
            this.cache.setLocal(false);
            if (!inTransaction) {
                this.dedicatedTxCommit();
            }
            throw throwable;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void addChildProperties(NodeData parent, QPathEntryFilter pattern, List<PropertyData> childs) {
        boolean inTransaction = this.cache.isTransactionActive();
        try {
            if (!inTransaction) {
                this.cache.beginTransaction();
            }
            this.cache.setLocal(true);
            if (childs.size() > 0) {
                HashSet<String> set = new HashSet<String>();
                for (PropertyData child : childs) {
                    this.putProperty(child, ModifyChildOption.NOT_MODIFY);
                    set.add(child.getIdentifier());
                }
                CachePatternPropsId cacheId = new CachePatternPropsId(parent.getIdentifier());
                HashMap patterns = (HashMap)this.cache.get(cacheId);
                if (patterns == null) {
                    patterns = new HashMap();
                }
                patterns.put(pattern, set);
                this.cache.put(cacheId, patterns);
            }
            Object var9_8 = null;
            this.cache.setLocal(false);
            if (!inTransaction) {
                this.dedicatedTxCommit();
            }
        }
        catch (Throwable throwable) {
            Object var9_9 = null;
            this.cache.setLocal(false);
            if (!inTransaction) {
                this.dedicatedTxCommit();
            }
            throw throwable;
        }
    }

    @Override
    public void addChildPropertiesList(NodeData parent, List<PropertyData> childProperties) {
    }

    @Override
    public ItemData get(String parentId, QPathEntry name) {
        return this.get(parentId, name, ItemType.UNKNOWN);
    }

    @Override
    public ItemData get(String parentIdentifier, QPathEntry name, ItemType itemType) {
        return (ItemData)this.getFromCacheByPath.run(new Object[]{parentIdentifier, name, itemType});
    }

    @Override
    public ItemData get(String id) {
        return (ItemData)this.getFromCacheById.run(id);
    }

    @Override
    public List<NodeData> getChildNodes(NodeData parent) {
        return (List)this.getChildNodes.run(parent);
    }

    @Override
    public List<NodeData> getChildNodesByPage(NodeData parent, int fromOrderNum) {
        Map pages = (Map)this.cache.get(new CacheNodesByPageId(parent.getIdentifier()));
        if (pages == null) {
            return null;
        }
        Set set = (Set)pages.get(fromOrderNum);
        if (set == null) {
            return null;
        }
        ArrayList<NodeData> childs = new ArrayList<NodeData>();
        for (String childId : set) {
            NodeData child = (NodeData)this.cache.get(new CacheId(childId));
            if (child == null) {
                return null;
            }
            childs.add(child);
        }
        Collections.sort(childs, new NodesOrderComparator());
        return childs;
    }

    @Override
    public List<NodeData> getChildNodes(NodeData parent, QPathEntryFilter pattern) {
        Map patterns = (Map)this.cache.get(new CachePatternNodesId(parent.getIdentifier()));
        if (patterns == null) {
            return null;
        }
        Set set = (Set)patterns.get(pattern);
        if (set == null) {
            return null;
        }
        ArrayList<NodeData> childs = new ArrayList<NodeData>();
        for (String childId : set) {
            NodeData child = (NodeData)this.cache.get(new CacheId(childId));
            if (child == null) {
                return null;
            }
            childs.add(child);
        }
        Collections.sort(childs, new NodesOrderComparator());
        return childs;
    }

    @Override
    public int getChildNodesCount(NodeData parent) {
        return (Integer)this.getChildNodesCount.run(parent);
    }

    @Override
    public List<PropertyData> getChildProperties(NodeData parent) {
        return this.getChildProps(parent.getIdentifier(), true);
    }

    @Override
    public List<PropertyData> getChildProperties(NodeData parent, QPathEntryFilter pattern) {
        Map patterns = (Map)this.cache.get(new CachePatternPropsId(parent.getIdentifier()));
        if (patterns == null) {
            return null;
        }
        Set set = (Set)patterns.get(pattern);
        if (set == null) {
            return null;
        }
        ArrayList<PropertyData> childs = new ArrayList<PropertyData>();
        for (String childId : set) {
            PropertyData child = (PropertyData)this.cache.get(new CacheId(childId));
            if (child == null) {
                return null;
            }
            if (child.getValues().size() <= 0) {
                return null;
            }
            childs.add(child);
        }
        return childs;
    }

    @Override
    public List<PropertyData> listChildProperties(NodeData parent) {
        return this.getChildProps(parent.getIdentifier(), false);
    }

    protected List<PropertyData> getChildProps(String parentId, boolean withValue) {
        return (List)this.getChildProps.run(parentId, withValue);
    }

    @Override
    public long getSize() {
        return (Long)this.getSize.run();
    }

    @Override
    public boolean isEnabled() {
        return this.enabled;
    }

    @Override
    public boolean isPatternSupported() {
        return true;
    }

    @Override
    public boolean isChildNodesByPageSupported() {
        return true;
    }

    protected ItemData putItem(ItemData item) {
        if (item.isNode()) {
            return this.putNode((NodeData)item, ModifyChildOption.MODIFY);
        }
        return this.putProperty((PropertyData)item, ModifyChildOption.MODIFY);
    }

    protected ItemData putItemInBufferedCache(ItemData item) {
        if (item.isNode()) {
            return this.putNodeInBufferedCache((NodeData)item, ModifyChildOption.MODIFY);
        }
        return this.putProperty((PropertyData)item, ModifyChildOption.MODIFY);
    }

    protected ItemData putNode(NodeData node, ModifyChildOption modifyListsOfChild) {
        if (node.getParentIdentifier() != null) {
            if (modifyListsOfChild == ModifyChildOption.NOT_MODIFY) {
                this.cache.putIfAbsent(new CacheQPath(node.getParentIdentifier(), node.getQPath(), ItemType.NODE), (Object)node.getIdentifier());
            } else {
                this.cache.put(new CacheQPath(node.getParentIdentifier(), node.getQPath(), ItemType.NODE), (Object)node.getIdentifier());
            }
            if (modifyListsOfChild != ModifyChildOption.NOT_MODIFY) {
                this.cache.addToPatternList(new CachePatternNodesId(node.getParentIdentifier()), node);
                this.cache.addToList(new CacheNodesId(node.getParentIdentifier()), node.getIdentifier(), modifyListsOfChild == ModifyChildOption.FORCE_MODIFY);
                this.cache.remove(new CacheNodesByPageId(node.getParentIdentifier()));
            }
        }
        if (modifyListsOfChild == ModifyChildOption.NOT_MODIFY) {
            return (ItemData)this.cache.putIfAbsent(new CacheId(node.getIdentifier()), (Object)node);
        }
        return (ItemData)this.cache.put(new CacheId(node.getIdentifier()), node, true);
    }

    protected ItemData putNodeInBufferedCache(NodeData node, ModifyChildOption modifyListsOfChild) {
        ItemData itemData;
        if (node.getParentIdentifier() != null) {
            this.cache.put(new CacheQPath(node.getParentIdentifier(), node.getQPath(), ItemType.NODE), (Object)node.getIdentifier());
            if (modifyListsOfChild != ModifyChildOption.NOT_MODIFY) {
                this.cache.addToList(new CacheNodesId(node.getParentIdentifier()), node.getIdentifier(), modifyListsOfChild == ModifyChildOption.FORCE_MODIFY);
            }
        }
        return (itemData = (ItemData)this.cache.putInBuffer(new CacheId(node.getIdentifier()), node)) instanceof NullItemData ? null : itemData;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void putNullItem(NullItemData item) {
        boolean inTransaction = this.cache.isTransactionActive();
        try {
            if (!inTransaction) {
                this.cache.beginTransaction();
            }
            this.cache.setLocal(true);
            if (!item.getIdentifier().equals("_null_id")) {
                this.cache.putIfAbsent(new CacheId(item.getIdentifier()), (Object)item);
            } else if (item.getName() != null && item.getParentIdentifier() != null) {
                this.cache.putIfAbsent(new CacheQPath(item.getParentIdentifier(), item.getName(), ItemType.getItemType(item)), (Object)"_null_id");
            }
            Object var4_3 = null;
            this.cache.setLocal(false);
            if (!inTransaction) {
                this.dedicatedTxCommit();
            }
        }
        catch (Throwable throwable) {
            Object var4_4 = null;
            this.cache.setLocal(false);
            if (!inTransaction) {
                this.dedicatedTxCommit();
            }
            throw throwable;
        }
    }

    protected PropertyData putProperty(PropertyData prop, ModifyChildOption modifyListsOfChild) {
        if (modifyListsOfChild != ModifyChildOption.NOT_MODIFY) {
            this.cache.addToPatternList(new CachePatternPropsId(prop.getParentIdentifier()), prop);
            this.cache.addToList(new CachePropsId(prop.getParentIdentifier()), prop.getIdentifier(), modifyListsOfChild == ModifyChildOption.FORCE_MODIFY);
        }
        if (modifyListsOfChild == ModifyChildOption.NOT_MODIFY) {
            this.cache.putIfAbsent(new CacheQPath(prop.getParentIdentifier(), prop.getQPath(), ItemType.PROPERTY), (Object)prop.getIdentifier());
        } else {
            this.cache.put(new CacheQPath(prop.getParentIdentifier(), prop.getQPath(), ItemType.PROPERTY), (Object)prop.getIdentifier());
        }
        if (modifyListsOfChild != ModifyChildOption.NOT_MODIFY && prop.getType() == 9) {
            List<ValueData> lData = prop.getValues();
            int length = lData.size();
            for (int i = 0; i < length; ++i) {
                ValueData vdata = lData.get(i);
                String nodeIdentifier = null;
                try {
                    nodeIdentifier = new String(vdata.getAsByteArray(), "UTF-8");
                }
                catch (IllegalStateException e) {
                }
                catch (IOException e) {
                    // empty catch block
                }
                this.cache.addToList(new CacheRefsId(nodeIdentifier), prop.getIdentifier(), modifyListsOfChild == ModifyChildOption.FORCE_MODIFY);
            }
        }
        PropertyData propData = modifyListsOfChild == ModifyChildOption.NOT_MODIFY ? (PropertyData)this.cache.putIfAbsent(new CacheId(prop.getIdentifier()), (Object)prop) : (PropertyData)this.cache.put(new CacheId(prop.getIdentifier()), prop, true);
        return propData instanceof NullPropertyData ? null : propData;
    }

    protected void removeItem(ItemData item) {
        this.cache.remove(new CacheId(item.getIdentifier()));
        this.cache.remove(new CacheQPath(item.getParentIdentifier(), item.getQPath(), ItemType.getItemType(item)));
        if (item.isNode()) {
            if (item.getParentIdentifier() != null) {
                this.cache.removeFromPatternList(new CachePatternNodesId(item.getParentIdentifier()), item);
                this.cache.removeFromList(new CacheNodesId(item.getParentIdentifier()), item.getIdentifier());
                this.cache.remove(new CacheNodesByPageId(item.getParentIdentifier()));
            }
            this.cache.remove(new CacheNodesId(item.getIdentifier()));
            this.cache.remove(new CachePropsId(item.getIdentifier()));
            this.cache.remove(new CacheNodesByPageId(item.getIdentifier()));
            this.cache.remove(new CachePatternNodesId(item.getIdentifier()));
            this.cache.remove(new CachePatternPropsId(item.getIdentifier()));
            this.cache.remove(new CacheRefsId(item.getIdentifier()));
        } else {
            this.cache.removeFromPatternList(new CachePatternPropsId(item.getParentIdentifier()), item);
            this.cache.removeFromList(new CachePropsId(item.getParentIdentifier()), item.getIdentifier());
        }
    }

    protected void updateMixin(NodeData node) {
        NodeData prevData = (NodeData)this.cache.put(new CacheId(node.getIdentifier()), node, true);
        if (!(prevData instanceof NullNodeData)) {
            if (prevData != null) {
                if (prevData.getACL() == null || !prevData.getACL().equals(node.getACL())) {
                    this.updateChildsACL(node.getIdentifier(), node.getACL());
                }
            } else if (LOG.isDebugEnabled()) {
                LOG.debug((Object)("Previous NodeData not found for mixin update " + node.getQPath().getAsString()));
            }
        }
    }

    protected void updateInBuffer(NodeData node, NodeData prevNode) {
        int prevNodeIndex;
        int nodeIndex;
        CacheQPath prevKey = new CacheQPath(node.getParentIdentifier(), prevNode.getQPath(), ItemType.NODE);
        if (node.getIdentifier().equals(this.cache.getFromBuffer(prevKey))) {
            this.cache.remove(prevKey);
        }
        if ((nodeIndex = node.getQPath().getEntries()[node.getQPath().getEntries().length - 1].getIndex()) != (prevNodeIndex = prevNode.getQPath().getEntries()[prevNode.getQPath().getEntries().length - 1].getIndex())) {
            this.updateTreePath(prevNode.getQPath(), node.getQPath(), null);
        }
    }

    protected void updateTreePath(QPath prevRootPath, QPath newRootPath, AccessControlList acl) {
        boolean inheritACL = acl != null;
        for (CacheKey key : this.cache.keySet()) {
            QPath nodeQPath;
            ItemData data;
            if (!(key instanceof CacheId) || (data = (ItemData)this.cache.get(key)) == null || (nodeQPath = data.getQPath()) == null || !nodeQPath.isDescendantOf(prevRootPath)) continue;
            QPathEntry[] relativePath = null;
            try {
                relativePath = nodeQPath.getRelPath(nodeQPath.getDepth() - prevRootPath.getDepth());
            }
            catch (IllegalPathException e) {
                // empty catch block
            }
            QPath newPath = QPath.makeChildPath(newRootPath, relativePath);
            if (data.isNode()) {
                NodeData prevNode = (NodeData)data;
                TransientNodeData newNode = new TransientNodeData(newPath, prevNode.getIdentifier(), prevNode.getPersistedVersion(), prevNode.getPrimaryTypeName(), prevNode.getMixinTypeNames(), prevNode.getOrderNumber(), prevNode.getParentIdentifier(), inheritACL ? acl : prevNode.getACL());
                this.cache.put(new CacheId(newNode.getIdentifier()), (Object)newNode);
                continue;
            }
            PropertyData prevProp = (PropertyData)data;
            if (inheritACL && (prevProp.getQPath().getName().equals((Object)Constants.EXO_PERMISSIONS) || prevProp.getQPath().getName().equals((Object)Constants.EXO_OWNER))) {
                inheritACL = false;
            }
            TransientPropertyData newProp = new TransientPropertyData(newPath, prevProp.getIdentifier(), prevProp.getPersistedVersion(), prevProp.getType(), prevProp.getParentIdentifier(), prevProp.isMultiValued(), prevProp.getValues());
            this.cache.put(new CacheId(newProp.getIdentifier()), (Object)newProp);
        }
    }

    protected void updateChildsACL(String parentId, AccessControlList acl) {
        ChildNodesIterator iter = new ChildNodesIterator(parentId);
        block0: while (iter.hasNext()) {
            NodeData prevNode = (NodeData)iter.next();
            for (InternalQName mixin : prevNode.getMixinTypeNames()) {
                if (mixin.equals((Object)Constants.EXO_PRIVILEGEABLE) || mixin.equals((Object)Constants.EXO_OWNEABLE)) continue block0;
            }
            TransientNodeData newNode = new TransientNodeData(prevNode.getQPath(), prevNode.getIdentifier(), prevNode.getPersistedVersion(), prevNode.getPrimaryTypeName(), prevNode.getMixinTypeNames(), prevNode.getOrderNumber(), prevNode.getParentIdentifier(), acl);
            this.cache.put(new CacheId(newNode.getIdentifier()), (Object)newNode);
            this.updateChildsACL(newNode.getIdentifier(), acl);
        }
    }

    @Override
    public void beginTransaction() {
        this.cache.beginTransaction();
    }

    @Override
    public void commitTransaction() {
        this.cache.commitTransaction();
    }

    @Override
    public void rollbackTransaction() {
        this.cache.rollbackTransaction();
    }

    @Override
    public boolean isTXAware() {
        return true;
    }

    private void dedicatedTxCommit() {
        this.commitTransaction.run();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void addReferencedProperties(String identifier, List<PropertyData> refProperties) {
        boolean inTransaction = this.cache.isTransactionActive();
        try {
            if (!inTransaction) {
                this.cache.beginTransaction();
            }
            this.cache.setLocal(true);
            HashSet<String> set = new HashSet<String>();
            for (PropertyData prop : refProperties) {
                this.putProperty(prop, ModifyChildOption.NOT_MODIFY);
                set.add(prop.getIdentifier());
            }
            this.cache.putIfAbsent(new CacheRefsId(identifier), set);
            Object var8_7 = null;
            this.cache.setLocal(false);
            if (!inTransaction) {
                this.dedicatedTxCommit();
            }
        }
        catch (Throwable throwable) {
            Object var8_8 = null;
            this.cache.setLocal(false);
            if (!inTransaction) {
                this.dedicatedTxCommit();
            }
            throw throwable;
        }
    }

    @Override
    public List<PropertyData> getReferencedProperties(String identifier) {
        return (List)this.getReferencedProperties.run(identifier);
    }

    @Override
    public void backup(File storageDir) throws BackupException {
    }

    @Override
    @Managed
    @ManagedDescription(value="Remove all the existing items from the cache")
    public void clean() throws BackupException {
        if (this.cache.getStatus() == ComponentStatus.RUNNING) {
            this.cache.clear();
        }
    }

    @Override
    public DataRestore getDataRestorer(File storageDir) throws BackupException {
        return new DataRestore(){

            public void clean() throws BackupException {
                ISPNCacheWorkspaceStorageCache.this.cache.clear();
            }

            public void restore() throws BackupException {
            }

            public void commit() throws BackupException {
            }

            public void rollback() throws BackupException {
            }

            public void close() throws BackupException {
            }
        };
    }

    @Override
    public void addListener(WorkspaceStorageCacheListener listener) {
        this.listeners.add(listener);
    }

    @Override
    public void removeListener(WorkspaceStorageCacheListener listener) {
        this.listeners.remove(listener);
    }

    private void onCacheEntryUpdated(ItemData data) {
        if (data == null || data instanceof NullItemData) {
            return;
        }
        for (WorkspaceStorageCacheListener listener : this.listeners) {
            try {
                listener.onCacheEntryUpdated(data);
            }
            catch (Exception e) {
                LOG.warn((Object)("The method onCacheEntryUpdated fails for the listener " + listener.getClass()), (Throwable)e);
            }
        }
    }

    @Listener
    public class CacheEventListener {
        @CacheEntryModified
        public void cacheEntryModified(CacheEntryModifiedEvent evt) {
            if (!evt.isPre() && evt.getKey() instanceof CacheId) {
                ItemData value = (ItemData)evt.getValue();
                ISPNCacheWorkspaceStorageCache.this.onCacheEntryUpdated(value);
            }
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    protected abstract class CacheActionNonTxAware<R, A>
    extends ActionNonTxAware<R, A, RuntimeException> {
        protected CacheActionNonTxAware() {
        }

        @Override
        protected TransactionManager getTransactionManager() {
            return ISPNCacheWorkspaceStorageCache.this.getTransactionManager();
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static enum ModifyChildOption {
        NOT_MODIFY,
        MODIFY,
        FORCE_MODIFY;

    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    class ChildPropertiesIterator<P extends PropertyData>
    extends ChildItemsIterator<P> {
        ChildPropertiesIterator(String parentId) {
            super(new CachePropsId(parentId));
        }

        @Override
        public P next() {
            return (P)((PropertyData)super.next());
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    class ChildNodesIterator<N extends NodeData>
    extends ChildItemsIterator<N> {
        ChildNodesIterator(String parentId) {
            super(new CacheNodesId(parentId));
        }

        @Override
        public N next() {
            return (N)((NodeData)super.next());
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    class ChildItemsIterator<T extends ItemData>
    implements Iterator<T> {
        final Iterator<String> childs;
        T next;

        ChildItemsIterator(CacheKey key) {
            Set set = (Set)ISPNCacheWorkspaceStorageCache.this.cache.get(key);
            if (set != null) {
                this.childs = ((Set)ISPNCacheWorkspaceStorageCache.this.cache.get(key)).iterator();
                this.fetchNext();
            } else {
                this.childs = null;
                this.next = null;
            }
        }

        protected void fetchNext() {
            if (this.childs.hasNext()) {
                ItemData n = null;
                while ((n = (ItemData)ISPNCacheWorkspaceStorageCache.this.cache.get(new CacheId(this.childs.next()))) == null && this.childs.hasNext()) {
                }
                this.next = n;
            } else {
                this.next = null;
            }
        }

        @Override
        public boolean hasNext() {
            return this.next != null;
        }

        @Override
        public T next() {
            if (this.next == null) {
                throw new NoSuchElementException();
            }
            T current = this.next;
            this.fetchNext();
            return current;
        }

        @Override
        public void remove() {
            throw new IllegalArgumentException("Not implemented");
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    class NodesOrderComparator<N extends NodeData>
    implements Comparator<NodeData> {
        NodesOrderComparator() {
        }

        @Override
        public int compare(NodeData n1, NodeData n2) {
            return n1.getOrderNumber() - n2.getOrderNumber();
        }
    }
}

