/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.services.wcm.skin;

import java.io.Reader;
import java.io.StringReader;
import javax.jcr.Node;
import org.exoplatform.portal.resource.Resource;
import org.exoplatform.portal.resource.ResourceResolver;
import org.exoplatform.portal.resource.SkinConfig;
import org.exoplatform.portal.resource.SkinService;
import org.exoplatform.services.log.ExoLogger;
import org.exoplatform.services.log.Log;
import org.exoplatform.services.wcm.portal.LivePortalManagerService;
import org.exoplatform.services.wcm.skin.XSkinService;
import org.exoplatform.services.wcm.utils.WCMCoreUtils;

public class WCMSkinResourceResolver
implements ResourceResolver {
    private SkinService skinService;
    private LivePortalManagerService livePortalService;
    private static Log log = ExoLogger.getLogger((String)"wcm:WCMSkinResourceResolver");

    public WCMSkinResourceResolver(SkinService skinService, LivePortalManagerService livePortalService) {
        this.skinService = skinService;
        this.livePortalService = livePortalService;
    }

    public Resource resolve(String path) {
        if (!path.matches(XSkinService.SKIN_PATH_REGEXP)) {
            return null;
        }
        String[] elements = path.split("/");
        String portalName = elements[4];
        String skinName = elements[5];
        String skinModule = portalName;
        String cssPath = null;
        SkinConfig portalSkinConfig = this.skinService.getSkin(portalName, skinName);
        if (portalSkinConfig != null) {
            cssPath = portalSkinConfig.getCSSPath();
        }
        if (cssPath == null) {
            for (SkinConfig skinConfig : this.skinService.getPortalSkins(skinName)) {
                if (!skinConfig.getModule().equals(skinModule)) continue;
                cssPath = skinConfig.getCSSPath();
                break;
            }
        }
        try {
            Node portalNode = this.livePortalService.getLivePortal(WCMCoreUtils.getSystemSessionProvider(), portalName);
            final String cssData = WCMCoreUtils.getActiveStylesheet(portalNode);
            if (cssData == null) {
                return null;
            }
            return new Resource(cssPath){

                public Reader read() {
                    return new StringReader(cssData);
                }
            };
        }
        catch (Exception e) {
            log.error((Object)"Unexpected error happens", (Throwable)e);
            return null;
        }
    }
}

