/*
 * Decompiled with CFR 0.152.
 */
package org.chromattic.core.mapper.onetomany.reference;

import org.chromattic.core.DomainSession;
import org.chromattic.core.EntityContext;
import org.chromattic.core.ObjectContext;
import org.chromattic.core.jcr.LinkType;
import org.chromattic.core.mapper.JCRNodePropertyMapper;
import org.chromattic.core.mapper.onetomany.reference.JCRReferentCollectionPropertyMapper;
import org.chromattic.metamodel.bean.BeanValueInfo;
import org.chromattic.metamodel.bean.PropertyInfo;
import org.chromattic.metamodel.bean.ValueKind;
import org.chromattic.metamodel.mapping.RelationshipMapping;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class JCRNamedReferentPropertyMapper<O extends ObjectContext<O>>
extends JCRNodePropertyMapper<PropertyInfo<BeanValueInfo, ValueKind.Single>, BeanValueInfo, O> {
    private final String propertyName;
    private final LinkType linkType;

    public JCRNamedReferentPropertyMapper(Class<O> contextType, RelationshipMapping.ManyToOne.Reference info) throws ClassNotFoundException {
        super(contextType, info);
        this.propertyName = info.getMappedBy();
        this.linkType = JCRReferentCollectionPropertyMapper.relationshipToLinkMapping.get(info.getType());
    }

    @Override
    public Object get(O context) throws Throwable {
        Class<?> relatedClass = this.getRelatedClass();
        EntityContext relatedCtx = ((ObjectContext)context).getEntity().getReferenced(this.propertyName, this.linkType);
        if (relatedCtx == null) {
            return null;
        }
        Object related = relatedCtx.getObject();
        if (relatedClass.isInstance(related)) {
            return related;
        }
        throw new ClassCastException("Related with class " + related.getClass().getName() + " is not of class " + relatedClass);
    }

    @Override
    public void set(O ctx, Object value) throws Throwable {
        DomainSession session = ((ObjectContext)ctx).getEntity().getSession();
        EntityContext referencedCtx = null;
        if (value != null) {
            referencedCtx = session.unwrapEntity(value);
        }
        ((ObjectContext)ctx).getEntity().setReferenced(this.propertyName, referencedCtx, this.linkType);
    }
}

