/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.ecm.webui.component.admin.templates;

import java.io.ByteArrayInputStream;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import javax.jcr.Node;
import javax.jcr.NodeIterator;
import javax.jcr.nodetype.NodeType;
import javax.jcr.nodetype.NodeTypeIterator;
import org.exoplatform.ecm.webui.component.admin.templates.UITemplatesManager;
import org.exoplatform.ecm.webui.form.UIFormInputSetWithAction;
import org.exoplatform.ecm.webui.selector.UISelectable;
import org.exoplatform.services.cms.templates.TemplateService;
import org.exoplatform.services.jcr.RepositoryService;
import org.exoplatform.services.jcr.core.nodetype.ExtendedNodeTypeManager;
import org.exoplatform.services.wcm.publication.WCMComposer;
import org.exoplatform.services.wcm.utils.WCMCoreUtils;
import org.exoplatform.web.application.ApplicationMessage;
import org.exoplatform.webui.config.annotation.ComponentConfig;
import org.exoplatform.webui.config.annotation.EventConfig;
import org.exoplatform.webui.core.UIApplication;
import org.exoplatform.webui.core.UIComponent;
import org.exoplatform.webui.core.lifecycle.UIFormLifecycle;
import org.exoplatform.webui.core.model.SelectItemOption;
import org.exoplatform.webui.event.Event;
import org.exoplatform.webui.event.EventListener;
import org.exoplatform.webui.form.UIFormCheckBoxInput;
import org.exoplatform.webui.form.UIFormInput;
import org.exoplatform.webui.form.UIFormInputSet;
import org.exoplatform.webui.form.UIFormSelectBox;
import org.exoplatform.webui.form.UIFormStringInput;
import org.exoplatform.webui.form.UIFormTabPane;
import org.exoplatform.webui.form.UIFormTextAreaInput;
import org.exoplatform.webui.form.validator.MandatoryValidator;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@ComponentConfig(lifecycle=UIFormLifecycle.class, template="system:/groovy/webui/form/UIFormTabPane.gtmpl", events={@EventConfig(listeners={SaveActionListener.class}), @EventConfig(listeners={RefreshActionListener.class}, phase=Event.Phase.DECODE), @EventConfig(listeners={CancelActionListener.class}, phase=Event.Phase.DECODE), @EventConfig(listeners={AddPermissionActionListener.class}, phase=Event.Phase.DECODE), @EventConfig(listeners={OnChangeActionListener.class}, phase=Event.Phase.DECODE)})
public class UITemplateForm
extends UIFormTabPane
implements UISelectable {
    public static final String FIELD_NAME = "name";
    public static final String FIELD_LABEL = "label";
    public static final String FIELD_ISTEMPLATE = "isDocumentTemplate";
    public static final String FIELD_DIALOG = "dialog";
    public static final String FIELD_VIEW = "view";
    public static final String FIELD_SKIN = "skin";
    public static final String FIELD_TAB_TEMPLATE = "template";
    public static final String FIELD_TAB_DIALOG = "defaultDialog";
    public static final String FIELD_TAB_VIEW = "defaultView";
    public static final String FIELD_TAB_SKIN = "defaultSkin";
    public static final String FIELD_PERMISSION = "permission";

    public UITemplateForm() throws Exception {
        super("UITemplateForm");
        UIFormInputSetWithAction templateTab = new UIFormInputSetWithAction(FIELD_TAB_TEMPLATE);
        UIFormSelectBox uiSelectBox = new UIFormSelectBox(FIELD_NAME, FIELD_NAME, this.getOption());
        uiSelectBox.setOnChange("OnChange");
        templateTab.addUIFormInput((UIFormInput)uiSelectBox);
        templateTab.addUIFormInput((UIFormInput)new UIFormStringInput(FIELD_LABEL, FIELD_LABEL, null).addValidator(MandatoryValidator.class, new Object[0]));
        templateTab.addUIFormInput((UIFormInput)new UIFormCheckBoxInput(FIELD_ISTEMPLATE, FIELD_ISTEMPLATE, null).setChecked(true));
        templateTab.addUIFormInput((UIFormInput)new UIFormStringInput(FIELD_PERMISSION, FIELD_PERMISSION, null).setEditable(false).addValidator(MandatoryValidator.class, new Object[0]));
        templateTab.setActionInfo(FIELD_PERMISSION, new String[]{"AddPermission"});
        this.addUIComponentInput((UIComponent)templateTab);
        this.setSelectedTab(templateTab.getId());
        UIFormInputSet defaultDialogTab = new UIFormInputSet(FIELD_TAB_DIALOG);
        defaultDialogTab.addUIFormInput((UIFormInput)new UIFormTextAreaInput(FIELD_DIALOG, FIELD_DIALOG, null).addValidator(MandatoryValidator.class, new Object[0]));
        this.addUIFormInput(defaultDialogTab);
        UIFormInputSet defaultViewTab = new UIFormInputSet(FIELD_TAB_VIEW);
        defaultViewTab.addUIFormInput((UIFormInput)new UIFormTextAreaInput(FIELD_VIEW, FIELD_VIEW, null).addValidator(MandatoryValidator.class, new Object[0]));
        this.addUIFormInput(defaultViewTab);
        UIFormInputSet defaultSkinTab = new UIFormInputSet(FIELD_TAB_SKIN);
        defaultSkinTab.addUIFormInput((UIFormInput)new UIFormTextAreaInput(FIELD_SKIN, FIELD_SKIN, null));
        this.addUIFormInput(defaultSkinTab);
        this.setActions(new String[]{"Save", "Refresh", "Cancel"});
    }

    public void refresh() throws Exception {
        this.getUIFormSelectBox(FIELD_NAME).setOptions(this.getOption());
        String nodeType = (String)this.getUIFormSelectBox(FIELD_NAME).getValue();
        this.getUIStringInput(FIELD_LABEL).setValue((Object)"");
        this.getUIFormCheckBoxInput(FIELD_ISTEMPLATE).setChecked(true);
        this.initTemplate(nodeType);
        this.getUIStringInput(FIELD_PERMISSION).setValue((Object)"");
    }

    private void initTemplate(String nodeType) throws Exception {
        this.getUIFormTextAreaInput(FIELD_VIEW).setValue((Object)this.getDefaultView(nodeType));
        this.getUIFormTextAreaInput(FIELD_DIALOG).setValue((Object)this.getDefaultDialog(nodeType));
        this.getUIFormTextAreaInput(FIELD_SKIN).setValue((Object)this.getDefaultStyleSheet(nodeType));
    }

    private String getDefaultStyleSheet(String nodeType) throws Exception {
        TemplateService templateService = (TemplateService)this.getApplicationComponent(TemplateService.class);
        return templateService.buildStyleSheet(nodeType);
    }

    private String getDefaultView(String nodeType) throws Exception {
        TemplateService templateService = (TemplateService)this.getApplicationComponent(TemplateService.class);
        return templateService.buildViewForm(nodeType);
    }

    private String getDefaultDialog(String nodeType) throws Exception {
        TemplateService templateService = (TemplateService)this.getApplicationComponent(TemplateService.class);
        return templateService.buildDialogForm(nodeType);
    }

    public List<SelectItemOption<String>> getOption() throws Exception {
        ArrayList<SelectItemOption<String>> options = new ArrayList<SelectItemOption<String>>();
        ExtendedNodeTypeManager nodeTypeManager = ((RepositoryService)this.getApplicationComponent(RepositoryService.class)).getCurrentRepository().getNodeTypeManager();
        Node templatesHome = ((TemplateService)this.getApplicationComponent(TemplateService.class)).getTemplatesHome(WCMCoreUtils.getUserSessionProvider());
        if (templatesHome != null) {
            NodeIterator templateIter = templatesHome.getNodes();
            ArrayList<String> templates = new ArrayList<String>();
            while (templateIter.hasNext()) {
                templates.add(templateIter.nextNode().getName());
            }
            NodeTypeIterator iter = nodeTypeManager.getAllNodeTypes();
            while (iter.hasNext()) {
                String nodeTypeName;
                NodeType nodeType = iter.nextNodeType();
                if (nodeType.isMixin() || templates.contains(nodeTypeName = nodeType.getName())) continue;
                options.add((SelectItemOption<String>)new SelectItemOption(nodeTypeName, (Object)nodeTypeName));
            }
            Collections.sort(options, new TemplateNameComparator());
        }
        return options;
    }

    public void doSelect(String selectField, Object value) {
        UIFormInputSetWithAction uiFormAction = (UIFormInputSetWithAction)this.getChildById(FIELD_TAB_TEMPLATE);
        uiFormAction.getUIStringInput(FIELD_PERMISSION).setValue((Object)value.toString());
        UITemplatesManager uiManager = (UITemplatesManager)this.getAncestorOfType(UITemplatesManager.class);
        uiManager.removeChildById("AddNewTemplatePermission");
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class AddPermissionActionListener
    extends EventListener<UITemplateForm> {
        public void execute(Event<UITemplateForm> event) throws Exception {
            UITemplateForm uiTemplateForm = (UITemplateForm)((Object)event.getSource());
            UITemplatesManager uiManager = (UITemplatesManager)uiTemplateForm.getAncestorOfType(UITemplatesManager.class);
            String membership = (String)uiTemplateForm.getUIStringInput(UITemplateForm.FIELD_PERMISSION).getValue();
            uiManager.initPopupPermission("AddNew", membership);
            event.getRequestContext().addUIComponentToUpdateByAjax((UIComponent)uiManager);
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class OnChangeActionListener
    extends EventListener<UITemplateForm> {
        public void execute(Event<UITemplateForm> event) throws Exception {
            UITemplateForm uiFormTabPane = (UITemplateForm)((Object)event.getSource());
            String nodeType = (String)uiFormTabPane.getUIFormSelectBox(UITemplateForm.FIELD_NAME).getValue();
            uiFormTabPane.getUIStringInput(UITemplateForm.FIELD_LABEL).setValue((Object)"");
            uiFormTabPane.initTemplate(nodeType);
            uiFormTabPane.getUIStringInput(UITemplateForm.FIELD_PERMISSION).setValue((Object)"");
            event.getRequestContext().addUIComponentToUpdateByAjax(uiFormTabPane.getParent());
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class RefreshActionListener
    extends EventListener<UITemplateForm> {
        public void execute(Event<UITemplateForm> event) throws Exception {
            UITemplateForm uiFormTabPane = (UITemplateForm)((Object)event.getSource());
            uiFormTabPane.refresh();
            event.getRequestContext().addUIComponentToUpdateByAjax(uiFormTabPane.getParent());
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class CancelActionListener
    extends EventListener<UITemplateForm> {
        public void execute(Event<UITemplateForm> event) throws Exception {
            UITemplateForm uiTemplateForm = (UITemplateForm)((Object)event.getSource());
            UITemplatesManager uiManager = (UITemplatesManager)uiTemplateForm.getAncestorOfType(UITemplatesManager.class);
            uiTemplateForm.reset();
            uiManager.removeChildById("TemplatePopup");
            event.getRequestContext().addUIComponentToUpdateByAjax((UIComponent)uiManager);
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class SaveActionListener
    extends EventListener<UITemplateForm> {
        public void execute(Event<UITemplateForm> event) throws Exception {
            UITemplateForm uiForm = (UITemplateForm)((Object)event.getSource());
            String name = ((String)uiForm.getUIFormSelectBox(UITemplateForm.FIELD_NAME).getValue()).trim();
            String label = ((String)uiForm.getUIStringInput(UITemplateForm.FIELD_LABEL).getValue()).trim();
            String dialog = (String)uiForm.getUIFormTextAreaInput(UITemplateForm.FIELD_DIALOG).getValue();
            String view = (String)uiForm.getUIFormTextAreaInput(UITemplateForm.FIELD_VIEW).getValue();
            String skin = (String)uiForm.getUIFormTextAreaInput(UITemplateForm.FIELD_SKIN).getValue();
            if (skin == null) {
                skin = "";
            }
            boolean isDocumentTemplate = uiForm.getUIFormCheckBoxInput(UITemplateForm.FIELD_ISTEMPLATE).isChecked();
            UIFormInputSetWithAction permField = (UIFormInputSetWithAction)uiForm.getChildById(UITemplateForm.FIELD_TAB_TEMPLATE);
            String role = (String)permField.getUIStringInput(UITemplateForm.FIELD_PERMISSION).getValue();
            if (role == null || role.trim().length() == 0) {
                UIApplication uiApp = (UIApplication)uiForm.getAncestorOfType(UIApplication.class);
                uiApp.addMessage(new ApplicationMessage("UITemplateForm.msg.role-require", null, 1));
                return;
            }
            String[] roles = new String[]{role};
            if (dialog == null) {
                dialog = "";
            }
            if (view == null) {
                view = "";
            }
            TemplateService templateService = (TemplateService)uiForm.getApplicationComponent(TemplateService.class);
            templateService.addTemplate(TemplateService.DIALOGS, name, label, isDocumentTemplate, TemplateService.DEFAULT_DIALOG, roles, (InputStream)new ByteArrayInputStream(dialog.getBytes()));
            templateService.addTemplate(TemplateService.VIEWS, name, label, isDocumentTemplate, TemplateService.DEFAULT_VIEW, roles, (InputStream)new ByteArrayInputStream(view.getBytes()));
            templateService.addTemplate(TemplateService.SKINS, name, label, isDocumentTemplate, TemplateService.DEFAULT_SKIN, roles, (InputStream)new ByteArrayInputStream(skin.getBytes()));
            WCMComposer composer = (WCMComposer)WCMCoreUtils.getService(WCMComposer.class);
            composer.updateTemplatesSQLFilter();
            UITemplatesManager uiManager = (UITemplatesManager)uiForm.getAncestorOfType(UITemplatesManager.class);
            uiManager.refresh();
            uiForm.refresh();
            uiManager.removeChildById("TemplatePopup");
            event.getRequestContext().addUIComponentToUpdateByAjax((UIComponent)uiManager);
        }
    }

    public static class TemplateNameComparator
    implements Comparator {
        public int compare(Object o1, Object o2) throws ClassCastException {
            try {
                String name1 = ((SelectItemOption)o1).getValue().toString();
                String name2 = ((SelectItemOption)o2).getValue().toString();
                return name1.compareToIgnoreCase(name2);
            }
            catch (Exception e) {
                return 0;
            }
        }
    }
}

