/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.ecm.webui.component.admin.unlock;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import javax.jcr.AccessDeniedException;
import javax.jcr.Node;
import javax.jcr.NodeIterator;
import javax.jcr.PathNotFoundException;
import javax.jcr.Session;
import javax.jcr.lock.LockException;
import javax.jcr.query.Query;
import javax.jcr.query.QueryManager;
import javax.jcr.query.QueryResult;
import javax.jcr.version.VersionException;
import org.exoplatform.commons.utils.LazyPageList;
import org.exoplatform.commons.utils.ListAccess;
import org.exoplatform.commons.utils.ListAccessImpl;
import org.exoplatform.commons.utils.PageList;
import org.exoplatform.container.ExoContainer;
import org.exoplatform.container.PortalContainer;
import org.exoplatform.container.component.ComponentRequestLifecycle;
import org.exoplatform.ecm.webui.component.admin.unlock.UILockHolderContainer;
import org.exoplatform.ecm.webui.component.admin.unlock.UIUnLockManager;
import org.exoplatform.ecm.webui.core.UIPagingGridDecorator;
import org.exoplatform.ecm.webui.utils.JCRExceptionManager;
import org.exoplatform.ecm.webui.utils.LockUtil;
import org.exoplatform.ecm.webui.utils.Utils;
import org.exoplatform.portal.config.UserACL;
import org.exoplatform.services.cms.lock.LockService;
import org.exoplatform.services.jcr.RepositoryService;
import org.exoplatform.services.jcr.config.RepositoryEntry;
import org.exoplatform.services.jcr.config.WorkspaceEntry;
import org.exoplatform.services.jcr.core.ManageableRepository;
import org.exoplatform.services.organization.Membership;
import org.exoplatform.services.organization.OrganizationService;
import org.exoplatform.services.wcm.core.NodeLocation;
import org.exoplatform.services.wcm.utils.WCMCoreUtils;
import org.exoplatform.web.application.ApplicationMessage;
import org.exoplatform.webui.config.annotation.ComponentConfig;
import org.exoplatform.webui.config.annotation.EventConfig;
import org.exoplatform.webui.core.UIApplication;
import org.exoplatform.webui.core.UIComponent;
import org.exoplatform.webui.event.Event;
import org.exoplatform.webui.event.EventListener;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@ComponentConfig(template="app:/groovy/webui/component/admin/unlock/UILockNodeList.gtmpl", events={@EventConfig(listeners={UnLockActionListener.class})})
public class UILockNodeList
extends UIPagingGridDecorator {
    public static final String[] ACTIONS = new String[0];
    public static final String ST_EDIT = "EditUnLockForm";
    private static final String LOCK_QUERY = "select * from nt:base where jcr:mixinTypes = 'mix:lockable' order by exo:dateCreated DESC";

    public UILockNodeList() throws Exception {
        this.getUIPageIterator().setId("LockNodeListIterator");
    }

    public String[] getActions() {
        return ACTIONS;
    }

    public void refresh(int currentPage) throws Exception {
        ListAccessImpl lockedNodeList = new ListAccessImpl(Object.class, NodeLocation.getLocationsByNodeList(this.getAllLockedNodes()));
        LazyPageList pageList = new LazyPageList((ListAccess)lockedNodeList, this.getUIPageIterator().getItemsPerPage());
        this.getUIPageIterator().setPageList((PageList)pageList);
        if (currentPage > this.getUIPageIterator().getAvailablePage()) {
            this.getUIPageIterator().setCurrentPage(this.getUIPageIterator().getAvailablePage());
        } else {
            this.getUIPageIterator().setCurrentPage(currentPage);
        }
    }

    public List getLockedNodeList() throws Exception {
        return NodeLocation.getNodeListByLocationList((List)this.getUIPageIterator().getCurrentPageData());
    }

    public List<Node> getAllLockedNodes() throws Exception {
        RepositoryService repositoryService = (RepositoryService)this.getApplicationComponent(RepositoryService.class);
        ManageableRepository manageRepository = repositoryService.getCurrentRepository();
        RepositoryEntry repo = manageRepository.getConfiguration();
        ArrayList<Node> listLockedNodes = new ArrayList<Node>();
        QueryManager queryManager = null;
        Session session = null;
        String queryStatement = LOCK_QUERY;
        Query query = null;
        QueryResult queryResult = null;
        for (WorkspaceEntry ws : repo.getWorkspaceEntries()) {
            session = WCMCoreUtils.getSystemSessionProvider().getSession(ws.getName(), manageRepository);
            queryManager = session.getWorkspace().getQueryManager();
            query = queryManager.createQuery(queryStatement, "sql");
            queryResult = query.execute();
            NodeIterator iter = queryResult.getNodes();
            while (iter.hasNext()) {
                Node itemNode = iter.nextNode();
                if (Utils.isInTrash((Node)itemNode) || !itemNode.isLocked()) continue;
                listLockedNodes.add(itemNode);
            }
        }
        return listLockedNodes;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class UnLockActionListener
    extends EventListener<UILockNodeList> {
        private List<String> getGroups(String userId) throws Exception {
            PortalContainer manager = PortalContainer.getInstance();
            OrganizationService organizationService = (OrganizationService)WCMCoreUtils.getService(OrganizationService.class);
            ((ComponentRequestLifecycle)organizationService).startRequest((ExoContainer)manager);
            ArrayList<String> groupList = new ArrayList<String>();
            Collection gMembership = organizationService.getMembershipHandler().findMembershipsByUser(userId);
            Object[] objects = gMembership.toArray();
            for (int i = 0; i < objects.length; ++i) {
                Membership member = (Membership)objects[i];
                groupList.add(member.getMembershipType() + ":" + member.getGroupId());
            }
            return groupList;
        }

        public void execute(Event<UILockNodeList> event) throws Exception {
            UIUnLockManager uiUnLockManager = (UIUnLockManager)((UILockNodeList)((Object)event.getSource())).getParent();
            UIApplication uiApp = (UIApplication)uiUnLockManager.getAncestorOfType(UIApplication.class);
            String nodePath = event.getRequestContext().getRequestParameter("objectId");
            RepositoryService repositoryService = (RepositoryService)uiUnLockManager.getApplicationComponent(RepositoryService.class);
            ManageableRepository manageRepository = repositoryService.getCurrentRepository();
            Session session = null;
            Node lockedNode = null;
            RepositoryEntry repo = repositoryService.getCurrentRepository().getConfiguration();
            for (WorkspaceEntry ws : repo.getWorkspaceEntries()) {
                session = WCMCoreUtils.getUserSessionProvider().getSession(ws.getName(), manageRepository);
                try {
                    lockedNode = (Node)session.getItem(nodePath);
                    if (lockedNode == null || Utils.isInTrash((Node)lockedNode)) continue;
                    break;
                }
                catch (PathNotFoundException e) {
                }
                catch (AccessDeniedException accessDeniedException) {
                }
            }
            if (lockedNode == null) {
                Object[] args = new Object[]{nodePath};
                uiApp.addMessage(new ApplicationMessage("UILockNodeList.msg.access-denied-exception", args, 1));
                uiUnLockManager.refresh();
                event.getRequestContext().addUIComponentToUpdateByAjax((UIComponent)uiUnLockManager);
                return;
            }
            LockService lockService = (LockService)WCMCoreUtils.getService(LockService.class);
            String remoteUser = lockedNode.getSession().getUserID();
            List authenticatedGroups = lockService.getAllGroupsOrUsersForLock();
            List<String> memberShips = this.getGroups(remoteUser);
            boolean isAuthenticated = false;
            for (String group : authenticatedGroups) {
                if (!memberShips.contains(group)) continue;
                isAuthenticated = true;
                break;
            }
            UserACL userACLService = (UserACL)WCMCoreUtils.getService(UserACL.class);
            if (isAuthenticated || remoteUser.equals(userACLService.getSuperUser())) {
                session = WCMCoreUtils.getSystemSessionProvider().getSession(lockedNode.getSession().getWorkspace().getName(), (ManageableRepository)lockedNode.getSession().getRepository());
                lockedNode = (Node)session.getItem(lockedNode.getPath());
            }
            try {
                if (lockedNode.holdsLock()) {
                    String lockToken = LockUtil.getLockToken((Node)lockedNode);
                    if (lockToken != null) {
                        session.addLockToken(lockToken);
                    }
                    lockedNode.unlock();
                    lockedNode.removeMixin("mix:lockable");
                    lockedNode.getSession().save();
                    LockUtil.removeLock((Node)lockedNode);
                }
            }
            catch (LockException le) {
                Object[] args = new Object[]{lockedNode.getName()};
                uiApp.addMessage(new ApplicationMessage("UIPopupMenu.msg.can-not-unlock-node", args, 1));
                event.getRequestContext().addUIComponentToUpdateByAjax((UIComponent)uiUnLockManager);
                return;
            }
            catch (VersionException versionException) {
                Object[] args = new Object[]{lockedNode.getName()};
                uiApp.addMessage(new ApplicationMessage("UIPopupMenu.msg.can-not-unlock-node-is-checked-in", args, 1));
                event.getRequestContext().addUIComponentToUpdateByAjax((UIComponent)uiUnLockManager);
                return;
            }
            catch (Exception e) {
                JCRExceptionManager.process((UIApplication)uiApp, (Exception)e);
            }
            uiUnLockManager.refresh();
            ((UILockNodeList)uiUnLockManager.getChild(UILockNodeList.class)).setRendered(true);
            ((UILockHolderContainer)uiUnLockManager.getChild(UILockHolderContainer.class)).setRendered(false);
        }
    }
}

