/*
 * Decompiled with CFR 0.152.
 */
package com.google.caja.parser.quasiliteral;

import com.google.caja.parser.quasiliteral.RuleDescription;
import com.google.caja.parser.quasiliteral.RuleDoclet;
import com.google.caja.parser.quasiliteral.RulesetDescription;
import com.google.caja.util.Json;
import java.io.IOException;
import java.io.Writer;
import org.json.simple.JSONArray;
import org.json.simple.JSONObject;

public class JsonRuleDoclet
extends RuleDoclet {
    private JSONObject jsonDocument;
    private JSONArray table;
    private int countRules;

    public String getDefaultExtension() {
        return "json";
    }

    public void initialize(Writer output) {
        this.jsonDocument = new JSONObject();
    }

    public void generateHeader(Writer output, RulesetDescription ruleSet) {
        JSONObject head = Json.formatAsJson("name", ruleSet.name(), "synopsis", ruleSet.synopsis());
        Json.putJson(this.jsonDocument, "header", head);
    }

    public void generateFooter(Writer output, RulesetDescription ruleSet) {
    }

    public void finish(Writer output) throws IOException {
        output.write(this.jsonDocument.toString());
    }

    public void generateRuleDocumentation(Writer output, RuleDescription anno) {
        if (0 == this.countRules) {
            this.table = new JSONArray();
            Json.putJson(this.jsonDocument, "rules", this.table);
        }
        Json.pushJson(this.table, Json.formatAsJson("number", this.countRules++, "name", anno.name(), "synopsis", anno.synopsis(), "reason", anno.reason(), "matches", anno.matches(), "substitutes", anno.substitutes()));
    }
}

