/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.services.cms.drives;

import java.io.Serializable;
import java.util.ArrayList;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DriveData
implements Comparable<DriveData>,
Serializable {
    private static final long serialVersionUID = -1483463576328793278L;
    private String name;
    private String repository;
    private String workspace;
    private String permissions;
    private String homePath;
    private String icon;
    private String views;
    private boolean viewPreferences;
    private boolean viewNonDocument;
    private boolean viewSideBar;
    private boolean showHiddenNode;
    private String allowCreateFolders;
    private String allowNodeTypesOnTree;

    public DriveData clone() {
        DriveData driveData = new DriveData();
        driveData.setAllowCreateFolders(this.getAllowCreateFolders());
        driveData.setAllowNodeTypesOnTree(this.getAllowNodeTypesOnTree());
        driveData.setHomePath(this.getHomePath());
        driveData.setIcon(this.getIcon());
        driveData.setName(this.getName());
        driveData.setPermissions(this.getPermissions());
        driveData.setShowHiddenNode(this.getShowHiddenNode());
        driveData.setViewNonDocument(this.getViewNonDocument());
        driveData.setViewPreferences(this.getViewPreferences());
        driveData.setViewSideBar(this.getViewSideBar());
        driveData.setViews(this.getViews());
        driveData.setWorkspace(this.getWorkspace());
        return driveData;
    }

    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public String getRepository() {
        return this.repository;
    }

    public void setRepository(String rp) {
        this.repository = rp;
    }

    public String getWorkspace() {
        return this.workspace;
    }

    public void setWorkspace(String ws) {
        this.workspace = ws;
    }

    public String getPermissions() {
        return this.permissions;
    }

    public void setPermissions(String permissions) {
        this.permissions = permissions;
    }

    public String getHomePath() {
        return this.homePath;
    }

    public void setHomePath(String path) {
        this.homePath = path;
    }

    public String getIcon() {
        return this.icon;
    }

    public void setIcon(String ico) {
        this.icon = ico;
    }

    public String getAllowCreateFolders() {
        return this.allowCreateFolders;
    }

    public void setAllowCreateFolders(String allowCreateFolders) {
        this.allowCreateFolders = allowCreateFolders;
    }

    public String getAllowNodeTypesOnTree() {
        return this.allowNodeTypesOnTree;
    }

    public void setAllowNodeTypesOnTree(String allowNodeTypesOnTree) {
        this.allowNodeTypesOnTree = allowNodeTypesOnTree;
    }

    public String getViews() {
        return this.views;
    }

    public void setViews(String v) {
        this.views = v;
    }

    public boolean getViewPreferences() {
        return this.viewPreferences;
    }

    public void setViewPreferences(boolean b) {
        this.viewPreferences = b;
    }

    public boolean getViewNonDocument() {
        return this.viewNonDocument;
    }

    public void setViewNonDocument(boolean b) {
        this.viewNonDocument = b;
    }

    public boolean getViewSideBar() {
        return this.viewSideBar;
    }

    public void setViewSideBar(boolean b) {
        this.viewSideBar = b;
    }

    public boolean getShowHiddenNode() {
        return this.showHiddenNode;
    }

    public void setShowHiddenNode(boolean b) {
        this.showHiddenNode = b;
    }

    public String[] getAllPermissions() {
        return this.permissions.split(",");
    }

    public boolean hasPermission(String[] allPermissions, String permission) {
        ArrayList<String> permissionList = new ArrayList<String>();
        for (String per : allPermissions) {
            permissionList.add(per.trim());
        }
        if (permission == null) {
            return false;
        }
        if (permission.indexOf(":/") > -1) {
            String[] array = permission.split(":/");
            if (array == null || array.length < 2) {
                return false;
            }
            if (permissionList.contains("*:/" + array[1])) {
                return true;
            }
            if (array[0].equals("*")) {
                String[] arrPer = new String[]{};
                for (String per : permissionList) {
                    arrPer = per.split(":/");
                    if (arrPer.length != 2 || !arrPer[1].equals(array[1])) continue;
                    return true;
                }
            }
        }
        return permissionList.contains(permission);
    }

    @Override
    public int compareTo(DriveData arg) {
        return this.name.compareToIgnoreCase(arg.getName());
    }

    public boolean equals(Object obj) {
        if (obj == this) {
            return true;
        }
        if (obj instanceof DriveData) {
            DriveData that = (DriveData)obj;
            return this.name.equals(that.name);
        }
        return false;
    }
}

