/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.services.cms.folksonomy.impl;

import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.TreeSet;
import javax.jcr.Item;
import javax.jcr.ItemExistsException;
import javax.jcr.ItemNotFoundException;
import javax.jcr.Node;
import javax.jcr.NodeIterator;
import javax.jcr.RepositoryException;
import javax.jcr.Session;
import javax.jcr.query.Query;
import javax.jcr.query.QueryManager;
import javax.jcr.query.QueryResult;
import org.exoplatform.container.ExoContainer;
import org.exoplatform.container.ExoContainerContext;
import org.exoplatform.container.component.ComponentPlugin;
import org.exoplatform.container.xml.InitParams;
import org.exoplatform.services.cms.folksonomy.NewFolksonomyService;
import org.exoplatform.services.cms.folksonomy.impl.TagPermissionPlugin;
import org.exoplatform.services.cms.folksonomy.impl.TagStylePlugin;
import org.exoplatform.services.cms.link.LinkManager;
import org.exoplatform.services.jcr.RepositoryService;
import org.exoplatform.services.jcr.core.ManageableRepository;
import org.exoplatform.services.jcr.ext.app.SessionProviderService;
import org.exoplatform.services.jcr.ext.common.SessionProvider;
import org.exoplatform.services.jcr.ext.hierarchy.NodeHierarchyCreator;
import org.exoplatform.services.log.ExoLogger;
import org.exoplatform.services.log.Log;
import org.picocontainer.Startable;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class NewFolksonomyServiceImpl
implements NewFolksonomyService,
Startable {
    private static final String USER_FOLKSONOMY_ALIAS = "userPrivateFolksonomy";
    private static final String GROUPS_ALIAS = "groupsPath";
    private static final String TAG_STYLE_ALIAS = "exoTagStylePath";
    private static final String PUBLIC_TAG_NODE_PATH = "exoPublicTagNode";
    private static final String EXO_TRASH_FOLDER = "exo:trashFolder";
    private static final String EXO_HIDDENABLE = "exo:hiddenable";
    private static final Log LOG = ExoLogger.getLogger((String)NewFolksonomyServiceImpl.class.getName());
    private NodeHierarchyCreator nodeHierarchyCreator;
    private LinkManager linkManager;
    private InitParams initParams_;
    private SessionProviderService sessionProviderService;
    private List<TagStylePlugin> plugin_ = new ArrayList<TagStylePlugin>();
    private List<TagPermissionPlugin> tagPermissionPlugin_ = new ArrayList<TagPermissionPlugin>();
    private Set<String> tagPermissionList = new HashSet<String>();
    private Map<String, String> sitesTagPath = new HashMap<String, String>();

    public NewFolksonomyServiceImpl(InitParams initParams, NodeHierarchyCreator nodeHierarchyCreator, LinkManager linkManager) throws Exception {
        this.nodeHierarchyCreator = nodeHierarchyCreator;
        this.linkManager = linkManager;
        this.initParams_ = initParams;
        ExoContainer myContainer = ExoContainerContext.getCurrentContainer();
        this.sessionProviderService = (SessionProviderService)myContainer.getComponentInstanceOfType(SessionProviderService.class);
    }

    public void start() {
        block2: {
            try {
                this.init();
            }
            catch (Exception e) {
                if (!LOG.isErrorEnabled()) break block2;
                LOG.error((Object)"===>>>>Exception when init FolksonomySerice", (Throwable)e);
            }
        }
    }

    public void stop() {
    }

    @Override
    @Deprecated
    public void addPrivateTag(String[] tagsName, Node documentNode, String repository, String workspace, String userName) throws Exception {
        this.addPrivateTag(tagsName, documentNode, workspace, userName);
    }

    @Override
    public void addPrivateTag(String[] tagsName, Node documentNode, String workspace, String userName) throws Exception {
        Node userFolksonomyNode = this.getUserFolksonomyFolder(userName);
        Node targetNode = this.getTargetNode(documentNode);
        for (String tag : tagsName) {
            try {
                Node tagNode;
                Node node = tagNode = userFolksonomyNode.hasNode(tag) ? userFolksonomyNode.getNode(tag) : userFolksonomyNode.addNode(tag);
                if (targetNode != null && !this.existSymlink(tagNode, targetNode)) {
                    this.linkManager.createLink(tagNode, targetNode);
                    long total = tagNode.hasProperty("exo:total") ? tagNode.getProperty("exo:total").getLong() : 0L;
                    tagNode.setProperty("exo:total", total + 1L);
                    if (!tagNode.isNodeType("exo:tagged")) {
                        tagNode.addMixin("exo:tagged");
                    }
                } else if (!tagNode.hasProperty("exo:total")) {
                    tagNode.setProperty("exo:total", 0L);
                }
                userFolksonomyNode.getSession().save();
            }
            catch (Exception e) {
                if (!LOG.isErrorEnabled()) continue;
                LOG.error((Object)("can't add tag '" + tag + "' to node: " + targetNode.getPath() + " for user: " + userName));
            }
        }
    }

    @Override
    @Deprecated
    public void addGroupsTag(String[] tagsName, Node documentNode, String repository, String workspace, String[] roles) throws Exception {
        this.addGroupsTag(tagsName, documentNode, workspace, roles);
    }

    @Override
    public void addGroupsTag(String[] tagsName, Node documentNode, String workspace, String[] roles) throws Exception {
        Node targetNode = this.getTargetNode(documentNode);
        for (String group : roles) {
            Node groupFolksonomyNode = this.getGroupFolksonomyFolder(group, workspace);
            for (String tag : tagsName) {
                try {
                    Node tagNode;
                    Node node = tagNode = groupFolksonomyNode.hasNode(tag) ? groupFolksonomyNode.getNode(tag) : groupFolksonomyNode.addNode(tag);
                    if (targetNode != null && !this.existSymlink(tagNode, targetNode)) {
                        this.linkManager.createLink(tagNode, targetNode);
                        long total = tagNode.hasProperty("exo:total") ? tagNode.getProperty("exo:total").getLong() : 0L;
                        tagNode.setProperty("exo:total", total + 1L);
                        if (!tagNode.isNodeType("exo:tagged")) {
                            tagNode.addMixin("exo:tagged");
                        }
                    } else if (!tagNode.hasProperty("exo:total")) {
                        tagNode.setProperty("exo:total", 0L);
                    }
                    groupFolksonomyNode.getSession().save();
                }
                catch (Exception e) {
                    if (!LOG.isErrorEnabled()) continue;
                    LOG.error((Object)("can't add tag '" + tag + "' to node: " + targetNode.getPath() + " for group: " + group));
                }
            }
        }
    }

    @Override
    @Deprecated
    public void addPublicTag(String treePath, String[] tagsName, Node documentNode, String repository, String workspace) throws Exception {
        this.addPublicTag(treePath, tagsName, documentNode, workspace);
    }

    @Override
    public void addPublicTag(String treePath, String[] tagsName, Node documentNode, String workspace) throws Exception {
        Node publicFolksonomyTreeNode = this.getNode(workspace, treePath);
        Node targetNode = this.getTargetNode(documentNode);
        for (String tag : tagsName) {
            try {
                Node tagNode;
                Node node = tagNode = publicFolksonomyTreeNode.hasNode(tag) ? publicFolksonomyTreeNode.getNode(tag) : publicFolksonomyTreeNode.addNode(tag);
                if (targetNode != null && !this.existSymlink(tagNode, targetNode)) {
                    this.linkManager.createLink(tagNode, targetNode);
                    long total = tagNode.hasProperty("exo:total") ? tagNode.getProperty("exo:total").getLong() : 0L;
                    tagNode.setProperty("exo:total", total + 1L);
                    if (!tagNode.isNodeType("exo:tagged")) {
                        tagNode.addMixin("exo:tagged");
                    }
                } else if (!tagNode.hasProperty("exo:total")) {
                    tagNode.setProperty("exo:total", 0L);
                }
                publicFolksonomyTreeNode.getSession().save();
            }
            catch (Exception e) {
                if (!LOG.isErrorEnabled()) continue;
                LOG.error((Object)("can't add tag '" + tag + "' to node: " + targetNode.getPath() + " in public folksonomy tree!"));
            }
        }
    }

    private Node getTargetNode(Node showingNode) throws Exception {
        Node targetNode = null;
        if (this.linkManager.isLink((Item)showingNode)) {
            try {
                targetNode = this.linkManager.getTarget(showingNode);
            }
            catch (ItemNotFoundException e) {
                targetNode = showingNode;
            }
        } else {
            targetNode = showingNode;
        }
        return targetNode;
    }

    @Override
    @Deprecated
    public void addSiteTag(String siteName, String[] tagsName, Node node, String repository, String workspace) throws Exception {
        this.addSiteTag(siteName, tagsName, node, workspace);
    }

    @Override
    public void addSiteTag(String siteName, String[] tagsName, Node node, String workspace) throws Exception {
        if (this.sitesTagPath.get(this.getRepoName()) == null) {
            this.createSiteTagPath();
        }
        this.addPublicTag(this.sitesTagPath.get(this.getRepoName()) + "/" + siteName, tagsName, node, workspace);
    }

    @Override
    @Deprecated
    public List<Node> getAllDocumentsByTag(String tagPath, String repository, String workspace, SessionProvider sessionProvider) throws Exception {
        return this.getAllDocumentsByTag(tagPath, workspace, sessionProvider);
    }

    @Override
    public List<Node> getAllDocumentsByTag(String tagPath, String workspace, SessionProvider sessionProvider) throws Exception {
        ArrayList<Node> ret = new ArrayList<Node>();
        Node tagNode = this.getNode(workspace, tagPath, sessionProvider);
        NodeIterator nodeIter = tagNode.getNodes();
        while (nodeIter.hasNext()) {
            Node targetNode;
            block3: {
                Node node = nodeIter.nextNode();
                if (!this.linkManager.isLink((Item)node)) continue;
                targetNode = null;
                try {
                    targetNode = this.linkManager.getTarget(node);
                }
                catch (Exception e) {
                    if (!LOG.isWarnEnabled()) break block3;
                    LOG.warn((Object)e.getMessage());
                }
            }
            if (targetNode == null || ((Node)targetNode.getAncestor(1)).isNodeType(EXO_TRASH_FOLDER)) continue;
            ret.add(targetNode);
        }
        return ret;
    }

    @Override
    @Deprecated
    public List<Node> getAllGroupTags(String[] roles, String repository, String workspace) throws Exception {
        return this.getAllGroupTags(roles, workspace);
    }

    @Override
    public List<Node> getAllGroupTags(String[] roles, String workspace) throws Exception {
        TreeSet<Node> tagSet = new TreeSet<Node>(new NodeComparator());
        for (String group : roles) {
            Node groupFolksonomyNode = this.getGroupFolksonomyFolder(group, workspace);
            NodeIterator nodeIter = groupFolksonomyNode.getNodes();
            while (nodeIter.hasNext()) {
                Node tag = nodeIter.nextNode();
                if (((Node)tag.getAncestor(1)).isNodeType(EXO_TRASH_FOLDER)) continue;
                tagSet.add(tag);
            }
        }
        return new ArrayList<Node>(tagSet);
    }

    @Override
    @Deprecated
    public List<Node> getAllGroupTags(String role, String repository, String workspace) throws Exception {
        return this.getAllGroupTags(role, workspace);
    }

    @Override
    public List<Node> getAllGroupTags(String role, String workspace) throws Exception {
        ArrayList<Node> tagSet = new ArrayList<Node>();
        Node groupFolksonomyNode = this.getGroupFolksonomyFolder(role, workspace);
        NodeIterator nodeIter = groupFolksonomyNode.getNodes();
        while (nodeIter.hasNext()) {
            tagSet.add(nodeIter.nextNode());
        }
        return tagSet;
    }

    @Override
    @Deprecated
    public List<Node> getAllPrivateTags(String userName, String repository, String workspace) throws Exception {
        Node userFolksonomyNode = this.getUserFolksonomyFolder(userName);
        return this.getAllPrivateTags(userName);
    }

    @Override
    public List<Node> getAllPrivateTags(String userName) throws Exception {
        Node userFolksonomyNode = this.getUserFolksonomyFolder(userName);
        return this.getChildNodes(userFolksonomyNode);
    }

    @Override
    @Deprecated
    public List<Node> getAllPublicTags(String treePath, String repository, String workspace) throws Exception {
        Node publicFolksonomyTreeNode = this.getNode(workspace, treePath);
        return this.getAllPublicTags(treePath, workspace);
    }

    @Override
    public List<Node> getAllPublicTags(String treePath, String workspace) throws Exception {
        Node publicFolksonomyTreeNode = this.getNode(workspace, treePath);
        return this.getChildNodes(publicFolksonomyTreeNode);
    }

    @Override
    @Deprecated
    public List<Node> getAllSiteTags(String siteName, String repository, String workspace) throws Exception {
        return this.getAllSiteTags(siteName, workspace);
    }

    @Override
    public List<Node> getAllSiteTags(String siteName, String workspace) throws Exception {
        if (this.sitesTagPath.get(this.getRepoName()) == null) {
            this.createSiteTagPath();
        }
        return this.getAllPublicTags(this.sitesTagPath.get(this.getRepoName()) + "/" + siteName, workspace);
    }

    private String getRepoName() {
        try {
            SessionProvider sessionProvider = this.sessionProviderService.getSystemSessionProvider(null);
            String repositoryName = sessionProvider.getCurrentRepository().getConfiguration().getName();
            if (LOG.isDebugEnabled()) {
                LOG.debug((Object)("The repository name is: " + repositoryName));
            }
            return repositoryName;
        }
        catch (NullPointerException e) {
            String repositoryName = System.getProperty("gatein.tenant.repository.name");
            if (repositoryName != null) {
                return repositoryName;
            }
            if (LOG.isErrorEnabled()) {
                LOG.error((Object)"Repository exception occurs:", (Throwable)e);
            }
            return null;
        }
    }

    @Override
    @Deprecated
    public List<Node> getAllTagStyle(String repository, String workspace) throws Exception {
        return this.getAllTagStyle(workspace);
    }

    @Override
    public List<Node> getAllTagStyle(String workspace) throws Exception {
        String tagStylesPath = this.nodeHierarchyCreator.getJcrPath(TAG_STYLE_ALIAS);
        Node tagStylesNode = this.getNode(workspace, tagStylesPath);
        return this.getChildNodes(tagStylesNode);
    }

    @Override
    @Deprecated
    public String getTagStyle(String tagStylePath, String repository, String workspace) throws Exception {
        return this.getTagStyle(tagStylePath, workspace);
    }

    @Override
    public String getTagStyle(String tagStylePath, String workspace) throws Exception {
        Node tagStyleNode = this.getNode(workspace, tagStylePath);
        return tagStyleNode.getProperty("exo:htmlStyle").getString();
    }

    public void addTagStylePlugin(ComponentPlugin plugin) {
        if (plugin instanceof TagStylePlugin) {
            this.plugin_.add((TagStylePlugin)plugin);
        }
    }

    @Override
    @Deprecated
    public void init(String repository) throws Exception {
        this.init();
    }

    @Override
    public void init() throws Exception {
        for (TagStylePlugin tagStylePlugin : this.plugin_) {
            try {
                tagStylePlugin.init();
            }
            catch (Exception e) {
                if (!LOG.isErrorEnabled()) continue;
                LOG.error((Object)"can not init tag style: ", (Throwable)e);
            }
        }
        for (TagPermissionPlugin tagPermissionPlugin : this.tagPermissionPlugin_) {
            try {
                this.tagPermissionList.addAll(tagPermissionPlugin.initPermission());
            }
            catch (Exception e) {
                if (!LOG.isErrorEnabled()) continue;
                LOG.error((Object)"can not init tag permission: ", (Throwable)e);
            }
        }
    }

    @Override
    @Deprecated
    public Node modifyTagName(String tagPath, String newTagName, String repository, String workspace) throws Exception {
        return this.modifyTagName(tagPath, newTagName, workspace);
    }

    @Override
    public Node modifyTagName(String tagPath, String newTagName, String workspace) throws Exception {
        Node oldTagNode = this.getNode(workspace, tagPath);
        if (oldTagNode.getParent().hasNode(newTagName)) {
            throw new ItemExistsException("node " + newTagName + " has already existed!");
        }
        StringBuilder newPath = new StringBuilder(oldTagNode.getParent().getPath()).append('/').append(newTagName);
        ExoContainer myContainer = ExoContainerContext.getCurrentContainer();
        RepositoryService repositoryService = (RepositoryService)myContainer.getComponentInstanceOfType(RepositoryService.class);
        ManageableRepository manageableRepository = repositoryService.getCurrentRepository();
        SessionProvider sessionProvider = this.sessionProviderService.getSystemSessionProvider(null);
        Session session = sessionProvider.getSession(workspace, manageableRepository);
        session.move(tagPath, newPath.toString());
        session.save();
        return this.getNode(workspace, newPath.toString());
    }

    @Override
    @Deprecated
    public void removeTag(String tagPath, String repository, String workspace) throws Exception {
        this.removeTag(tagPath, workspace);
    }

    @Override
    public void removeTag(String tagPath, String workspace) throws Exception {
        Node tagNode = this.getNode(workspace, tagPath);
        Node parentNode = tagNode.getParent();
        tagNode.remove();
        parentNode.getSession().save();
    }

    @Override
    @Deprecated
    public void removeTagOfDocument(String tagPath, Node document, String repository, String workspace) throws Exception {
        this.removeTagOfDocument(tagPath, document, workspace);
    }

    @Override
    public void removeTagOfDocument(String tagPath, Node document, String workspace) throws Exception {
        Node tagNode = this.getNode(workspace, tagPath);
        NodeIterator nodeIter = tagNode.getNodes();
        while (nodeIter.hasNext()) {
            Node targetNode;
            Node link;
            block4: {
                link = nodeIter.nextNode();
                if (!this.linkManager.isLink((Item)link)) continue;
                targetNode = null;
                try {
                    targetNode = this.linkManager.getTarget(link);
                }
                catch (RepositoryException e) {
                    if (!LOG.isWarnEnabled()) break block4;
                    LOG.warn((Object)e.getMessage());
                }
            }
            if (!document.isSame((Item)targetNode)) continue;
            link.remove();
            long total = tagNode.getProperty("exo:total").getLong();
            tagNode.setProperty("exo:total", total - 1L);
            Node parentNode = tagNode.getParent();
            if (tagNode.getProperty("exo:total").getLong() == 0L) {
                tagNode.remove();
            }
            parentNode.getSession().save();
            break;
        }
    }

    @Override
    @Deprecated
    public void updateTagStyle(String styleName, String tagRange, String htmlStyle, String repository, String workspace) throws Exception {
        this.updateTagStyle(styleName, tagRange, htmlStyle, workspace);
    }

    @Override
    public void updateTagStyle(String styleName, String tagRange, String htmlStyle, String workspace) throws Exception {
        String tagStylesPath = this.nodeHierarchyCreator.getJcrPath(TAG_STYLE_ALIAS);
        Node tagStylesNode = this.getNode(workspace, tagStylesPath);
        Node styleNode = tagStylesNode.getNode(styleName);
        styleNode.setProperty("exo:styleRange", tagRange);
        styleNode.setProperty("exo:htmlStyle", htmlStyle);
        tagStylesNode.getSession().save();
    }

    @Override
    @Deprecated
    public void addTagStyle(String styleName, String tagRange, String htmlStyle, String repository, String workspace) throws Exception {
        this.addTagStyle(styleName, tagRange, htmlStyle, workspace);
    }

    @Override
    public void addTagStyle(String styleName, String tagRange, String htmlStyle, String workspace) throws Exception {
        String tagStylesPath = this.nodeHierarchyCreator.getJcrPath(TAG_STYLE_ALIAS);
        Node tagStylesNode = this.getNode(workspace, tagStylesPath);
        Node styleNode = tagStylesNode.addNode(styleName, "exo:tagStyle");
        styleNode.addMixin("exo:privilegeable");
        styleNode.setProperty("exo:styleRange", tagRange);
        styleNode.setProperty("exo:htmlStyle", htmlStyle);
        tagStylesNode.getSession().save();
    }

    @Override
    @Deprecated
    public void removeTagsOfNodeRecursively(Node node, String repository, String workspace, String username, String groups) throws Exception {
        this.removeTagsOfNodeRecursively(node, workspace, username, groups);
    }

    @Override
    public void removeTagsOfNodeRecursively(Node node, String workspace, String username, String groups) throws Exception {
        int[] scopes = new int[]{1, 0, 3, 2};
        HashMap<Integer, String> map = new HashMap<Integer, String>();
        map.put(0, "");
        map.put(1, username);
        map.put(3, groups);
        map.put(2, "");
        for (int scope : scopes) {
            for (Node child : this.getAllNodes(node)) {
                List<Node> tags = this.getLinkedTagsOfDocumentByScope(scope, (String)map.get(scope), child, workspace);
                for (Node tag : tags) {
                    this.removeTagOfDocument(tag.getPath(), child, workspace);
                }
            }
        }
    }

    private List<Node> getAllNodes(Node node) throws Exception {
        ArrayList<Node> ret = new ArrayList<Node>();
        this.getAllNodes(node, ret);
        return ret;
    }

    private void getAllNodes(Node node, List<Node> list) throws Exception {
        list.add(node);
        NodeIterator iter = node.getNodes();
        while (iter.hasNext()) {
            this.getAllNodes(iter.nextNode(), list);
        }
    }

    private List<Node> getChildNodes(Node node) throws Exception {
        ArrayList<Node> ret = new ArrayList<Node>();
        NodeIterator nodeIter = node.getNodes();
        while (nodeIter.hasNext()) {
            ret.add(nodeIter.nextNode());
        }
        Collections.sort(ret, new NodeComparator());
        return ret;
    }

    private Node getGroupFolksonomyFolder(String group, String workspace) throws Exception {
        String groupsPath = this.nodeHierarchyCreator.getJcrPath(GROUPS_ALIAS);
        String folksonomyPath = "ApplicationData/Tags";
        Node groupsNode = this.getNode(workspace, groupsPath);
        return groupsNode.getNode(group.substring(1)).getNode(folksonomyPath);
    }

    private Node getUserFolksonomyFolder(String userName) throws Exception {
        SessionProvider sessionProvider = this.sessionProviderService.getSystemSessionProvider(null);
        Node userNode = this.nodeHierarchyCreator.getUserNode(sessionProvider, userName);
        String folksonomyPath = this.nodeHierarchyCreator.getJcrPath(USER_FOLKSONOMY_ALIAS);
        return userNode.getNode(folksonomyPath);
    }

    private Node getNode(String workspace, String path) throws Exception {
        ExoContainer myContainer = ExoContainerContext.getCurrentContainer();
        RepositoryService repositoryService = (RepositoryService)myContainer.getComponentInstanceOfType(RepositoryService.class);
        ManageableRepository manageableRepository = repositoryService.getCurrentRepository();
        SessionProvider sessionProvider = this.sessionProviderService.getSystemSessionProvider(null);
        return (Node)sessionProvider.getSession(workspace, manageableRepository).getItem(path);
    }

    private Node getNode(String workspace, String path, SessionProvider sessionProvider) throws Exception {
        ExoContainer myContainer = ExoContainerContext.getCurrentContainer();
        RepositoryService repositoryService = (RepositoryService)myContainer.getComponentInstanceOfType(RepositoryService.class);
        ManageableRepository manageableRepository = repositoryService.getCurrentRepository();
        return (Node)sessionProvider.getSession(workspace, manageableRepository).getItem(path);
    }

    private boolean existSymlink(Node parentNode, Node targetNode) throws Exception {
        NodeIterator nodeIter = parentNode.getNodes();
        while (nodeIter.hasNext()) {
            Node pointTo;
            block4: {
                Node link = nodeIter.nextNode();
                pointTo = null;
                try {
                    if (this.linkManager.isLink((Item)link)) {
                        pointTo = this.linkManager.getTarget(link);
                    }
                }
                catch (Exception e) {
                    if (!LOG.isWarnEnabled()) break block4;
                    LOG.warn((Object)e.getMessage());
                }
            }
            if (targetNode == null || !targetNode.isSame((Item)pointTo)) continue;
            return true;
        }
        return false;
    }

    @Override
    @Deprecated
    public List<Node> getLinkedTagsOfDocument(Node documentNode, String repository, String workspace) throws Exception {
        return this.getLinkedTagsOfDocument(documentNode, workspace);
    }

    @Override
    public List<Node> getLinkedTagsOfDocument(Node documentNode, String workspace) throws Exception {
        HashSet<Node> ret = new HashSet<Node>();
        StringBuilder queryStr = new StringBuilder("SELECT * FROM ").append("exo:tagged");
        ExoContainer myContainer = ExoContainerContext.getCurrentContainer();
        RepositoryService repositoryService = (RepositoryService)myContainer.getComponentInstanceOfType(RepositoryService.class);
        ManageableRepository manageableRepository = repositoryService.getCurrentRepository();
        SessionProvider sessionProvider = this.sessionProviderService.getSystemSessionProvider(null);
        QueryManager queryManager = sessionProvider.getSession(workspace, manageableRepository).getWorkspace().getQueryManager();
        Query query = queryManager.createQuery(queryStr.toString(), "sql");
        QueryResult queryResult = query.execute();
        NodeIterator nodeIter = queryResult.getNodes();
        while (nodeIter.hasNext()) {
            Node tagNode = nodeIter.nextNode();
            if (!this.existSymlink(tagNode, documentNode)) continue;
            ret.add(tagNode);
        }
        return new ArrayList<Node>(ret);
    }

    @Override
    @Deprecated
    public List<Node> getLinkedTagsOfDocumentByScope(int scope, String value, Node documentNode, String repository, String workspace) throws Exception {
        return this.getLinkedTagsOfDocumentByScope(scope, value, documentNode, workspace);
    }

    @Override
    public List<Node> getLinkedTagsOfDocumentByScope(int scope, String value, Node documentNode, String workspace) throws Exception {
        ArrayList<Node> ret = new ArrayList<Node>();
        if (scope == 1) {
            Node userFolksonomyNode = this.getUserFolksonomyFolder(value);
            NodeIterator iter = userFolksonomyNode.getNodes();
            while (iter.hasNext()) {
                Node tagNode = iter.nextNode();
                if (!this.existSymlink(tagNode, documentNode)) continue;
                ret.add(tagNode);
            }
        } else if (scope == 0) {
            String publicTagNodePath = this.nodeHierarchyCreator.getJcrPath(PUBLIC_TAG_NODE_PATH);
            Node publicFolksonomyTreeNode = this.getNode(workspace, publicTagNodePath);
            NodeIterator iter = publicFolksonomyTreeNode.getNodes();
            while (iter.hasNext()) {
                Node tagNode = iter.nextNode();
                if (!this.existSymlink(tagNode, documentNode)) continue;
                ret.add(tagNode);
            }
        } else if (scope == 3) {
            String[] roles;
            for (String group : roles = value.split(";")) {
                if (group.length() < 1) continue;
                Node groupFolksonomyNode = this.getGroupFolksonomyFolder(group, workspace);
                NodeIterator iter = groupFolksonomyNode.getNodes();
                while (iter.hasNext()) {
                    Node tagNode = iter.nextNode();
                    if (!this.existSymlink(tagNode, documentNode)) continue;
                    ret.add(tagNode);
                }
            }
        }
        Collections.sort(ret, new NodeComparator());
        return ret;
    }

    public void addTagPermissionPlugin(ComponentPlugin plugin) {
        if (plugin instanceof TagPermissionPlugin) {
            this.tagPermissionPlugin_.add((TagPermissionPlugin)plugin);
        }
    }

    @Override
    public void addTagPermission(String usersOrGroups) {
        if (!this.tagPermissionList.contains(usersOrGroups)) {
            this.tagPermissionList.add(usersOrGroups);
        }
    }

    @Override
    public void removeTagPermission(String usersOrGroups) {
        this.tagPermissionList.remove(usersOrGroups);
    }

    @Override
    public List<String> getTagPermissionList() {
        return new ArrayList<String>(this.tagPermissionList);
    }

    @Override
    public boolean canEditTag(int scope, List<String> memberships) {
        if (scope == 0) {
            if (this.tagPermissionList != null) {
                for (String membership : memberships) {
                    if (this.tagPermissionList.contains(membership)) {
                        return true;
                    }
                    if (!membership.contains(":") || !this.tagPermissionList.contains("*" + membership.substring(membership.indexOf(":")))) continue;
                    return true;
                }
            }
            return false;
        }
        return true;
    }

    @Override
    @Deprecated
    public List<String> getAllTagNames(String repository, String workspace, int scope, String value) throws Exception {
        return this.getAllTagNames(workspace, scope, value);
    }

    @Override
    public List<String> getAllTagNames(String workspace, int scope, String value) throws Exception {
        ArrayList<String> ret = new ArrayList<String>();
        List<Object> tags = new ArrayList();
        switch (scope) {
            case 0: {
                tags = this.getAllPublicTags(value, workspace);
                break;
            }
            case 1: {
                tags = this.getAllPrivateTags(value);
                break;
            }
            case 3: {
                tags = value.indexOf(";") >= 0 ? this.getAllGroupTags(value.split(";"), workspace) : this.getAllGroupTags(value, workspace);
                break;
            }
            case 2: {
                tags = this.getAllSiteTags(value, workspace);
            }
        }
        for (Node tag : tags) {
            ret.add(tag.getName());
        }
        Collections.sort(ret);
        return ret;
    }

    private void createSiteTagPath() throws Exception {
        if (this.sitesTagPath.get(this.getRepoName()) == null) {
            Node rootNode;
            ExoContainer myContainer = ExoContainerContext.getCurrentContainer();
            RepositoryService repositoryService = (RepositoryService)myContainer.getComponentInstanceOfType(RepositoryService.class);
            ManageableRepository manageableRepository = repositoryService.getCurrentRepository();
            SessionProvider sessionProvider = this.sessionProviderService.getSystemSessionProvider(null);
            Session session = sessionProvider.getSession(this.initParams_.getValueParam("workspace").getValue(), manageableRepository);
            String[] paths = this.initParams_.getValueParam("path").getValue().split("/");
            Node currentNode = rootNode = session.getRootNode();
            int depth = 0;
            for (String path : paths) {
                Node cnode;
                if (path.length() <= 0) continue;
                currentNode = cnode = currentNode.hasNode(path) ? currentNode.getNode(path) : currentNode.addNode(path);
                if (depth++ != 0 || currentNode.isNodeType(EXO_HIDDENABLE)) continue;
                currentNode.addMixin(EXO_HIDDENABLE);
            }
            session.save();
            this.sitesTagPath.put(this.getRepoName(), currentNode.getPath());
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class NodeComparator
    implements Comparator<Node> {
        private NodeComparator() {
        }

        @Override
        public int compare(Node o1, Node o2) {
            try {
                if (o1.isSame((Item)o2)) {
                    return 0;
                }
                int pathComparison = o1.getPath().compareTo(o2.getPath());
                return pathComparison == 0 ? 1 : pathComparison;
            }
            catch (RepositoryException e) {
                return 1;
            }
        }
    }
}

