/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.services.cache.invalidation;

import java.io.Externalizable;
import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectOutput;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import java.util.concurrent.CopyOnWriteArrayList;
import org.exoplatform.services.cache.CacheListener;
import org.exoplatform.services.cache.CacheListenerContext;
import org.exoplatform.services.cache.CachedObjectSelector;
import org.exoplatform.services.cache.ExoCache;
import org.exoplatform.services.cache.ObjectCacheInfo;
import org.exoplatform.services.log.ExoLogger;
import org.exoplatform.services.log.Log;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class InvalidationExoCache<K extends Serializable, V>
implements ExoCache<K, V>,
CacheListener<K, HashCode<V>> {
    private static final Log LOG = ExoLogger.getLogger((String)"exo.kernel.component.cache.InvalidationExoCache");
    private final ExoCache<K, HashCode<V>> delegate;
    private final CopyOnWriteArrayList<CacheListener<? super K, ? super V>> listeners;
    private final ConcurrentMap<K, V> localCache;

    public InvalidationExoCache(ExoCache<K, V> delegate) {
        this(delegate, delegate.getMaxSize() > 0 && delegate.getMaxSize() < 512 ? delegate.getMaxSize() : 512);
    }

    public InvalidationExoCache(ExoCache<K, V> delegate, int concurrencyLevel) {
        this.delegate = delegate;
        this.delegate.addCacheListener(this);
        this.listeners = new CopyOnWriteArrayList();
        this.localCache = new ConcurrentHashMap(concurrencyLevel, 0.75f, concurrencyLevel);
    }

    @Override
    public String getName() {
        return this.delegate.getName();
    }

    @Override
    public void setName(String name) {
        this.delegate.setName(name);
    }

    @Override
    public String getLabel() {
        return this.delegate.getLabel();
    }

    @Override
    public void setLabel(String s) {
        this.delegate.setLabel(s);
    }

    @Override
    public V get(Serializable name) {
        HashCode<V> result = this.delegate.get(name);
        return result == null ? null : (V)this.localCache.get(name);
    }

    @Override
    public V remove(Serializable key) throws NullPointerException {
        Object value = this.localCache.get(key);
        this.delegate.remove(key);
        return value;
    }

    @Override
    public void put(K key, V value) throws NullPointerException {
        this.delegate.put(key, new HashCode<V>(value));
    }

    @Override
    public void putMap(Map<? extends K, ? extends V> objs) throws IllegalArgumentException {
        if (objs == null) {
            throw new IllegalArgumentException("No null map accepted");
        }
        LinkedHashMap<K, HashCode<V>> map = new LinkedHashMap<K, HashCode<V>>();
        for (Map.Entry<K, V> entry : objs.entrySet()) {
            if (entry.getKey() == null) {
                throw new IllegalArgumentException("No null cache key accepted");
            }
            if (entry.getValue() == null) {
                throw new IllegalArgumentException("No null cache value accepted");
            }
            map.put(entry.getKey(), new HashCode<V>(entry.getValue()));
        }
        this.delegate.putMap(map);
    }

    @Override
    public void clearCache() {
        this.delegate.clearCache();
    }

    @Override
    public void select(CachedObjectSelector<? super K, ? super V> selector) throws Exception {
        if (selector == null) {
            throw new IllegalArgumentException("No null selector");
        }
        for (Map.Entry entry : this.localCache.entrySet()) {
            Object value;
            ObjectCacheInfo info;
            Serializable key = (Serializable)entry.getKey();
            if (!selector.select(key, info = new ObjectCacheInfo<V>(value = entry.getValue()){
                final /* synthetic */ Object val$value;
                {
                    this.val$value = object;
                }

                @Override
                public V get() {
                    return this.val$value;
                }

                @Override
                public long getExpireTime() {
                    return -1L;
                }
            })) continue;
            selector.onSelect(this, key, info);
        }
    }

    @Override
    public int getCacheSize() {
        return this.localCache.size();
    }

    @Override
    public int getMaxSize() {
        return this.delegate.getMaxSize();
    }

    @Override
    public void setMaxSize(int max) {
        this.delegate.setMaxSize(max);
    }

    @Override
    public long getLiveTime() {
        return this.delegate.getLiveTime();
    }

    @Override
    public void setLiveTime(long period) {
        this.delegate.setLiveTime(period);
    }

    @Override
    public int getCacheHit() {
        return this.delegate.getCacheHit();
    }

    @Override
    public int getCacheMiss() {
        return this.delegate.getCacheMiss();
    }

    @Override
    public List<? extends V> getCachedObjects() {
        return new ArrayList(this.localCache.values());
    }

    @Override
    public List<? extends V> removeCachedObjects() {
        List<V> list = this.getCachedObjects();
        this.clearCache();
        return list;
    }

    @Override
    public void addCacheListener(CacheListener<? super K, ? super V> listener) throws IllegalArgumentException {
        if (listener == null) {
            throw new IllegalArgumentException("The listener cannot be null");
        }
        this.listeners.add(listener);
    }

    @Override
    public boolean isLogEnabled() {
        return this.delegate.isLogEnabled();
    }

    @Override
    public void setLogEnabled(boolean b) {
        this.delegate.setLogEnabled(b);
    }

    @Override
    public void onExpire(CacheListenerContext context, K key, HashCode<V> obj) throws Exception {
        Object value = this.localCache.remove(key);
        if (this.listeners.isEmpty()) {
            return;
        }
        for (CacheListener listener : this.listeners) {
            try {
                listener.onExpire(context, key, value);
            }
            catch (Exception e) {
                if (!LOG.isWarnEnabled()) continue;
                LOG.warn((Object)"Cannot execute the CacheListener properly", (Throwable)e);
            }
        }
    }

    @Override
    public void onRemove(CacheListenerContext context, K key, HashCode<V> obj) throws Exception {
        Object value = this.localCache.remove(key);
        if (this.listeners.isEmpty()) {
            return;
        }
        for (CacheListener listener : this.listeners) {
            try {
                listener.onRemove(context, key, value);
            }
            catch (Exception e) {
                if (!LOG.isWarnEnabled()) continue;
                LOG.warn((Object)"Cannot execute the CacheListener properly", (Throwable)e);
            }
        }
    }

    @Override
    public void onPut(CacheListenerContext context, K key, HashCode<V> obj) throws Exception {
        V value = obj.getValue();
        if (value != null) {
            this.localCache.put(key, value);
        } else {
            Object currentValue = this.localCache.get(key);
            if (currentValue != null && obj != null && currentValue.hashCode() == obj.hashCode()) {
                value = currentValue;
            } else {
                value = null;
                this.localCache.remove(key);
            }
        }
        if (this.listeners.isEmpty()) {
            return;
        }
        for (CacheListener<K, V> listener : this.listeners) {
            try {
                listener.onPut(context, key, value);
            }
            catch (Exception e) {
                if (!LOG.isWarnEnabled()) continue;
                LOG.warn((Object)"Cannot execute the CacheListener properly", (Throwable)e);
            }
        }
    }

    @Override
    public void onGet(CacheListenerContext context, K key, HashCode<V> obj) throws Exception {
        if (this.listeners.isEmpty()) {
            return;
        }
        Object value = obj == null ? null : (Object)this.localCache.get(key);
        for (CacheListener<K, Object> cacheListener : this.listeners) {
            try {
                cacheListener.onGet(context, key, value);
            }
            catch (Exception e) {
                if (!LOG.isWarnEnabled()) continue;
                LOG.warn((Object)"Cannot execute the CacheListener properly", (Throwable)e);
            }
        }
    }

    @Override
    public void onClearCache(CacheListenerContext context) throws Exception {
        this.localCache.clear();
        if (this.listeners.isEmpty()) {
            return;
        }
        for (CacheListener<K, V> listener : this.listeners) {
            try {
                listener.onClearCache(context);
            }
            catch (Exception e) {
                if (!LOG.isWarnEnabled()) continue;
                LOG.warn((Object)"Cannot execute the CacheListener properly", (Throwable)e);
            }
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class HashCode<V>
    implements Externalizable {
        private int hashCode;
        private V value;

        public HashCode() {
        }

        public HashCode(V value) {
            this.hashCode = value.hashCode();
            this.value = value;
        }

        public V getValue() {
            return this.value;
        }

        @Override
        public void writeExternal(ObjectOutput out) throws IOException {
            out.writeInt(this.hashCode);
        }

        @Override
        public void readExternal(ObjectInput in) throws IOException, ClassNotFoundException {
            this.hashCode = in.readInt();
        }

        public int hashCode() {
            return this.hashCode;
        }

        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (obj == null) {
                return false;
            }
            if (this.getClass() != obj.getClass()) {
                return false;
            }
            HashCode other = (HashCode)obj;
            if (this.hashCode != other.hashCode) {
                return false;
            }
            if (this.value != null && other.value != null) {
                return this.value.equals(other.value);
            }
            return true;
        }

        public String toString() {
            return "HashCode [hashCode=" + this.hashCode + ", value=" + this.value + "]";
        }
    }
}

