/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.services.cms.folksonomy.impl;

import java.util.Iterator;
import java.util.List;
import javax.jcr.Node;
import javax.jcr.Session;
import org.exoplatform.container.ExoContainer;
import org.exoplatform.container.ExoContainerContext;
import org.exoplatform.container.component.BaseComponentPlugin;
import org.exoplatform.container.xml.InitParams;
import org.exoplatform.container.xml.ObjectParameter;
import org.exoplatform.services.cms.folksonomy.impl.TagStyleConfig;
import org.exoplatform.services.cms.impl.DMSConfiguration;
import org.exoplatform.services.cms.impl.DMSRepositoryConfiguration;
import org.exoplatform.services.cms.impl.Utils;
import org.exoplatform.services.jcr.RepositoryService;
import org.exoplatform.services.jcr.core.ManageableRepository;
import org.exoplatform.services.jcr.ext.hierarchy.NodeHierarchyCreator;

public class TagStylePlugin
extends BaseComponentPlugin {
    private static final String EXO_TAG_STYLE = "exo:tagStyle";
    private static final String TAG_RATE_PROP = "exo:styleRange";
    private static final String HTML_STYLE_PROP = "exo:htmlStyle";
    private InitParams params_;
    private RepositoryService repositoryService_;
    private NodeHierarchyCreator nodeHierarchyCreator_;

    public TagStylePlugin(InitParams params, RepositoryService repoService, NodeHierarchyCreator nodeHierarchyCreator) throws Exception {
        this.params_ = params;
        this.repositoryService_ = repoService;
        this.nodeHierarchyCreator_ = nodeHierarchyCreator;
    }

    public void init() throws Exception {
        Iterator it = this.params_.getObjectParamIterator();
        Session session = null;
        while (it.hasNext()) {
            TagStyleConfig tagConfig = (TagStyleConfig)((ObjectParameter)it.next()).getObject();
            if (tagConfig.getAutoCreatedInNewRepository()) {
                session = this.getSession();
                this.addTag(session, tagConfig);
                session.logout();
                continue;
            }
            session = this.getSession();
            this.addTag(session, tagConfig);
            session.logout();
        }
    }

    public void init(String repository) throws Exception {
        Iterator it = this.params_.getObjectParamIterator();
        while (it.hasNext()) {
            TagStyleConfig tagConfig = (TagStyleConfig)((ObjectParameter)it.next()).getObject();
            if (!tagConfig.getAutoCreatedInNewRepository() && !repository.equals(tagConfig.getRepository())) continue;
            Session session = this.getSession();
            this.addTag(session, tagConfig);
            session.logout();
        }
    }

    private void addTag(Session session, TagStyleConfig tagConfig) throws Exception {
        String exoTagStylePath = this.nodeHierarchyCreator_.getJcrPath("exoTagStylePath");
        Node exoTagStyleHomeNode = (Node)session.getItem(exoTagStylePath);
        List<TagStyleConfig.HtmlTagStyle> htmlStyle4Tag = tagConfig.getTagStyleList();
        for (TagStyleConfig.HtmlTagStyle style : htmlStyle4Tag) {
            Node tagStyleNode = Utils.makePath(exoTagStyleHomeNode, "/" + style.getName(), EXO_TAG_STYLE);
            tagStyleNode.setProperty(TAG_RATE_PROP, style.getTagRate());
            tagStyleNode.setProperty(HTML_STYLE_PROP, style.getHtmlStyle());
        }
        exoTagStyleHomeNode.save();
        session.save();
    }

    private Session getSession() throws Exception {
        ManageableRepository manageableRepository = this.repositoryService_.getCurrentRepository();
        ExoContainer myContainer = ExoContainerContext.getCurrentContainer();
        DMSConfiguration dmsConfiguration = (DMSConfiguration)myContainer.getComponentInstanceOfType(DMSConfiguration.class);
        DMSRepositoryConfiguration dmsRepoConfig = dmsConfiguration.getConfig();
        return manageableRepository.getSystemSession(dmsRepoConfig.getSystemWorkspace());
    }
}

